import argparse

__all__ = ['parse_commandline_args']


def create_parser():
    """Get the args from the command line"""
    parser = argparse.ArgumentParser(description='Deep active learning args --PyTorch ')

    
    parser.add_argument('--work-dir', default=None, type=str, help='the dir to save logs and models')
    parser.add_argument('--save-freq', default=100, type=int, metavar='EPOCHS',
                        help='checkpoint frequency(default: 100)')

    
    parser.add_argument('--model', default='resnet18', metavar='MODEL')
    parser.add_argument('--dataset', type=str, default='caltech101', metavar='DATASET',
                        help='The name of the used dataset(default: cifar10)')
    parser.add_argument('--load-path', type=str, default=None, help='which pth file to preload')

    
    parser.add_argument('--strategy', type=str, default='AugSingleSampling',
                        help='which sampling strategy to choose')
    parser.add_argument('--num-init-labels', default=100, type=int,
                        metavar='N', help='number of initial labeled samples(default: 1000)')
    parser.add_argument('--n-cycle', default=2, type=int,
                        metavar='N', help='number of query rounds(default: 10)')
    parser.add_argument('--num-query', default=100, type=int,
                        metavar='N', help='number of query samples per epoch(default: 1000)')
    parser.add_argument('--subset', default=10000, type=int,
                        metavar='N', help='the size of the unlabeled pool to query, subsampling')
    parser.add_argument('--updating', action='store_true', help='Whether to use updating or retraining')
    parser.add_argument('--n-epoch', default=2, type=int, metavar='N',
                        help='number of total training epochs(default: 100)')

    
    parser.add_argument('--batch-size', type=int, default=50, metavar='BATCH_SIZE',
                        help='Batch size in both train and test phase(default: 64)')
    parser.add_argument('--num-workers', default=0, type=int, metavar='N',
                        help='number of data loading workers (default: 4)')
    parser.add_argument('--lr', '--learning-rate', default=0.01, type=float, metavar='LR',
                        help='max learning rate (default: 0.1)')
    parser.add_argument('--momentum', default=0.9, type=float, metavar='M', help='momentum (default: 0.9)')
    parser.add_argument('--weight-decay', default=5e-4, type=float, help='weight decay (default: 0.0001)')
    parser.add_argument('--milestones', default=[100, 140], type=int, nargs='+',
                        help='milestones of learning scheduler to use '
                             '(default: [160])')
    parser.add_argument('--drop-ratio', default=0., type=float, help='dropout ratio in the architecture')

    
    parser.add_argument('--seed', default=None, type=int, metavar='SEED', help='Random seed (default: None)')

    
    parser.add_argument('--out-iter-freq', default=10, type=int)

    
    parser.add_argument('--duplicate-ratio', default=1, type=int, help='duplicate ratio of the labeled pool')
    parser.add_argument('--aug-ratio', default=5, type=int, help='single-image augmentation ratio')
    parser.add_argument('--mixup-ratio', default=5, type=int, help='mixup augmentation ratio')
    parser.add_argument('--aug-lab', default=2, type=int, help='augmentation intensity for labeled pool'
                                                               'only available when (aug_ratio + mixup_ratio) > 0')
    parser.add_argument('--aug-ulb', default=4,
                        type=int, help='augmentation intensity for unlabeled pool, '
                                       'only available when (aug_ratio + mixup_ratio) > 0')
    
    
    parser.add_argument('--aug-trials', default=1,
                        type=int, help='Number of trials for calculating informativeness')
    parser.add_argument('--aug-metric', default='aug-prob-minmargin',
                        type=str, help='Only for augmentation-based metrics, including:')

    
    parser.add_argument('--pace', default=0.1, type=float, help='Only available when aug_metric based on mixup')

    
    parser.add_argument('--ablation-aug-type', default='autocontrast', type=str, help='Ablation augmentation type')

    return parser


def parse_commandline_args():
    """Returns the args from the command line"""
    return create_parser().parse_args()
