CUDA_VISIBLE_DEVICES="4,5,6,7" \
    python -m torch.distributed.launch \
    --nproc_per_node=4 \
    --master_port 59800 \
    extract_feature.py \
    --model r50 \
    --out_dir ./output/r50 \
    --input_size 448 \
    --batch_size 512 \
    --image_path ./data/product_img_paths.txt \
    --item_type product \
    --item_num_recordings ./data/product_index.csv

CUDA_VISIBLE_DEVICES="4,5,6,7" \
    python -m torch.distributed.launch \
    --nproc_per_node=4 \
    --master_port 59800 \
    extract_feature.py \
    --model r50 \
    --out_dir ./output/r50 \
    --input_size 448 \
    --batch_size 512 \
    --image_path ./data/patent_img_paths.txt \
    --item_type patent \
    --item_num_recordings ./data/patent_index.csv

python get_simi_fast.py \
    --product_features ./output/r50/product_itemwise \
    --product_num_record_path ./data/product_img_paths.txt \
    --patent_features ./output/r50/patent_raw \
    --patent_num_record_path ./data/patent_index.csv \
    --batch_size 512 \
    --load_batch_num 2 \
    --save_csv ./output/r50/sim

python fast_eval.py \
    --simi_file ./output/r50/sim/max_sim.pkl \
    --patent_dict_path ./data/patent_index.csv \
    --gt_path ./data/GT_all.csv \
    --batch_size 1024 \
    --output_dir ./output/r50/sim/max_sim \
    --topK_patents_file ./data/pub_number_list.npy \
    --transfer_index ./data/index_transfer.csv