import os
import numpy as np
import torch
from datetime import datetime
from pathlib import Path

device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')

device_cpu = torch.device('cpu')
data_folder_out = "./out"


def save_path(num_model=None):
    if num_model is None:
        now = datetime.now()
        folder_str = now.strftime("%Y_%m_%d__%H_%M_%S")
    else:
        folder_str = str(num_model)

    folder_path_models = os.path.join(data_folder_out, folder_str)
    print("Time stamp: ", folder_str)
    print("Save path: ", folder_path_models)
    return Path(folder_path_models)