## MambaTS

Key codes:

- For the architecture design of MambaTS, please refer primarily to `models/MambaTS.py`.
- For variable permutation training (VPT), please focus on the `random_shuffle` and `unshuffle` function in `utils/masking.py`.
- For variable-aware scan along time (VAST), please refer mainly to `layers/mamba_ssm/mixer2_seq_simple.py`.



Usage:

1. Install Python 3.11. For convenience, execute the following command.

   ```bash
   pip install -r requirements.txt
   ```

2. Prepare Data. You can obtain the well pre-processed datasets from public channel like [[Google Drive]](https://drive.google.com/drive/folders/13Cg1KYOlzM5C7K8gK8NfC-F3EYxkM3D2?usp=sharing), Then place the downloaded data in the folder`./dataset`. Here is a summary of supported datasets.

3. Train and evaluate model. We provide the experiment scripts for all benchmarks under the folder `./scripts/`. You can reproduce the experiment results as the following examples:

   ```
   # long-term forecast for ECL
   bash ./scripts/MambaTS_ECL.sh
   ```

   

