bird_schema = {
    "account": [
        "account_id",
        "district_id",
        "frequency",
        "date"
    ],
    "alignment": [
        "id",
        "alignment"
    ],
    "atom": [
        "atom_id",
        "molecule_id",
        "element"
    ],
    "attendance": [
        "link_to_event",
        "link_to_member"
    ],
    "attribute": [
        "id",
        "attribute_name"
    ],
    "badges": [
        "id",
        "userid",
        "name",
        "date"
    ],
    "bond": [
        "bond_id",
        "molecule_id",
        "bond_type"
    ],
    "budget": [
        "budget_id",
        "category",
        "spent",
        "remaining",
        "amount",
        "event_status",
        "link_to_event"
    ],
    "card": [
        "card_id",
        "disp_id",
        "type",
        "issued"
    ],
    "cards": [
        "id",
        "artist",
        "asciiname",
        "availability",
        "bordercolor",
        "cardkingdomfoilid",
        "cardkingdomid",
        "coloridentity",
        "colorindicator",
        "colors",
        "convertedmanacost",
        "dueldeck",
        "edhrecrank",
        "faceconvertedmanacost",
        "facename",
        "flavorname",
        "flavortext",
        "frameeffects",
        "frameversion",
        "hand",
        "hasalternativedecklimit",
        "hascontentwarning",
        "hasfoil",
        "hasnonfoil",
        "isalternative",
        "isfullart",
        "isonlineonly",
        "isoversized",
        "ispromo",
        "isreprint",
        "isreserved",
        "isstarter",
        "isstoryspotlight",
        "istextless",
        "istimeshifted",
        "keywords",
        "layout",
        "leadershipskills",
        "life",
        "loyalty",
        "manacost",
        "mcmid",
        "mcmmetaid",
        "mtgarenaid",
        "mtgjsonv4id",
        "mtgofoilid",
        "mtgoid",
        "multiverseid",
        "name",
        "number",
        "originalreleasedate",
        "originaltext",
        "originaltype",
        "otherfaceids",
        "power",
        "printings",
        "promotypes",
        "purchaseurls",
        "rarity",
        "scryfallid",
        "scryfallillustrationid",
        "scryfalloracleid",
        "setcode",
        "side",
        "subtypes",
        "supertypes",
        "tcgplayerproductid",
        "text",
        "toughness",
        "type",
        "types",
        "uuid",
        "variations",
        "watermark"
    ],
    "circuits": [
        "circuitid",
        "circuitref",
        "name",
        "location",
        "country",
        "lat",
        "lng",
        "alt",
        "url"
    ],
    "client": [
        "client_id",
        "gender",
        "birth_date",
        "district_id"
    ],
    "colour": [
        "id",
        "colour"
    ],
    "comments": [
        "id",
        "postid",
        "score",
        "text",
        "creationdate",
        "userid",
        "userdisplayname"
    ],
    "connected": [
        "atom_id",
        "atom_id2",
        "bond_id"
    ],
    "constructorresults": [
        "constructorresultsid",
        "raceid",
        "constructorid",
        "points",
        "status"
    ],
    "constructors": [
        "constructorid",
        "constructorref",
        "name",
        "nationality",
        "url"
    ],
    "constructorstandings": [
        "constructorstandingsid",
        "raceid",
        "constructorid",
        "points",
        "position",
        "positiontext",
        "wins"
    ],
    "country": [
        "id",
        "name"
    ],
    "customers": [
        "customerid",
        "segment",
        "currency"
    ],
    "disp": [
        "disp_id",
        "client_id",
        "account_id",
        "type"
    ],
    "district": [
        "district_id",
        "a2",
        "a3",
        "a4",
        "a5",
        "a6",
        "a7",
        "a8",
        "a9",
        "a10",
        "a11",
        "a12",
        "a13",
        "a14",
        "a15",
        "a16"
    ],
    "drivers": [
        "driverid",
        "driverref",
        "number",
        "code",
        "forename",
        "surname",
        "dob",
        "nationality",
        "url"
    ],
    "driverstandings": [
        "driverstandingsid",
        "raceid",
        "driverid",
        "points",
        "position",
        "positiontext",
        "wins"
    ],
    "event": [
        "event_id",
        "event_name",
        "event_date",
        "type",
        "notes",
        "location",
        "status"
    ],
    "examination": [
        "id",
        "examination date",
        "acl igg",
        "acl igm",
        "ana",
        "ana pattern",
        "acl iga",
        "diagnosis",
        "kct",
        "rvvt",
        "lac",
        "symptoms",
        "thrombosis"
    ],
    "expense": [
        "expense_id",
        "expense_description",
        "expense_date",
        "cost",
        "approved",
        "link_to_member",
        "link_to_budget"
    ],
    "foreign_data": [
        "id",
        "flavortext",
        "language",
        "multiverseid",
        "name",
        "text",
        "type",
        "uuid"
    ],
    "frpm": [
        "cdscode",
        "academic year",
        "county code",
        "district code",
        "school code",
        "county name",
        "district name",
        "school name",
        "district type",
        "school type",
        "educational option type",
        "nslp provision status",
        "charter school (y/n)",
        "charter school number",
        "charter funding type",
        "irc",
        "low grade",
        "high grade",
        "enrollment (k-12)",
        "free meal count (k-12)",
        "percent (%) eligible free (k-12)",
        "frpm count (k-12)",
        "percent (%) eligible frpm (k-12)",
        "enrollment (ages 5-17)",
        "free meal count (ages 5-17)",
        "percent (%) eligible free (ages 5-17)",
        "frpm count (ages 5-17)",
        "percent (%) eligible frpm (ages 5-17)",
        "2013-14 calpads fall 1 certification status"
    ],
    "gasstations": [
        "gasstationid",
        "chainid",
        "country",
        "segment"
    ],
    "gender": [
        "id",
        "gender"
    ],
    "hero_attribute": [
        "hero_id",
        "attribute_id",
        "attribute_value"
    ],
    "hero_power": [
        "hero_id",
        "power_id"
    ],
    "income": [
        "income_id",
        "date_received",
        "amount",
        "source",
        "notes",
        "link_to_member"
    ],
    "laboratory": [
        "id",
        "date",
        "got",
        "gpt",
        "ldh",
        "alp",
        "tp",
        "alb",
        "ua",
        "un",
        "cre",
        "t-bil",
        "t-cho",
        "tg",
        "cpk",
        "glu",
        "wbc",
        "rbc",
        "hgb",
        "hct",
        "plt",
        "pt",
        "aptt",
        "fg",
        "pic",
        "tat",
        "tat2",
        "u-pro",
        "igg",
        "iga",
        "igm",
        "crp",
        "ra",
        "rf",
        "c3",
        "c4",
        "rnp",
        "sm",
        "sc170",
        "ssa",
        "ssb",
        "centromea",
        "dna",
        "dna-ii"
    ],
    "laptimes": [
        "raceid",
        "driverid",
        "lap",
        "position",
        "time",
        "milliseconds"
    ],
    "league": [
        "id",
        "country_id",
        "name"
    ],
    "legalities": [
        "id",
        "format",
        "status",
        "uuid"
    ],
    "loan": [
        "loan_id",
        "account_id",
        "date",
        "amount",
        "duration",
        "payments",
        "status"
    ],
    "major": [
        "major_id",
        "major_name",
        "department",
        "college"
    ],
    "match": [
        "id",
        "country_id",
        "league_id",
        "season",
        "stage",
        "date",
        "match_api_id",
        "home_team_api_id",
        "away_team_api_id",
        "home_team_goal",
        "away_team_goal",
        "home_player_x1",
        "home_player_x2",
        "home_player_x3",
        "home_player_x4",
        "home_player_x5",
        "home_player_x6",
        "home_player_x7",
        "home_player_x8",
        "home_player_x9",
        "home_player_x10",
        "home_player_x11",
        "away_player_x1",
        "away_player_x2",
        "away_player_x3",
        "away_player_x4",
        "away_player_x5",
        "away_player_x6",
        "away_player_x7",
        "away_player_x8",
        "away_player_x9",
        "away_player_x10",
        "away_player_x11",
        "home_player_y1",
        "home_player_y2",
        "home_player_y3",
        "home_player_y4",
        "home_player_y5",
        "home_player_y6",
        "home_player_y7",
        "home_player_y8",
        "home_player_y9",
        "home_player_y10",
        "home_player_y11",
        "away_player_y1",
        "away_player_y2",
        "away_player_y3",
        "away_player_y4",
        "away_player_y5",
        "away_player_y6",
        "away_player_y7",
        "away_player_y8",
        "away_player_y9",
        "away_player_y10",
        "away_player_y11",
        "home_player_1",
        "home_player_2",
        "home_player_3",
        "home_player_4",
        "home_player_5",
        "home_player_6",
        "home_player_7",
        "home_player_8",
        "home_player_9",
        "home_player_10",
        "home_player_11",
        "away_player_1",
        "away_player_2",
        "away_player_3",
        "away_player_4",
        "away_player_5",
        "away_player_6",
        "away_player_7",
        "away_player_8",
        "away_player_9",
        "away_player_10",
        "away_player_11",
        "goal",
        "shoton",
        "shotoff",
        "foulcommit",
        "card",
        "cross",
        "corner",
        "possession",
        "b365h",
        "b365d",
        "b365a",
        "bwh",
        "bwd",
        "bwa",
        "iwh",
        "iwd",
        "iwa",
        "lbh",
        "lbd",
        "lba",
        "psh",
        "psd",
        "psa",
        "whh",
        "whd",
        "wha",
        "sjh",
        "sjd",
        "sja",
        "vch",
        "vcd",
        "vca",
        "gbh",
        "gbd",
        "gba",
        "bsh",
        "bsd",
        "bsa"
    ],
    "member": [
        "member_id",
        "first_name",
        "last_name",
        "email",
        "position",
        "t_shirt_size",
        "phone",
        "zip",
        "link_to_major"
    ],
    "molecule": [
        "molecule_id",
        "label"
    ],
    "order": [
        "order_id",
        "account_id",
        "bank_to",
        "account_to",
        "amount",
        "k_symbol"
    ],
    "patient": [
        "id",
        "sex",
        "birthday",
        "description",
        "first date",
        "admission",
        "diagnosis"
    ],
    "pitstops": [
        "raceid",
        "driverid",
        "stop",
        "lap",
        "time",
        "duration",
        "milliseconds"
    ],
    "player": [
        "id",
        "player_api_id",
        "player_name",
        "player_fifa_api_id",
        "birthday",
        "height",
        "weight"
    ],
    "player_attributes": [
        "id",
        "player_fifa_api_id",
        "player_api_id",
        "date",
        "overall_rating",
        "potential",
        "preferred_foot",
        "attacking_work_rate",
        "defensive_work_rate",
        "crossing",
        "finishing",
        "heading_accuracy",
        "short_passing",
        "volleys",
        "dribbling",
        "curve",
        "free_kick_accuracy",
        "long_passing",
        "ball_control",
        "acceleration",
        "sprint_speed",
        "agility",
        "reactions",
        "balance",
        "shot_power",
        "jumping",
        "stamina",
        "strength",
        "long_shots",
        "aggression",
        "interceptions",
        "positioning",
        "vision",
        "penalties",
        "marking",
        "standing_tackle",
        "sliding_tackle",
        "gk_diving",
        "gk_handling",
        "gk_kicking",
        "gk_positioning",
        "gk_reflexes"
    ],
    "posthistory": [
        "id",
        "posthistorytypeid",
        "postid",
        "revisionguid",
        "creationdate",
        "userid",
        "text",
        "comment",
        "userdisplayname"
    ],
    "postlinks": [
        "id",
        "creationdate",
        "postid",
        "relatedpostid",
        "linktypeid"
    ],
    "posts": [
        "id",
        "posttypeid",
        "acceptedanswerid",
        "creaiondate",
        "score",
        "viewcount",
        "body",
        "owneruserid",
        "lasactivitydate",
        "title",
        "tags",
        "answercount",
        "commentcount",
        "favoritecount",
        "lasteditoruserid",
        "lasteditdate",
        "communityowneddate",
        "parentid",
        "closeddate",
        "ownerdisplayname",
        "lasteditordisplayname"
    ],
    "products": [
        "productid",
        "description"
    ],
    "publisher": [
        "id",
        "publisher_name"
    ],
    "qualifying": [
        "qualifyid",
        "raceid",
        "driverid",
        "constructorid",
        "number",
        "position",
        "q1",
        "q2",
        "q3"
    ],
    "race": [
        "id",
        "race"
    ],
    "races": [
        "raceid",
        "year",
        "round",
        "circuitid",
        "name",
        "date",
        "time",
        "url"
    ],
    "results": [
        "resultid",
        "raceid",
        "driverid",
        "constructorid",
        "number",
        "grid",
        "position",
        "positiontext",
        "positionorder",
        "points",
        "laps",
        "time",
        "milliseconds",
        "fastestlap",
        "rank",
        "fastestlaptime",
        "fastestlapspeed",
        "statusid"
    ],
    "rulings": [
        "id",
        "date",
        "text",
        "uuid"
    ],
    "satscores": [
        "cds",
        "rtype",
        "sname",
        "dname",
        "cname",
        "enroll12",
        "numtsttakr",
        "avgscrread",
        "avgscrmath",
        "avgscrwrite",
        "numge1500"
    ],
    "schools": [
        "cdscode",
        "ncesdist",
        "ncesschool",
        "statustype",
        "county",
        "district",
        "school",
        "street",
        "streetabr",
        "city",
        "zip",
        "state",
        "mailstreet",
        "mailstrabr",
        "mailcity",
        "mailzip",
        "mailstate",
        "phone",
        "ext",
        "website",
        "opendate",
        "closeddate",
        "charter",
        "charternum",
        "fundingtype",
        "doc",
        "doctype",
        "soc",
        "soctype",
        "edopscode",
        "edopsname",
        "eilcode",
        "eilname",
        "gsoffered",
        "gsserved",
        "virtual",
        "magnet",
        "latitude",
        "longitude",
        "admfname1",
        "admlname1",
        "admemail1",
        "admfname2",
        "admlname2",
        "admemail2",
        "admfname3",
        "admlname3",
        "admemail3",
        "lastupdate"
    ],
    "seasons": [
        "year",
        "url"
    ],
    "set_translations": [
        "id",
        "language",
        "setcode",
        "translation"
    ],
    "sets": [
        "id",
        "basesetsize",
        "block",
        "booster",
        "code",
        "isfoilonly",
        "isforeignonly",
        "isnonfoilonly",
        "isonlineonly",
        "ispartialpreview",
        "keyrunecode",
        "mcmid",
        "mcmidextras",
        "mcmname",
        "mtgocode",
        "name",
        "parentcode",
        "releasedate",
        "tcgplayergroupid",
        "totalsetsize",
        "type"
    ],
    "status": [
        "statusid",
        "status"
    ],
    "superhero": [
        "id",
        "superhero_name",
        "full_name",
        "gender_id",
        "eye_colour_id",
        "hair_colour_id",
        "skin_colour_id",
        "race_id",
        "publisher_id",
        "alignment_id",
        "height_cm",
        "weight_kg"
    ],
    "superpower": [
        "id",
        "power_name"
    ],
    "tags": [
        "id",
        "tagname",
        "count",
        "excerptpostid",
        "wikipostid"
    ],
    "team": [
        "id",
        "team_api_id",
        "team_fifa_api_id",
        "team_long_name",
        "team_short_name"
    ],
    "team_attributes": [
        "id",
        "team_fifa_api_id",
        "team_api_id",
        "date",
        "buildupplayspeed",
        "buildupplayspeedclass",
        "buildupplaydribbling",
        "buildupplaydribblingclass",
        "buildupplaypassing",
        "buildupplaypassingclass",
        "buildupplaypositioningclass",
        "chancecreationpassing",
        "chancecreationpassingclass",
        "chancecreationcrossing",
        "chancecreationcrossingclass",
        "chancecreationshooting",
        "chancecreationshootingclass",
        "chancecreationpositioningclass",
        "defencepressure",
        "defencepressureclass",
        "defenceaggression",
        "defenceaggressionclass",
        "defenceteamwidth",
        "defenceteamwidthclass",
        "defencedefenderlineclass"
    ],
    "trans": [
        "trans_id",
        "account_id",
        "date",
        "type",
        "operation",
        "amount",
        "balance",
        "k_symbol",
        "bank",
        "account"
    ],
    "transactions_1k": [
        "transactionid",
        "date",
        "time",
        "customerid",
        "cardid",
        "gasstationid",
        "productid",
        "amount",
        "price"
    ],
    "users": [
        "id",
        "reputation",
        "creationdate",
        "displayname",
        "lastaccessdate",
        "websiteurl",
        "location",
        "aboutme",
        "views",
        "upvotes",
        "downvotes",
        "accountid",
        "age",
        "profileimageurl"
    ],
    "votes": [
        "id",
        "postid",
        "votetypeid",
        "creationdate",
        "userid",
        "bountyamount"
    ],
    "yearmonth": [
        "customerid",
        "date",
        "consumption"
    ],
    "zip_code": [
        "zip_code",
        "type",
        "city",
        "county",
        "state",
        "short_state"
    ]
}