import json
import re

def clean_query(query: str) -> str:
    """Cleans SQL queries while preserving valid SQL operators like division."""
    # Remove tab characters and newlines (but keep spaces)
    query = query.replace("\t", " ").replace("\n", " ")

    # Remove triple dashes and everything after (metadata markers, not SQL comments)
    query = re.sub(r'-----.*', '', query)

    # Collapse multiple spaces
    query = re.sub(r'\s+', ' ', query)

    return query.strip()

def process_json(file_path, output_path):
    """Reads a JSON file, cleans queries, and saves the cleaned output."""
    with open(file_path, 'r', encoding='utf-8') as f:
        data = json.load(f)
    
    cleaned_data = {key: clean_query(value) for key, value in data.items()}
    
    with open(output_path, 'w', encoding='utf-8') as f:
        json.dump(cleaned_data, f, indent=4)
    
    print(f"Cleaned data saved to {output_path}")

# Example usage
input_file = "exp_progressive_claude-37_septpredict_mini_dev_claude-3-7-sonnet-latest_cot_PostgreSQL.json"  # Replace with your input JSON file
output_file = "exp_progressive_claude-37_septpredict_mini_dev_claude-3-7-sonnet-latest_cot_PostgreSQL_cleaned.json"
process_json(input_file, output_file)
