import json
import os

def save_sql_queries(input_file, partial_file, output_file):
    """Read the input JSON file and save all SQL queries into a single .sql file."""
    with open(input_file, 'r') as f:
        data = json.load(f)

    with open(partial_file, 'r') as f:
        partial = json.load(f)

    json_out = {}
    i = 0
    # Open the output file in append mode
    with open(output_file, 'w') as out_file:
        for entry in data:
            if partial[int(entry)]["is_original"] == True:
                json_out[str(i)] = data[entry]
                i += 1
        
        json.dump(json_out, out_file, indent=4)

if __name__ == "__main__":
    save_sql_queries("/Users/hmmoore/Desktop/mini_dev/llm/exp_result/exp_progressive_claude-37_septpredict_mini_dev_claude-3-7-sonnet-latest_cot_PostgreSQL_cleaned.json", "/Users/hmmoore/Desktop/mini_dev/llm/data/mini_dev_postgresql_partial_gpt_sept_2025.json", "/Users/hmmoore/Desktop/mini_dev/llm/exp_result/exp_progressive_claude-37_septpredict_mini_dev_claude-3-7-sonnet-latest_cot_PostgreSQL_cleaned_original.json")

