# MLL

## Prepare environment

Prepare your conda environment with `environment.yml`.

```bash
$ conda env create -f environment.yml
```
## Prepare Datasets

**Target Datasets and Sample Datasets:** We have listed all needed datasets in the json file `./dataset.json`. You can download them from source websites of each datasets and put them to specific paths as shown in the attribute `'root'` of each dataset. Here are the download links of them.

| Datasets          | Link                                                         |
| ------------------- | ------------------------------------------------------------ |
| ImageNet      | https://image-net.org/download.php             |
| ImageNet-V2  | https://huggingface.co/datasets/vaishaal/ImageNetV2/resolve/main/imagenetv2-matched-frequency.tar.gz?download=true     |
| ImageNet-Sketch | https://huggingface.co/datasets/songweig/imagenet_sketch/resolve/main/data/ImageNet-Sketch.zip?download=true     |
| ImageNet-A  | https://people.eecs.berkeley.edu/~hendrycks/imagenet-a.tar     |
| ImageNet-R | https://people.eecs.berkeley.edu/~hendrycks/imagenet-r.tar |
| CIFAR100  | https://www.cs.toronto.edu/%7Ekriz/cifar-100-python.tar.gz           |
| Country211  | https://openaipublic.azureedge.net/clip/data/country211.tgz     |
| CLEVR-D  | https://huggingface.co/datasets/djghosh/wds_vtab-clevr_closest_object_distance_test/tree/main      |
| DTD                | https://www.robots.ox.ac.uk/~vgg/data/dtd/download/dtd-r1.0.1.tar.gz             |
| DMLab     | https://huggingface.co/datasets/djghosh/wds_vtab-dmlab_test/tree/main              |
| Flowers102      | https://www.robots.ox.ac.uk/~vgg/data/flowers/102/102flowers.tgz               |
| FER2013  | https://www.kaggle.com/datasets/msambare/fer2013      |
| Food101          | http://data.vision.ee.ethz.ch/cvl/food-101.tar.gz                 |
| GTSRB  | http://benchmark.ini.rub.de/Dataset/GTSRB_Python_code.zip              |
| MNIST  | https://yann.lecun.com/exdb/mnist/t10k-images-idx3-ubyte.gz               |
| OxfordIIITPet  | https://thor.robots.ox.ac.uk/~vgg/data/pets/images.tar.gz          |
| PCam  | https://github.com/basveeling/pcam             |
| Rendered SST2  |  https://openaipublic.azureedge.net/clip/data/rendered-sst2.tgz    |
| RESISC45  | https://1drv.ms/u/s!AmgKYzARBl5ca3HNaHIlzp_IXjs           |
| StanfordCars  | https://huggingface.co/datasets/djghosh/wds_cars_test/tree/main                |
| STL10  | http://ai.stanford.edu/~acoates/stl10/stl10_binary.tar.gz             |
| UCF101           | https://drive.google.com/file/d/10Jqome3vtUA2keJkNanAiFpgbyC9Hc2O/view?usp=sharing                |



**Evaluation Datasets for MLL:** You can download evaluation datasets `evaluation_datasets.tar.gz` from [here](https://pan.baidu.com/s/1UfCpXTtkCxIAtxGr4xnmLw?pwd=gp1q) and unzip it to `./evaluation_dataset`. You can also construct it from scratch by runing the code.
```bash
$ python evaluation_dataset_construct.py
```

## Build Model Labels

```bash
$ python label.py
```

## Select Models

```bash
$ python selection.py
```

## Reuse models

```bash
$ python reuse.py
```

The results will be stored in `./res/reuse`