#!/usr/bin/env python
"""
Unified Flow Matching Experiment Framework

This package provides a unified framework for running Flow Matching experiments
across different robotic manipulation tasks including Kitchen, PushT, and Robomimic.

Main components:
- configs: Configuration classes for different experiments
- experiments: Experiment implementations for each task  
- utils: Utilities including experiment factory and evaluation tools
- flow_unified.py: Main entry point for running experiments
"""

from .utils import ExperimentFactory, create_kitchen_experiment, create_pusht_experiment, create_mimic_experiment
from .configs import BaseExperimentConfig, KitchenConfig, PushTConfig, MimicConfig

__version__ = "1.0.0"
__author__ = "Flow Matching Research Team"

__all__ = [
    "ExperimentFactory",
    "create_kitchen_experiment", 
    "create_pusht_experiment",
    "create_mimic_experiment",
    "BaseExperimentConfig",
    "KitchenConfig",
    "PushTConfig", 
    "MimicConfig"
]
