# Reproducing Published Experiments and Results

This is a guide on how to reproduce published experiments and results for various datasets.

<div class="admonition note">
<p class="admonition-title">Note: Understand how to launch training runs and view results first!</p>

Before trying to reproduce published results, it might be useful to read the following tutorials:
- [how to launch training runs](./configs.html)
- [how to view training results](./viewing_results.html)
- [how to launch multiple training runs efficiently](./hyperparam_scan.html) 

</div>

1. Follow the steps in the [Dataset Pipeline](../datasets/overview.html#dataset-pipeline) in order to download and postprocess your dataset(s) of interest.
2. Some of the datasets provide explicit guidelines on reproducing experiments that should be followed (for example, the [CoRL 2021 robomimic datasets](../datasets/robomimic_v0.1.html#reproduce-study-results)).
3. Otherwise, you can just follow the normal steps for [launching training runs](./configs.html) and [viewing training results](./viewing_results.html).
