import pandas as pd
import argparse
import random
import utils
from nameparser import HumanName

def parse_args():
    '''
    Config
    '''
    parser = argparse.ArgumentParser()
    parser.add_argument("--task", type=str, choices = ['movie', 'soccer', 'airport', 'music', 'book', 'soccer_olympic', 'soccer_key', 'movie_foreign_year', 'multimodal_movie','multimodal_soccer'], default = '', required = True)
    parser.add_argument('--demo', type=str, default='null')
    parser.add_argument('--model', type=str, choices=['gpt35', 'gpt4', 'llama', 'mistral', 'gemini', 'gemini_vision', 'gpt_finetune', 'gpt_finetune_2', 'gpt4v', 'claude'], default='gpt4')
    parser.add_argument('--rag', type=str, default='null')
    args = parser.parse_args()
    
    return args

    
def qa_split(input_directory,model,task):


    res_df = pd.DataFrame(columns=['question', 'entity_idx', 'question_idx', 'model_answer', 'model_reasoning', 'gold_answer', 'gold_entity'])
    cnt = 0
    with open(input_directory,"r") as f:
        while(True):
            res = []
            line = f.readline()
            if len(line)==0:
                break
            if "th question" in line:
                two_idx = line.split("th question")[0]
                movie_idx = int(two_idx.split('-')[0])
                prompt_idx = int(two_idx.split('-')[1])
                line =f.readline()
                while('Q: ' not in line):
                    line =f.readline()
                question = line.split(":")[1].replace('\n','')
                res.append(question)
                res.append(int(movie_idx))
                res.append(int(prompt_idx))

                line = f.readline()
                flag = False
               
                if 'A:' in line:
                    line = line.lower()
                    if 'yes/no:' in line:
                        line = line.replace('yes/no:','').strip()
                        line = line +'.'
                    if 'yes or no:' in line:
                        line = line.replace('yes or no: ','').strip()
                        line = line +'.'
                    if 'yes/unsure' in line.lower():
                        line = line.replace('yes/unsure','unsure').strip() ## THIS IS DONE FOR SOCCER DATASET for movie dataset it was originally changed to yes... need to talk about!
                    if 'no/unsure' in line.lower():
                        line = line.replace('no/unsure','unsure').strip()
                    split_text = line.split(':')
                    line = ':'.join(split_text[1:]).strip()
                  

                    if line.startswith('yes'):
                        model_answer = 'yes'
                    elif line.startswith('no'):
                        model_answer = 'no'
                    elif line.startswith('unsure'):
                        model_answer = 'unsure'
                    else:
                        flag = True
                        
                        model_answer = 'unsure'
                res.append(model_answer)

                #rationale
                if flag:
                    line = 'unsure. ' + line
                if len(line.split(model_answer)[1]) >= 1:
                    changing = line.split(model_answer)[1][0]
                else:
                    changing = ""
                line = line.split(f'{model_answer}{changing}')[1].strip()
                cnt =0
                rationale =""
                while(True):
                    #line = f.readline()
                    if line =='' or line=='\n':
                        line = f.readline()
                        continue
                    else:
                        if "Gold Answer:" not in line:
                            cnt +=1
                            rationale += line
                            line = f.readline()
                            continue
                        else:
                            if cnt==0:
                                rationale = 'No rationale'
                            break
                res.append(rationale)
                
                ##Gold Answer
                if "Gold Answer: "not in line:
                    raise ValueError('Strange Gold Answer')
                else:
                    if "Gold Answer: " in line:
                        gold_answer = line.split("Gold Answer: ")[1].strip().lower()
                        ##ADDED SINCE I MESSED UP...
                        res.append(gold_answer)
                    else:
                        print(line)
                        raise ValueError("GOLD ANSWER STRANGE")

                ##GOLD ENTITY
                line = f.readline()
        

                if "Gold Entity: " in line:
                    gold_entity = line.split("Gold Entity: ")[1].strip()#.lower()
                    if task=='soccer_olympic':
                        gold_entity = gold_entity.split(',')
                        if len(gold_entity[-1].strip())==0:
                            gold_entity = gold_entity[:len(gold_entity)-1]
                        if len(gold_entity)>=3:
                            tmp_entity = ["/".join(gold_entity[2:])]
                            gold_entity = gold_entity[:2]+tmp_entity
                        gold_entity = ','.join(gold_entity)
                    if task=='soccer' or task=='soccer_key' or task=='multimodal_soccer':
                        name = HumanName(gold_entity)
                        first_name = name.first
                        last_name = name.last
                        if last_name =='' or 'jr' in last_name:
                            gold_entity = first_name
                        else:
                            gold_entity = last_name
                    #CURRENTLY PSG, Paris, 1992/1993/1990 ish
                    res.append(gold_entity)
                    
                else:
                    print(line)
                    raise ValueError("GOLD Entity STRANGE")

                res_df.loc[len(res_df.index)] = res
                
    res_df.to_csv(f'./results/{model}/crafted_df/{task}.csv')

    return res_df
            
                 




            
#['question', 'movie_idx', 'question_idx', 'model_answer', 'model_reasoning', 'gold_answer', 'gold_entity']
# I want to find how many consistency there are and how many rationales are correct!!
def numerical_analysis(task, model,number_of_prompts, rag_str, demo_type):
    #log_directory = f'./extra_res/{model}/{task}.log'
    if demo_type !='null':
        log_directory = f'./results/{model}/{task}_{demo_type}.log'
    else:
        if rag_str =='null':
            log_directory = f'./results/{model}/{task}.log'
        else:
            log_directory = f'./results/{model}/{task}_rag.log'
    #if os.path.exists(f'./results/{model}/crafted_df.csv'):
        #df = pd.read_csv(f'./results/{model}/crafted_df.csv')
    df = qa_split(log_directory, model,task)
    tmp =[]
    if task=='movie' or task=='movie_foreign_year' or task=='multimodal_movie':
        tmp = [ 1100, 385, 1074, 97, 581, 144, 781, 391, 1307, 136, 83, 185, 645, 652, 1123] #1016
    '''
    # Common exclude list for all the models
    if task =='soccer':
        tmp = [1069, 609, 1067]
        #exclude_list = [1, 3, 6, 7, 10, 11, 13, 16, 17, 19, 20, 21, 23, 24, 26, 29, 30, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 49, 51, 53, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 68, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 87, 88, 89, 90, 91, 92, 93, 94, 95, 97, 98, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142, 143, 146, 147, 148, 149, 150, 151, 152, 153, 154, 156, 157, 158, 159, 160, 161, 162, 163, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 195, 196, 197, 198, 199, 201, 202, 203, 204, 206, 207, 208, 209, 210, 211, 212, 213, 214, 216, 217, 218, 219, 220, 221, 223, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 292, 293, 294, 295, 296, 297, 298, 299, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 318, 319, 320, 321, 322, 324, 325, 326, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 367, 368, 369, 371, 372, 373, 374, 375, 376, 377, 378, 379, 381, 382, 384, 385, 386, 387, 388, 389, 390, 391, 392, 394, 395, 396, 397, 398, 400, 401, 402, 403, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 557, 558, 559, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 680, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 752, 753, 754, 755, 756, 757, 758, 759, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 843, 844, 845, 846, 847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 861, 862, 863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 874, 875, 876, 877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 903, 904, 905, 906, 907, 908, 909, 910, 911, 912, 913, 914, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 980, 981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1158, 1159, 1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1179, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190, 1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295, 1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304, 1305, 1306, 1307, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341, 1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1370, 1371, 1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1401, 1402, 1403, 1404, 1405, 1406, 1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415, 1416, 1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431, 1432, 1433, 1434, 1435, 1436, 1437, 1438, 1439, 1440, 1441, 1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486, 1487, 1488, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499]
    elif task=='movie' or task=='movie_foreign_year':
        tmp = [ 1100, 385, 1074, 97, 581, 144, 781, 391, 1307, 136, 83, 185, 645, 652, 1123] #1016
       # exclude_list = [0, 1, 3, 4, 5, 6, 7, 10, 11, 13, 15, 17, 21, 22, 23, 27, 32, 33, 35, 36, 37, 38, 40, 41, 43, 44, 45, 46, 48, 50, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 67, 70, 71, 72, 73, 75, 76, 78, 79, 80, 81, 82, 83, 84, 86, 87, 88, 91, 92, 94, 97, 98, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 120, 122, 123, 124, 125, 126, 128, 130, 131, 132, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 152, 153, 154, 155, 156, 159, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 178, 179, 180, 182, 185, 186, 189, 192, 195, 196, 197, 198, 199, 201, 202, 204, 207, 211, 213, 214, 215, 216, 218, 219, 220, 224, 226, 229, 230, 231, 232, 234, 235, 239, 240, 241, 242, 243, 244, 245, 246, 247, 250, 251, 253, 254, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 268, 269, 270, 271, 272, 273, 274, 276, 277, 280, 283, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 297, 298, 299, 300, 301, 302, 305, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 323, 324, 325, 326, 327, 330, 331, 332, 333, 334, 337, 338, 339, 340, 341, 342, 343, 344, 346, 349, 350, 351, 352, 353, 354, 355, 356, 358, 359, 360, 363, 364, 365, 366, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 393, 395, 397, 398, 399, 400, 401, 402, 404, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 432, 433, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 448, 449, 450, 451, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513, 516, 517, 518, 520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 554, 555, 556, 557, 558, 559, 560, 561, 563, 564, 565, 567, 568, 569, 570, 571, 572, 573, 574, 577, 578, 579, 580, 581, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 630, 631, 633, 634, 635, 636, 638, 639, 640, 641, 642, 643, 646, 648, 649, 650, 651, 652, 653, 655, 656, 657, 658, 659, 661, 662, 663, 664, 665, 666, 669, 670, 671, 673, 674, 675, 676, 677, 678, 679, 680, 681, 682, 684, 685, 686, 688, 689, 690, 691, 692, 693, 694, 695, 696, 699, 701, 702, 703, 704, 706, 707, 708, 709, 710, 711, 712, 713, 714, 715, 717, 718, 719, 720, 721, 723, 724, 725, 726, 727, 728, 729, 731, 732, 733, 735, 736, 737, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747, 749, 750, 751, 752, 753, 754, 755, 756, 757, 758, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 772, 773, 774, 776, 777, 778, 779, 780, 782, 783, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 794, 796, 797, 798, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 811, 812, 813, 814, 815, 816, 817, 818, 819, 821, 822, 823, 825, 826, 827, 828, 830, 831, 833, 834, 835, 836, 837, 838, 840, 841, 842, 843, 844, 845, 846, 847, 848, 849, 850, 851, 852, 854, 855, 856, 857, 858, 859, 860, 861, 862, 863, 864, 865, 866, 867, 868, 869, 870, 871, 873, 874, 875, 876, 877, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 904, 905, 906, 907, 908, 909, 910, 911, 912, 913, 915, 916, 917, 918, 919, 920, 921, 922, 924, 926, 928, 929, 930, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 942, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 980, 981, 982, 983, 984, 985, 986, 987, 988, 990, 991, 992, 995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1012, 1013, 1014, 1015, 1018, 1019, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 1028, 1029, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1057, 1058, 1059, 1061, 1062, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1073, 1074, 1075, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1104, 1105, 1106, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1116, 1117, 1119, 1120, 1121, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1131, 1132, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1158, 1159, 1162, 1163, 1164, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1179, 1180, 1181, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190, 1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1209, 1210, 1211, 1213, 1214, 1215, 1216, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 1245, 1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266, 1267, 1269, 1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295, 1296, 1297, 1299, 1301, 1302, 1303, 1305, 1306, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1330, 1332, 1333, 1335, 1336, 1337, 1338, 1339, 1340, 1341, 1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1370, 1372, 1373, 1374, 1375, 1376, 1377, 1379, 1380, 1381, 1383, 1384, 1385, 1387, 1388, 1390, 1391, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401, 1402, 1404, 1405, 1406, 1408, 1409, 1411, 1412, 1413, 1414, 1415, 1416, 1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431, 1432, 1433, 1434, 1435, 1436, 1437, 1438, 1439, 1440, 1441, 1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475, 1477, 1479, 1480, 1481, 1483, 1484, 1485, 1486, 1487, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499]

    elif task=='airport':
        pass
        #exclude_list = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 16, 17, 18, 20, 23, 24, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 41, 42, 43, 44, 45, 47, 48, 49, 50, 51, 53, 54, 55, 56, 57, 58, 59, 61, 64, 65, 66, 67, 68, 69, 70, 71, 72, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 88, 89, 91, 93, 94, 95, 96, 97, 98, 99, 101, 102, 104, 105, 106, 108, 110, 111, 112, 113, 114, 117, 118, 119, 120, 121, 123, 125, 127, 130, 131, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142, 145, 146, 147, 148, 149, 150, 151, 153, 154, 156, 157, 159, 160, 161, 162, 163, 166, 167, 168, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 203, 204, 205, 206, 207, 209, 210, 212, 213, 214, 215, 216, 218, 219, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 232, 233, 234, 235, 236, 237, 240, 241, 242, 243, 245, 246, 247, 248, 249, 250, 251, 252, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 275, 276, 277, 279, 281, 282, 284, 285, 286, 287, 288, 289, 290, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 304, 306, 308, 309, 310, 312, 313, 314, 315, 316, 317, 318, 320, 321, 322, 323, 324, 328, 329, 330, 331, 332, 333, 335, 337, 338, 339, 340, 341, 342, 343, 345, 346, 347, 348, 350, 352, 353, 355, 357, 358, 360, 362, 363, 364, 365, 366, 367, 368, 369, 370, 372, 374, 375, 376, 377, 380, 381, 382, 383, 384, 386, 387, 389, 390, 391, 392, 393, 394, 395, 396, 398, 399, 400, 401, 402, 403, 404, 405, 407, 408, 410, 412, 413, 414, 415, 417, 419, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 434, 435, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 448, 449, 450, 451, 452, 453, 454, 456, 457, 460, 463, 464, 465, 467, 468, 469, 470, 471, 472, 473, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 495, 496, 497, 499, 500, 501, 502, 503, 505, 507, 508, 509, 511, 512, 514, 516, 517, 518, 519, 521, 525, 526, 529, 530, 531, 532, 533, 534, 535, 536, 539, 540, 541, 542, 543, 545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 557, 558, 559, 560, 561, 563, 565, 566, 567, 568, 569, 570, 571, 573, 574, 575, 578, 579, 580, 581, 582, 584, 586, 587, 588, 590, 591, 592, 593, 595, 596, 597, 598, 600, 603, 604, 605, 607, 610, 611, 613, 615, 616, 617, 618, 619, 621, 622, 623, 624, 625, 626, 627, 628, 629, 631, 634, 635, 637, 638, 640, 641, 642, 646, 647, 649, 650, 651, 653, 655, 656, 657, 658, 659, 660, 662, 663, 664, 665, 666, 669, 671, 672, 673, 674, 675, 678, 680, 681, 683, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 698, 699, 702, 703, 704, 705, 706, 707, 708, 709, 710, 713, 714, 716, 717, 718, 721, 723, 725, 726, 728, 729, 730, 731, 732, 733, 736, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747, 751, 752, 753, 754, 755, 756, 757, 758, 759, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 771, 774, 775, 776, 777, 779, 780, 781, 782, 785, 786, 787, 788, 789, 791, 792, 793, 794, 795, 798, 799, 800, 801, 802, 803, 804, 806, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 820, 821, 823, 825, 826, 827, 828, 830, 831, 832, 833, 834, 835, 836, 838, 839, 840, 841, 842, 843, 844, 845, 846, 848, 849, 852, 853, 854, 856, 857, 858, 859, 860, 861, 863, 865, 866, 868, 870, 871, 872, 873, 875, 876, 877, 878, 879, 881, 882, 883, 884, 885, 886, 888, 889, 890, 892, 894, 896, 897, 898, 899, 900, 901, 902, 904, 905, 906, 908, 909, 910, 911, 912, 915, 916, 917, 918, 919, 921, 922, 923, 924, 925, 927, 928, 930, 931, 932, 934, 935, 936, 937, 938, 940, 942, 944, 945, 946, 947, 949, 950, 952, 953, 954, 955, 956, 957, 959, 960, 961, 964, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 980, 981, 982, 984, 985, 986, 990, 991, 993, 994, 997, 998, 999, 1000, 1001, 1002, 1010, 1011, 1012, 1014, 1015, 1016, 1017, 1019, 1021, 1022, 1023, 1024, 1025, 1027, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1041, 1042, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1054, 1055, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1085, 1086, 1087, 1088, 1089, 1090, 1095, 1098, 1100, 1101, 1103, 1104, 1106, 1107, 1109, 1111, 1112, 1113, 1114, 1115, 1119, 1120, 1122, 1123, 1124, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146, 1147, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1157, 1159, 1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1179, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 1200, 1201, 1202, 1205, 1206, 1208, 1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235, 1237, 1238, 1239, 1241, 1242, 1243, 1244, 1245, 1246, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 1265, 1266, 1267, 1268, 1269, 1271, 1272, 1275, 1276, 1277, 1279, 1280, 1281, 1282, 1283, 1284, 1287, 1288, 1289, 1290, 1291, 1293, 1294, 1295, 1296, 1297, 1298, 1299, 1300, 1304, 1306, 1307, 1308, 1311, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1322, 1324, 1325, 1326, 1327, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1343, 1344, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1370, 1371, 1372, 1373, 1374, 1376, 1377, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 1385, 1386, 1388, 1389, 1390, 1394, 1396, 1397, 1398, 1399, 1400, 1402, 1403, 1404, 1406, 1407, 1408, 1409, 1410, 1411, 1413, 1414, 1415, 1416, 1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 1426, 1427, 1429, 1430, 1431, 1432, 1433, 1434, 1436, 1438, 1439, 1440, 1441, 1442, 1443, 1445, 1447, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 1462, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1472, 1473, 1474, 1475, 1477, 1478, 1480, 1481, 1484, 1486, 1487, 1489, 1490, 1491, 1493, 1494, 1495, 1496, 1497, 1498, 1499]
    elif task=='music':
        tmp = [960, 810]
        #exclude_list = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 219, 220, 221, 222, 225, 226, 227, 229, 230, 231, 232, 233, 234, 235, 236, 237, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 358, 359, 360, 361, 362, 363, 364, 365, 367, 368, 369, 370, 371, 372, 373, 374, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 406, 407, 408, 410, 411, 412, 413, 414, 415, 416, 417, 419, 420, 421, 422, 423, 424, 425, 426, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 478, 479, 480, 481, 483, 484, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 561, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 629, 630, 631, 632, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 657, 658, 659, 660, 661, 662, 663, 664, 665, 666, 667, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 711, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 730, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 752, 753, 754, 755, 756, 757, 759, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 779, 780, 781, 782, 783, 784, 785, 786, 787, 788, 789, 791, 792, 793, 794, 795, 796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 844, 845, 846, 847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 862, 864, 865, 866, 868, 869, 870, 871, 872, 873, 874, 875, 876, 877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 903, 905, 906, 907, 908, 909, 910, 911, 912, 913, 914, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 927, 928, 929, 930, 931, 932, 933, 934, 935, 936, 938, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 966, 967, 968, 969, 970, 971, 972, 974, 976, 978, 979, 980, 981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1094, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146, 1149, 1150, 1151, 1153, 1154, 1156, 1157, 1158, 1159, 1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1191, 1192, 1193, 1194, 1195, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 1205, 1206, 1207, 1208, 1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219, 1220, 1222, 1223, 1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236, 1237, 1238, 1239, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266, 1267, 1268, 1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295, 1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304, 1305, 1306, 1307, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1323, 1324, 1327, 1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1338, 1339, 1340, 1341, 1343, 1344, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1370, 1371, 1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379, 1380, 1381, 1382, 1383, 1385, 1386, 1387, 1388, 1389, 1390, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404, 1406, 1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415, 1416, 1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431, 1432, 1433, 1434, 1435, 1436, 1437, 1438, 1439, 1440, 1441, 1442, 1443, 1444, 1445, 1446, 1447, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499]
    elif task=='book':
        tmp=[47,232]
        #exclude_list = [0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 48, 49, 50, 51, 53, 54, 55, 56, 57, 58, 59, 60, 61, 63, 64, 65, 66, 67, 68, 69, 70, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 131, 132, 133, 135, 136, 137, 138, 140, 142, 143, 145, 146, 147, 148, 149, 150, 151, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 190, 191, 192, 193, 194, 196, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207, 208, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 226, 227, 228, 229, 230, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 299, 300, 302, 303, 304, 305, 307, 308, 309, 310, 311, 312, 313, 314, 316, 317, 319, 320, 323, 324, 325, 326, 327, 328, 329, 330, 332, 333, 334, 336, 337, 338, 340, 341, 342, 343, 344, 345, 346, 347, 349, 350, 351, 352, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 385, 386, 388, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 419, 420, 421, 422, 423, 424, 425, 426, 428, 429, 432, 433, 435, 436, 437, 438, 439, 440, 441, 442, 443, 445, 446, 447, 448, 449, 451, 452, 453, 454, 455, 456, 457, 459, 460, 462, 464, 465, 466, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 481, 482, 485, 487, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500, 502, 503, 505, 506, 507, 508, 509, 510, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 552, 553, 554, 555, 558, 559, 561, 562, 563, 564, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 593, 594, 595, 596, 597, 598, 599, 602, 603, 604, 606, 607, 608, 609, 610, 612, 613, 614, 615, 616, 617, 618, 619, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 635, 636, 638, 639, 640, 641, 644, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659, 661, 662, 663, 664, 665, 667, 668, 671, 673, 676, 677, 678, 679, 680, 681, 682, 683, 684, 685, 686, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698, 701, 704, 705, 706, 707, 708, 709, 710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 724, 726, 727, 728, 730, 731, 733, 734, 735, 736, 737, 738, 740, 741, 742, 743, 744, 746, 747, 748, 749, 750, 752, 753, 754, 756, 757, 759, 760, 761, 762, 763, 764, 766, 767, 768, 769, 771, 772, 773, 774, 775, 778, 779, 780, 781, 782, 783, 784, 785, 786, 787, 789, 790, 791, 793, 794, 795, 796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 820, 821, 822, 823, 824, 825, 826, 827, 829, 830, 831, 833, 835, 836, 837, 838, 839, 840, 841, 842, 843, 845, 846, 847, 848, 849, 850, 853, 854, 855, 856, 857, 858, 859, 860, 861, 862, 863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 875, 877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 903, 904, 906, 907, 908, 909, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 921, 922, 923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 933, 934, 935, 936, 937, 939, 940, 941, 943, 944, 946, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 964, 965, 966, 967, 969, 970, 971, 972, 974, 975, 976, 977, 978, 979, 980, 981, 982, 983, 985, 986, 988, 989, 990, 991, 993, 994, 995, 996, 997, 998, 1000, 1001, 1003, 1004, 1006, 1007, 1008, 1010, 1011, 1012, 1013, 1014, 1015, 1017, 1018, 1019, 1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1032, 1033, 1034, 1035, 1036, 1037, 1039, 1040, 1041, 1042, 1044, 1045, 1046, 1047, 1048, 1049, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1063, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1083, 1084, 1085, 1086, 1087, 1088, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1100, 1101, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1113, 1114, 1115, 1116, 1118, 1119, 1120, 1124, 1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1134, 1135, 1136, 1137, 1138, 1140, 1141, 1143, 1144, 1145, 1146, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159, 1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1179, 1180, 1182, 1183, 1185, 1188, 1189, 1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208, 1210, 1211, 1212, 1214, 1215, 1216, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 1224, 1225, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236, 1237, 1239, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1260, 1261, 1264, 1265, 1266, 1267, 1269, 1270, 1271, 1272, 1273, 1274, 1275, 1277, 1278, 1279, 1280, 1281, 1282, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 1294, 1295, 1296, 1297, 1298, 1300, 1301, 1302, 1303, 1304, 1305, 1307, 1309, 1310, 1311, 1314, 1316, 1317, 1318, 1319, 1320, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1331, 1332, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1365, 1366, 1367, 1369, 1370, 1371, 1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379, 1381, 1383, 1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1405, 1406, 1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415, 1416, 1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 1425, 1426, 1429, 1430, 1431, 1434, 1435, 1436, 1437, 1438, 1439, 1440, 1444, 1445, 1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1465, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490, 1491, 1492, 1493, 1495, 1496, 1497, 1498, 1499]
        #'''
    #FOR ALL KNOWN ENTITIES CODE
    #exclude_list = utils.find_intersection()[task]
    #ELSEWHERE 
    exclude_list = utils.check_validation_file(task, model) #[]
    
    #exclude_list = exclude_list+tmp
    df_list = [] 
    res_answer_dict = {} #A
    res_entity_dict = {} # R
    res_sc1_dict = {} # P(answer correct | rationale correct) 
    res_sc2_dict = {} #P(rationale correct | answer correct) 
    a_r_dict = {} #P(answer correct ^ rationale correct)
    res_sc1_tmp_dict={}
    r2_r1_dict = {} #P(r1 correct | r2correct)
    r2_nr1_dict = {}
    r3_r2_dict ={} #P(r2 correct | r3 correct)
    r3_nr2_dict = {}
    unsure_dict={} #unsure
    a_r_ext_dict={}
    multi_soccer_tmp_entites={}

    for i in range(number_of_prompts):
        df2 = df[df['question_idx']==i]
        df2.reset_index(inplace=True)
        df_list.append(df2)
        res_answer_dict[str(i)] = 0
        res_entity_dict [str(i)] = 0
        a_r_dict[str(i)] =0
        unsure_dict[str(i)]=0
        multi_soccer_tmp_entites [str(i)]=0
        if task =='soccer_olympic':
            res_sc1_dict[str(i)] = [0,0,0]
            a_r_ext_dict[str(i)] = [0,0,0]
            r2_r1_dict[str(i)] = [0,0]
            r3_r2_dict [str(i)] = [0,0]
            r2_nr1_dict [str(i)] = [0,0]
            r3_nr2_dict[str(i)] = [0,0]
        elif task=='movie_foreign_year':
            res_sc1_dict[str(i)] = [0,0]
            a_r_ext_dict[str(i)] = [0,0]
            r2_nr1_dict [str(i)] = [0,0]
            r2_r1_dict[str(i)] = [0,0]
        else:
            res_sc1_dict[str(i)] = 0 
        if task=='soccer_olympic':
            res_sc1_tmp_dict[str(i)] = [[0,0],[0,0],[0,0]]

        if task =='movie_foreign_year':
            res_sc1_tmp_dict[str(i)] = [[0,0],[0,0]]
        res_sc2_dict [str(i)] = 0
    tot_ent_num =0
    tot_num=0
    for i in range(len(df_list[0])):
        entity_idx = df_list[0].loc[i,'entity_idx']
        if entity_idx in exclude_list:
            continue
        tot_num+=1
        for j in range(number_of_prompts):
            model_answer = df_list[j].loc[i, 'model_answer']
            gold_answer = df_list[j].loc[i, 'gold_answer']
            model_reasoning = df_list[j].loc[i, 'model_reasoning']
            gold_entity = df_list[j].loc[i, 'gold_entity']
            model_answer = utils.replace_unlatin_characters(model_answer.lower())
            gold_answer = utils.replace_unlatin_characters(gold_answer.lower())
            model_reasoning = utils. replace_unlatin_characters(model_reasoning.lower())
            if task != 'soccer_olympic':
                gold_entity = utils.replace_unlatin_characters(gold_entity.lower())
            else:
                gold_entity = utils.replace_unlatin_characters(gold_entity)

            if model_answer.lower() =='unsure':
                unsure_dict[str(j)]+=1
            if model_answer.lower() == gold_answer.lower():
                res_answer_dict[str(j)] +=1
                if task=='soccer_olympic': ##ABOVE WILL NEVER PASS
                    res_sc2_dict[str(j)]+= utils.check_soccer_olympic_entity(gold_entity=gold_entity, model_reasoning=model_reasoning)
                    a_r_dict[str(j)] +=utils.check_soccer_olympic_entity(gold_entity=gold_entity, model_reasoning=model_reasoning)
                elif task =='movie_foreign_year':
                    res_sc2_dict[str(j)] += utils.check_director_name_year(gold_entity = gold_entity,model_reasoning= model_reasoning)
                    a_r_dict[str(j)]  += utils.check_director_name_year(gold_entity = gold_entity,model_reasoning= model_reasoning)
                    
                else:
                    if gold_entity.lower().strip() in model_reasoning.lower().strip() or utils.remove_special_characters(gold_entity.lower()).strip() in utils.remove_special_characters(model_reasoning.lower()).strip():
                        #print(gold_entity)
                        res_sc2_dict[str(j)] +=1
                        a_r_dict[str(j)] +=1
 
            if j==1:
                tot_ent_num +=1
            if task == 'soccer_olympic': #need to change r2_r1_dict afterwards
                    res_entity_dict[str(j)] += utils.check_soccer_olympic_entity(gold_entity=gold_entity, model_reasoning=model_reasoning)
                    gold_entities = gold_entity.split(',')
                    if not (len(gold_entities) ==3 or len(gold_entities)==2):
                        raise ValueError("STRANGE PARSING PROBABLY IN GOLD ENTITIES")
                    if ((j==0 or j==2) and gold_answer.lower()=='yes') or (j==1 and gold_answer.lower()=='no') :
                        multi_soccer_tmp_entites[str(j)]+=1
                        gold_entity1 = gold_entities[0]
                        gold_entity2 = gold_entities[1]
                        gold_entity3 = 'NEVER GONNA!_!__!_!_!EXIST' if len(gold_entities)==2 else gold_entities[2]
                        g1_ind= False
                        gold_entity1_list = utils.gold_entity_soccer_club_heuristic(gold_entity1)
                        for gval in gold_entity1_list:
                            if gval.lower().strip() in model_reasoning.lower().strip():
                                g1_ind=True
                                break
                        if g1_ind: #FIRST RATIONALE IS TRUE
                            res_sc1_tmp_dict[str(j)][0][1]+=1
                            if model_answer.lower() == gold_answer.lower():
                                res_sc1_tmp_dict[str(j)][0][0]+=1
                                a_r_ext_dict[str(j)][0]+=1
                            r2_r1_dict[str(j)][1]+=1  
                        else:
                            r2_nr1_dict[str(j)][1]+=1  
                        if gold_entity2.lower().strip() in model_reasoning.lower().strip():
                            res_sc1_tmp_dict[str(j)][1][1]+=1
                            if g1_ind:
                                r2_r1_dict[str(j)][0]+=1
                            else:
                                r2_nr1_dict[str(j)][0]+=1

                            if model_answer.lower() == gold_answer.lower():
                                res_sc1_tmp_dict[str(j)][1][0]+=1
                                a_r_ext_dict[str(j)][1]+=1

                        if len(gold_entities)==3:
                            if gold_entity2.lower().strip() in model_reasoning.lower().strip():
                                r3_r2_dict[str(j)][1]+=1
                            else:
                                r3_nr2_dict[str(j)][1]+=1
                            sub_g_3 = gold_entity3.strip().split('/')
                            sval=0
                            for yearval in sub_g_3:
                                if yearval.strip() in model_reasoning.lower().strip():
                                    sval+=1
                            if sval == len(sub_g_3):
                                if gold_entity2.lower().strip() in model_reasoning.lower().strip():
                                    r3_r2_dict[str(j)][0]+=1
                                else:
                                    r3_nr2_dict[str(j)][0]+=1

                                res_sc1_tmp_dict[str(j)][2][1]+=1
                                if model_answer.lower() == gold_answer.lower():
                                    res_sc1_tmp_dict[str(j)][2][0]+=1
                                    a_r_ext_dict[str(j)][2]+=1
            elif task == 'movie_foreign_year':
                res_entity_dict[str(j)] += utils.check_director_name_year(gold_entity=gold_entity, model_reasoning=model_reasoning)
                director_name, movie_year = gold_entity.split(',')
                director_name = director_name.strip()
                first_name = director_name.split(' ')[0]
                last_name = director_name.split(' ')[-1]
                if first_name.strip() in model_reasoning or last_name.strip() in model_reasoning:
                    res_sc1_tmp_dict[str(j)][0][1]+=1
                    if model_answer.lower() == gold_answer.lower():
                        res_sc1_tmp_dict[str(j)][0][0]+=1
                        a_r_ext_dict[str(j)][0]+=1
                    r2_r1_dict[str(j)][1]+=1
                else:
                    r2_nr1_dict[str(j)][1] +=1
                if str(movie_year).strip() in model_reasoning:
                        if first_name.strip() in model_reasoning or last_name.strip() in model_reasoning:
                            r2_r1_dict[str(j)][0]+=1
                        else:
                            r2_nr1_dict[str(j)][0] +=1
                            #print(j, model_reasoning, gold_entity)
                        res_sc1_tmp_dict[str(j)][1][1]+=1
                        if model_answer.lower() == gold_answer.lower():
                            res_sc1_tmp_dict[str(j)][1][0]+=1
                            a_r_ext_dict[str(j)][1]+=1
            
            else:
                if gold_entity.lower().strip() in model_reasoning.lower().strip() or utils.remove_special_characters(gold_entity.lower()).strip() in utils.remove_special_characters(model_reasoning.lower()).strip():

                    res_entity_dict[str(j)] +=1
                    if model_answer.lower() == gold_answer.lower():
                        res_sc1_dict[str(j)] +=1

                #with open(f'./extra_res/ERProblem/{task}_{model}.log', 'a') as f:
                    #f.write(f'{gold_entity}, {model_reasoning}\n')
            #else:
                #   print(gold_entity)

                    
    

    
   
    #tot_ent_num/=3
    for j in range(number_of_prompts):
        if res_answer_dict[str(j)]==0:
            res_sc2_dict[str(j)] = 'div_by_zero'
        else:
            res_sc2_dict[str(j)] = round(res_sc2_dict[str(j)]/ res_answer_dict[str(j)] ,2)
        if not (task=='soccer_olympic' or task=='movie_foreign_year'):
            if res_entity_dict[str(j)]==0:
                res_sc1_dict[str(j)] = 'div_by_zero'
            else:
                res_sc1_dict[str(j)] = round(res_sc1_dict[str(j)] / res_entity_dict[str(j)],2)
        else:
            for i in range(len(res_sc1_tmp_dict[str(j)])):
                if res_sc1_tmp_dict[str(j)][i][1]==0:
                    res_sc1_dict[str(j)][i] = 'div_by_zero'
                else:
                    res_sc1_dict[str(j)][i] = round(res_sc1_tmp_dict[str(j)][i][0]/res_sc1_tmp_dict[str(j)][i][1],2)
        if  task == 'soccer_olympic' or task == 'movie_foreign_year': #
            for k in range(len(a_r_ext_dict[str(j)])):
                if task=='soccer_olympic':
                    a_r_ext_dict[str(j)][k] = round(a_r_ext_dict[str(j)][k]/multi_soccer_tmp_entites[str(j)],2)
                elif task=='movie_foreign_year':
                    a_r_ext_dict[str(j)][k] = round(a_r_ext_dict[str(j)][k]/tot_num,2)
            if j==0:
                print("BASIC")
            elif j==1:
                print("NEGATION")
            print(r2_nr1_dict)
            print(f"p(r2|r1) = : {round(r2_r1_dict[str(j)][0]/r2_r1_dict[str(j)][1],2)}")
          #  print(f"{r2_nr1_dict[str(j)][1]}")
            print(f"p(r2|not r1) = : {round((r2_nr1_dict[str(j)][0])/r2_nr1_dict[str(j)][1],2)}")
            if task=='soccer_olympic':
                print(r3_r2_dict)
                print(r3_nr2_dict)
                print(f"p(r3|r2) = : {round(r3_r2_dict[str(j)][0]/r3_r2_dict[str(j)][1],2)}")
                print(f"p(r3|not r2) = : {round(r3_nr2_dict[str(j)][0]/r3_nr2_dict[str(j)][1],2)}\n")
                
        
        if tot_num == 0:
            res_answer_dict[str(j)] = 'div_by_zero'
        else:
            res_answer_dict[str(j)] =  round(res_answer_dict[str(j)]/tot_num,2)
        if tot_ent_num == 0:
            res_entity_dict[str(j)] = 'div_by_zero'
        else:
            res_entity_dict[str(j)] = round(res_entity_dict[str(j)]/tot_ent_num,2)
        a_r_dict[str(j)] = round(a_r_dict[str(j)]/tot_num, 2)
        unsure_dict[str(j)] = round(1 - unsure_dict[str(j)]/tot_num -  res_answer_dict[str(j)],2)

    print(f"Total number of values: {tot_num}")
    print(f"A: {res_answer_dict}")
    print(f"R: {res_entity_dict}")
    if task == 'soccer_olympic' or task == 'movie_foreign_year':
        print(f"AR_EXT: {a_r_ext_dict}")
        #print(f"res_sc1_dict: {res_sc1_dict}")

    else:
        print(f"AR: {a_r_dict}")
    print(f"H: {unsure_dict}")



   




def main():
    random.seed(192)
    args = parse_args()
    task = args.task.strip()
    demo_type = args.demo
    model = args.model
    rag_str = args.rag
    demo_print = '' if demo_type =='null' else f'demo {demo_type} '
    print(f"Running to Analyze {task}, {model}, {demo_print}analysis!!")

    numerical_analysis(task, model,2, rag_str = rag_str, demo_type = demo_type)



    
    print('\n\n')
    return

if __name__  =="__main__":
    main()