(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    174288,       3258]
NotebookOptionsPosition[    170585,       3191]
NotebookOutlinePosition[    171200,       3212]
CellTagsIndexPosition[    171157,       3209]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
We follow the derivation in Kolter (2011) with the aim of constructing a \
fixed-point counterexample with n=3 states and k=2 feature space, where w* is \
near [1, -1]
We achieve this by splitting the left state into two equal states.\
\>", "Text",
 CellChangeTimes->{{3.848632720901607*^9, 3.848632738020585*^9}, {
  3.8486340159286547`*^9, 3.848634057462323*^9}, {3.8489104946422167`*^9, 
  3.8489105216064568`*^9}},ExpressionUUID->"051258ff-3da9-473b-961b-\
d8991c9fcfd8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"param", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", 
       RowBox[{"1", "+", "param"}], ",", " ", "1.05"}], "}"}], "}"}], 
    "\[Transpose]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
      RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "V"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"epsilon", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi", " ", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", " ", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "param"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.05", "+", "epsilon"}], ")"}], "/", "2"}], ",", " ", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"1.05", "+", "epsilon"}], ")"}]}], "/", "2"}]}], "}"}]}], 
     "}"}], ".", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"100", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dm", " ", "=", " ", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], "/", "2"}]}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}], 
      RowBox[{
       RowBox[{"(", "p", ")"}], "/", "2"}]}], ",", "q"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"what", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"LeastSquares", "[", 
      RowBox[{
       RowBox[{"Refine", "[", 
        RowBox[{"Phi", ",", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"epsilon", "==", "0.0001"}]}]}], "]"}], ",", "V"}], "]"}], 
     ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"param", "\[Element]", "Reals"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"what", " ", "/.", 
  RowBox[{"{", 
   RowBox[{"param", "->", "2"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"Phi", ".", "what"}], "-", "V"}], "]"}], "<", "0.0001"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"param", "->", "2"}], ",", 
    RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.848910053020782*^9, 3.848910152351247*^9}, {
   3.848910308449559*^9, 3.84891030984326*^9}, 3.851936641725163*^9, {
   3.852099656777422*^9, 3.852099660756007*^9}, {3.8520998283982353`*^9, 
   3.8520998330051622`*^9}, {3.852100643443104*^9, 3.852100647045465*^9}, {
   3.857312621661829*^9, 3.857312691960071*^9}, {3.857316711815258*^9, 
   3.85731676509906*^9}, {3.85765391359242*^9, 3.857653919307899*^9}, 
   3.857653970095665*^9, {3.85989693288984*^9, 3.859896944490634*^9}, {
   3.859897496931375*^9, 3.8598975945161552`*^9}, {3.859897902003407*^9, 
   3.8598979206232347`*^9}, {3.859898432342708*^9, 3.859898538002281*^9}, {
   3.85989857821306*^9, 3.859898582607389*^9}, {3.859898733660108*^9, 
   3.859898739319944*^9}, {3.859898922338215*^9, 3.859898927499708*^9}, 
   3.8599089226791687`*^9, {3.859976797797181*^9, 3.859976832973092*^9}, {
   3.859977124610374*^9, 3.859977129792815*^9}, 3.859977256340473*^9, {
   3.859977293909544*^9, 3.859977303975683*^9}, {3.859979542759618*^9, 
   3.859979551035636*^9}, {3.85997977767616*^9, 3.85997983483222*^9}},
 CellLabel->
  "In[305]:=",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", "p", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "q"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835369123*^9}},
 CellLabel->
  "Out[313]=",ExpressionUUID->"96d8b17f-698d-45a2-8c73-e54b5bfca086"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.009999598065796958`", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.9999955340644108`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835391633*^9}},
 CellLabel->
  "Out[315]=",ExpressionUUID->"eabb3504-d9b3-40c2-8a0a-66520194105a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835394786*^9}},
 CellLabel->
  "Out[316]=",ExpressionUUID->"5b56d065-b6db-4b99-9509-c3bd8f569b25"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the fixed point w_star:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.848570432944818*^9, 3.8485704485407467`*^9}, {
  3.848570915714424*^9, 
  3.848570984363884*^9}},ExpressionUUID->"0a5d41cb-08ef-4253-a74f-\
02384f62cb6a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sA", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
        RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "Phi"}], " ", "+", " ", 
     RowBox[{"eta", "*", 
      RowBox[{"IdentityMatrix", "[", "2", "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sb", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "R"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wstar", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "sA", "]"}], ".", "sb"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.848570984364477*^9, 3.848571676353101*^9, {3.848913024643092*^9, 
   3.84891305207668*^9}, {3.848913722679961*^9, 3.848913736469101*^9}, {
   3.857312703508958*^9, 3.8573127254150143`*^9}, 3.8598985463718767`*^9},
 CellLabel->
  "In[317]:=",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0."}], ",", 
      RowBox[{"param", "->", "1.2"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0.", ",", "0.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851991153216415*^9, 3.851991186354488*^9}, {
   3.859897604498384*^9, 3.859897667449603*^9}, 3.8598977068231173`*^9, {
   3.859898770173263*^9, 3.859898811920697*^9}, {3.859898900650683*^9, 
   3.8598989076267014`*^9}, {3.859977170380211*^9, 3.8599772094073343`*^9}, 
   3.85997727963168*^9, {3.859977312311514*^9, 3.8599773537170477`*^9}},
 CellLabel->
  "In[320]:=",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJytvXlYTd37wB2SDBEylIyFTFHSoLSbTjrNE02EyFjKLGTMVCplVkgqU2ZC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    "], {{
      {RGBColor[0.1, 0.1, 0.1], Opacity[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJwtmgf8V9Mbx++933Pvj2SVmU2IpNLQDmlnpRSSjGxlN1TSRIqilKhUiKKU
kEiJkpSVhtFQ+Ns7m//70+e8Xp2e932+53u+5957znOe8Tvs4p7te2RJkpRK
NORNIUn2RFbkokVZkryFHFgkyZlwGZ+tyZOkGjwO/ZXoT0aeRP+BDHIc+rFc
X4H+JGRT9LehPwY+Gr4C7kyfoVzfzTjnwQ0YcwT9z4UnoZ+AvimyCf0H0P8E
uCZ8PVyVPvdwfTn9C/g0uBlcHj4Hbg2X4JaaE5yWeX5N4F3hTnAbuAw+HT4V
3g3uDLeFd4bP1H3DOdwaPgXeCT4Dbg4HuBV8MrwL3BFuBddD1mWevZhnTbgG
fB18NzwAfgluRv8VXPen/ynwG3A/PUN4OXwr/AH3/xD999NzQP8a+r7om8BL
4T5wY/hVuDf8K+0VeBr9G6FfAvdC1wB+Gb4Frg+/BN8M10BWZ/yezOcFvvOx
ngmf16E9C99An1PhNzXvOPar9P+N/s3Rr+T6NvS14Xnw9XBd+Fje44+MdwL8
JPrr0E9AjuK7b/HdGugf4boH+inIsejfR18d/USur0E/GXk/+vfQ/8b1YVzX
1vyRJ6Lvjf6PwuupLnIvvnsxfBY8UvOiz8v0GaFnDC+ED4cPgy+C90tZo7Qt
icc+FNkNfQvm/Vbid3EgY17DZ+fCleCr4E7wAfDVcGf4UPh63SPtELgnsoue
ObIK41zFmO3ghnB/uAl8HKyNdjT9b+P6Evq3QdZD3xd9Y7gqfC3cED4Gvhqu
BR8OXwLXho+AL4UbwcfC18B14SPhy+A6cGW4e9w7uveL4YP43Wu5Po/f3R++
HD4H3g++DO4I7wF3gU+D94QvgE+HK8Bd4TPgf+P7aIg8Av1N8IXwP3EPNEDu
jv58uB38Z1xzJyL/Krw36iGTMtuIxvB/hfd8I+Th6G+Eu+r9wzfAF8CV4Zvh
bnBF+EL4THgf+FL4bHhfuDvcAd4bvgRuDx8M94DPh2fzrvfg529mvS6C34Pb
IY+kzy30uYg+P9PmwlPRH4W+N3wxuirwcPhSrUH4Drg7/DjteH2X/o/B1TRP
eAZcXd+Fv4rrfiL8ZVzrD8J1aX1Yk9XRraMNQn8nuq/hafBD8DDtQ+bZAH69
8L30gdfA/eHh8LLC67Av/Frhd90bXijbqn0KL0IuYZztrIfP0Y/nejz67+AZ
8CT4Q3gYPBLeAA+BR8Dr4cHwXfBW+D7t1dzPaR5jfsWY29Dfr72N/ls9F/hh
+Ee4Ec87Q/5Am4V+Cvrv4SfgyfAbPIO/GGcacmnhPdgL/auF990t8JLC+/Hm
3GNPpf8nmec+Dd4Ir+WzZ+DjNGbuPgcj55Ss/1/m35wOb4IPzT1/3fsW2v7M
82ze7f7wrMTPfwZtG/ycng/fmQwfQL+VhdfkAPSrCq+fgfCbhfdFf/gV+Ar4
Rvgl+DzZWHgxfCV8k+ZZeJ3fCq8ovP77ae3xG7V4HgH5Lvq+6Ifo/pBzmcOX
zOUj9HfKzqJ/B+4DD9a6hm+Fh8Lvw/3gYXBbZH2+eyvf/Rj9XVzfg35j4bNq
tN4p3Ay+Gh6NHET/JfQvx/VEeBzyqWjvLoOfKzxuD82tsL27Cp5d2E5dAT8s
uylbCk+S7ZCN1XspbPuuhJ8ubPsuhxfA7WVj4fnRVl6be82OZA4rmc909FVl
K9A/Ch8nWwQ/UdhuXgJPg4+VDdF71tmmsyaPe4tx1jHOFPRHyj6gn1nYhnaH
nyxscy+FH4GPkp2HJ8seyZbC9yJvZ5zFstu8p8Hwq/BD9DlENpY+98keyZbC
Y3RuycbCY2WzZMfg+2XLZGPhY7THee9/wy8UPkt6wj8VfvePwJ/CY+D74LXw
7fAd8ObC72wMfCjzOY1xDkKOk61Hf5aeoc4z2Ua9T9lH2f/c4w1h/kuZ/y7R
D3kAebTsFeOUxf09DP3rmW3AUPg1vQvtdXi97EDu/dGBffQg3zlINhndJ4XP
5nvhCTprZbe1zuEljF+u8F57R2cH3/2AsSYk9lGa02rLbqM7pWSf8IbM/uC9
8Gq4AmMcSUu1RvnvS+SLyAW0RfDdyJxWOX72M60KPAO5L7Iq7f3E73Q08u3M
9v5OeBlckc+Ppe2e2PbfhVyu+WQeZwztK/R/ot+CPFx2Ct6MfFl2WX5gbj9E
k/xP9oh+m5FflOxPvQ7/znit+Pxz+PnEftky5B/os9Tz+IbrXXnGDeFdgn2u
59B9ndnWyc7/Kh8g9xif6dxBL19/nfaA5ivfLLX/JZsm21Yj9fzkI5VF1jyL
1M/oH907co58cp1bUa/ntiL1vd+JfFO2FHlg7hhC91hB7xXdb/DT8ilLtqvb
kfPjmBr7Qdov8Azk87S9adfSmjPWysR+snQH06bo3eSWuyOfzX0vuyH/ZtyD
Uq+nr7neR+PqffL9B+mzc+44RmtMa61L6j46J06RXU7se8/N3Wen3PHNeHgN
/TfCW7VOkBVz65/P7efueO+ZfZNLda5l9iP6qg+8mnF7yXbk9lMuQT8V/dP8
/gvwFOTXidf0V4njjzOQIzPHLqdrPcNnaU/D92SOXc6ER2WOjU6DR8DVUo+j
ZfdYHP/puA/yuDfkD16uzzP7g5fBj2b2p7rD0+ENrLOLEvu939HKpb73Zamf
1XJkZ9kteBVtYLSNr2T2YbZxXa/M+0xrRmtqQcm+97/02QRvh5vyO3P4bFfa
2NTxXHP0w+jzJNcl2nTa4ty/tVB+Dn1Ww0lcY21Try3Fdp1kDxTvpF6Tz9Iq
6RxCvxW5M79XD91OyM/p/y76gFxMWwPnyJOC18avJceR56Afm9keaD9qXyoG
7Yj+fvTHR71sheLIllrbmWPHFvDwzLFjB/g+uFvJz3ZyZt+5C/xgZh+8q/wQ
Pf/c935U7jhsE/o9S/bZL4AnZvbTL4Qfzuwjd5Nvkzme2wjvgWyb+x51r4pH
P9HeKdm/u0n2JrNPcSu8ILM/2Ev+T2af4lp4VmZf9UZ4Xmbf5Bp4Zub1oXuZ
ktm/6Cc7nHm9X6F9LV+CddBBzyX6LFejfxJ9PZ5zA7ifbB19WvBZ03i+3YB+
bmabove4Ivez0DNZmnsvnEyfQZl9h1PgwZl9nx7wU/DZcDN4iN4d44/SWo9+
dE/tC/QD4Ovg2ZnX8PXwM5n96FbwXZnP/4p6t5l9mQpwS/h3xQlc14ln7E7o
22c+exX2tMvsB+0Kd8l89u6idZrZF+A2kjaZz8xy8Dnw/qUd4VJyema/7AT4
xsyxxUHwhZnjjwPhCzKfqzvDHTL7GrL5p2b2QfiXtMjsa/Cok1aZ/Zq94dMy
+0F7wW1j7KxcUPPMvlUl+NzMPtf+cKfMvtV+cEfFtvA+8JmZfZ/y8Hlwayb/
kNZN4T3xbeLz62+uT0RfP8ZMB6A7P7OPVgu+KbPv3BkerznnPhdW585zfKBz
qeS8yDrZ55LzJetl28XxrJmEfJ3rDXC5knMs2u/bkS/mPrPW5z5vNP6E1GfH
j/BHmfMkP0XbPrVkf2FLPPN/TXytfMxaZFnJuZyP4F2RC3Kf4zORDVLbN50Z
T8TvTkwdV8hWPZ7bLv6b+JxVfuhj5G4l53LegbOSYxyd+z8hj5ePpf1TOMfz
Nn3SkmM97XHl9WrS51Gt78I2VXN4MnF8JJums/Ec+pRjQdxBnwdKPh/Xco8L
4zO8DvlD7rOjlhYpfb+PfR7j+mydU8iL+G579KNl68o81lXyc/msfuzTLZ5Z
90ZfTnv2dvgZPjtYe0F7me9u5rOhfHdO7vUi/aa4BrQWZsVn2DP1eaT70hmi
tTYlvruKcQ03i/5hGs/T9oy/WueTYgjGaoR+Xe6Y7FytAfqvh3eDu8KzS47B
f87sY1aI53OT4Pf7Hp8fFhzDbtVv5o4xFeP3jPPUO382+N5lq6rDF6KrgfxF
7xLZiXmNQFeT9krq+PtmPXM+mx/8bBUTfQn3lq2Dvwi2z4o9twX3V0z6XXAe
TDHgN8H2XLHhp8F2XvGpnoHWo3wZxb8tU/urT9OnbeK4YxmffQiXR84s2Z/8
hudwPX2mpvZ1Z8GtE8eA80uOOxR/DIr5ZNkS+V5abzpL9a60H7QOdwuWOn9l
y2TTNmj/Rn9D62VwcN5mRz4w9Xc172eifyg/sSqf7SljpxxOfKd6t3vkzg8o
t1w12M87Lng9n586b1mF6/PgY5DfyseKXCuu+f8pNgy2/4pDfwjONyr38n1w
jlfx9bfB553i9OHBuTjFlXcE5+gUPw4LzuMpfhwanN9TLNw/2K4qJro9+Dl0
ijZqJnx07tiqTWq/RWuqdWr7MyQ416fnrPWo+es9KZ+iNfm4rgufr/8qFqOd
mjqW195tnjq2HxBs5xWv9Qu27YoTp0e/603abcG2WjHjwOBzR3HuY8Fnq+Lr
1cFnunI1b8FXJs51qIbQLa75lcH+gHIjj8bx5d+9F+xLKOezOdjHUD5kY7AP
oDzJA4XPxVrINcE+ifJFn+aOnSprPiXHGZ9ntv+j0Hek7/rgs145tO3B8azq
EcsL+y7K7X4cfO6LPwz2B/rG8fXMZc9b57a3yodXot++2tf81pfo26deM//x
3YGJaxbKVV8MP5I5pvgOnod8XTmnxLnKZcE+ofKZy4P9SeUzlc9SXKLYblNw
TKG86y+Z7ZJiwD9ofRLnJ0/W/SSuF5yUO35UveD34BhEecumueNN1Qt+oT0v
/w+5qLAdV179r8zjyKa1ls3hvuoiG+WOMXXOLI02Tfu0Ru44VHWEVcF+rHLm
b8PnJ86lvxvsryrH/n6wf6u89Lpgf1W59I+Cn5Vyvx8E+7TK324qnOuXzyZn
SfGF4vUVwX6+cto1ZYMS1yZeDY6JlCteFBwTKb+9ODiGUn57SXBspfz2J8Gx
mPLP2+N71Rp7I9jnV568IeMvTlxb2VI47yObI1/yHnBV5rNLfoXyAd/T/1ye
29H0OwZ+Cv07uXPROot0Rg1SbkV2qXBMNBLuQP/ywbmKteiGFJZdOCOu077Q
uZd5ncsmHBh8Fu+w58jaXF+FvmvwmlypmJkxFgb7VMoJV4ZXob8S+QqtXeK8
vfQd0TcLtvk6FyrBVRQPxzh6L+3DxDWdG/jsqdSxm86yrjrzkEXu/IlqhUdo
TyauDX2tuSXOqyuvrTWs+pRi+b347vLcsfwP6Ocjf4z7Uf74pyXbNJ23nwXH
rcrbl8nOJq4/qsaifbcos++jZ/4Z/EFh/171l28K5612+EW5353qUPKnFBtu
oP+W4PhXdYcvCte05Gup3iUbq7NibXB8oXx7q9xxqGpniteapvZhFJ8qVlUM
rLhS/t1n8tFyn/VaD8oN6wytGXwmNlH8GHxmKTei2FMxm/IxyheNQX9I4trK
pOinyV+7M9gWqUY2tbBfXifGJUfJFmVek4r76+f2g+UPq7a7d/C5sE9wfqYS
/Lv8yeiTyDfZN/i82A/5CO34xLWbqcF1T9Vbq8F3w2/yW88Hx++qz86P71Sx
wHP6rcT109nBNV/VZF8IjpFVq32x5FzCf8proW+cuOY7Orh+p1rSi4XjOsWS
8s/lq39Ssh8i2/Vn5nGUS1dOfV6wzykfbG5w/Vo132eCa9aq8yo2lU0ew3dv
SX2OLE3tV1yQ2k+W/6YzU35bjn5c4tpHKXcdU7lZnT36bhYcM+isVo2hWrSf
c+Lel/9Yi339Tua83M8l5x+Vh/wIrkL/hYnrJsfnrskqD1ydtjRxrUq1TeXr
lLeroDM1cb3pkNz1AtViDtO+SlxzGV7Y/uscUE1GPsbWzDFI9RiHyM+tFv1m
1XBUE9lGn3+C8/DK5f4d37XqCP8G13xVR3iDfiPgDxm7fO78sOpNW4PzS6r7
yybKNoa43rUONY80973Ltt8XfRvVM7Pcz0f57ZC7jqw6lO5buUsluf7InZdW
3WpW4fpo/Rhr1pHdZl5/Bc9tVPT95DPJlx8fvEdUx5wQ/HcLqnX+GpwbV/3r
N3h44hqZnqH2ccMy2+fGMY5onDv+0vk4Kri2q5rgCyXnMP9hDtPjOlQM9Ghw
vkI1l3mp8xvKVykmU6ynXG/9uGeV75qsMzhxnWVScK1ZNZSRwXVh1UHuCa47
qy55f3DOXM9wXHB8rbrGE8G1df2dwwPBOXbVPh4Pflb6O4q7g+vRqrPcq7Wb
uKa5IDivpb+dmBhcy1Y96KHgGpPqOA8H53NUA1JOrl3cS8oDKEemXMDnueMF
5ahnps4rzqa1yR3z6u9PbgnOsahuovyt7NNnyJa57YP+pqJvcP7hrGjH9H5X
8Jx/Uu6J8S6XTcsdPygePSB3rlhx94jg2r3qRGODcyyqH42WzaC9TOsVnPNR
Had3cJ5E9Zo+wfkT1XFkg3WP25A/BfsnA6NPqfNrTubYpX6MfXT2ywdQTl65
LtnDofSZFt+X1saU4L/ZUK18XvQbFVM/W7guovyY4lP5CfIXVNfWGaGzQrGz
YqmWZT6PdS6rpqM4ukXq+HdG8N+u6G9afgmuYakG/XNw7U91pSa5a+X6O5P/
A181coI=
            "]], Polygon3DBox[CompressedData["
1:eJxFmnncVlP7xc999t73Q2RuNIWUIfPwSiHRJKFJKEOZ56IUkUoDmgyNSqUk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            "]], Polygon3DBox[CompressedData["
1:eJwt13nczlUax/Hbcz/3/QzRYtSMFjISbeRFRggVimzZsitLIVslS/Zky5ZC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            "]], 
           Polygon3DBox[{{1419, 900, 1075, 358, 360, 1529}, {1536, 1083, 706, 
            132, 361, 1579}, {1652, 952, 765, 379, 1098, 1780}, {1549, 357, 
            1253, 1633, 886, 1741}}]},
          Annotation[#, "Charting`Private`Tag$38338#1"]& ]],
        Lighting->{{"Ambient", 
           Hue[0., 0., 1.]}, {"Directional", 
           GrayLevel[0.6], 
           ImageScaled[{1, 1, 3}]}}]}, {}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtlUtIVlEQx++53733U3r4yOilmZqFhhHmo6BIq1XvogctpLLaVORCaCvh
LhKK1i2CWhRpu6AooqhFD4k0o1SKgtBealaQmtrvz5zF8J87Z2bOnHndosam
PafDIAjaoBQ0n48xcAG4NR0E3QhbkyBI+F7kgiAN1kBZ8LVgQWzy5+Am6Cm2
EfrroyBYJh/gGuT3kWciP8b3H/SHORvBdwT/LWW2Jcgq0KlENhiYzTR8ERRw
VhpbbA/Bheg5ZDF4k+8B5I/BOfjfhH4eWB6b7QtwArqCzmXumoXdJfjZ4GjK
bF+DudjUoZ8D3oO64Zfg/xxUwvcg+MjHoFgK+Z6JD5fYvYp5Cj+bOXsGfx55
L/xd+Gqwlnze5rwZ+SC+byH/Ar6BtsC3gKvxlw1WgQPQV/jD+K7F/p5qhG1H
ynLzM7T36F39ofnWvf/g+9DfiG0/OOrM9hdYjK8P4LbIYtN7B8Ab0Gd0MvA/
5XOu3J9Aby7+hvHdqRo5y3kR9Fo6yMYVLzQBjfOdjX455w3Y9iCrjCyHilN1
UA5nIn8CLuZsJ3wp2M4dv+F3wldDf6Wfsv5Qn2xENhSb7j5ymYfPDdx1FVmr
s5q+d5bn3ei0cf4gNlvloYDvMWd9WBZaXcpD60X15FHdid4Z1QKsQL4L+Uqw
I7b6doON+D+J7kX8ZHC2Xz7BOugTOvXgKc6LQuuleX6mNFvTvKUY/QR5E7Qc
WS1YD6V0X2Q12uus59Ygu47tWvlCNtuZL+VKNR1BvpQ4Pjrrhe9+HjWXeku/
/CRWV9X3OrIyZ3VU/81I7C71cKGvhWryzlkeehVrYu9Snh/xXQ3lhlY/1VH7
QXcrhkORzZVqkRXaPbpPtcz285Xr63gA/gc4iW0h/CvlBl9nneVfdcuE7mDb
FdtemIytD9Wfmu9mfK3nnk69PWVxusjyqzz3ICvV2529/QdYAw1B+cgP6s1p
i3GJjzNGlqHYUrZbKvG/KrEz6SiPDdgcR+9CYjEqVu2Rw2nbfZr9Fj/XXZoL
fOU762ftTuVNdZVc/sbAtz7nyn2377d2P5vKzXa/j3WP9pZyordI5z73rY1s
HguJt17vCS0neovepHPFo3msii2vyn+vv7fP2U5Wj2kf9nkd6b6E1ukfkFiv
Khea0XI/RytCy02Z7yvFrp2gPXUttrqoj3IS2w/aExN+b/xzpqMaHknbrpRP
7UnNnWq4A/l/blXS5Q==
           "]], Polygon3DBox[CompressedData["
1:eJwtlUtsVlUQx+899/G1YgQEMdhCS0vFoCA2lIJG5SUmGm1jVKIJoiS60Cg7
lxrD1o1x7cJEFxrBtQZiJLrwFSNVQ6QLo2KrtNJqouXt78ecxXx35sycOfP4
z3xrDhx85KVUFMUrUA0t52dXWRSXoCfhf+d7mvN+vlPQCGc1FypoB/zGtihu
hr8b/ukOZ/C/YD+C7XGoH/0Jvg9wdhSbI1VRzCPPQZW+0H+B7iL39nN/uA7b
H9Hvg1+PfjG6Nzk73xTFSvhz8Nehvwl+EP0p+Jc5W0D/DnQv5/dALbpzvNeD
vhc6X8UbL+J3bYq3p/h+yN0B9FfQv87Zl8ijOZ+3vAP/M/oL+F6EfhF39nA2
Db+VswV0zyE/hf0hzq5Fnufeg8ivon8NebKM+MzBXA4hL23jHd+7BZ8H4Veh
fxv5cfQz8I/hYwnne5H/Qh6D/wf+KDaHeWMnci93e6AzyCMp3l8MbYHfxBt3
8J3C/gPur4bfiW4H1AdfGm+KnMztLD5ugF9uH6Hd3BlKUbP9uR6T6ri/tg2c
iJc10GXoPexP8/0N6kK/ARpI0eNdTdTUnNelwI41s3b/iQfkWzn/GNsx5Nvg
L1fh2zeWYddtT8uoubX/vgosLIX+hu/DZhx+A3fvt27QZvgluSfjyAl5oQj8
fouPdehK+GeIZQZ+1NpBs9AbbdTXOh9AP9tEL6zf5iZm5KJ8GbNzmLNpfA8j
n4A/xv37OJ8oA/+fiiHrhM1QE/VWXsEbz9fR76E68p9qYkb0dayI2ZnkrEb+
CPlUEz1xdsSQvbpa/yLmdqiNnMzNmXwX3Sw+uvL79teczE2fn9gf+D/KmAln
wxi2l4FBY/u8iVo7g8ebmCFnaTBFf+2h2JxP0dtNfLvLwJ84VG+v/7XO2I+m
wKrxbE2BebHfBb8y40Nf5m+/mzp2i/nMkMvGFP22HrfneK2dGPqpiZq7T7bV
0YvuFP6dsWvgL1SBBWvmfnCmB7F9tIx5uCLGyuih9+2xvbbH4nEf8c2lyNl8
rOEq5BcyXtwB4k78fZbxai2s91wVO7U/13u6DMyKe3MQy2OdwID7spf3v8JH
X47fXfF1E7vL++vhH+rEzjOf95Ef7sQMGe+RJmraSbETrbUxGc9E3ldNil2p
vk2B5y15JiaaiOcJ4jnrf0QT8Wjrm75tDMYyyNk3TWDMXbIsBfacGWfHHSR+
e4jnrhQz6CxewubXMvbLZN5BYsMZcVbuTIFf7b3nPInFG+FXtIEBsSDmxJ7/
B2Jlu3Gg35b96UNf7mf/O04iD7TRQ7H5bO7t6jr8jed+jDSxy5wJ8eVsGYv+
xOP1deS3N8+M9f+hih7ZK2N01s3H2P3POQP/ZxnzJlbc3+5xd5c1sNf23Nq4
M4xfG+fPHgzn/1J74xtXd3EVb9uT76q4b6/+B4ue73A=
           "]], 
          Polygon3DBox[CompressedData["
1:eJwtkTtLA0EUhe8mOysKikk6zcONCNpGYxCMqIhNbAy2Fj5K0SI/wU4UhPwC
CzuTUlAUGy0UgmCwE2shmhcWYpT4Xcbi27nn3HNnZnf9zb38bkBEomDghcei
IxLHjMEN2nNFMnjvUINuUGQF75W6yMwaaxK90SNSoZdlbhYemd33RKp4bQiR
u8NzPDujs/3kEuheuEZP4X9DDG3A0cuBj1dhtsM+UWqD50KacwvkLolNoFf1
rtzjGG+buoHXhHW8EHqe2XuySbwd9Bu5ZdY+9An+AbpFfUXdJtuCMmfecvYg
9SS9FJwZu6/uv8X8J71S0N7lnPUnYM9Jk/uAC+o4uTGoq0cmQias76Dvg+8x
O4cuuPY7nhr7DUbpf+lnoDeErtEb1hoG6DXRR/jj6Aex52f+39fHG4EFcmH0
Ibksa07vgr/EGVVj/6/+52dmy+hfaODVYRqe0F2YIZPSHJ7PXn/Na0Ms
           "]], 
          Polygon3DBox[{{1531, 480, 479, 1058, 1059, 1674}, {1544, 484, 483, 
           1021, 977, 1450}}]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0jsohWEYB/D3HM45HHeZSbK42zFJ4kSdJCGDjYFJMUuMMjDKwCiKUQZG
Re73y0YyyyK/L8P/+z3P8L3P+3x91ePT2alYCGFBGhVRXevxyZncEEo5zyqu
sIkbbOcOMzzkCE95JpPqT87xh0tMJUJYYwW3WMN9tvKYB/xls9kXrGdSEjkh
XOqTvIrO4TXzeMN83jLNOxawUO7VRXxgMR9ZwieW8pllfGE5X/nO6AO0yJuy
gSnJuNu5voNH0R25x2puRu9zlQku8tvOs/zgu0yoTzgc7clebrON62zkMiu5
64wvNplbwjrGZSxuD/0oizjMQg6xgINMc4D5zDKP/eyTlDrDJHtoTOimsaGL
0eqdjEf31sRi///DH1MxNzo=
        "]], 
       Line3DBox[{471, 354, 1551, 356, 1116, 384, 1552, 355, 1092, 353, 471}],
        Line3DBox[{1093, 468, 1569, 469, 1117, 470, 383, 466, 1568, 467, 
        1093}], Line3DBox[{1548, 477, 357, 1549, 359, 386, 360, 358, 1548}], 
       Line3DBox[{474, 473, 472, 1570, 385, 476, 1571, 475, 474}], 
       Line3DBox[{529, 362, 1118, 460, 364, 1112, 388, 1560, 365, 439, 433, 
        403, 1557, 436, 440, 435, 391, 1110, 368, 443, 414, 452, 451, 374, 
        1121, 1679, 447, 395, 446, 372, 1122, 394, 1096, 373, 1106, 1678, 
        1107, 378, 397, 1108, 380, 448, 1574, 449, 464, 375, 1127, 396, 441, 
        444, 442, 406, 1575, 415, 1128, 453, 369, 392, 437, 438, 1576, 434, 
        463, 461, 1129, 462, 389, 1577, 366, 390, 363, 1550, 361, 1579, 529}],
        Line3DBox[{1094, 523, 524, 1567, 525, 526, 527, 1578, 528, 1553, 387, 
        478, 1100, 479, 480, 1119, 481, 1572, 482, 483, 484, 485, 1573, 486, 
        487, 488, 489, 1120, 490, 491, 492, 493, 494, 495, 1113, 1564, 496, 
        497, 498, 499, 1103, 500, 1123, 501, 1124, 1680, 1125, 502, 503, 1126,
         504, 505, 1565, 506, 507, 508, 1114, 509, 510, 511, 512, 513, 1562, 
        514, 1104, 515, 516, 517, 518, 519, 1561, 520, 521, 522, 1094}], 
       Line3DBox[{578, 411, 425, 367, 428, 1102, 404, 1580, 417, 465, 416, 
        430, 422, 459, 1566, 1115, 423, 419, 456, 455, 454, 1097, 376, 1554, 
        381, 398, 1109, 382, 1134, 399, 1555, 379, 1098, 377, 1583, 1136, 371,
         370, 393, 457, 1137, 418, 458, 420, 426, 421, 1559, 405, 432, 413, 
        1138, 429, 412, 431, 427, 409, 424, 410, 1585, 445, 401, 1101, 407, 
        400, 1586, 408, 402, 578}], 
       Line3DBox[{1095, 557, 558, 559, 560, 561, 1584, 562, 563, 564, 1111, 
        565, 566, 567, 568, 569, 570, 571, 1563, 572, 573, 1139, 574, 575, 
        1556, 576, 577, 450, 530, 531, 532, 533, 1130, 534, 1558, 535, 536, 
        537, 538, 539, 540, 1681, 1131, 541, 542, 543, 544, 545, 1132, 546, 
        1581, 547, 548, 1133, 549, 1099, 550, 1582, 551, 1135, 552, 1677, 
        1105, 553, 554, 555, 556, 1095}]}, 
      {GrayLevel[0], 
       Line3DBox[{1141, 1455, 787, 1140, 1682, 1357, 1142, 1683, 1358, 1143, 
        1684, 1359, 1144, 1685, 1360, 1145, 1686, 1361, 1146, 1687, 1587, 
        1782, 1147, 1688, 1362, 1148, 1689, 1363, 1149, 1690, 1364, 1150, 
        1691, 1365, 1151, 1692, 1366, 1152, 1693, 1367, 1153, 1863, 1456, 
        1368, 1457}], 
       Line3DBox[{1155, 1588, 1783, 1154, 802, 1156, 1694, 1369, 1157, 1695, 
        1370, 1158, 1696, 1371, 1159, 1697, 1372, 1160, 1698, 1589, 1784, 
        1161, 1590, 1785, 1162, 1699, 1373, 1163, 1700, 1374, 1164, 1701, 
        1375, 1165, 1702, 1376, 1166, 1703, 1377, 1167, 1704, 1378, 1168}], 
       Line3DBox[{1170, 1591, 1786, 1169, 1592, 1787, 1171, 818, 1172, 1705, 
        1379, 1173, 1706, 1380, 1174, 1707, 1381, 1175, 1708, 1593, 1788, 
        1176, 1594, 1789, 1177, 1595, 1790, 1178, 1709, 1382, 1179, 1710, 
        1383, 1180, 1711, 1384, 1181, 1712, 1385, 1182, 1713, 1386, 1183}], 
       Line3DBox[{1185, 1596, 1791, 1184, 1597, 1792, 1186, 1598, 1793, 1187, 
        834, 1188, 1714, 1387, 1189, 1715, 1388, 1190, 1716, 1599, 1794, 1191,
         1600, 1795, 1192, 1601, 1796, 1193, 1602, 1797, 1194, 1717, 1389, 
        1195, 1718, 1390, 1196, 1719, 1534, 1197, 1720, 1391, 1198}], 
       Line3DBox[{1200, 1603, 1798, 1199, 1604, 1799, 1201, 1605, 1800, 1202, 
        1606, 1801, 1203, 849, 1204, 1721, 1392, 1205, 1722, 1607, 1802, 1206,
         1608, 1803, 1207, 1609, 1804, 1208, 1610, 1805, 1209, 1611, 1806, 
        1210, 1723, 1393, 1211, 1724, 1394, 1551}], Line3DBox[{1552, 1213}], 
       Line3DBox[{1215, 1612, 1807, 1214, 1613, 1808, 1216, 1614, 1809, 1217, 
        1615, 1810, 1218, 1616, 1811, 1219, 864, 1220, 1726, 1617, 1812, 1221,
         1618, 1813, 1222, 1619, 1814, 1223, 1620, 1815, 1224, 1621, 1816, 
        1225, 1622, 1817, 1226, 1727, 1395, 1227, 1728, 1396, 1228}], 
       Line3DBox[{1232, 1729, 1397, 1230, 1730, 1398, 1234, 1731, 1399, 1236, 
        1732, 1400, 1238, 1733, 1401, 1240, 1734, 1402, 1242, 1735, 881, 1244,
         1736, 1403, 1246, 1737, 1404, 1248, 1738, 1405, 1250, 1739, 1406, 
        1252, 1740, 1548}], 
       Line3DBox[{1256, 1409, 1742, 1254, 1829, 1633, 1253, 1882, 1675, 1251, 
        1828, 1632, 1249, 1827, 1631, 1247, 1826, 1630, 1245, 1825, 1629, 
        1243, 1824, 880, 1241, 1823, 1628, 1239, 1822, 1627, 1237, 1821, 1626,
         1235, 1820, 1625, 1233, 1819, 1624, 1229, 1818, 1623, 1231}], 
       Line3DBox[{1259, 1634, 1830, 1258, 1744, 1411, 1260, 1745, 1412, 1261, 
        1746, 1413, 1262, 1747, 1414, 1263, 1748, 1415, 1264, 1749, 1635, 
        1831, 1265, 896, 1266, 1750, 1416, 1267, 1751, 1417, 1268, 1752, 1418,
         1269, 1753, 1419, 1529, 1880, 1420, 1270, 1754, 1421, 1271}], 
       Line3DBox[{1273, 1636, 1832, 1272, 1637, 1833, 1274, 1755, 1422, 1275, 
        1756, 1423, 1276, 1757, 1424, 1277, 1758, 1425, 1278, 1759, 1638, 
        1834, 1279, 1639, 1835, 1280, 912, 1281, 1760, 1426, 1282, 1761, 1536,
         1579}], 
       Line3DBox[{1285, 1429, 1764, 1284, 1428, 1763, 1283, 1427, 1762, 
        1550}], Line3DBox[{1287, 1640, 1836, 1286, 1641, 1837, 1288, 1458, 
        1459, 1642, 1864, 1289, 1673, 1765, 1501, 1430, 1290, 1879, 1524, 
        1525, 1431, 1291, 1766, 1432, 1292, 1767, 1643, 1838, 1293, 1644, 
        1839, 1294, 1460, 1461, 1645, 1865, 1295, 1478, 1479, 1560}], 
       Line3DBox[{1298, 1435, 1770, 1297, 1434, 1769, 1296, 1433, 1881, 1532, 
        1577}], Line3DBox[{1300, 1646, 1840, 1299, 1463, 1464, 1866, 1301, 
        1586}], Line3DBox[{1313, 1439, 1775, 1312, 1438, 1774, 1311, 1437, 
        1773, 1310, 1480, 1515, 1012, 1576}], 
       Line3DBox[{1315, 1648, 1842, 1314, 1504, 1505, 1875, 1316, 1506, 1451, 
        1465, 1843, 1666, 1580}], 
       Line3DBox[{1327, 1442, 1779, 1326, 1441, 1778, 1325, 944, 1324, 1494, 
        1522, 1878, 1672, 1523, 1323, 1495, 1668, 1884, 1543, 1575}], 
       Line3DBox[{1329, 1649, 1844, 1328, 1650, 1845, 1330, 1509, 1510, 1846, 
        1521, 1520, 1331, 1512, 1513, 1566}], 
       Line3DBox[{1342, 1443, 1781, 1341, 958, 1340, 1850, 1654, 1339, 1849, 
        1653, 1338, 1670, 1848, 1472, 1467, 1337, 1519, 1063, 1546, 1574}], 
       Line3DBox[{1356, 1470, 998, 1355, 1862, 1664, 1354, 1861, 1663, 1353, 
        1860, 1662, 1352, 1859, 1661, 1351, 1858, 1660, 1350, 1857, 1659, 
        1349, 1856, 1555}], 
       Line3DBox[{1469, 1468, 1851, 1671, 1343, 1655, 1852, 1344, 1656, 1853, 
        1345, 1657, 1854, 1346, 1658, 1855, 1554}], 
       Line3DBox[{1549, 1741, 1408, 1255, 1743, 1410, 1257}], 
       Line3DBox[{1557, 1482, 1308, 1481, 1868, 1448, 1462, 1447, 1307, 1876, 
        1508, 1507, 1306, 1841, 1647, 1772, 1305, 1436, 1771, 1304, 1493, 
        1526, 1492, 1872, 1527, 1303, 1514, 1446, 1502, 1874, 1665, 1503, 
        1302, 1486, 1585}], 
       Line3DBox[{1559, 1475, 1318, 1497, 1669, 1873, 1496, 1466, 1319, 1776, 
        1440, 1320, 1777, 1538, 1883, 1321, 1488, 1489, 1679}], 
       Line3DBox[{1583, 1334, 1780, 1652, 1678}]}, 
      {GrayLevel[0], 
       Line3DBox[{580, 788, 1682, 581, 802, 609, 1787, 817, 624, 1792, 832, 
        639, 1799, 846, 652, 1808, 860, 667, 1819, 875, 1730, 682, 889, 1744, 
        696, 1833, 904, 711, 1837, 918, 725, 988, 1866, 989, 930, 737, 1049, 
        1875, 1050, 939, 748, 1845, 948, 761, 1852, 961, 774}], 
       Line3DBox[{582, 789, 1683, 583, 803, 1694, 610, 818, 625, 1793, 833, 
        640, 1800, 847, 653, 1809, 861, 668, 1820, 876, 1731, 683, 890, 1745, 
        697, 905, 1755, 712, 986, 1864, 919, 726, 1024, 1101}], 
       Line3DBox[{584, 790, 1684, 585, 804, 1695, 611, 819, 1705, 626, 834, 
        641, 1801, 848, 654, 1810, 862, 669, 1821, 877, 1732, 684, 891, 1746, 
        698, 906, 1756, 713, 1045, 1046, 1765, 1047, 1048, 1874, 974, 990, 
        975, 1006, 991, 1087, 1138}], 
       Line3DBox[{586, 791, 1685, 587, 805, 1696, 612, 820, 1706, 627, 835, 
        1714, 642, 849, 655, 1811, 863, 670, 1822, 878, 1733, 685, 892, 1747, 
        699, 907, 1757, 714, 1069, 1879, 1070, 1071, 1072, 1031, 1872, 1033, 
        1032, 1038, 1039, 1873, 992, 1002, 993, 1137}], 
       Line3DBox[{588, 792, 1686, 589, 806, 1697, 613, 821, 1707, 628, 836, 
        1715, 643, 850, 1721, 656, 864, 671, 1823, 879, 1734, 686, 893, 1748, 
        700, 908, 1758, 715, 920, 1766, 727, 931, 1771, 739, 940, 1776, 750, 
        1136}], Line3DBox[{590, 793, 1687, 592, 807, 1698, 614, 822, 1708, 
        629, 837, 1716, 644, 851, 1722, 657, 865, 1726, 672, 880, 1735, 687, 
        894, 1749, 701, 909, 1759, 716, 921, 1767, 728, 932, 1772, 740, 1084, 
        1777, 1096}], 
       Line3DBox[{594, 795, 1688, 595, 1785, 809, 616, 1789, 824, 631, 1795, 
        839, 646, 1803, 853, 659, 1813, 867, 674, 1825, 882, 1736, 689, 896, 
        703, 1835, 911, 718, 1839, 923, 730, 1051, 1876, 1052, 934, 742, 1026,
         1121}], 
       Line3DBox[{596, 796, 1689, 597, 810, 1699, 617, 1790, 825, 632, 1796, 
        840, 647, 1804, 854, 660, 1814, 868, 675, 1826, 883, 1737, 690, 897, 
        1750, 704, 912, 719, 987, 1865, 924, 731, 1020, 976, 1868, 1014, 1015,
         1016, 1110}], 
       Line3DBox[{598, 797, 1690, 599, 811, 1700, 618, 826, 1709, 633, 1797, 
        841, 648, 1805, 855, 661, 1815, 869, 676, 1827, 884, 1738, 691, 898, 
        1751, 705, 913, 1760, 720, 1011, 1112}], 
       Line3DBox[{600, 798, 1691, 601, 812, 1701, 619, 827, 1710, 634, 842, 
        1717, 649, 1806, 856, 662, 1816, 870, 677, 1828, 885, 1739, 692, 899, 
        1752, 706, 1083, 1761, 1076, 1118}], 
       Line3DBox[{602, 799, 1692, 603, 813, 1702, 620, 828, 1711, 635, 843, 
        1718, 650, 857, 1723, 663, 1817, 871, 678, 1882, 1082, 1740, 1075, 
        900, 1753, 707, 914, 1762, 721, 926, 1881, 733, 935, 1773, 744, 944, 
        757, 1850, 957, 770, 1861, 971, 785}], 
       Line3DBox[{604, 800, 1693, 605, 814, 1703, 621, 829, 1712, 636, 1080, 
        1719, 1073, 858, 1724, 664, 872, 1727, 679, 1829, 886, 1741, 693, 901,
         1880, 708, 915, 1763, 722, 927, 1769, 734, 936, 1774, 745, 945, 1778,
         758, 958, 771, 1862, 972, 786}], 
       Line3DBox[{606, 984, 1863, 985, 607, 815, 1704, 622, 830, 1713, 637, 
        844, 1720, 1092}], 
       Line3DBox[{773, 960, 997, 1851, 760, 947, 1844, 747, 938, 1842, 736, 
        929, 1840, 724, 917, 1836, 710, 903, 1832, 695, 888, 1830, 681, 1729, 
        874, 1818, 666, 859, 1807, 651, 845, 1798, 638, 831, 1791, 623, 816, 
        1786, 608, 801, 1783, 579, 787, 983, 1001}], 
       Line3DBox[{775, 962, 1853, 762, 949, 1056, 1053, 1846, 1066, 749, 1065,
         1064, 1086, 978, 1843, 1102}], 
       Line3DBox[{776, 963, 1854, 763, 995, 1057, 994, 1115}], 
       Line3DBox[{777, 964, 1855, 1078, 1097}], Line3DBox[{778, 965, 1109}], 
       Line3DBox[{780, 966, 1856, 765, 952, 1107}], 
       Line3DBox[{781, 967, 1857, 766, 953, 1108}], 
       Line3DBox[{782, 968, 1858, 767, 954, 1062, 1028, 1063, 754, 1127}], 
       Line3DBox[{783, 969, 1859, 768, 955, 996, 1848, 755, 943, 1036, 982, 
        1884, 1128}], 
       Line3DBox[{784, 970, 1860, 769, 956, 1849, 756, 1035, 1037, 1034, 1878,
         1068, 1067, 1013, 1088, 1012, 1091, 1060, 1129}], 
       Line3DBox[{1000, 999, 998, 772, 1781, 959, 759, 1779, 946, 746, 1775, 
        937, 735, 1770, 928, 723, 1764, 916, 709, 1754, 902, 694, 1743, 1742, 
        887, 680, 1728, 873, 665, 1116}], Line3DBox[{1098, 1780, 951, 1106}], 
       Line3DBox[{1122, 1883, 741, 933, 1841, 729, 922, 1838, 717, 910, 1834, 
        702, 895, 1831, 688, 881, 1824, 673, 866, 1812, 658, 852, 1802, 645, 
        838, 1794, 630, 823, 1788, 615, 808, 1784, 593, 794, 1782, 591}], 
       Line3DBox[{1134, 779}]}, {}, {}}},
    VertexNormals->CompressedData["
1:eJzsvHdQlc3S6CtZJYqIAQwokoMEQQRWk5OABMk5SZAoIIhITio5o2QQQQWU
rOgakgIiIKKCRAVEBGWBAgIinPWsz3vvKW/tt2p/dU6dW3U3/1D1q6lZPT09
PT39TA+HrYeeA/m2bdtsabZtoyD+/x4U+ymXegCxvg4Wdxn+BuUHm7Yohu3B
l+7RJxRxHQ+aFbwiURKQlqzxYWuLAPy8MT+3KFTxIb7TVKre/OD6VWoJ4zpB
n38BWSh+OLFkZ9VJLlCY0VjFuGscz3rwhav47JXNC9Z8nODneHsN48Kn1n4F
50TinyeYx4rHHAO/zR3rGN/2X38hu9b4sp3Hj4GD1htS+9/JBWvBD+JwbEsh
/F3LnCD44Oja/9xeMOLgdctvXJBv2fkT49nVt9a3xHTwRsd1jMjZ+OABueky
SZ5DGctbP3xxBXxSD8t4hcEspn8B4/flSme2Ri1wS+UW1r+3icPFqN/TGE/e
WhndemCP06lRZJKmkoXfNBZdGLdalbTdsnTGPWG4HtIioQkjrpunMD6dW+xe
H/YBksXxn22d52D47XyZ05o8sBSqTDmxXEPHZAUf8caH4mT1V/C2xPbRvcKD
70t40PIQ56vXTwAo22LrsX4Cbk1Wvw2lRD+fDxyfERWBSfoD3zB+at5keWrP
PJ7BNuh54TAfePreJ+n/JsOLNcFd7/Dx07hH2VvcEGy3uYJxW+hez5sownck
/ZDSP8YNIWGFJP2AYeDaMckOHHVjZec+f244ddqexKl+NP4MNhrGrTtfKeUf
4wEPT31SPy24hp8bUdM4//JvJxPP88P2KRnS7zY5HfZ7f+Q7jkow5oFRujA8
8DhH0qddJLnzU8Ut3O/Zbt4d2mLwe4//DMZvT6zuU4imh6xjP5WPNknBpfSa
txj34tvwojE4CmYfDbhlNZUgpAylYFxqyLJcyEANPg86aqtvMwWn+3PtG0SO
k3agUj4cCmtyVIb7dENxbYSvNXVErtp4V67UwB+JrHldZH8ajxNR5P49ROTX
uG/zPzqigEb0+/ZQ7FAD7ZOuB7H+c5ZlqMaq9qPKM5+39QpKgPDe8jGMp9UJ
rPzeIkNB/MslzYknYJ9VzDzGrYc7luoY5vAHIxeLTrEKQrj9k+8YP/j2yM9x
t3r8wUSftx8H+YF/28QPjH9P810ePjCM+9xAY2B5UgCUFeJJXLw/6vv6tXlc
zsfWqvQtQTjx6uMixv0lU73yVddxlfmD7rYVJ8Cn2JP0u+M/UoQHiqjg/Ruh
ZqcoMYg4U/8Z4zIJnJ1GPcxwWFXqbmXwKVA8w/Ye44d4Tj0U+XAUHmZ5vC0W
kIcf5x8+wLharUlCrMppOF3van/WXBsswpzmN4lcu5EhS1fJFaQ3AlMsL3nA
51lzuikilyz5mCB00RPW/e/wLwefwx9L8thHIPL+3VfqCN4eaOz6tpOrHJ44
d+qh6wvYvExXFCypGCL/5aG+c5rn4PPuOm9svmaqqbWKj/CiNYeuGwXlsjBd
ugdh8ojqUC2ydDEhRzh7UnxJHK7M+kxinOLnGU/vrFX8smqIpi2FKPxOSJ4j
jYuie4Gx7AX+WJ1C7vk9IpBZ30xaFxT0w4u7BGZwugUffw9qiECStwqJf+df
dJtZXsfNT9wOp/cShRcsSbMYp0nf9dVGhwba+tSf19aLw+Ws4imMG0q/aq+N
2A37560Xd9WdAu/HxoMY51vE718v44CCbTK+N+nlIOBb1WOMv3GqoXuzJgrc
JmRH6VjU4FRFnDHGO84euzmlfhYKEu0nJrlM4NejwmRMD0ljk4u/dTOBW8L8
VcjbZLD4pJqhtUGAEilvC0ZqBzD9vbNlXd0Jt5JJuW8Nm5cbXMP3B84jo18B
Fevj9jgZnY+DP4l88KzgnSwdN+T1k7v8wF17IHD6TM8R+UDR0xa7CQlUwH/X
ce+YEqz1O17E5DlRGLY72IsdZc5wK/PZSwO5//dujHs/vXtXu4AS5QmbhViO
SkDP2AzJ/oceVn+uZh7GBz9utb/jfhL0KlRJ83JgVJwwI/8dl0m26+XAvZMQ
PJY4gXFNFwbnSV8qqHzHtfe7rCQ8fNM5ivFSdlOH5+PMcHEh/zu7/2nI/ND3
mrSuFeI2bmkcgVamzpDDwnKQKGZF0mdI3MOcY51CMChBxRb/UxnMOuL8Mf5E
a39DHqcCsKitjBns1oPnwb/OY3Yb4P6yZindDuhf/Yj0rnOC3v37Li38P/vC
X38LcCKlGM8gbAlPJ3bzyCZdw996SPDE5uVoXIK7crkN+r/2E/nCg4d+EXns
CfELqg+vI8nhS6dVdgeDXbR72C4ir62x2E+2qoQK5i6x2YSehadH57MwedxH
M5xdi7lRPXm6U8YtBZATr8nH5H/1i1FBuYkJdSn43rValoX5U73PMf7wi8bI
td7PeOVNX0vGamlQ2yB/hfF7eAZjnPA67pCFVy3jtDQ8aRPuxfhMXBW50Ekm
SCRcMTHixkHt+eOkfrgFXtSF2R6E8nu++0Yvy8PeEyqk9X64WYBcxY0Prr/g
M1/YpwJUsRRXMF5eG68WE38a9qLld9Ifz8LI4YG3mPwTnWtOVpu6MN+VufR1
jyWYvGQRw/TAYTTm4L07BHJeJw7towiFUp8b2/2IXBoPhAzGJPiw+ZGnxywU
PDL2JyZtEqBiqOuiBaMReFRNftpc88QvS8p8/U1sv+fwDyd6f3N0r47WMijE
E6+THfEW03+K9mm9LPJXEBXf9KKPsgmt/DzktdUwD5khp1t9gs+hnQM59NYe
pvBqO3UBJs8F3D51zVkxNC7svujXpgF7jFnFsXEFeZAVp51lQ3Kq5J/PXVEC
9cWTqST9VB1Wo6tfwlN+npGdS1KAqwcryzBuyjRyhpuVAoZcqN5rlSnAlkha
KcZ7700JuYTsA5oruQ++miqBqglzOsarosaaWhi5gas9vUiZRw0SurscMF7P
edGqp/okdCt9PVX5+SwYJbFMYfpkS/NZr5pVBTUL6TPuYiZAz/VlGRuv55B1
XaS2PdD01d3KfuEGpernH2Drl3dt5AgdXT0SlOalZDGuRdyvXprsayHAVsTV
yVkbP3h0uO+iwSt70HggzDhAbM/+bMuqWUcPPJ/dR0HxQfg1rRsPsN+VlmIu
fXjD6P+256LnWW8x/Z9/ebkjP/UhOrnUfJNBMg+svl+mGJwhxm8novbQ6Dki
Qv+35opUFxhz9Ln0ldg+tyDbyeiePJrSct1xfuQc+Ak828T6sd3NJ+vSx4V4
WEVrmCu0YKOyiI20n4Y8MPMvIEfvrbrCZqQ0IOJorT7GKc+I8dU9poXyeLkJ
LlkN4DrGQeLens4LQ/NHoRjd5bHc0IS1blMejJdEOQW2pYiCRsP25u0tumBF
2FOJjStMumwhskUB5JM4776mNYErUTXimDxfuL/u7vxgBD7fXxbt6jxPtMcj
ZcuY/a9t738eEAQ7a8+f6ZKIgLp8v3arf/APM8nqY50JThAlwbsV36APeIc1
eqyffZFiTPXvtSA3d1fC1ilPfPQbGQ5MzpQlXPX8sD5S4Mhbx51Mw4+n5Phi
cp5/J3j8gNA1pBv56WyEnA98p1F+r0rkuwau94u6hSFxS75u2t9h8D2o6acO
kZOrsis+c9RFKdo1aZt+tiA0dT8Q8//PFE8eszYUR/v2MORHOxvBkjplCzbe
iN+6DrHluxByViS/OqoPjUrcPtjvjuDUr77avQe+bFOptn6uD6H5kn4Y771c
uud1sxDMRfN7d8kbghfjIBnGL4kahy1tkwOD4yesU3PNIeXKp1jSPiVdnPRu
hx7Mmz282ud4HijqUyZWiJzHRIuOL8sNDkRqzLmJBUAEeu7YTuQ3Zj73xTU3
IOpI3Q+RFnjUITz7LjiPGEd9UusePhgJog8dDOBcCExD25AWsb3vtjWlV3OW
QLklvo1iUQXm3mg1Yeuaqk/J68AzNeCdsYnfqnbEd73KPo/pWeLTM/HDv3WQ
dKaG9la1Ij6v22Yck99PMkK0wc4XfVvKOKNdbwXMsu8ujxN5fjBNZaN/C7iN
rfu6uDWjUP2e3dwWBJAX/hyjweWAaOUvvnO97ANUlnG9Y1jcwuwyouuohHyN
YyV/7nMAzfjgolXMbh/oHiQ7fBR5+i1rm/RYw9DpfUmYnLvKcxVrdnPAjks8
I/ZJ1iAX6PMQ43KOfGEeVtIw+K76x05xO7ihfYBhHZuvZ+5VqQ5nofyhFUV4
lwscCr/X94PIg9tynq1YO8BDyscaWhKXwXgTx9FH5FzH41eu7E5CeWS8iTLX
s5GImlda+a9/bbdmiwaW/jaeMNfE/uH+iCPk7jhkMI3FM11fHTu8DUAsbcVc
dFEWLnG1/SKt35BUt0e9ShDVc6xuq98Bl5/TQIq3E2SfPUu01UJJtuWWW1+i
8dmaHKT1KOai4YyTcULBVLNlwx06sKNjtAFbF/axnX6KjXdRPHOvRkzwHeCx
N54V+kqAHexpe055yqA3dlVvSp21wcj41DQ2X7oDxxc4G0yQ3lgKfayYP8zu
P9o7iOkhPWuR6vNJ9LjXqpGe3QuEx06kf8PiilNTq8ORwhDxWkaKJtkTpG1F
2ueJnE7BoNf+lBbIhN10TlLyAa3++aufsLiUrXNXULYdsJmnyy8oh8A29o2O
eiL/feGltHxLJLoyz3tkvTITnTVXpOX5/a/1acGUd1tELgTOXU/V3bMzDHZ+
g1xXzN4Wn64vJ9rAF8nmoy9DjeHVPva3mJ1IUgQwzKeeBfdq86wg1pNw6cnQ
LDZeVe9du+Juy0NQXe+TrZwr+Aw6ripMn9vp3b9OFqijj/sS8rcywnDv2/Bm
GP96904x630rtM64gBrxSrCnQrUMsyunOD/ds0dDkfCvkgOl5oGAS53Uj/gH
P5beuhnyKPcKrBo8v5lalYFUNiRKc4njvTgq9Oymow4KtXZ/ML8RCamRdbuj
iP0s6XI1mQ3Jg8i13wYWapHwvTH9YjyRU6s7EcR3ngZPsYYftUO2MBt9XxWz
5777M3Rk+QlomNa3r+VjGWq898otdulfy+NT9i6F8CMacr4NStS/TAY6PlYW
RmKcYPz27sanJSdgrJu7Rb7kArvI0Owssf82PXZv8xUDOJA3a3MTaUF2jLMc
Zrd0lLqFJ4j7rm6f1dEBDWFgPtNrientMs299U/sOOiPdXyxpRCEW3HVbyft
L0WbUcYhKkgtajlrq8sZT8XmGko6B9EtD1WHGqJjrmaMrYdlYGOC4g3W/+p0
iIbq4wvoFG77Fd9eB7AVmI3D9kFvN1eV7aw3EP+TvjLFc2kgW2EVH/oP9vOv
+FecH0fkfCCicdvHIDXbhvIZTNseJv37/VB3Wew0vRoO90pUWotT06CNWU22
lyhP5eLKKwXhC+Dxpev81F5fKNfYcRtbX6/5JHri5UxhMa2+IWDBDOSdJRSw
eWybc3K1WdUCdvdXzveXFWHe8n0jZrfhCgpXd68pAKecxVsDNh6QEvqWjent
kWRwlOwLKdCkc5ger03BvyBzf4fxb2IL2hcGFdEVqbrSYMtY3Efl6zkYL0vp
T9Of1EF5H08UspiIQyD1XAfWvxztpdpxa0v0glzMgnLWEFaf7DXG5GFRNvke
aOSKflOMjX2R8AXCu01dLM4Zi0pum7/kjzJbn6XRKiTDfaMH4nGb/77ecnZu
qw5cvQQ39h9IyjtXAL1044qCRL/6u5tSfXnRE5LzYxKeucbC+nAAHSfxd3dO
qkUTz3CQtE01lWP5Eux+5+2N6TN2pz9z6G4TuPiiJ/dlqB189N2ThZ3LjtAu
XEqh1wFWic8ZLHS6YOH/cBizK/1IGphIIZ5nqmRF627KQEHkJdI5UTmLk+6L
Lg7onGUCKDmOQW9UfxPGz53pLLQ+LgGxBzY/bzGa4EfHjD9iXF0y5uSpNHlE
kcbaD5lhuM8TtSR/QgbmNrx6Gmhy9ZjZ7Q4hEHuyqYjxB7KtVidM9NHGEVrX
K7yasCVj0YrJI+Sxx9tcyRS9/OXbz95nC0Ze+GeY/KPUBdxXWs0Re+fM4CKX
D/Cmj9tOEnn0ec7L3+z0kDo7ZNCJhcBRmzTmp9g56NO05Yo8J3AYc7BzHAiD
uM/G9BVE/vkG+6VfVbqwv9CXbqInEFglaWZeYPuyy+7Ne7QGsFxwkvqt/kVw
K6pT+ULk87dOB2Sc1gOLcM03P/vtwcLwyldMnvMt22U3zDTB5tqEPJOjITy7
xiiPyR+rPdQ4a6EMdEP3L9T9UIFv5/l2YuO1Z5wzZ9krB12+TLsOhJ0EJhGL
QlL+ih6X+CLmFNw9kj+wfuIwZPKkkuwWzJKSdSnFYO5cGmFL1g+38MThy/+U
V/x/2Y8hs7N0W44m2HnKtQmcskbcnzZZMf98P/iaRb9uDKrlD2KTsMhH/bRb
t2X+Yb9u/H3+R2BaDFJdehn21jwWhu/facv7b9hzyhPXn9I3oiEmfNCnYyQN
BtQtLTKIfoCM6qX7w25JVBGf77bwTQPOdalzY+NiFLmuGnExC3FJGGdEZ9ji
QqsMDPyJ7Q3uiAuf8DACCbbc2mQRJ+I6CKpdIravTrO0u+ibBLSTdC7HuI1w
xcfk+XuJchpcPq5adj0FlFLJFFb8s5BrSxHVGnG8NuKPnG/XtMHe+4x9B3lf
IFiNz3kzNQ/3RO/6SKzbQbulr2J63hV4x57DjNlDTG3bwakNd4gferJTnjsS
7gibHQkl8sR77TY0/T5oe8UZl+YIR+Ab/SU3QuTH9nF45KsloQTG8qLBi3HE
fuscN4jyj21/3R0wfQcovtJZumTUoLXru5WDR4jnbg46tlvlBehLfp3P5fVi
oAyKs5cm7lMCx8vNPH7lA4VIf+kd6hoUyL+PyXqCAExM6UruE1XI+IrBgRnl
TkQzR3liRfXfn5crFe65yXci4IxeXQbdu7uoWkUuVI/4u9E1FrZ3hSNRbmWz
+WGUDiYKFOrXifI3BsgMC79xgv7r/ZqdZH6wU2BU7S1xvD2PGdY2AlRRwI0f
uvP798OXjhpvbB5rsgSukt9TQHoSw+WIPx7Pb/KBdG5dHHil7JYkCZ7qV634
Fekho+ziCMZfeG7YmcaeBOqHBz9XvNgJgTqqpLxNTHzWza0LCfjBd85183pK
0PujMZOUjzWaMsefCcX/VpIlFAyawYR1+irp3KqUzZnZcBsE1MSCeshakGlD
9zrLnX+tH8kNMi32Ol+gr7s0o8oWAQOJ6n5Xif0oPe1V045QRqa/BFzbnrPC
+NfT10n7xZ19HlQx4pAzePZz8MZV3Au3O5/+aT3+Ky4RZ5LOXVUIEgdeGMb3
ViF/5zEn66l/v5/ntC8nDtcVQHC/7dRicQNacF2cpH777/fz73I0cs74g74q
qtIs92vuNobZtsdMmN9LHGAx/LV1HvYo/JzXtvCDI6IROZidKHE8TxPJiUZ0
PFMMi7PpqH3hsJIj0a5e4ofbfe9WIqbxiclgRTx6c1CJrrWOAENCXS7vpiPA
O8F0M7/6BlC9jvvymriuZ+9U5f3iVUJOkn6QJ0MJ5UxLWZj+JzXSnt3acxL8
tni/tHKu4+gu0pHypSymdhtNFfcR2af2vR/2N6Ep/ssuKw+JcfjO98/dBSsR
NHXzaDG1oobj3fUKaf++3uwopBrS8qNQ8rXHo9VTt9AV821tvhvE9bKh9ZRt
/D6yvvbund7YU7S154PYt8f/++flX/HlIJ+fER8jgZay7EAZTzqsre8RzyHq
P+1jZ4hudhnKuJAVSMF4E/fZfewpfpkYr5qPG3c+qIIEDhnRu1mNiG9kU1Lh
H+S3D+iy+sGfhSzYOdWsnbJAeC7fa9s/7C9Tl6+Q1TrE4UIUTFtH7l+A0Qyd
7Zg/FxDTcOH0VkTpciORopkUkCpBX0DKj91b+BDeLAYsddU/tjiscdIKt0jf
F9Jyk5qDrG7gXBLiZOXO6MOqNv4GFr/9po+gb8stgIr5awnsXwNxMXw96DhR
nvyKNINkdgWUVZqAtjiv4SfoN8tJ37MCHyWMSYvDwrcfFxS/ruIOFyiQvq9N
eb2/ns6ejdgybTZnZZ8iNoNZJpX2fz0uyrIVIdrAK0D/6VWXnXcyHG+21gv8
b+yb/y7/+MqoyZrLEJHNDQilzAZDwu8aFzxR/rv3zOx5v59H2t3X9/bVRIBh
BHVaLJHHJ2aEZPl5AceYeKYRIQY9L/IO1MX888zaqYOcF8BOWcVDq8gL3tSN
0H7E4q6HnDx4Lj+Q5aqZG9weBuulT4XjMH8rJMYRLhcDy4aiD34+TIWfhTwZ
TUS7MlPS7BoxMkTDX87oUJMHQzZ19VIzsb1euoa63dsQeHCvmiEnuQAN6P6I
/bT+v18/s+fD2W9aWyH5vBhhutc+4KIVzoiNK7SxJMC3/QKq0VI/pVkbCtv1
S27cJvLuYIbjZG26iNqwWmCuxQ4ul+rfxc7RKdWMASlzDsjql0xPhL8RXN5+
1AjLO9nEZwbQ5PkgyQjJydBcT1BJ2uB5g8W9eT90d9JGok8uhk+Zb0dA1efG
Ri4iVzg7FEfnbwfu0mGcGlIRIJ9E3Z9C5FZliSssO84BPXor1tjkCfK11FPY
+Y568j3eh+kGIue6sFRBVoxcZRp30awRQGtek1Ca4o5ayLZHDnV4QqZWbgeW
X3rb0TMtT38ZfdjP6sTDHwiba9eE7vw39il1N5onM4X+SM5iQv7HVBiY+DK9
CsHWY4vv5xcU15CSaKpG7mo6nJY2adcnzrulAW7Knc4Z+ck8oEqcCIPbjFe3
5/zD7xICX+7YoX4LlAd1bUJNCyHS7Chj/89/X86ftMOrxmQX4RhfXO3V3+Ew
48j/NhrzD+VNuzPuh4BA36ebzsqp8IqyPeIwcT26XHlWlD52HakvqKYNcCRD
XqbRPXIiX+TtyXqWdhktcvMpdrwOAX1VlnOJxH5o3L11RsgugVQ5l07o20Cg
LGRuKydyXurDhKYPl4BHrXMnq2kIzIlae2YTOQUH11fbeUBRr9mbeYud4cCi
ZQCWj+pkdzpS7qmOtO/aqfnqe0OUhhz1DJFPs9IzpL02Qjt/XKUdNb0Cjy6V
UvRifqnb/c73p0MoYXhulaWpD5nc3dx2tnIOkqT36ZUY3YBJ12FRstgY2D7C
7FFBlH+KZsp2aM4f7Oh2RyReN4dnW8e3vcPOv3eNbq6N5cPumOOzJ2WSgdfC
y1OOuO7iZM7JTFu2AdfbitgijWbYRl9hH3mGACue9A+pH/YT5WiybcjqA9Wn
ZS8Ix7/Bl+SfhB80mVDUYMrEOpUEKrfvnw4i7ncNzW+dVzgKYWzpu3R/Xg5M
Kv/Y7U6cx6ZMpw+n+bohfN7Gs4izDw4XqjM1L32DyghfnrLKdrjo1crvLd8N
pZ50yi1p8/BC7ZhWBk0yEE4P9lWEJMMZ9+0B9kS7qgqk169bz0fD/l+/57Pd
R/kUFJxHCQSQbGvL1DpQi0bLPe5Uv2xFbtvLpgRDCXDHVKe3WS8dcl9R5Ek7
ZoH0887tMUT/Py2aQCH8oAD1bAvbdNssho9bFpaSxLiXX+xDE8exavRTz6Ob
Ia0Tub1NO6ivSIxnuGXOWB1JhtJJ6Qt9obnA+BVZshD7KacsiXVNTgaVyM1Y
q7BnyJedKprzOjFueZ+Qm9x0DaJjgu7/sm1HYglb1hd9CUA/UHXdUjUQrW6b
7PMdK0JeB4pVC4nrd7Ka+RFzbAS6wZPYx3/wOUpf2L/9fAQBsm6/ueNQmov2
OR66fXTvI1RY9fTm2BsCrCv018yxxsLQMcXfdbsLgDDT0H2POI8vWMsoB/oC
0Ac6GFm+Vgw+eZ8WThP7H8pIvDDrmA7uL0+9EJ6dAFqzXdqa3V+AJdE5PHif
P3S6/HqQxFsI6MDxzmpiP0dNFyOO4Il23nUd19VWBGN6NMOtxH6uffV3lCzy
A7vU866HH6eApo36RyOivXXK5Mg2zHgiFrY4arKCfNi/Uoy/RdSPZObHq+FC
qtCZ7ajhmXsTDpKzvjj9D/moY2m8OvdMvEDtitDJZjI9YFyUnJv7B7+x6SdE
Lu+XBGY8KYfp71wDnsJla75/2GcfudI9Cc7IQrGuvZKF3XdQwUhgcSpx3iNf
vJJ73BADVeRms7qEWJBOih5PI/ZT+ej5u06XGHj07HqCMyEG1F73BWLnSg5B
8UPhIw+QmPEJroG4NhTNVRt5L5x4DrreKc7Qnwx7LZUS9z7PhcejLSdnifrU
5l85GWmXAb8yO03GgzqRCxkw3DMhgC0d9evgIFsUjl41VYlnoJNJA8wfiPrh
90sajk57hAQ54qgm8YMoJEB1h53hNzBJsdRuYooFCx2G62eO5kPRvGcwL1HP
R9lmjBdzLkHLuW3iKQdT4YxcuMkZopzOadu/7Up3RYaB6aJ7bhfAWl7i1T3E
9tW7jp4cfWMOhx87Jy23ZkGZRXYntr685lOlQjnuIZb3Lokfvt4BVis6j+g5
Arh2aYzWpz0HtVqbCObeXuSVX6OtEDAPDMfGRJ1sctDV1nlTFVwuhEvesqYn
2sm3Yy1C1AuVSIGfNzPYpwlFzX/SXriH9b80cXfxFtobUKbbb14I+VVSZ8uJ
/mGZstPXqKgQ/NNDo169fIR6zYa83r4iQFLgoclk60RYEYiY9jfPg0zftxNs
RPkDK3053FS74A1lu7iOcB96+e6x4i3GeTgaU32b60k66qd4SB0Snwq25MMG
54h+qTXr150nYqXwYkA4881gDZLrkem4OUwATa1Paz6a9cBkdv/9rrstqKMv
Imd3FAGEvjvytIwWonU7m3cuLiUwPyWbkfKdAFezqqYUKxphXepawOORLlQo
3ctvupMAtZ+bdGPl6qCUmSf+1XQnau3wOzQiQQAHFtklKv5q5HGBUo/nTic6
E7Dkq6dAgFPjAQEKg4ngd6aegs4oDyhdc+/TE8dVrHVtkoc+HV3+9Nq+IKUA
bsmNKykT9dkVp/udrSwDwcgU37RlPgycf3U9j8gHKG9xNn0rAZUs/iybj+1I
ftvXe92OBNAXcOrvehuP4jTTbvxYLABuO87CHUQ7LLGRTxOkvweFNHm+2WbP
UYzfhTNel4j7YK3xpYdWJXD4ICVrsUcLGgq/nHe/kAC+AgtxnwZSkItxdWNY
dwFoKAz1hxJ/1y9bi/9+dAI6yVlTdoStAEy3K0f7EPvvO/VRdnC2AryFbQE4
HiONY1lzws8JkPN2/6U3gwVo+eJQ5z3R21CmTqm6+YMYf7LoqZxEJZC40hOy
8qwFESaPMMvkEeCCRPiHOz8KYeduwXoj2mr03DOg994kAeDbwvPOnkI0nuCc
84z+Dnyxf8PHQ5wXsufru1OeFUINU4VU87daNHV0+bH5CNH+5y9w1uBS0e9D
DzmfsxRAqmJW4DtMfictn2XdJ+BuWdjxleUlWmyqaf9ASQBj7aoyt6xaYLwS
YkF+6AVicZfq7jtJgKcHG4diAh6ifnWdo2kPm1DYmUKaphIC3Lxkq5B6KwOs
rh8ZbB/Nh4qy7n3WxP4vll17LET+AHXO8Add+dmMNFI/atfkEiD3SRmdlFYl
+m0Z39Pm3YwKglqv0RQT/UY0G2X5+VQwX2WWfLE3H/LCd1roE/V5U8GwrJ4Y
Tz/R+uI+ezMX9KJ8Cu4SOY0q5dXuxCpkemsuiKWoGYn43vjGkk3cjxiWmaMO
VCJ1rxkqbcdmdG7Ry+oOsX/a5jExMaVYGBuuamDQygOFKgKfPdHeUuL3NL1X
S4QK4YtX0g7kw/pCCfMXYv86VarJXIbVKLf4jo7YcCdilw7adhqIfiZ4LpXS
OR5USphDbTvzwEXoOi0XsZ94Ed5n8aZ4MI8N3/5T5TmiHTsSpa5GgEG1hMaS
bQXIvYTS3au2BcV5+Ff5FBHjgY5zTrd7ilDw0RV5X5NW9KA+ovrOLaKdpPZw
ZcmFwntw6878lAHBF2ncA4h+ybi4oUGWJgYGFczM+PfkwwRPUL39P5wrSy62
4sILStEXqidcR/EtiOruEP1Bov5ZVH5MdrhVo06do10Jii8Q7dZlXLwUAQpG
vJkcbiRBqEiJyYmlXMhyvXEXW4/Ny71fpQ6GoNFfrHS3b9yEo9lBqptEfzL4
yCKs1DYaWR+jf2r/ugB8bPoMQoh6O2yn5+a4FocOF60k1jYWgVxLBPUOoj08
v7D71wnfZOhN+NL7paAejcyTdVcQ/Y9Ay/Hqy4X3oYX+mwstYxcaELFpwRPl
SbdJg8n+JBSrOEapH1IA+U9y3FaJ/QTWfaYWvNaCqtPng9b5X6IPzk23U8fm
wcZo4rJI9C3gnRY1OxNTCGpZc7r3iH7VQcHbRn/0Fjzt+UFTjwqBhbHD2J/I
W9T9f+iYZsMiuzau3bIIjm1J0GyuEOBE/51P16auQWpfZubi9XxAPWHmu4h6
MJbzmu2jyUDKktcpR9bygTsjQtB17f9cHuP2muqm9LQfCMS239Nm8IfXlO85
Gv4b55r/VdxTfum3r8RneDVZ61Aq9gkkT/NU6Uy0/x+T5z/8P/w//D/8fxUP
bywoET40AcctVBhky6ZhwSJa2nxr6P9zcv6H/4f/h///h1PcD6J7tFyA8sc3
gxn0ioCguvri0DIB6IVNJeufmyGmz1mCcc+kAZWrvMS+Cyfakn8KfuuOlxTg
H4p7Lwy/TLlIdUCy6OWug5QsaHNHy2vbt+Lg8VybVEeg1RC3jgwu4fevL850
CvDAfvUxUp0R05P2fsmOVfxtt3uD3pWCkNzIQqqvUf2ytbpVF4ynjzGQ3nHi
OBQbbJDqy94WH1+TTZjCMylNozw3XiimHCfVeZ0zuLtxRzMUv13z6GrCt2Pg
EtJFqhe78rzJr+FiN/6pazgvWTk3VK/LkOqewpbXNw5LhOB7JXVekeUeg6TS
DVL7gIW2daObyTiTjomciFPccEEwhdTem75wLfiBBU6XlrXnJDknqOXiSe3n
/qpTE/pTp6aWK+N/mPolLvbTtePDxdwQskeR1M+v7/9Vb7X2V73V/eNFpP4d
j5855FrBBRqnV0jtN7/hjNMufMIJTsgXh+/hB5uSMFIdlrM24eeWlhqe7coO
+6yzvMDj9pukh2/ZBg1hzgs4Qt58n8N1IQgHc1KdkeTvXUvg6ITzrcsg8CkJ
gudCDknP+YG+83cM13E7ig34VzZEgCHgFqnuppltx0LwBTdccEEp+5cXIqDU
KvGVdN9m+LRjYio1LFFaN+yJloCljI5xjEfSpX5Fe21wFxtFw1NtJSHx5GtS
PQj31lfYuc4KF+71aSrqAigmFpHuO1U27XwWPOKAY9/i6yohyEPueHIlxn9b
GqsF7BSDF4Z2eD0pTegzEjmK8dE58jnmBn6cJLNL8MPruuCjqP4S+y5Z0f3Z
L6HNDDos7zoYNhkCH5P+T+xeGQN1iRL3/nPI6vKw49HtypA3dPk39j29RP3y
1Zet/EiWa3l4pEQGtgpvk+T52uCPOx7FgI7TspWV3BOFR2VapHtBDx54Vd9r
XcWPBlOtjbIJg2/+Y5Kdj+xJGzQmn8CfGY5kPZUnAFd3CZHqvPb4nF79zFSE
oz1qurxtgR8uL3eTOL+3i9iWyThu7WuT9W13AdidZUrivH/qwrL/qgsTyIln
1vy8ilNsE4hN8D8BoUlTpLowR9PvXm/DKcDsWpmA4ytR+K4aSpLzXH6lm2Ue
IwjFcuw+WSgBYWFkpHlpfeiZYaHKDqKZivcDXWVhhr+NVD9S/8w+ZnuoMPw4
ufom4pAKuJoLXsL42ZWXMg6M+qCmI0f96qAZCDk51WL3ndzO1WWeG3SFFxSV
y8nRF6DmixbPZ+zeiM1SI7OZGaK263/2ukUX4g+dHMTaO9+0LxCtBmReWQmq
qspw13qbDtZ/UqWlnpPRQaQRby75VOoUONMtD2B8r7Nyt9ciNSrYxSDfdUUM
sktaSN+j70sEfXqTt4APKRKaO3ZXBCLZ3Ul2+LCSenlvbT7u+TYBidajRPvs
u02q/wo6c7h3x9QcbhKXHZ/nIQK3bv4gtf/yV11Y15+6sP7rl07W7KEG8p6N
px/cxSFmzI10/wS3FpSSGrcL+kTapwPqJMGc484wxjU2GV7KnD8Iq9vJelQN
ZMGsZZCkT17Ky4f6evhh3xzX2X4mJUgzVUggrSOc3bGOMnk471Vo935JB4p0
riRjdlsYN0d5Uf4KHNmnNQlxfiC3p24au0e3Y9sBl93ZaXCDKj5jKyARRAa1
1Q/+xuqMXNoCQ10RK3J1HGKxhRu4aRHsXnRK3zhP83c9tHHm7X0jHj2oH1A8
i9l5U2tynAI9H2rZ/WkrzVYOKHeoku4N8tr3iu+22Y2yLyjYtR2Rggudu0j6
twzjFLPT38DvmNv97r2+BHy+cZtU//uKLWWJYJ2PL9ybHfTj6klgu8pB8ue/
wzLucRot435FXd7DNnYSGP22ke4XKf2pC6v4qy4s8qdWL//wLgh1V8kYYDoN
NKYabzAeW1iWOsx9EFwLzYPqpnDAFkLTTNoXLNxaH5jwAv+HsUL7l4qg93mF
dF/99KJQ5cw7KaCv3LPJzqgFQ028FBgvvDF1/a75OeA7l/v12xsLGLP3+Yz5
gZ+brY8zZqJR2H319PkTV2A90vODApEPDxd3fs1zR5GPLxpveTmA+tkPPNg9
5JK10jbbg5Loht519lYvVaB3EDUg1a/NCUapkh9BIyf68o51ycHFi1drSfbJ
6BzcxU+Dxs4Lx4eyy8KkbNgLkp14d08dYWrFP6tQ9OlF0uCoNU6q51qr8o//
RrGFMwynuHtKSAaep3L0YHziT51X/F91Xpm3Ao4MPmEDq+hDc6yC8nDfSrYa
42yvwt4rBXGD5GueWP5FJTjb1niNZOesGvrJcSdhCs+deFhCE95/3CTV6Qjy
ezwmK1SDSz4i95QpjGAup94QsxOd8OgJ/BM3EO0UsO/y9QIvRnIO7Hu38kaw
kWt6BLi9NzHS3h8KKT0bBE0iv/1pSr9UMh5G/DJftVsHQe/xGZqJTQKU+/sE
KB18CdtW3izr8jxBkqqPg7YoCdBxz46To6MSpDtpGz5uz0NZWj433L8SoPS9
1t3eTGVEB1n1vKp6oPdLWxZbF8cDHepE8HzIAlF6Tuepwor7GWdM/v23S8un
yXcj2xgyte5WRbAg/6/7yW8Dnsm9Wx3AR1e3T7VmKEC5VRKpzistVGo+sJ8a
RN4w14SOK8A5B68Skj/8U+dF9afOS/lPnRfeeB9dX+1xuO9fGnmzQhXMvru6
kuz/+oGj/TxiQM1jPvDmpxaY7bm2HeNHp9Xzz1MqwtbA/rG0RgPgYVDpxvS5
+N6aSVzdFFYZ7QX4RR3AyeynKnafgdr2QstWZD7aF+mE8PgcVJzlL6aySoC2
KI4Yxe8PkEOAB0/k00pkrFhyQ3aMuK6L9G6f3O4LzovjX5UkbAEZlvFj89La
lPVz21gF0nu6oa2odws4mXq9BOcJoCIpItX4PAUJ3bqVM5cVAX2PQp4wEOdF
qyJdnpnCCI1SyKUXBlqDP51QJVZnVDjFQFVlJYkYb/Y01r/XBS06yTxM/2lU
7ZVURDufumY+GWarCatGyaKk9Tgh8aWK9yt+j9yvAw2nNQAmlkj1XOyD3e7n
R5lAh869iz5NA0QEZLQxfuFPnVfhX3VenuP92VKeIuDxyTY2zkQXus+sI+x3
nwVq0VrYy4HAmeOnraWMIJbSrwDTp1ju6KGfnnpAjhsZnSDYwtKk3y5M/kZR
fYdrUhch9vj4KseXy/DOoVIVuw+z3/hSBXSnw+1o0Z1rXxKBbXp44P0Gcb0L
+r7OdT0P9LhKS195XZgZebeOzYucU83510ZRqJP6V+TFBi/43PUp0QOLAwd8
dDwPRqDSQ22eI89CIGzqfeg5LN4DDlH+654otYZwx4TCB+rHwsew+3ja5I+j
LK6qoNre4poWAUvImaX5ge2D1w7/jgh7IoDEHgSUUewxhCj/AFpsvP6mz6vf
LG3hdedFCbUD+pBkSXUJ43ZHeJdecByApFOH6Xr2nIMZ6jlnjLf+qeea/VPP
dfFPPRc+0YK285ssdH2kV/v12gxGBd42Y/F5lOZe2S2Gs5A+UvC20sYehC6J
JWH3bQis2v1pHx3ggIPZvrwUHzDtcmLA6qHeRUemJszcQd6N3VL8r+8jt55z
7oyzRP+WmGsoz1iORCd8VsqUq5B9uxzN2CgBnoa9Of6qOwSULPNV109eBqv7
m+VJxH5SHSZ3ld40h6ffOqbfMSsB7wiTMyaPmZ1BDj94I7nHZ+wdmszA3aDn
HVa/E1fpTSF0pREGzm7Klx96jFQ1Sg6W3SbGFTHHVoso7kHI+nPOurJSpMO8
umPXHAFOcSeycsiZIqafK19mqTzgqRCPMrYPvstbvL0yLYOktN/u3gi0gwTF
/BHMTj6Ma8feKWZG4YJC4uzIGpjMhrOxeUnMd8vb33kcvC5sFDz6ZA3sA8Fh
GBf/U8/17q96rksVLGLvhbTg7ala9tRBZ7D9TtGI3a9bvLonc/eWDVD7wDC/
wiU473J+bZjI31fu4uQ2DkexEvxL25fi0ezR0E9VxPXooFO+v8U8EYzXdr5W
uZ0ImVLeR8aJ+3vLxon+SrkLcOj9aivdW1tgVr42hI0rM3DrtwbzOaCXVl/m
EDsNHWwyCqR1mjkd13X4PBrOFuHUtdKCAD77MOz+PP7ntY4kj2IUH3+F/WBr
AXjVXw24tkSAfXBKDWQQsGvundVuaEU9F8PacdYE4Hv8Zm3XGg+i2zjEGbvm
CYFzhB9YHdZt95qYsn0n4azE7WTj7V6wbuTcgvFN+f+qwzr9Vx3W+r2AE1XM
tlAjMjn+kzwYYruqOrH7ct/bYi7o0LiiQO+igGWpQOTuV/kNW6f/6hzaftF/
6cotP7DVe2z3btAfQvNaUrF3Hq4jChyjpiV4p8SYNFfpQ+pnxmlsXsyL01fI
BrQAOZMn+HmLQozAITrMz9hoyslW6Vig1733U3dwK8A0p6weZoembvd4VSqu
IP/w8PdBc74QvU2fpeof5NH3kI7u41RCnz98qnzRGwnajrVlMcT2wQumRfUg
DzyO20f5JcKhQuqmRxGR0/2pn8r+q37K80lvx7GUG2hs/MfTFyEliDNwRdDo
H+5lFV7UtVaot4PkV7vPXy60A38y+s9Y/WCyemh411V9KMlONLVRUgNC+8gC
5idnQ6IWVilV4ZmBl9ayDT+8i+31wPRwW//xUth+A9R4TH7hwa1TsPp1iR2z
H9fiAoVvtxzRN6Yc3gwZG7h0mKrkO5HzKCxzpvCFIHfGm2uepyMhJuLxJla/
qdIcK9Wiew3GK78zi5q3o9NsM5Udvv/rvhPlXqsjJ1+7ATXNAi8Hf+fDePnJ
vY/WCbBbYN+DkApvkGuaU/WtD4W+s5K6WUR58h5Rxbdz24PPJM1VahZX8OK7
bIDZZ/f0o+45akMQJtuvZSFuAPUMgibYvDdeEP4dd+oMCL7XrFm5LAcSxybJ
Mf1Eq3J9TpVQAJtqKnwl63E4RThEihNOqx4Y8aDUQe3zHrF2PSJw7nv+HKa3
zrKijUAyM1T0jPU5i68etE2Qv8b8BsWX7czDTo5IJF6W69ord4jleJ6F3UOj
KUz94anrjfZ9pOefTogGtXcaHyz+wd6y/9Qrpf5VrxRLMVk6XuUFc70eHu/a
EmG7upN4P9GfDHXukw765AjWOV+q1N2D4U2kqMEjYv+jUgzR9/dZweWt8cJf
Tm5w8ItQLeZPJJ3P5l1PPAeCHxXOD9CYwxCVjSomf4DbKRU3HuJ+f3xwi+2+
BtygnY/GxksRfvsN1xox/r6cKMU7KAm/EhpJ7zM4Dq9sGWnKQvdY5PCLJ0dA
SGHtGcb5yBeyqw6po5HHt1POEXjh54cnRhjfFTkTxtuti6gYd66X0KpC+oQB
Dut/IF73nMB9I/QytPoef7c5vHqxJxlbLyIKNWbfws1Q8NvM+dAEN1DZl2qH
vUNiU7LZc2fcGBk3u1sV4v1h9ZWrDlYvtj+bSvKZrgbK9vmw1nc/BHqWXvRg
ejgcdbXdpE4EYkq3m3cVhYLSQhIHtt5H/9QrHfqrXmntZYdzev45yNxbd1Cy
yBuyrxnIYHW1chtStKPzesA7/3tpqsMJJt84bMPuH6o3vLnp4XAWbq3bmtvn
WcCy8y7S/mIsTp7+Y0QNbtmqdvsu6IC7coQKNt7ZoUhLUztF2P/E82udtQIw
ENK1SHG7M79onxIOdHbPSBexiIKirDbpvGZ9wfvIhp0Qql6uEjxTqAB26q03
SeeOXwLz5K828ZxrOxwfR4tC6nNt0nkW4kwuD/RO4IuvqlmGsPBD0vFIUr5o
cOzemmTWc3yP5bLNnQPcMKdZSsovseqf/NUaloLPFJO73Kh6HPbc+krKs9GQ
K6/f4i3G6Uw03BKM4AQeTdf/escp9tnPYKN7uESpJ6PywZxw0N2DxH/8yWv9
/CuvZdbcmbncNonzHqlM9cvkA63MryR5xoQmRFVE5nDlbZyO+10FoazNjZSP
qj1LGdYX8wPHSfGW793yCZhp+EY613dzFh+QSf6No9zrn3jlrjiI0e4jndMt
fllc+xBKC3GRgnIvH0nDcSNJ0jnrvGeqHLchD7jOnNjNNqEKYx2cThg/oG7H
7BBqjUxSOXiYtivDTEfVWWy+2vyueKVkHUanjN8vJySdguk0K1K9mIiT3mjF
Ajm6wXGDNbH7BOz5sI2UhwkY2bOslfwVr6ovU/ttlR+m3B6R8jkyg/mXdq/3
4qPlx4pYvXhhaOwjKS93+73Pz/Hb1bjY7vZt7xx5YNryIUk/HWf7L+eefo0L
FPoYtV2dB1ay2kmc809eKOuvvJAupZSd0/ufuMng9GF/rhMgeDyBgPFkMWcx
3SIysGD9mJG/SxTWAzVIebzwiqEw1pmdcC/dRGZTmnguvM1OOr8HXAu0Ketg
BQHtHe5l/aehnWGT9A7JuFHta1o9Hpj1WLhe6q4I/e9MSfVBQugCl2rNWfAs
/6jaaWQEbDF9k6R3mWJfZpqP6YGI9NNSXJMhcEdYpmN8zY75yddSK/SFo8Nu
tkUX4kB4CFvXOoIvT90MFEURy5FWFsfkoZlGglSPYOZSZrztKAs64d8g3+N8
ElREW0j1j8Xx5hX1mpt4edOmtV0aItD8cS/JHvTM8gdonSfxjVPyFgu/hYCa
fZWUlyOohcw2PsPjoop5x/fECELeWSuSXZlfXTI8nTWBU5/1nFvWEIQa3WQS
n/6TF/r6V17opIp21G1TKqjveePfsE0cFkRjSfULlUOOFuRqTFDpaLmLq0YC
TNIR6f2cUzIXf504dgAEWb0snOykQXLuIulcb3+oj8alnBvSHM6Rf+dVAL8z
LcWkfLLUstkVC1mI4yLoMGdpwYv4fQTMP0gqWjK9jrsMzBK/47IqfCF879tu
zI/FC0cNXDe/AHO7cvQyoi/AgMdbX2x/edNXuJcqzQ25Hnj4YpjFFgJ9X0li
++BNys4pqwZFZJv0WujJS3UYP2C1ivWfa6GiX3v2KJpd2betHmRAr2OiA5Pn
2qKHyhM2WqR5ftq0c+YkmP9WJenfxJ+CsuzLIj7pVd3J7DNi0LtWQnrXa9Tm
xxeqyCacvOXoF3JpUYhlO02yN8VdF5xCPxJwn4dPcMjsIOpT97/yyQp/8kL3
/soLCWvYjwSa7QKrQzxU0n5SUHFHg7TuInRWpVZM2CDEJ6wm20cWNEfek/Ih
/loMFpnTXHDEQ0h0xFwBLBnCijDulFxofChBAixE2iWPHSCeT5dHTmI84VH1
T/lSXQh4d8KcndEU/FuPc2D2OfjU3cMsIg0Ubmr5Ynm28ZIMNQ5iHM5axTD7
ZVcMGmHflonli07EtC7IYXHs+Jln2pGGSPZqgkLKcUNg/GVwAOvnSt2x9PgF
YUR/Itw52kcR2o95JJHyYIxLfBOZrOjqW8rVtvsyUGmbQ8oLXVMmF46V28Tv
Tf7eH1JO9DMLdaT3uw57RZaNRtTjTEv1LofSSYLJeBfJrqg8d/UrsKziHpsc
xas2SkCxYCIpr/vxT77o+l/5ItYh14xEejb4PuaSEYKXg+/36Ujvyy2Keup+
E+SCJlOl6fqPirAkEZSG8bneHH/mO2IQqu2o4rWpDmz5CziMP6rYJxsxoAyy
Eg/NhmLOwWNLpkkszjTfHdX767sL8KYrqXbyeQClluVlLP43eXC51tDJH5iX
n3G6fvcCA7GCwudEXi9h55bH9hIaehcdHHmeoE5bqp17qYjnI9Ga7dknvBD3
uTDXMG9nMLxF5YzVHRseOBzjKSCDxPfVOJ29oQky96pIcZopL3cuW8lRpG3D
z3PphiIMbTHdIuV5znR8KH29HTncnWc/ry8Hj1Zbn5DyRa3rLpt3inCLpwJ9
vh/AgSAyJb0P4NGz8PpZKhlMHmb5uj1EFp5kaneS8rR/8kLkf+WFtObvaxwU
OQ7rJgXnq6hUQZA5wIe0zzpMr5EfFAWuB8mNpzU14Umu1jGS3rxHEuZd5Yl+
+TzP6yl92Fuvx4OtO4G9LEvG+Uag/mXxht9HW7DfNwrYefzl/i/B1D/z0SCH
Plfzp1y0t3KM7hnxXJDW59JRsXwV2h38g+sOBcLj0woB6Vh8RZX8rIIzHkI7
C1ix/BudggbXJDEOlDsbIvNlogJ5GlUO4PRugTh8r+aZJ/qxRwYLm3yV8M3C
YiH9eQ7qVc4VNfxGjBsTjp6rcNFAYh/2fA7/YQiHbrUrYPNr4K3lTKYvjDrZ
Vc8pS2lCCm8UL2n/6j+ynzKRBbmGkym+LFSBkgi5IIw/qHFinsA/xvcLzfM8
DlSCHrNdGRi/IQijvXw7oZ2S/FPlD0UQfdlLmi/nP3mhnL/yQub1pxXOUomA
kHq336VeHYhs0urH9JZNYeTYTAUw2DrfM91tQIxnXGcwOfN+lGSbLOuAb4Yj
vb20DdSPFcuQzllPczQOPfEEg7qu31i9ZObTZOuXRD7yUtvM49BDlOsSe/nt
TCUKjzEdqh4lwIdskSzWbz7AvLe2UE3CFuLHnl/E8mynt9pZks5HIavt2q8C
G7xApWtkzh2Lx3ZQTS0EZ6KjEtWpIiNx8PG7+cOODWIce9YqzMbSHPGXXTBs
DnOAIQHzfCw+HG98EBT9ThqxMmkOrhw1hBmfa58w+dWujj1xTeFAzQn5T3we
6YCIvd8kNt6cxvpTiZeH8fYHadty47Xgt1DacdI5xfcojvP1bihIb5tbitSE
RHFmMZLd/skLTf+VF5LcFL+bdUIWosgWuqKHTKFlLX8N81e2opPU0jZaoCa1
fusQtR1YhSaFYHmS9jT9lV/y9mBQ9khY+dFFoFkTL8fWo6prmrq8bylClvG7
b+HLUYSx+VDXDDHuBTxnslcoDGZHhg82hwHD/gM/zYjt3fymb1VfTIT3erfO
9zDFwIV39wusifb5vtxsfU3xPAi392b6yevCN+ZTe7F8BepJIztq6I2iqCOY
ZJrMAJX55WH+hC2N/Vn39kb4ohWzwkx4hHLijj/ovUO0/1h4Mu3mg/ScXks8
2nEFpFo5pbD7iprV/grut86gs/xz3wM67IDadPUYNi7X9Trjl2wnUOp6xtt6
GTMQmZ7dgek/QdHiqczH78T44bD6KyEjuH7Xbxrjpzz3CkQzHQGGLr1LGQcM
4eOo7W5MnyJ/8kKv/8oL6VqN719014Qzjy48En7nBDJBnsnYvD88emf0xXYb
qPJSVi+p8gE+hfcPPhD572uyEndDIhDTueAc3heJyPqSyC+snnHdeiaRS6kC
5Q6klq03VSEJ2BrKGyb6EzMBpl1hIeBqfeLjqRV/iDrT/jUV6ycKv13PzBwu
te958I1ZCWRLuP2w+S0Y11qIUTqPzP2KLgZZaYEk/pMTpudv+pYO+Y+KUbvn
huHIhwJoobUTUV8ixle0BkWDe+Pg07PDLZZjych5Z+SZDuI+KEDO+IN7gBr1
bZ443D5pD0mNy4KYPi1ulx7wihMEl9b9YJFoBxVUFj8xvvEnLyT+V17Inmeb
qnu6DdgPDk2Ull+FzMc3D7YR+T4XkzdabZ7ItunYkYaOUGTzbsksb+tfn4tV
W/04u5IiQZEg9kasPxIqzAcyWLD4UN2JJuqGC0g8fOQmGW8LujFi2dg58WFC
8enScX1Q8b8980b0NBSgYxrYPJ6mdqN8GmuBOFgjYmu4FCDyuZcSprdzNV+O
v79xBQmesv8Qw+gD+8WoXLF3hJR8ijNsth1CLe7HS3CX/eDIFVzsKNa+sW3n
AK0I7O94+3jS1ANW7ZWTSO8Q/sn/BPyV/3lN+Ii7HRaFHAxZPfy5C9EOtdwo
03Vi/HnM8auT1SXobzQwL1v0AzbxvRNPML96fviBn6UFGKBr8MBMHwRKG/iw
c0rTL6q6QxFacMgf9Oa8ReHX/jkmzA8o53WV3jpjgD67B+7fk30K9n68w4KN
92rQia5vr53QiMOy5Mgza5C92by2SORhNeaD6uX2qCtD4C7PQD5yk6m4ef0f
7oH/Kz6g9kU/xiwc9Ice+J+qTwJy5qseTkR7nnxWE2PqZAs83RxXbtTbgqfS
OWlsXWwo1E5/HtADufojOs59qtAqdIARk9NQd69LD1IBRZvAKTlrftC8MEN6
xzLg5qOKeSEddC/UTXmwWwTePVcnvSsVp3n8B4uzOYpnfpoVvKgHUaKbXph+
hIa7+XIp3VFxQ0iQ5ZQXFE+nfhn9B7uSlrr0jTzoEmLTMmVlfdmMLHBkjVoP
CBD4Jw+j/icP8+pPHqaFzvhgtO4liPXmOULbkwK9gijDmDjeJRePG2oTF+Hl
zeune07EADlfoZMR8XfJH9M+Tmt2gDSm8L3JD72h74OQBeYHArnygnfcsoGn
5iEi86bOEFSUzY7Ni2yKwi4Wn3NwmVWUv4fzHKgkTpDev51aPqIUpaQBL3hL
CnT55MBZTYAZ088KzZn9qhvycF7tMt3rvcfBv0+Q9C7Eri8WapbZ6ujCwdre
R1J80OOookv6/hVK9JuNeuj9G3MRuKsKzfsY9mD6rNeLHabvNUM6umyLyQzW
YExr+QOLTxpqT3TkmDsgy+U28/kKHxCifcOBfS8Ij99wa6XwQg82NpV6PsWC
GgfZkYNY+3bGJ7S7ndHnVb5MmgP5cJrixfAMUW/f/+RbzP/Kt/yP4t47nMv3
/x+2GlqkNBTZZGQWodfT3il7l8ysjGSTrazMqAiVQkbJSrzOhoxQRFlpSCoq
sioqv9d1ub7Hfbxfx1H37/35fX73/e/zuI7zOq/ndY7nfDwKX8VZdI9agz6P
bo1EeRhMxzOOYfFe9fZlbTQXD4EH02WzqWW+4JolsBx7r7U2X7e8lhkoV5Rt
Y5E9CjksE7FYHP5qBDOSf6MPDQL83+tI5sDatqiM6S3iyBP2vK3acNhHuSnU
lGLfMvJVYd8re6x9Ob2iCtT1Pjff4iQDmW85cZyoP60TDgIHRpkKB0Zx05Lc
xvufchcCx+AKgWMQTOAY/Gl80/3OokUumWjTxvYGkL4Ih5sUh7T/i33cd9K8
ul+9iwVN40F9G40M+FgVZF5COeezZtVUL/duRotqmgI5liT4OCnaiOnh3bJ5
41YPGSjavUPcsNQEvve64rhGYTzjsUHf9kOx3PtWmnOHobmCdS/2vTynbsZH
/o4Hmcs+m2q6U9DBj5oyvynjc+7zLD1bag871o0NfnUJhPhz/Lc6KM9fVrmx
KsA8B9lE3mPavJAFKWiCUZLyvePtegbpITGIq2hNh3BxOOxonIyWws69jUt6
DvP6p54NCVwXAQLXJYTAdfmWaz9QSo6A1aEHd6RIX0Vzr7meT1Hs6p2DnYHg
lgvk773pcR/uovLonB/6lRMQ9weclnBCfpZKftrt1pUZF2cYeLrAfjDWF8a5
14lhfcHzF7dfrZc6gLQMz9ke6xEHx5T387j9UOa07VG+AgyJ7mCZE+GEnoYS
3O8u/di2b1pbFuoznyVyUfw2E1plHH+4o8Q9uqxVBnpb3v5eT2YDkQ29uJ+o
d1rj+RlyPFmruXbf9nXyYGWoiOPrhuoVFnHmpsKGr59HlFlvIWToEtX//r+3
fsSo8HP+R8//rfH/JC+K4j1QAnHoSzKvU7tBFpLtSVqgp+jfQGwJz0Qo+Z94
Jq8InJMoKpyTdV3NwVec8pFGtwaPhGwl0gqUu1r4hnI/ErglawjckjsEbsk4
ITf5P8Qz+ZN8nm7pfFjzv3k+/Fv59UdGjdocZBCTmVnpvbwR7f+eoBh95M/j
D/euYF//LhXZ0DLue7nsJmoILUnw//Tn5xMIHAABAgegi8AB+Lfz1KEN5gn6
aYK+rXrnUnspBB7e3bYawxfdKm63241BHdj8n41fKV0H7Ywj0Xg850NxwktW
K8RHt0ZJhC8cNGRPud+iyCU/LuFsZFHhbPwP/oYzlTxx9ZoJq8QoMGEeOtp8
NZXi750PkKPMfwMxTiTV898yu6J31amBmn3Ou6uq29Ejvhcx2Hxqvsl6+m9y
A3kjM3FTx3gkwL1qXuYv98j/bfkkgcuhTOByuBK4HK8JuTyV3JfA6yilwuvw
JORFVHIR4GmCHF/0rGDG1Z3dC0ZX5tdh5/losodnT7oHauxlti0IdoT8ZW2R
WHyyS8iexzbNDnZIWu5oVg4Hx+aOmHLMLopi1hm8bwYgoGSwp9QXrtsL+GF2
WpnLz8+dHj5I15LHSE4mAG5nPREg/wf6pAvcNbU9zwt9/nWrhYvRF946yyg8
xuwW4jzPojrP/+34iiFLOBth/5s4Gyqt+S2I7At+aQ8eSXkngHFuniUrZT7d
xD4Kp9pHMVtBcm3dafS7mlOPRzAZ7KIbvI2xOqtls1eqKyLRtXXViw9ETsOO
1OjTNJRxZo6Ic0bpB6CjT5U+WX0Ihe1qIXIYboY0gbMRR4WzsYqQq1PJeba6
ZO3doIROaGgJW4cfhXNOTMZYnYx50+y4/zNNNLrp2dr3Rh5QYc/OhPk7e2pE
a9InDyDy+SfyQfE+UFrvm4vxCDwmzR73VTNAax3Dfu409YODR/MLMDy3R/3C
jsePhMLLtRmxvNIh4PzqMW3KX/5v6nhMTkDrPRDmWaEdxXMXzMYYik8em4Bl
h7+q8C7Wgbap8WoBnbugGKhTs//Mn8c59bOHl/1sAJp5WLBLhj0HpubMVGL/
ct6qW10zTi51AdrgCwnGJu6QmH302Pu/zHP/jRDxNOUBED3pJxG5pg9Cg79a
zp8dg0hLK/S7tx9ODL2dzBZ/DYKccWfX2n+AiqkffFZtsijsStlzbyVFdG5N
VObf7M/Ox+0pH3MpdtVUvsv6t2fhfqSIfQNl/vuJe5mf6l7eRNyPz6nuwT+N
/yc5PbHOzajWeUz9bM/gvR4kN0PL0pXXhnbSv/Wr9//8XzvHPH0f6iuci0S1
t3w23P7WiAIrHwnNJU+AzKeK9kL+UNTYuq3pHHMeyH5fkUGm+Bensm7JrTVL
h1vzx2jt8l5DK+2WD6eNx//1eyt27nnnxNsCF8b2nHpi1ImqUo32XTb7Apcu
bn8U8C4XVT7lrsrXuAI53hZ9mbP/vXN+zXxEOeNsJCKHiU9IXnqIfPhLRO+d
ppyrZ5ZwRQIIXJF7BK6I/wrropvXfeE2DO813ZIOZyO2LtOl/F/u2vDfznFH
0ebTh++Hc+fDupB3/Ycp+vHjZxZInLiBdmxlq3hU04gaXIbZ2sL/PP8+CcZr
SR3nELtmgeXxj9fQ7ZIi2hN/wfv9kzyUwDeQIfANLAl8g2WGgUWe5efBKlfh
Dr1yArzKKl7v+Zf9OM922JWe3QLtyM3e0vLiPFpxnT5X+D84txNMxifGOvPQ
++YvkYrnG5CfWVZjViPFbn++hCczSeDJeBN4Mv92/H8r33BSMLd5UwLsDH2v
Kr4uHxoWb9wvo+jnN1rL1ueQAtoqajEfV+aCvdm6JqyPfk5pqQ/dl+hDZyX6
0P9vz5NhPz/thWsG0DsRUPJJ9TxcOrrLR/cv+l/J7qEXsToOuDfma2k6NKHT
yhY75sImQOjyDf1XFvmwj/589MKP+yhfWiGoOo9yD44u4X7kr1/C/egmcD/+
NP7gCsXGp6l8iDbnTfbvDBIUWCqTcXusSfp8+akz6Pf9jiidwmDS4lVzuxUU
uYNNwLLWr7RoQjshBT0QB3IBB57Hf15aNVdoOUY+5rKmfERdCEoUhPF8fdPb
lPkG626yX/MFsdkoAQgfMcfrJeizTBZkNlwia9Sp2k+U88N17llcrpVxMBDE
H5KcFelH6JYJgPZsDS63N3rgr7iqj2Tl9iZrxxFB+GlQief3VXibzdir35Ki
64JoXHqFoIilFq+LeJUcczCgdoIUvcpz2efRXfAglgHP+x83WZBnOLRAipm6
nTv8XBLy3C7hfR8Detv0up4zwlxbZNG+lXuh/KAY7j8upgeNnlnFCXtumkkz
pqmA9T1xvF76W6JKdoa2GlRXj9iXRJqBh3LNbsyvv0LbvuyrGgktmPPetPqt
BrtPPcLrUsx0fggEPgpFJZoc/o5e8SS5+mAyFr+d9bsjd+Q5K7pj7qXNOiEN
Fb4Ir//vymNKvn3/N3n/aQmR1cliELpWGs/Lrzj2cm7X2vfkBw4mRSmdwjDK
9Aavl5iuqv9+Z10lmUbs0q7Q60LQ3jiM6yGHz8iP0bKX9GOT4tSa5cJA/yAd
l/ud/iztZjBGcpFTnZSvEYEzbSz4OCZdcjOZMXOkb3FDt2ReicEkDS3+3nT9
8tSfoXRQWsscey5TEsIfMOH5fb6k3NJf65hB9pTzKnUpGSheb4Hno49xsTmd
o+GEtOU+H09uVQSB9VJ3MPn93iOH4xZ3w+4o1RfafTqw6+L4Dky+PE2qP6XW
EU5tjuN92udCed/36xi+nNl78UGNdz7gF6O6Ql7ZkLRyx3gVZhf97GetDzLQ
R0LoZZWDhD7kDJmWYPqXvviqwGLGG915aNl2KiWM9M4iKx7DSY6KpjWYjOZF
3OlDWRVDcrCiVK8dr5+xHHbub1iNVC5xKX7Uk4KrxVN4v8w9bimfYu8ZstB8
wTrNanEwkfDC1znX3JcZlXUPyTxWDHMb28WAxUAK14+FisaJdPER0or+m3qt
W8TB/0MzXk9yt+mgQXLaHIlR992tdH4J6G0LwesuRisXNa+fpIfbpdei90hL
gb5GOl4PcIB71VyREjP4RF06Kdm4B3hbU/H8dc/u7IR+Lna4fujI9LDiPpBm
kcLzsL3LDlRbtu+CjjGmo2ohauAnficEr9/Y0GnpHKQJ7zmeu+U4GwP3rcJc
TD9ZdjLoXkwyRN568sI/NA4KTnWYAeW+25LiNeEW4Awtl+++CikxITF+lHuB
xZklX9SxrJazR00eN8jqnYfAuHPlKCbPyaiOfcznithVO1pnU1xI2ca0wVj8
MDfu8ZzFbQnEu3Z+i8+AEoSpleH7RZSji0774ib0zfXpPjERWUg7EoTHYT6t
vCDB4EeDTC+XONp4SkONVB5ej2TzXWEyR6qHHD1wg3aFshSgmE5cPzFlrh++
mn4hMdoIOpgFSYH8jCwu//pbptPVnxbofl3pONkrDXuyE3Gc1a60z5bfYteB
c9xrq4+ZMsCToYvj+hYvN30zt4YNFho8AwXjFOAQvxdeV/Bl9/BQ0l5ByDbo
1kqnU4GNHMH4/L1ZrB6dzpeHd/Fff1qy6wG3+JnPWDzqwk3uzmPOltC3dqPt
9BVbGF7PewnLE22eyw662PMcBR78qHpA6TESzad/sPzTJyA93ufdts4WDB7S
JJJDj5PV64vw/pqHp0KtYVcIyv0wXOK93Rsa2HQ0sPhtR/VD7qb39qiv/+Sx
H5stSKs3vBDG8kS+ctMyJ1eQ0MDXQxsNBzVh8peIKDZPJlR4iPMeF5KsM1/Q
2QDArFyLn+fX4nu2LzvBiB7JPZg8FLMXLhYX4PUhESeNxq/bvSHLGffY6rXI
gPm5fFw/mUXv5z7IzZJcvtA1ltDKwlzHS7xvq69M5UpyCiMwr81h9n+2Fw6b
XcV56GR+VzN0dG6CyRfrxv2u7oM0+WX4+uR8tevuhc28sL7Gu6fDURkeX2Us
wORTTziV9NKlYHtWhoZYuRaM5HDguOuHcyLirj/TBL/NW0r00k1AvmfBCVu3
XCWrNrWJekP7SGLP4SAf4LsvxNn1Fzufd4+7rkikJYxFq6++ujOSLKa3fjU2
jnzGvP9q0nWYXHl74Mix86iIySur6OsEsJVVNc522qCOX3m2oWEHyYeSBtKx
uOh0tqrxnR9aSCq2L8rKzQBkIkbpsf+e7rbNz++GMHJ10Et8UqAKMyRPvG9I
SeyE5Vb7DejUJ0+2fgtFKOAtws+9ngzpOFGZT+TQ2RZ+JSYSBOoG4vq5n/X5
aMSuXyRHuYwqSSUS9JIy8PoTg+PR635psMBXuqNfghwUoXQoCB9H6se3qjct
nHBtOEfBj08F7Nunc/H/Kx5cPXh9F2yJ9d2cl6AJb5UuWWBy119TLfAaQE/9
IpOBkgGoR5KOY/MPb7XdufqqKcyE6Zx/XWcLV6xDjLE8RdOTyR28a1KQF22F
Y/d8IorxpcnDcMKfHlbzqY9MAP1DqvKDl4NBe2+DNy02f48Fz+pXxnCgd9kr
jsM+ZMaoU1x4X173htbabW0g07l7pTvcQZWtNr5JmyZAguBR6pj+J4/Sgbt8
0+EDlujbj+/8Q6/dyOaTojhuNukffEyOd/6Hj+n7KXRkZaMp0tx4TTuvyRoe
Hs8wwvaRJsHHNErFx+S/1SG3r3c3aps8FUx3WRd0v+xkxfRznuBpek3wNAUQ
PE062evDf51jRw4e+pdK8tUAXc6KxesrCP4mbir+JkNj0d5TLXPkuIaw92Mx
KvCaKQHnL8sieJ16qHidtpwpELwtxABKFrwLLRdUoL8oEP+Pv7WX+J4Kqfie
Dr55cXWDCBvEma96w+ahBqqW/jju9zGiDuQiVR3Ina4XcXeeCsKicwg3StMC
MdZuA0x+ieCHUqfih/JIv7x5rlQGuPeP0fdu0gfrgY+1eN6T4I2Sp+KN4pMz
2XDmnTZsHDi/Qw1ZwuUUBS3sfw0TfFIeBJ/UG4JPas9yqSA3O2egS0j0sdzk
DVvk9gVhcbMNBM8UPcEzVUPwTJ2bkheqhevI58p6G+9dxWgosUW/8OMEfPZQ
Hyr+fQLuehwy7fGyo9gVuwexPpHvBP9UBsE/hQj+KfWZ6gLVEX34WVQ38PhB
MFlM/y3eJ7Wd4KUqpOKlUg8LsUt4koZur/zVP1wcRvGLlVdKUu7HbXRtLO/1
jRDNuMD2zKRUsnrBVjtsHJ33biJcA2EooPGi20bvcNii9ugDxncTof+IJ8L4
IDoeZC/z0PcIvDuxTwJbnzOfWpqLZaXQQ739QzKmJkCj2DGL6XO70m+bqXxm
9GQlz2fXZYaQK86egY3/fsiom1Z0I/gMDq91+moAdU2pmZg8+pOizHENUbCS
fzFuqmUM6d4hopj8jObacF4jEmQrmnynU7GEeBe9V9h/SUrw3ds4cxBWFumd
Txd2gPsyD19h99SOt+pbN9i7ghvXdHequT/wqXPKYviux49o8BX7VKHSxCvp
bDp1qPNLt/atmgn4kH/Rk/ecDVhWskUsp9UCTp4KVuycVNpasazMSQu2bBwN
Q21HybUnC3B+GStL5Zw3+cFoRXpyxIpljjA6Yib2kCJvWCCxdlfqo/Y1G8Y5
1vmRT8sEN+F18s7NetJwB/rAOpWu8DaavXzh7s9rE1B4YvfVm4y2SP3nhyiW
Yi+oY1jlgsWRRrJMUrT6lJDgg/2xY8gWUj6LSWJ6bq5L+DBybgcarb5m9k7k
EGTGxbtjegB30YKIYQ7oSTQ5W95mDT5bQqMweZTA0KrHh2VBd8bkrpLYEcgU
ytuHfVfVzMWN7gk60LpTRfREiROEFoSGYXE860/O/rNatkCzaYqhuuoEBIlO
HsTirq4VCnNJjbGIa9NHBZmHaejqRo/n45Tzs+HlCuv1fb7gsuhg8367Fzgx
XNqIxXt9H4y5P+oyhWh1p9Jbc4qgmXQjDFsP0+U05es71OBg5MlHi2+NSDsq
RfH7pU61N91b3AOdUz1fomFrAltLh3qxfgQXBbsRr20HUNpbabGJzlBy8gDr
Otxusdh1RUf8LAy/no9eZMtENENdCb8o/m/k2lvfVPSM0M+4AI3MbfZQutyW
BTv/lWl3q/mPGiK7n1YF7zceh5pZsQpMz3b706KlN0mgl24jucdvuALDkbkp
rI/mzsD592u3CcH1Jy63mD67wGa2/fmYHSj0WkGEz0EDxKOanuSoekKhQ+Mn
bJ5hsXpryx0PgWunZ/w56wCQt2cQxfCoGZ6tL3CQ8EPWBjqSBdxxqOW1+gUs
X2nhc+NnpYoTWM10HNS/YAPD/GPy2Hv1WMySZz/qw48wfcaIo7Jgbj6I80he
pN9Waf1MGQYHJFoWjV3Ib0iG1zA9PLJ3YeZjtEdKmwIf7xXUgXruUVrMjlpv
OmguF6GDLGiYfvzWMCaTLLqUcX+T4MugYf4nX0YVwZfxenyJL2OB4Ms4R+CZ
KxJ45qYEnrkhk+4a+zdqKOR3/DGa+FAQOM8ph63/N5v5lQbv7IVZc/o6l5QQ
qHrLKdlKkX+oPj9yl0MNOBI+8n+56Q5MEdqtWD1DOIG/LUiFvz1uvsQjMDay
xCPwjuAR+JNdlLt1n+CJEF/oO95Ew9VM2e+aLfR1lHFMjUo9eBOsYNyw82n7
DUPoP2GwH8cfGGi3PPNSB0iJUZtnrSXB7mQDfr/sN3FZQUOxbyILl7nTCO4m
hW4SbMD9aOVbJRIKVkj9c+K3nfuU4VJx9hlsfx0q7rl64IQmAped2cjJm6T8
1NsFe56fdsUOz5X+iEvT5MHapONwZzUfTeNf7LpDXKIHSkXzgdVle6TWqXpU
WJCRq99CeV6Jb0ZBKQi2rG3yVmEvR5FPfoSVTk7Ak+7i31zztmjg0RaFZr4S
lMJa//Ts9ATk1+tmt+8MQn6L3k5BrJfRBnOmZM6/1AmYKNZ5s5uGwJ428/3M
n2Mg4mlpqzq27zatJwlH24PT8SrXc6yOcHmurR37X2UiyZsSzAwh0f2u5JsN
2pBRfvsVtq/3fLhSFb1HHTwPsVxbfk4ExJa99MPtxkWzJ6MhCrDSymru1X4H
smaACs4zG52y+vE2NmP04HNwwOZdcvDJ8eVmbJ1PtUnvtX6uhrjeXh9bXGVA
0tJtOYU9X943t/xp5lFEs3f1jn5ZO6jVfdCE5RfaXkX7vLgViR55cFt/akqC
DtVjHBX/QRz77Ak+mYH8QKDdcfDtTEoLBEpUfwly+vfjZN2XOC0UGgxM8Swx
8WlngI3c8x3rw7r49m3n22gnKNj5cgu/sjek2tREDVPmX7lNf3PnLVMQznbW
PyJjDvXzRgbY+szbDwVKr3Rgi7/blqx4Zbj6reM9pp/k+WG0epkytM1xnLz3
gh/GO6/h/WghVTf2L38jCxE6v/oOmCeRzc4cxP3QzAtr6la7HUS8h6/ZB9dJ
QVrUr35snP6iuJcfF62QF6t4puUTY6jOMR3E7pfh50dlezxdUIfCNrUdDcdB
KiztNpaX+figOUpezxf1QVrJmgvJQBvNyd3xH+g5/cy2BvlrPqBfoLvjjVwu
3OevbWX9OQEmKz1rJb8fg9HfA2LHGeLgp0pOM8aP6T02nS7DbQdzbEcbGuxO
AL+/djl2H73e8K27s9oUYoV+CTD420LhZQjAzvnO+TH3kw/0ILTs17EO84Mw
+G3NSux7u7fHRmqOqMKyabbySzXyYKX60hbTzwzdW4WHWfvgo0p61nQ5N1gX
tD3A4wzew88YybtBZfHa1KKNOumbkQ8evyJPhmeMz9CiyoYT6vpDEhDD1YD3
L7ieLvd9bThGbu5208v8IgT0vbl4POqbZ2Igo003+fVyd7vDTQIgkrgTj/vd
m7Ne+DGYT155Xea1dCM/8DWM4vKRQ2aBDMsekvzYVilvn+eHG+0IlzsRfVJ+
VH1S+/0ykoNvT5CYYDBeNnwXaGx3xOOB9idYtzdaLJC2MkoKfY+WhCjXw3hc
K3a1yabbvYxgGzaQVRsoCy8k3+HrZJ51rV3UKk6gHVSxeEinAo2OeXjfDdmK
c3+aNuW+9mzZ4VJoCnxJPw5h+/0E3V66Eb4geDMdO+UiqQkvlFWsMb9VyuDC
u+N5dOj8hTJ1ndviYKa9C48vqXtP+kR0jpNvMWaJpMWKgMdOBTwu9zj4/I9H
XQ/IWnaeScnDQqDpWIl/16kf2t+ZqrpJEV8MkgYnhaCVdG0p7kf0MR2h6mOq
/hE6dDFgHby64V6dZLAHyBzTeB/EAX9auxhVDpDfEZEYcJYEk+umcPyQj7UV
MTz50mCjEDgMv7TgQmKcAianzf52Oi3YAT5zzXkkDh0Fd6kdnFi9qNcu/6Lz
4i5w/NpY+zoaOVhtt40Ds8OfCg9cHH31k3zB0Wudo78EyIXX4ngyHJemJF/m
viCfunzrXhyXOLR53sbjZm6Dyh6tDC8oRmLLnNcKcUhY8QWXaxL9Qbup+oOM
UziSfpCEYZ4tN97/igp8rPuK45xc37HnvpShGtjxDsaXThpA/XC6AG4nrNjU
PVaVBMee31eNUToFfVeDN4dT9ululpccrg1OECj6bPBDlimQjLsZsPl7Lnq6
cB6aIPMeutfHcFsK5Prz8Djhu0m34cT+IVL/hcO7c22kwOJBFB6PCiT6aFyo
+mgSO0/eEJ8zBns2ukr/O4fAXWK3O3aeMLNfeVK3Ow52RfXSrnoeATOnfOMX
KPMRFYvcIGr5nKRaERF5bFAG6Nxd8fhMJNE/cpCqf+TRD4Owu9UnISNmIIWG
7APsLIfhKnYeEn0Qt4k+iDtEH8Q2iwkhTqE4gDdnP79lDITEwTI/IYrckvDT
Oan4jieFlvxr2a5/+tflhB/9kcqPdif8ZX4qf7mK8IufUfnFn/7g/14k/FY1
Kr81kPBPZan805eEH+pK5YeuI/xNGip/80/n8JvkJb+SVuqffmU30e/AQNXv
EEb4lTRhq/7hV2798qTHaTAZaf66MNnpdgom2wWv6v3GeBKjG/WYjBF/5p7x
9CA72CYhYoKdz/nhaN55zx4kg54ce7vZFCL9XrRh31W+Os1ltwgruvJ+MalM
wRCu2oklYHqwL33+kaSxHn7bTgtIUfzEifnlWZhcd+bpejnrg3Ddce2m79X2
UFX1BO+XIb+0St8W7AJz46K8R6r8oFY76wN2Lqma6V6ku1yFQlpsMl+F1yHW
csGfodUU/1TELbnjSBSQ7tenpXSGgRBHw3GMl4dGY+C21VEv0DIdF3351B4e
qi/Xwvp8/buORu+aPwhs1x/TqNbwwEJHBX6fbl9ul/uT1ws90/NXze/3h6Zf
LiuxOiVPGpENNrSaSPv80S23Pe1BP7jyAzZPT9PZH573BdA9hfSv75kOQ3mC
gSRmT3od6zEXlmSFmr6fhb5d1nBIjSMatzP9Vn1JWnsa9XdMCM1WpiOzClH5
aordLjppE8bckoHuSO1a9QWykZArA/cKih90TpxhwXmnO8TeyHw3Q7k/beki
f2Hr+W7lhmu31h8Ak4Cj5oxT/BBkeHw5fg8m838LnrNGJEdDZbfiE7DAUi2A
/fe8dpM38W77UNZ538P8ra4gXXnjNuannO1KDmDp3AqRJey64/SuED2y8Szm
H/nruTOWO4RAY1POGcErwaA7wFSD7Ue9+0yMtrJHgNWE6clKCWMIediYjfkp
6gedr+lx6IBT5OXzDd78oKCsrojHD3MC62wvbIMf11kfuz0PgRNH9c1aKPIh
2ZtvmBa9IVFZcYh79Djc1jlb0Yn5Eas3fqS7YArjWddpBV11oXrD65XYuhq8
n5x1Q18D9Ht4X9hu4QN3WjYvbHzmMeXHAh9c0IiFyM2bdCWo6xrrXDnFfp79
LplZqqkP44Oo7uCAKvxKTTqK/d/D1wZnGSdUQGCC225jPA+cSLmJ93/xxT6t
DFxUhAjzQWW9jdywdb6w4m91Gn+0G5mX6ld5Pf5ZvxpA8EimUPFIXiXkJf+b
/JJ/kl8RMOpX74xBWxSup30LOwUKN6bvvf8v8mflO+7Nmf8dgX4enU8x+CoE
Rj8HG7A6sQqiTvgFUSfcQtQJ6919/G1PajTExlZ58rgFkZ7cXHU9niJvYp5e
+7zYCL7mfU6f9Q5BI2dqOLH1kDA3k7dBtATucLL1eU3dRFe8NTUdX03AJneJ
0y3DdmBUs4q1aCAY+g4wtGL+6Rj74tjbOkfQ7fZnNNI5CftUH9dgfqIPoc8k
Kn1GELyTE6VLvJPCBO/ku5IludeNf8qnenhiHZlS0WSP0eEyzgxY3OtxYIFi
3xoc5i7u/RYC+9PMitPvX0JHeAOyNCh+mbzQZ5H8igC4k2C83MQ4Hqa9rk9s
o4xzZUaojumeKqIt12YJVv1BKtu4Mx1bV6l+p9nWJ6ogegbJq6/8gkid7p54
PHZFxfU2u7A9sDrqxuGHez+TKpL2v/7bOiwuE9rPzuwFVoU6vpLZJ+FGyAaL
8v9g3RqcvHu7qPYyGOiKtWiakFFikq+kwN1/P07Hha+MvvyxSNqJ65WUVSaK
fBC124xyvrlarJ0SqclCbRf0FtLuXkOurWxhj2YodhdRx2tLVb/0gIgbPKOK
G7ASvIS/Rv7JS/hv5/kn+TrGpfgJO8E3Ok/ET/70/OmMzO3X6TKQ4lkOC/XO
KsRwbaQ24PUEqMnFdzWtPoeEzX85TYrcRmxJpIXu/4Bf8j3BT/d17J/8dI2E
/D2VPDB7TdaBLBdocUOR81me0Fe2/Q7W3zec9aqLcSwc+Kcv8CZWJ8K2N+wr
MX/WcLtydVRWCHB1aRSLC11GgiNv41ZT1nNzbcjI0e/nQJUm6lOYRzVSC6zP
fzb039PzgTOSr7ZU26LbVjbBEv7+cLHVcBuGr2W1fun8bKc6P+OIuNYdIq71
k/gvz9Ybn5VwtEdrHoTKyksaQfnNc++xuPH6j2s+xLR6otpn3CkpC47wIFCE
G7v3W4PeHLtocRJtT+vssJ0JBvf6HYIYH7oowStnTfDKKRO8ciqE/CiV/Lef
yqXv/O4o+5fMvYwbrtDkcK0BG1/XxdQxUdgHaaZGf6EP9AXmYY3Fpr/sx10E
HxyJig8uiZDXUskriDieFlUcbyNRB9j4f1gH+Cd5HlG/KklVv2oitMT7piu4
xPtmRPC+TRJ8cB8E/in/FdtstNzKA5j2M70e9PCBytmYWKyfwt/yWAmi94Pp
QyjNTyIcuH8W/sL6H7cR9ahkqnrUA2FPricbK6Mf8X6uAyNusCEyIg/DNeok
9sU41b6IJvQmQ6W3P30v+6J69vRsIuh63nOB6lhoWr7nd+p/oM+kp2PN9GHJ
kHTIb+F3WSoE+fqmp/6lnoqhfK5Lp9EX8gpomtLW+AFS0nf8W100ahoVOi/x
Bopa992li3wHdEMs5ft0X//xeelUjw/Ce20RB7uVe+Djs8idRebC1H9QX/dv
5ZobpYUi+pLg9vevn76XZUPXjhc7Bv8DO6d9teTrsPEYOEkfO7XsxkXYLHKm
+PFfxjnntcTHd8BviY+PleDjY8tY4uM7XbfEx6dG8PFtY5Xpk2NuhYS7mxaY
nTug5pUfX3v4F+B4cSay/PY5WCf2yNez6gwMGRYVHKM872yvuv2D33GI27uz
WG7GCETenssa/dt9Xd773nq7N2pS/bDFji0f1rCMbDXH+GL6t5l32HhCRZ+J
86WpPGBfv47G+y/flUfwIv2g4kX60/Nu6RtoC32vgFLk7RUM0gjtPVEkaVg/
AVplwqPkjReQ6nZr9RLpIlRQk1wvOf3/X1+Dnsmxg1PXkhFfT5VZn3o+WK6e
Ylf8/4Dn9L8l/27u4vGFJhbG4i+mKI5dhFMDEeUIs/OTR3pbzyaDvZ9wN71F
Liz7WBmG8cpdI/iqHlHxVQ2qOW2QVkkBk6JB1W39aWAvv2pK5y/7tLC7+5bZ
tT4QF6vxs9n+Eniqe7fEOH2EwvWqQXaV59GHJ3BZqzUfVukYR6t+//f6HO5Y
+4rxRiq00+28e4KtGXaF/di43v/P4/gQPHG8BE9cM8ETZ0HwzTEw/JNvDnW3
fT/zqZc0UvbD0ZAkCHYtj/H6ydd3TqZfDHRDqmHutFtXKIMhiqXD/FbnybQT
X1w+kGqXZ8vWWItAAp89HodUNOgxEnedJdF/yknm2CcGz95exuvf0ONlJ47t
cUbsG4OOCdhowXy1nicWJzk8/FSR7L0bTfGyXr+spQz7Tl3G8ZwZdd++3W0/
TVrUseEu7hSH2dMKePxTcjizTsSDFi55Ng41pErCaAYvHo8dvsJ7UN9wLQwc
lOQSv7UbptvqcFydDeRRNXXbY4imdo2CAsXvyUqU/YDFIeP9z/UmLuqgfacq
e23u6IG/wscDmH/aFls1frOEB827z354d0oBhD8x4XU4+yN+vXsftkB6njkS
56AqDdlneXGcos28veGKOYzwfu0P+QyfPaC2rg+Pl1bOnQ6o5NgEk12CjvNx
ciBxcB3eP1icTq+O1HiBr3xTks5OJYj0mMbx2M/dtKiNEAxCqzQepFzVc4KK
g63OWL4vKXAkMV/LHlnrf//0rv4wBKaYX8L0Vt6eV2ZQL4nC6XSdBZapQtXq
F3jfVpMCpwMj0xbEWmSqc9FCAb7QhrZh8sEgq/1BL2jha/HPfIEBWfghuAmP
V0ezdGxqub0eHj/5wM1+SR5SYA2O62XO7x/bmbMDDssnSLxNUgRuq0Qc32Zo
y4vW2K27YPrUB7Gx9eqwpYAFx6kT+d3tu1tPGSoNhDIz+AzAOXHcFsdjsWiR
nz1VDoxnPtQES+Sh4nMtJNNPE3D/eOla+qIoNBQazBw+6w+NMb7mGO7Hmvwz
h7VllJF7NX8vv4EepEVIN2PjVKj9oFfl40O/vvi1xGxQAcMMxovYe/fyFbtp
1axGGWsiD/+6CzC5XB7HmU+1fxzwaf1yYG7y4KZjA7irsR7PR0wHkUYflG8G
6VpG0admSvBdOR2PMwyscib1veQD2+mIIn1WNdh7zBHPpzfcfThu+HI3PNpk
eslVZD881DRZi8lDG1bdWVDRgxi9bdzN/Rbg9IRRG4svkZWN2DgVz6LciDyJ
uR9p6Hn/r+Jwyv4a9Zer96qMQqfEdbabyXtAIAtvRjRmbx+5yn+DpR3KyoZK
w1bUo62I5TrT8gko8HtSLL/KEA3obR+kaTCn2BkMi5gdHtUtZL91QBK50B7V
vs6lQ7mH70vgdaSiUyfqmLYiw+PSlgJSauCgKJ6IyRXMjzvP246SlUdSbxnE
qsC6mjzcz93jHCkGdRwwVaZxcL2iOmxijg/D5BtHGELWnhGF4vVVNyQcdaBb
4/oeTJ7Psur17c8k4Fm+MTT/miF8+DqqhP2XkyeiPvNVmgOtoEnqDJcDvH49
64nVP0y/am96zVqJvP3GHz6/WoGeZHpYfOicAHEC78WECu/lY4t8gnuzMHQH
qAXYsxtDrMO2PThOtSKXbrymFzoGVit2tpqCcHcjB8avykjglvRT4ZZczqrs
6ezbDe2uRzx7XtnA4nJJD0xvrEJHzfb7a0EW65P9L147Qv8RHnHMT7kg8DyV
3dgWnRBJWbdmQRW+XcnXx+Ltttd0F4Rq89HE3nDjz1wXwTzmN038twkYJ3A8
NjYt4Xi4EDgeyeYrObcOqYCdiNOlfQkewN2vyYzZyVptFtuzNlpCsJLJkd1f
/YBx7Ru9forcGLHeXcmug06yqiy/2XwA+dDd1sG+t8nxaGf5LlMUIiXstq9B
Gkp+3MTjui9uc8yljErDU7ZXw7aLzuDpJ26MnQNVL9XJcscPol/2kQJ1bHxg
Je4xho2T5Ld97yd9LcTA+y2+yGQjTKFteL3N499MtCcDzNDI6MWYcRp1GNSY
Efv1F3vJIeRL2cRyT8TEuu6TjWEDOu/m4kP3iDJPmpZdAg6OQC9ZHl027Akz
+sOmmN0ln6lY+d7WBEICsskryCYAhpeXYftCdOcBaSZJfaTnIzt1sE8WPj66
cxOPB7rstz8wZI12Pbu5ffU9M2g9abYD0/9ntmH1h1kuaKvUj03jG08A/3JT
YUxvamd9HWUXTqCLV/2TaH8lg8uBmyL3KH7BAYYvW5ff94EKh3a7te8vwrch
qVc7Kftun25UHU/bMbCjLRDsjT4NUoXZBnqUcSJaAp2OvbGFd+/sBGpafaBH
77ErFqc9NH765YS6KUz7aUyItx6BX4tdk1ic2bTtaNkVNj0warRrUBM9AKFv
PISw+ZP0HS9POatCfGGh+nsaOThyMckd0zOJ8KMbqfzoqwT+QCyBP2Dz/4I/
cJfAE1CkwhOYJPruF0L+2Xf/zsHI8TatC5AN37x/vsYXJp/wrcZwO9fkLvXL
21L1y7MeUE522esNo9m7c+4KB0BfVeaVBxT5kfXW7IEHzBHnZR2HvmRPsLOL
N/v0l3Uy6cv2s9f5Phwa1t8/tXAXcjgrnpz9Sx/0n+TFMQqS99P9kavlyKXW
RjJqZ57y9mucgMi0i6FKNJeQDMpu+nLuLmoeu/m7ourfj79pd3wHe+1qNHpo
VU5SmRRIjjLiebrb/o2+HIXT5D0iH8q5u0RgnfgXHLfwgXfAPO2z1+SAm+6F
b/oEIWqVCW4XzUjqBPStbiGv5XyVay4pAC6bM/H88s/Jhh8Ce8+SDi+XbuF8
yA8WW5by0TZc63/ILbaQilqG4KGEAMUfWnrelshHn6DKR9v9bu7io/tCov8Z
lw0LovDryCiej/ZzKtyxmuU7yXWw95ligQRIzzrgeVI/qdbOW/kMYCvssWuC
aQ803tqJ2z+Tv7IGurhYoevY0I1D50hwNbEevwfrK1UiSO8k4FS9RwdHmA4c
tRrbhcnzDN0LhTuWI0PYNvXJTQImCiPx8TdYLTN1jpkmv0wT7nWIE4XmdDVc
P7q6ylX5tC/IcozvtqWYC8PAK118/uQgwVmxJ0Wk+G+xejn3hWAh+gkuvxOq
UyVyfpAU3zL/yxCEId3MDpdnEvnow1T56MOzgl2RgWvgvJ9uvwPFrlP0a8K/
K3pnajD9qa2Q0Ka6dgOnAny8TI/3a6wlayh65otAzO7vY4dXqwHf2YAoTK4X
S1Nx5Zc+OAhItXUMmsProqId2LnUxcqmka7rBJpOW4qXjTmCYbf5Qcw+HNNt
MOLaSotSXXN0wp5LgM9QNz6f0Ny8p5unPpD58rRKGa3FIWiTHJ539kk5M8WT
fIs0rNjL93hUDGiYt+J2r8/NFIOED+9Je58fe3Vmnzh8ZgjCnycReWpxqjx1
bcjVjgdVgmD/oMi4+LIy3Is4j9f96rJ84hpDAE8fBG37ZHAAdPRuteH1Jz0N
Oy45BYK1Zs2jTzm+IHrn+fFKivxe0JsXavnxwDlYqMHTGg09a9j9H1HOSSbm
W4qPf0+TJ/mgfnBUCrZV8+Hrf0Isa+SVzi3S152ntxnqS8EcXymepzYXKrgh
rTRF+iybVXahVArqQ2vw592I/PURqvz1sjX7tRskDUD0ywNN9U4LuGEy+A47
94bV39guW3YceC7Eq0dEHofmoiOZWD4xPPK5SqlcG/K6zGZsvuI+Uokd/Pxu
8gvIDQhGWIYUk4JCcv3XPZMBbZMwPK+9wjFUNItpnuRVX1L7TEsWtGvmBvB1
QuS7Rany3RVCwXUPpYLgQaZabvs1H8ivG2Ot+cs59smZp/esER2UDzG4nS8l
QWteP47TcqZzKT/eZf/P/Li3a3znhEk8fBF3EH1jEgTaFelHNy3+mT/CY88S
f4Tl+SX+iKcEf4QCwR/RQ8UfcY7gj1hN8EfoEfwRZwj+iJdU/BHzb5b4I5ip
+CPYCP4IXYI/QpLgjzhG8ES4UfFEPCB4IgSpeCLECZ6IxX3/5Im4TfBEnKbi
iagl+soPEH3lJkRfeavpEn+ENcEfsZ3gj+gn8uarqfLmYwSvxDYqXommVVcD
fDVS0KpZz25p/Vg45xXou5+iz69ir+Pnml3QnjQPDevPnqBHThzG6sTO8zRx
9Jqpop8aim0HhKzgKcicxM6BXnn35s3hQmhZSt3bW3TGwBWeLo/p4ReH1gW3
pgWy01xb/5VFA9DRHDqLycfX79T5KbcVTskMO/YoGoK/d3ccJn9z4h0Pu6we
NFuskXt/yw4mfN+vwvSTwMBAWmvqANVdsjvDZ4/DQbYzP7HvOsBsXFS/uhAd
Hiue11hbinzNbzmhj5T9WMvkw+xwFWW/inJ1MShB7+vpX54fp/gpZjyNnG8O
wcljmwMGuNVhIGS2Ddtfltbv3nbLJcLks9Vvzd/GoiqBweoLFD2s0dwd+Wm5
EVqfEuQl5eQMGtyXzLH8cuPWop53LTLoqOFVrQmeIzA35q+GjfMy85HqRto1
aGJhlsN13SHo7+7H8e4uaJRWXuXnBTj4gsfc5xBMPBS1wOSt3rG8PexRyFde
0Z/dIhlFneVzPkN5bwl7Z3L8+07gCl788ZXhGXw+0bJzmOEzPKuMS776PAEl
afjLyq1NR6e5HT/nUOyZ7HdKjHObfCDmylOlPZLuoLOr1gez9/Y+yF+z39ME
ImYe/zYRI0G/2ZknOK4jkb+4SZW/uDMXc+FFGQdy1d6m4enqCro6swrY977u
U6lVtpOERk8f34p+V/Aa0Gyf/ss5QFMmZd7cZw/XWpm7spysoIXUuQ5bb6PM
/bGLq/RhaKcmfdDD3eBe+BHfLxO/u5Jn3CXRt1hh1WrxUBD8bTCN5R0ityuy
JsTIwgEZa6VFtwDKvn7kjdljHHmJZ4teHgeuHN9mW44TEOAy5t1GkXdueVGf
tsECrnihE+LTByFKokYW07MY448S0zvaUFj+ZFeUszhYRUbhdVZvHXnFeiOW
o6dXH24+ea0UZZ6POg1TE+BVpBKQWuCMjC/kOz3WLEKJ2UxTc7MUfUq+dr/0
XR8m+U6eEc5Shw7nozgfkJbDO84VPmqUfaeTYpO+E3h0aiKw8VcVvBWkeawH
njlZ1zc/z4bTkvI2iLJPVwf4yKlEKMGWeP43sf68wD3/pAS3W/7Qh6uvbvKq
hMsG3RoQjKqnU4WGnT/jsPXmRfSZOlP1mUaknOId+T5LqncncQsnicHnIQP8
PhU5dPGOuqUVUtfMZRs/cgAEcm/g98sl1aoR/loJxLg3XMbmuiLIVn3A6znv
/KG/ckQkfmv4Ezp4H7nyst1vSciw3ob3+UpYdu4ysFsH9eGW4+LrKPfb+go8
/xv5hZmLrdERhfcV2TSqW4FViWoztq6MFZMq2Y8po6ZDavFj2ppgkpewGXte
SsL6pl4GF3I4GUWq9ZKHPMstuH3yiehDpKXqQ2yY9i3Q2r8Wrm8tM9p4QAY4
/aXxPtnGyMTSZ6xboGHBwTMlTh4W4wxxO+EbK6fILWU+2HeepyEnVwksTbSv
Y/JN7GpmNU3BiHf4I/uzLk+IesGbjOXlNy+/s7Ci3gipiOwJnuU3gg0S3+9g
62poSsDmcoYoKptT7ueXU4YTFqq4vTEwFu3+5RErqrkx97SxVR6EhYfxeuNO
or+Piaq/r+NR7zHJdlbYc/jLGUnYB/faynDcLV2v2qTPNtygOBOTxlisBGnm
Nfg6qeX26U1/IQ7GCww9y6I0QOf6gh0mD8/m1w7LVoGrRg9dYlcaQtlw+m78
HGYZPnlxTQnkXrsgLBN1AQUrd/HXT07A6flMfcvXHuj8s/jmZ82OkMl2mx7D
w0n1TtU4yrMXZT9LVFgI0oKfSrx4HGPXqEeqhBEX+kqrMaIrrAw39jfjOH6F
7TtcK9VWovoiXpNb/gBbvKLx+kZdos9ukqrPjnPz+udbPu2AQKHTTDf7lMHy
rSyOj92DViYP1AuD/qF9WoP2GiBwQ9AVj0fRkN5ovZID1rHNMw9cD0KPkuxD
7LvoPvBtLaXsx9jghFtsdodAzecqF7aeHdQMt6yxy0DjajZP1/OnIcT66UEz
Zd9ppHp6aHM3wwstFskc3Rq0CLzLY0wo6z+vWOpraTlI5rDRCndfRGz03hkZ
nyjrM93uScYZdXTn+vTcsT2GIGOYh+NA/nBcdcXhrTAqXjm6k9SkCZmlTng/
IDfpQZda7AZE/2j/1/ZaVZDU3InXSd6dOvswqfAxOWbX7+UQpwIVG+LxOJIa
0Xd2iqrvzHZD+vNWfwGQSt22bCObFtAXDJlj8uPatkPz3Lvh7he3Zx85DsKl
d5KvsfmYlj19rryoBkldPl1uGmZAX3pmL3bOB7Q7e0fttQWJH2XJ2umuoNAw
h/eJKErQxJivvIkiN7/1Fe0uRw4OU33fh7A6zKX4UgJVfCmI6Icyp+qHYuq4
PSg764sM7aK6n8zYgDb9k+SBxf8nvtRHFV8KIvqAtKn6gKZS6/ZaR2iDIZvF
3UJ1J1Bgku3H7guG52w/Td67oDUPv/ywcjUAuYhga+ze+VopctdGNRl9li3w
z39+Co472rBZY7giRF+MKFVfTNzyp54GOtaw5oQkJ8+IP2Ttzv2E3Xfn1xpM
3fx0BPFnCyp3z6oDa+QqPyx+8oLoE9lO1Sfiuy9fvOO1OTJewxcyQTEPJQs4
+DA9RxNxiQNUcYlsS86RsZuGyGDuivGy4j1g1U1jhektd5mUkV+APWJpPZY0
Q5lXkvObLdj3fjz/TuD6a1+038zboZ0pGJIqWVjK/nLPPn64eHOB+RgkqFey
xfQEgr4YxzDW37HCY+WZo29sYfb0sG1gjQtMBM2qY35ZwaLaguW8EezSpZMx
PGkEsRotl7FzjIaIbxykim8IhvSwxOaZoyOPCr66WujDCj8OHK/yRsmEoESE
AwrNqxOdeuEK6ya2XsH7ZexP6JYKeiGGGdudnUpRcILrPW0sRX7k+NGs9jpf
VMD/nOfT3izIk/5dmU6xW1KJOvwjVHX486yPvtDt84SLMraHLbnOAMP9F3K/
KP93iLs0baOfI0yG6ZeMvgiBtwymNncxfab9Dvh5xxrmnoS7SB12g9M8NN+x
710w+P2hesQQmB249icbW8Lszs2nsfW28c6hpG5/HSjIUFJOpdj5Ws3GeN/f
fBr5czrl/Ix0rmvNy5WBZ4e/BWP7zomoE7tIVSeWT8Qzhx/+M55ZqrUuRXzB
DtHk8B8KYPFBTNtL0zE81aMdS7iRqVS4kX/6v6OdS3iAWwk8QG0CD/Dfxm3+
JHcjcOo2ETh1mgRO3TARH5ukio8JEnG5Eqq4HP/0zXvPpI6jiilFhXuWbtAy
Y2mH1aHxEvhpllT4aX+aD+eppfoKCar6ChJRR/GYqo6C5W5yuldwJHwqt1yc
WxECOkVe9lh/aGFQ6lxbUTgcf3vCMZI5Auxfc7nYUORZ6gE7WofIMCgvcv2c
ZT2gjXJl3ikUf5DoV/Kg6lfiTV+KH16lih/+t/T/35L/L4S/nM0=
     "]], {}},
  Axes->True,
  AxesEdge->{{-1, -1}, {1, -1}, {-1, -1}},
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  AxesStyle->GrayLevel[0],
  BaseStyle->{
    Specularity[1.], 
    RGBColor[0.1, 0.1, 0.1]},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->GrayLevel[0, 0.5],
  Boxed->{Back, Bottom, Left},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{409.4980545774421, 319.4882566272493},
  ImageSizeRaw->Automatic,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Lighting->{{"Ambient", 
     Hue[0., 0., 1.]}, {"Directional", 
     GrayLevel[0.6], 
     ImageScaled[{1, 1, 3}]}},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0], 
      Opacity[0.2]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{0, 1}, {0., 0.5}, {0., 0.0018152859865780842`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  TicksStyle->GrayLevel[0],
  ViewPoint->{2.0764318352967353`, -1.8103809036747005`, 1.9649304865506558`},
  
  ViewVertical->{-0.4376918613806606, 0.38161088366483437`, 
   0.814124663641679}]], "Output",
 CellChangeTimes->{{3.851991175596321*^9, 3.851991188156067*^9}, 
   3.852099769026505*^9, 3.852099840152269*^9, 3.852100226701511*^9, 
   3.8521006529204493`*^9, 3.852102744002846*^9, 3.856790500789186*^9, 
   3.857306002990883*^9, 3.857311947626852*^9, 3.857312736106235*^9, 
   3.85731678740065*^9, 3.857472550671721*^9, {3.857472669108161*^9, 
   3.857472692148705*^9}, 3.857480400691743*^9, 3.857501084918508*^9, 
   3.85751684082974*^9, 3.857576042248208*^9, 3.8576555356399508`*^9, 
   3.858008094574027*^9, {3.8582777871859407`*^9, 3.858277792462254*^9}, 
   3.8593168251313963`*^9, 3.8598927620429153`*^9, 3.859896952499642*^9, {
   3.85989759928612*^9, 3.859897675141019*^9}, 3.85989771447301*^9, 
   3.8598980000631723`*^9, 3.859898714540739*^9, {3.8598987700434933`*^9, 
   3.859898787797167*^9}, {3.859898894951852*^9, 3.859898976089574*^9}, 
   3.8599088975038*^9, 3.859908933455188*^9, 3.859975691534268*^9, {
   3.859976813379868*^9, 3.859976835442383*^9}, {3.8599771660336437`*^9, 
   3.859977210213913*^9}, 3.8599772873210373`*^9, 3.859977341859164*^9, 
   3.859977375981565*^9, 3.859979582659725*^9, 3.859979865050913*^9},
 CellLabel->
  "Out[320]=",ExpressionUUID->"382c93c3-862a-4dc4-8015-498c6b8598d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0."}], ",", 
      RowBox[{"param", "->", "1.2"}], ",", 
      RowBox[{"q", "->", "0.44"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.85997900439428*^9, 3.8599790959643707`*^9}, 
   3.859979176201169*^9},
 CellLabel->
  "In[321]:=",ExpressionUUID->"cbb700c9-903c-4b75-ac3e-0e9c9622c628"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVV3k0FIwXjShRtEhNFNKiDfXRlHBtYTB2WZNtpKwhFcouMaJIiKSUfcmW
7Ev2dcYM+awpFV+FiCzp5/fHO++8c96779xz3nnvPmFrFz0K67p16z6t2f+9
OuUrrWbCUC49IqWX15oENqU9riMESXxPi3reZEPCP8lxiYUEZajNjAR7U0jQ
6OgrSCIYIDpeKvazPQlGtguVDwm2+DDIttDiQsKQ+F2lCIIHtnv4hzTeJuHZ
Tu2QMEIQ9piY30pKIMGfo/DwPUIMLv1oG1vqI+Go6oPQAtcYBF2zNzn0Lwn0
YJeJgaYY2E7spOgPknBg/fEsMc9HmNwSqVAwSkLjn1QxBj0WL460ngmcIGHz
bKyUIDUeZ7888HBfJiFuyEupePUppPLLhOOE1GFskpI3PZOKZKv6HB1XdUwN
GHA+3/MS7xeJ7bVu6gix4KDoK70EvcI0S/K6OgptXPaUxLzETbJIgaCXOrid
ZYO9ia/QdcSfhytIHQ0B/aYbbqdBIjv+9pk4dZzK3rZBgCMTRZKHxZdq1cH1
199cdV8eirLU2Pz4NRB3xcjiuEoedP9+jLTcp4EDjOOW25zzICj7SVZJWANy
GX02A5V5yP2quInnsAbeZsQWvxHLx9B+1cc1pzTwXf9bhUZnPpac/9hFqGvA
MP1xm/uWAhxjFm8d8tbAQd0fX+vDi7B8OPFG37gG9viqSl9OKYLtEXn2pxMa
2JrzLJzzTRE8DDRbLn/XwBKHvpjuWBHSa9pY2X9poLvmjfvwmWKMdxUl27Fp
wkvCf/X3eDFqhFmLWkQ00cnDyysm/waystLfj1A0caPzLOLm3sKlnUmWntUE
t1jxeAtHGfSFd5KTFjSRGiFBXRYog6DawHq2FU3QNA/3W5wvQx6LVfogGxnH
2njdD8aW4cM2Y4VyPjJGmqZeFRDLIfJ2k93Jc2So1r7k7vCqQNveC1pCd8kY
FhIuXr1fgUfcXMmsVDI8/BLNJF5UQEFqXGoiiowURKdHt1Vg6W84qT6BjOVK
P0VTgUooFlY9zMolI6/MzPNLZSXEVPp5dfvI2FW0bZiFpRrV6c5PeY9rwZy6
bPCJrxpWjoQPqye18Nx2vK3xeDWSFFVmfhC1cHzn27fhxtW4dGPi8aiSFhQ9
LR/tzK/G/Y+qNE5zLZxONHoVI16D0g+cRf4RWrCyeHUxfbgGEwWl70/+0kKQ
On98/EQNZs2PiYwva+HV6ShG2FwNVqkZCsms2vjG7aXhxFkLGWtpQdGt2vCs
Jp89dboWgau4FHFMG1ShX7wVEbUQn30gnWujjZIxpfYumTpES+ss3+/XRq+a
/0yEah0IJlnTXB+0MZ9bxaepV4eHFJaCqK/aIHqftWq+XAd2dqX61wvaKN0h
Pl/zsA4JqXJpR7h08FZ5j1DB1zqMbZIfvH9UBxWvpt1jYuqxKfJFSZSjDgY3
i8XrJdejfuTQUq+rDlbcHKq2ZtaD1LU4KnxdB7L4zBFRXY8aca7Chts6qOob
SAqerMcjvv4DKpE6qOZoavKUf4eHfARViUId1F1N4jf59g49x1SvDq7qoHDC
wcFi/t3afJw+57peF6n20uU26xpwmeo6xsGhi2C7PlNn3gb4StZ2qm3ThZr1
toRAmQZIUgnD6w/oosskeHcutQEtpp8XHdV1MajmtHP9iUZEVhr1yT3RRUfT
OQoHsRGvV587ej/TRZUKZ/EWhUYcvavcXPlSF8nKaQa7DRvx793Tc/r5urCW
/xB94nYjWAKHtzQ16OIr0XC7cUcjKIJv5rpmdPHrkCxPjlMT5huu2eVo6UFu
TLEp7GYTvrH21Z821ENIkpqvfWATDGkjWs1meuDjNZgSiW+CU+yeA2xX9HCa
xaEr4V0THhTwkUcD9XBzIC4ylL8ZabP5HMRyPaxEzvHYtjRjSITA2SyhD2WN
pSYFRjOI7aLJ7mf0Qd2wzk9wpBkW5WTtI/L62Huba/rfuWb8GniqWqitD7mr
+7t1hVpwe9EpSslFH77KOlG40YLNQ+7NlHx9sC5mbeU/2AovbvXxc+cMwN+h
OAvxVkyxKjgUKxlAMqWfaXu2Fc8uCs+d1TQAhbTxSS65FdzZ46a2Fw3QHG99
UNGzFUH84U/k/QwQKU2QvtLUipaHnK6izQYQ8AmxeXOlDTvEHAgaVoaQ0tmr
MujehnGVTDmygyG0DhSJstxpg7brSeGL1w3h2/7hu/rDNlS2/w54dc8QYwKy
N4fL2iAwqB46VmCIjMpZKvvmdlCL3Pr5OC7g9F/LEv3cdizkla4Qqy5Ak1wT
cL60HYtHTbb813IBNk8EtYl17UhP+a87l3kBUcThL3t622Ha2zxt//0CJlzM
CGN/2tGx8Egka68REkcNfVzJHbijp/QhyN8ILHXqihHfOjDravkn3MgYu7dm
cvvOd4Dw5EVsPMUYYhabBlzXdeK6t3BohbsxTJea3A14O/HT0ma/UpQxik6d
f8kv04mIjJ/bjVuNYfcCHJnhnRAQ5rRuUTRBe5BkZ+PRLmxc6GUTVTGFNE8b
6wOpLpSrHfQuNDZFerwV0Uy+C+wO86mXHEwRmHv/2ZRhFwpCOTT4H6zlv//q
ttu/C3HpjxNFh9fyjyXtutrXhcfOW+0/3TEDX8k/mpJjXUhglKemRJshSL7V
b/VbFx7uP/YlKN0M+ZnLHiSWbhw/r79QRTdDeLXo8BBfN6Zk6INcR8yhOBGQ
v0GxGxutYu5bDZnjllhnq4NqNySCBP/kzJkj350w3q3Zjem77ZOHNl/EvtU8
whOjbkTHhmx7du4iFrcPBYg7dcPzLEtgReJF5MsQDY3juvFDIGCM094CglH/
LWb86MYqfX+p5Q5LVFn5ZhTMdoM4+nOWLGwJi392mJT/Xuu/SCRdELdEYq90
aTsrDW+MjC3falhi994wzyk+GhQCw4xpwZbYnik6KwkaBpbMQ6l/LfHau+K5
rDINlJGoM9o8VtAh6+ipkGiY3/Bz6aSgFSKnb7w20qeBqbzAbwIrbCY2uXhd
puH73IZhor8V2N9RvlVH0qBOKJWlclkj9dHik+YYGh4Nt5T67LWG8uUIDVo8
DX/4N3tFi1sjgLM4c+wFDfa8p6KkDKyxqsN2hb2Uhod/pfONk63xe+j5uPoo
De1bayuCZW3w38LIMFOCDi/fTbRzSbYouRxZp36aDoXlBzk/S2zh1yf3qvoc
HXwhz+7/120LvjdJThkqdEwHFm5KY6es3R+zFR9zOvwWXQIvuVGQMNdLOBBK
R+XeDwllJnag2Ib8iYugQ7XkndSmm3aQYEh92BJNx18/m5TMWDs0FsakLyTR
wT+Z3jvJsMOMmx6xrZCODfTK4CDDy2s6r8PAbYQO2oUv4rr29thhdfvMl0/0
NR7mG52p9hjuPi5gPklfu2MK1+by7eGRH/7x/C864qSFypWX7ZHsQnIjcPVg
um7dxQOPrmD++7vImtM9GOwd2Rw2chW1Fz3cpWR6kJllGL6PywHUDhGjTIUe
pPdVHJMhOmB/TsC+GM0e5Hu/Iws8cADZUT7nsnUPcnQWA4o1HJE6Wd7Kfb8H
vnf0DmQMO8H5sbbI1egeBO1rzuLZ4Qyi8kfvhrgefM2ezTyo5ozWJM4TPi96
MFu9sNmpyBkzOiaRE6U9GP5l8q75kQvk3szrv/vYA9nVEwU+1a7gsA3LFpzo
QZqSmTP7qCvoW/exe//ogTjNWpCd5RooV8+XnFzsAXfJqS3uytdA3RuzO5mb
gXU3pUN0aNfQH3hy6NZZBlKxQTSc3R3PJRqkmHIMRPOciGkTc4fjkPF9CWUG
vKccnQqM3bGO6IcvWgwsJjq7B+S649BkZ4qBLQMz8Ix6Yu2B6VjrpbwrDCiJ
SLrdeeCBMqV5PS4XBnbsyFkQrfUAOWkvW90tBlKKb3F/3X8dHjqOduKRDGQf
L/ybOH0dcn/+VoXFMDDy3j1Z/ZAnNmZG7/ocz4Bx7AaLSXNPJKwvb05MZcCr
zG18d4cnaks2HeMsYyDrVgxz8u0NcO9Nm/r0iYGAkT/c8223IH8hcOjjxBq+
UDYJPF5wi7zUNvaDATf5KZZWfS/0suxOG/3NQLXMvYnGUS88/RxqMbiZievM
uFoKlw+6BSmaA9uYKBKQFKox8QGriYL0v3xMHBTi/pyZ4QO7tsWd74WYWD3s
fttS6zbE8q929EgykaKZzp6bfQeWEyrl9LNMHO03XZ3k8F3bayIZNDkmBNwG
V/Zf9sV8zEBQl9oanu8y7xivH6puacq0mTPBcdToaf8nP0wXiB5ttWJCT0BK
pJffH/u/se1usWPCUzl5nmDgv/YPVM42ujKBxxUJqc3+ICuJZdUFrdX773IR
rA/AHR/O+Np7TJDOcExmswciv/hzSM19JtoljWmTpEDwiiZbV8Uxod2TpPK2
L3BNP23dU5bNxO/jT4sTOIPBrfJt49vXa/yuOGU+Mw+GvG/zrzclTJx0LF2Z
yQ9G6owfrbiGiV9TkrL9liFw7J0Jfc1g4hrx80rF6F085en0zO9nwvdoSttu
tVB0q2Xa5g0zEYYd23ILQiFZbi2f85WJ/LSDIUIP78FuTk4s+zsTqitFL3U3
hiHuBL9A1k8mKLsm/W39wrCS3LOQvsLEj1DC+oU74RDrzxtPY+nFmVfeX8bY
qLDcTu15taEXPxuzEu9FUuFVfGJkYi2OC1WwlXxMxf8AuwXFHg==
       "]], 
      LineBox[CompressedData["
1:eJw9lGs01VkYxpWTCimXopJo3CoiKaPMPBFSJI7rpBpJnJJc0qhkXErtc45L
wiBKN2eEUiaNLmY0XYRUcsnexxSJKZWkozBG858v8+Fde71rr/W8z/t71t56
AWH8bePl5OQ8ufrvFC385Noz0oYcYhtomZ2M+2s0qiiPwr94OFOGZKS5H9px
dxaFp02jwDBdjHiPDq+VuhTd6643NgvEiPSysb1hQOG70zSwzlYM7+9kmpfN
KWa+360h+CyCk5+bvMkyimRHXuWXJhGsN5X2SVZQZO1MOlx1WQTtLYF38x0p
vprUW5gaLoLK1upLmi4UvNtsdaa7CHLbtPOPuXPzyvTKzi0RoUvQHEk2UpSM
TP6lYUSI4nB73ahIigpqniLJFCI/8pTS+2hOX69lVVCsEClRo5+2x1L0TR2n
PDFYiPC9Vxq+JxQGtQ8spTZCBOyfdo2lULQaO/2hMF8IzwM7z3llUPAPuv0q
P0MIq3j9GOeTFK9zpUaBAwTGifFB985SDNvMWnqrk2DWoXZ32/MU6by4uheN
BGNHMo2trlDkuIYHCq4Q9Av71cuvUXw2rzGvkRB0il2+mPxOoU2OqXXkEtxJ
47XOq6PoLZpjYJVIcDXd/9aJRxT77RabRUQTFGXcLNVqoYhblvllYyjB8Syt
nAxGcczKtHFoK4E4O+qgSgeFnWLFqJ0fwYHcx7uE3RRTaxcOWXsQ7Moz2cB7
QzGnXMW73ZnA/wRxiOunyBMM3jF2IOAXvDQfGaRIWfNWRQcE9qdXau/5m8tv
bqfWDWuCpWfzJ/bLMWyesP3FmCWBYeHQwA4FhpKn05NemRNo/ez5rFuJIf6J
u2W0KYHi+Uu1/qoMTLndpngBwWixcoV0BkOIXzkvwZigr1Rwylub4SPNU/zb
kOD5xTviRj2G+2EaPZpc//gd762FEUPylCa5pwYE1SYOLpkmDOrLulItuPtL
IUmlg4sZ9vFkEQuMCE4V31X2sWKoDtQ68xunf/T1hNBKGwbV2R9M33PzE4wd
G2baMdwaF7n8JucvMviwacxqhkV9OvKGiwkCJPdS2l0YNHpl1GQpx6Nboe8b
PoPkx9NGjdz+q/RXuxb4MOQVJYaoc3wstx65KLeJwWOsf4XMnkD/TI1KQADD
a76nYxTHV6NzYtjtYIbUnqj1mXyCCbpOj/RDOf+V55Z4bSDoOXE/7a9ohnkR
QT9UhRC0tk/qd4plcBCFKgTvIaiZvcatOJHjK17cUhHH5Z9bOy00hWGu/D6J
008EOW2TIx4e43huGSlMO0Mg1FzbaJbDkBVr+zyhjGBHVl36wBmGk3/y9cPq
CTY0Kw54FDEcXdA5eRcjcFZ35ldcYMiNsXk2t5fAJL1ebW8lg1lSoFuhkhDv
kh9k/NPA+Tluxo/1EeJZvbJscxNDoJMO9d0pxEPFdZ7VbQybTn19YTRBiIuk
QeNgF0OEvFpBcZkQJ2um7Hn5imHbB93mGzVCpCm4tjj0McjGfTxytoN7f4ce
Zk0aZhh+0RSrMF0E/9sqn7aPMbzR84bIXAT38eu96+WlsH8QnjjoIoJF/KMZ
qSpSeC9fWp1FRJDFPM5W15dCK7prLE1JjJfXpw1FzZdihK/i07lIjJZhN9/W
RVK0lNwvd/QQ42p0o1autRSqBzqrBAViSK6q7hv5ltMPmt+2pEaM7EF36mcv
hYWTpMmsX4y9u5/k6qyXomS4WV7qkAxBudpInKcUmwuso/Iik/FhrfPQXV/p
///lv4HpicY=
       "]], LineBox[CompressedData["
1:eJwVj3c8FI4Dhs3SV8lqnEhJJSlCaXqTJHfo7mwyItnrkETIClkVaVCpREZk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       "]]},
     Annotation[#, "Charting`Private`Tag$38387#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.013960274991579077`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8599790191385*^9, {3.8599790517144203`*^9, 3.859979096467621*^9}, 
   3.859979176499426*^9, 3.859979582766142*^9, 3.859979865159339*^9},
 CellLabel->
  "Out[322]=",ExpressionUUID->"fae22e22-ca36-4252-9f8d-fdda0bebd6b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"wstar", "*", "what"}], " ", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"epsilon", "->", "0.0001"}], ",", 
         RowBox[{"q", "->", "0.44"}], ",", 
         RowBox[{"param", "->", "1.2"}], ",", 
         RowBox[{"eta", "->", "0"}]}], "}"}]}], "//", "Total"}], "//", 
     "Total"}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"tmp", ">", 
     RowBox[{"2", 
      RowBox[{"Norm", "[", "what", "]"}]}]}], ")"}], "&&", 
   RowBox[{"0.3", "<", "p", "<", ".6"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.859898987023349*^9, 3.85989921572355*^9}, {
   3.859899250090685*^9, 3.859899279801219*^9}, {3.8598993165223417`*^9, 
   3.859899365297201*^9}, 3.859908871655725*^9, {3.859976709524143*^9, 
   3.859976714593574*^9}, {3.859979134111746*^9, 3.859979187775628*^9}, {
   3.859979317147999*^9, 3.859979446704867*^9}, 3.859979494929811*^9},
 CellLabel->
  "In[323]:=",ExpressionUUID->"3994771a-8fca-4fdd-9d46-41c965a7d7b0"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 324, 27, 21874851026236730262, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.859899255225458*^9, 3.8598992720184393`*^9}, {
   3.859899317149091*^9, 3.859899330556438*^9}, 3.859899366330948*^9, {
   3.8599088720975943`*^9, 3.859908898842255*^9}, 3.8599089370665903`*^9, 
   3.859975692046205*^9, 3.85997671569569*^9, 3.8599768399236403`*^9, {
   3.859979155412715*^9, 3.859979188261301*^9}, 3.8599793358011627`*^9, {
   3.8599793836492434`*^9, 3.859979447314561*^9}, 3.8599794961001787`*^9, 
   3.859979865499621*^9},
 CellLabel->
  "During evaluation of \
In[323]:=",ExpressionUUID->"eb477998-1c6c-4ad8-870d-1c83d61ff697"],

Cell[BoxData[
 RowBox[{
  RowBox[{"param", "\[Element]", 
   TemplateBox[{},
    "Reals"]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.3617656710469713`", "<", "p", "<", "0.36176570113294554`"}], 
      "&&", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1.2203388433790667`*^144", "-", 
           RowBox[{"1.2075085454030684`*^145", " ", "p"}], "+", 
           RowBox[{"4.4600087287452205`*^145", " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{"7.287447118589324`*^145", " ", 
            SuperscriptBox["p", "3"]}], "+", 
           RowBox[{"4.44478585767287`*^145", " ", 
            SuperscriptBox["p", "4"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4.014114269357927`*^144", "-", 
              RowBox[{"3.971911003153794`*^145", " ", "p"}], "+", 
              RowBox[{"1.4670502999719667`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"2.3970920530312362`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.462042974001874`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5.308007818720408`*^144", "-", 
              RowBox[{"5.252200918431323`*^145", " ", "p"}], "+", 
              RowBox[{"1.9399334287863231`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"3.1697611222390787`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.9333120613881546`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3.300950684041444`*^144", "-", 
              RowBox[{"3.266245416854426`*^145", " ", "p"}], "+", 
              RowBox[{"1.2064082788003397`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"1.9712150957234608`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.2022905743872177`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"8.25237671010361`*^143", "-", 
              RowBox[{"8.165613542136065`*^144", " ", "p"}], "+", 
              RowBox[{"3.016020697000849`*^145", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"4.928037739308652`*^145", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"3.0057264359680443`*^145", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], "<", 
       "param", "<", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1.2203388433790667`*^144", "-", 
           RowBox[{"1.2075085454030684`*^145", " ", "p"}], "+", 
           RowBox[{"4.4600087287452205`*^145", " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{"7.287447118589324`*^145", " ", 
            SuperscriptBox["p", "3"]}], "+", 
           RowBox[{"4.44478585767287`*^145", " ", 
            SuperscriptBox["p", "4"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4.014114269357927`*^144", "-", 
              RowBox[{"3.971911003153794`*^145", " ", "p"}], "+", 
              RowBox[{"1.4670502999719667`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"2.3970920530312362`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.462042974001874`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5.308007818720408`*^144", "-", 
              RowBox[{"5.252200918431323`*^145", " ", "p"}], "+", 
              RowBox[{"1.9399334287863231`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"3.1697611222390787`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.9333120613881546`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3.300950684041444`*^144", "-", 
              RowBox[{"3.266245416854426`*^145", " ", "p"}], "+", 
              RowBox[{"1.2064082788003397`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"1.9712150957234608`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.2022905743872177`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"8.25237671010361`*^143", "-", 
              RowBox[{"8.165613542136065`*^144", " ", "p"}], "+", 
              RowBox[{"3.016020697000849`*^145", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"4.928037739308652`*^145", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"3.0057264359680443`*^145", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
     ")"}], "||", 
    RowBox[{
    "0.36176570113294554`", "\[LessEqual]", "p", "<", 
     "0.36184471686202024`"}], "||", 
    RowBox[{
    "0.45792791035166636`", "<", "p", "\[LessEqual]", "0.4580135250739988`"}],
     "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.4580135250739988`", "<", "p", "<", "0.4580135576748389`"}], "&&", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1.2203388433790667`*^144", "-", 
           RowBox[{"1.2075085454030684`*^145", " ", "p"}], "+", 
           RowBox[{"4.4600087287452205`*^145", " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{"7.287447118589324`*^145", " ", 
            SuperscriptBox["p", "3"]}], "+", 
           RowBox[{"4.44478585767287`*^145", " ", 
            SuperscriptBox["p", "4"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4.014114269357927`*^144", "-", 
              RowBox[{"3.971911003153794`*^145", " ", "p"}], "+", 
              RowBox[{"1.4670502999719667`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"2.3970920530312362`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.462042974001874`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5.308007818720408`*^144", "-", 
              RowBox[{"5.252200918431323`*^145", " ", "p"}], "+", 
              RowBox[{"1.9399334287863231`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"3.1697611222390787`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.9333120613881546`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3.300950684041444`*^144", "-", 
              RowBox[{"3.266245416854426`*^145", " ", "p"}], "+", 
              RowBox[{"1.2064082788003397`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"1.9712150957234608`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.2022905743872177`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"8.25237671010361`*^143", "-", 
              RowBox[{"8.165613542136065`*^144", " ", "p"}], "+", 
              RowBox[{"3.016020697000849`*^145", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"4.928037739308652`*^145", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"3.0057264359680443`*^145", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], "<", 
       "param", "<", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1.2203388433790667`*^144", "-", 
           RowBox[{"1.2075085454030684`*^145", " ", "p"}], "+", 
           RowBox[{"4.4600087287452205`*^145", " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{"7.287447118589324`*^145", " ", 
            SuperscriptBox["p", "3"]}], "+", 
           RowBox[{"4.44478585767287`*^145", " ", 
            SuperscriptBox["p", "4"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4.014114269357927`*^144", "-", 
              RowBox[{"3.971911003153794`*^145", " ", "p"}], "+", 
              RowBox[{"1.4670502999719667`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"2.3970920530312362`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.462042974001874`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"5.308007818720408`*^144", "-", 
              RowBox[{"5.252200918431323`*^145", " ", "p"}], "+", 
              RowBox[{"1.9399334287863231`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"3.1697611222390787`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.9333120613881546`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3.300950684041444`*^144", "-", 
              RowBox[{"3.266245416854426`*^145", " ", "p"}], "+", 
              RowBox[{"1.2064082788003397`*^146", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"1.9712150957234608`*^146", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"1.2022905743872177`*^146", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"8.25237671010361`*^143", "-", 
              RowBox[{"8.165613542136065`*^144", " ", "p"}], "+", 
              RowBox[{"3.016020697000849`*^145", " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"4.928037739308652`*^145", " ", 
               SuperscriptBox["p", "3"]}], "+", 
              RowBox[{"3.0057264359680443`*^145", " ", 
               SuperscriptBox["p", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
     ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.859899012948135*^9, 3.8598991518565607`*^9}, {
   3.8598991907215443`*^9, 3.859899223448545*^9}, {3.859899255205336*^9, 
   3.859899272000023*^9}, {3.859899317130948*^9, 3.859899330536615*^9}, 
   3.859899366308963*^9, {3.859908872076006*^9, 3.859908898831339*^9}, 
   3.859908936938448*^9, 3.859975691560701*^9, 3.859976715568128*^9, 
   3.859976839880146*^9, {3.8599791448082848`*^9, 3.859979188269547*^9}, 
   3.859979335816662*^9, {3.859979383711825*^9, 3.859979447329708*^9}, 
   3.8599794961170797`*^9, 3.859979865517171*^9},
 CellLabel->
  "Out[324]=",ExpressionUUID->"9f587c7c-0984-4053-96ba-aa0b88b57a24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"testp", "=", "0.36184471686202024"}], ";", 
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{
         RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"epsilon", "->", "0.0001"}], ",", 
         RowBox[{"q", "->", "0.44"}], ",", 
         RowBox[{"param", "->", "1.2"}], ",", 
         RowBox[{"eta", "->", 
          RowBox[{"10", "^", "etax"}]}], ",", 
         RowBox[{"p", "->", "0.36184471686202024"}]}], "}"}]}], "//", 
      "Total"}], "//", "Total"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", 
     RowBox[{"-", "7"}], ",", "10"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ref", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"wstar", "*", "what"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", 
        RowBox[{"q", "->", "0.44"}], ",", 
        RowBox[{"param", "->", "1.2"}], ",", 
        RowBox[{"p", "->", "testp"}]}], "}"}]}], "//", "Total"}], "//", 
    "Total"}], "//", "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"ref", "//", "Factor"}]}], "Input",
 CellChangeTimes->{{3.859979231188657*^9, 3.8599792858634243`*^9}, {
  3.859979462247497*^9, 3.859979470410192*^9}, {3.859979521261462*^9, 
  3.8599795222706137`*^9}, {3.8599796950233183`*^9, 3.8599796956834297`*^9}, {
  3.859980291174617*^9, 3.8599802920938396`*^9}, {3.85998050188949*^9, 
  3.859980520418404*^9}, {3.859980749277096*^9, 3.859980754711328*^9}, {
  3.8599810590302477`*^9, 3.85998107095947*^9}},
 CellLabel->
  "In[378]:=",ExpressionUUID->"a01ff745-b666-43f8-b696-6e1333ac5b44"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwd13k4lN8XAHDbjG2GGca+0zdpU4pQeo+Q7FoQUUSSUpKiUtEqpCRrWZJ9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       "]]},
     Annotation[#, "Charting`Private`Tag$61349#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 2.634862493621985},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-7, 10}, {2.6348624936219793`, 5.404456310245259}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.859979286420108*^9, {3.859979454776904*^9, 3.859979471897004*^9}, 
   3.859979522774479*^9, {3.8599796817590637`*^9, 3.859979696167622*^9}, 
   3.85997986564351*^9, 3.859980292423744*^9, 3.859980521313834*^9, {
   3.859980750112173*^9, 3.8599807573848352`*^9}, {3.8599810596582108`*^9, 
   3.8599810714871597`*^9}},
 CellLabel->
  "Out[379]=",ExpressionUUID->"af690101-da56-4880-8e17-f3ba13a15a26"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "0.003660297224417549`"}], "+", 
   RowBox[{"0.021346545063431727`", " ", "eta"}]}], 
  RowBox[{
   RowBox[{"-", "1.4210854715202004`*^-13"}], "+", 
   RowBox[{"921.2177644479319`", " ", "eta"}], "+", 
   SuperscriptBox["eta", "2"]}]]], "Output",
 CellChangeTimes->{
  3.859979286420108*^9, {3.859979454776904*^9, 3.859979471897004*^9}, 
   3.859979522774479*^9, {3.8599796817590637`*^9, 3.859979696167622*^9}, 
   3.85997986564351*^9, 3.859980292423744*^9, 3.859980521313834*^9, {
   3.859980750112173*^9, 3.8599807573848352`*^9}, {3.8599810596582108`*^9, 
   3.8599810714969397`*^9}},
 CellLabel->
  "Out[380]=",ExpressionUUID->"aa81dbed-e516-4371-b601-29079f0baf84"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.021346545063431727`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "0.17147024090038437`"}], "+", 
     RowBox[{"1.`", " ", "eta"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1.542616226437871`*^-16"}], "+", 
     RowBox[{"1.`", " ", "eta"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"921.2177644479319`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", "eta"}]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.859979286420108*^9, {3.859979454776904*^9, 3.859979471897004*^9}, 
   3.859979522774479*^9, {3.8599796817590637`*^9, 3.859979696167622*^9}, 
   3.85997986564351*^9, 3.859980292423744*^9, 3.859980521313834*^9, {
   3.859980750112173*^9, 3.8599807573848352`*^9}, {3.8599810596582108`*^9, 
   3.8599810714997473`*^9}},
 CellLabel->
  "Out[381]=",ExpressionUUID->"5abfecd6-5120-4e0b-bd0e-2fc507013c6e"]
}, Open  ]],

Cell["\<\
We have candidate solution! The 10^-16 is spurious (because of numeric \
error). We pick testp to be exactly at the singularity, so one of the roots \
of the equation must be at eta==0.\
\>", "Text",
 CellChangeTimes->{{3.857496342078785*^9, 3.857496359678273*^9}, {
  3.8599797179069777`*^9, 3.859979725311686*^9}, {3.859980945976013*^9, 
  3.859980970226527*^9}, {3.85998103274146*^9, 
  3.859981046789366*^9}},ExpressionUUID->"7033b8f7-5c56-45a1-9020-\
9cdc55035473"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", "0.0001"}], ",", 
       RowBox[{"q", "->", "0.44"}], ",", 
       RowBox[{"param", "->", "1.2"}], ",", 
       RowBox[{"p", "->", "0.36184471686202024"}]}], "}"}]}], "//", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nV", "=", " ", 
   RowBox[{
    RowBox[{"Norm", "[", "V", "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"param", "->", "1.2"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"tmp", ">", "nV"}], "&&", 
   RowBox[{"eta", ">=", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.859980569616571*^9, 3.859980582912456*^9}, {
   3.8599806225531588`*^9, 3.859980707464902*^9}, 3.8599807723098707`*^9},
 CellLabel->
  "In[365]:=",ExpressionUUID->"6c5d7d70-2cd9-4263-a11d-f84acde67975"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 367, 34, 21874851026236730262, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.8599806321458607`*^9, 3.859980647007407*^9}, 
   3.859980711273102*^9, 3.859980775713623*^9},
 CellLabel->
  "During evaluation of \
In[365]:=",ExpressionUUID->"dac9a440-5b1a-4164-bf14-fcf870238fd1"],

Cell[BoxData[
 RowBox[{"0.`", "<", "eta", "<", "4.4327364160744294`*^18"}]], "Output",
 CellChangeTimes->{
  3.859980583301682*^9, {3.859980632163437*^9, 3.85998064701659*^9}, 
   3.8599807079058332`*^9, 3.8599807757292137`*^9},
 CellLabel->
  "Out[367]=",ExpressionUUID->"ebfbfbaf-7249-4c47-9bfc-9237c8f2944d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"Total", "[", 
       RowBox[{"wstar", "*", "what"}], "]"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", "0.0001"}], ",", 
       RowBox[{"q", "->", "0.44"}], ",", 
       RowBox[{"param", "->", "1.2"}], ",", 
       RowBox[{"p", "->", "0.36184471686202024"}]}], "}"}]}], "//", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nV", "=", " ", 
   RowBox[{"what", "/.", 
    RowBox[{"{", 
     RowBox[{"param", "->", "1.2"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"tmp", "<=", "0"}], "&&", 
   RowBox[{"eta", ">=", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.859980886441723*^9, 3.859980924167862*^9}, {
  3.859981231146985*^9, 3.85998123732524*^9}},
 CellLabel->
  "In[382]:=",ExpressionUUID->"c2e84982-a21d-4cc7-8381-259b833932b1"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 384, 37, 21874851026236730262, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.8599809065031033`*^9, 3.859980924964583*^9}, 
   3.8599812379412003`*^9},
 CellLabel->
  "During evaluation of \
In[382]:=",ExpressionUUID->"ef79ad66-a4e9-4062-8389-1576c3d3d839"],

Cell[BoxData[
 RowBox[{"1.5426162264378713`*^-16", "<", "eta", "\[LessEqual]", 
  "0.17147024090038437`"}]], "Output",
 CellChangeTimes->{{3.859980906519014*^9, 3.85998092498035*^9}, 
   3.859981237959059*^9},
 CellLabel->
  "Out[384]=",ExpressionUUID->"e1c1d5bd-101d-4287-98b2-0dd13487beaf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", "0.0001"}], ",", 
       RowBox[{"q", "->", "0.44"}], ",", 
       RowBox[{"param", "->", "1.2"}], ",", 
       RowBox[{"p", "->", "0.36184471686202024"}]}], "}"}]}], "//", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Refine", "[", 
    RowBox[{"tmp", ",", 
     RowBox[{"Element", "[", 
      RowBox[{"eta", ",", "Reals"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "//", "Numerator"}], "//", "Simplify"}], "//", 
  "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "//", "Denominator"}], "//", "Simplify"}], "//", 
  "TraditionalForm"}]}], "Input",
 CellChangeTimes->{{3.859981279962924*^9, 3.859981517306781*^9}, {
  3.8599899505275784`*^9, 3.8599899558851*^9}},
 CellLabel->
  "In[422]:=",ExpressionUUID->"f71c0ddd-dfc5-4a4c-85c2-5423c43051bf"],

Cell[BoxData[
 FormBox[
  SqrtBox[
   RowBox[{
    RowBox[{"6.942500000000001`", " ", 
     SuperscriptBox["eta", "4"]}], "+", 
    RowBox[{"16394.064286648354`", " ", 
     SuperscriptBox["eta", "3"]}], "+", 
    RowBox[{"1.0932439517121157`*^7", " ", 
     SuperscriptBox["eta", "2"]}], "+", 
    RowBox[{"86.870797195194`", " ", "eta"}], "+", 
    "0.00017257208336014435`"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.859981281294228*^9, 3.8599812906441793`*^9}, {
   3.859981323544489*^9, 3.859981517635638*^9}, 3.8599899563652887`*^9},
 CellLabel->
  "Out[424]//TraditionalForm=",ExpressionUUID->"799ee944-0138-4a74-a609-\
061d92b5ea14"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
    RowBox[{
      SuperscriptBox["eta", "2"], "+", 
      RowBox[{"921.2177644479319`", " ", "eta"}], "-", 
      "1.4210854715202004`*^-13"}]},
   "Abs"], TraditionalForm]], "Output",
 CellChangeTimes->{{3.859981281294228*^9, 3.8599812906441793`*^9}, {
   3.859981323544489*^9, 3.859981517635638*^9}, 3.859989956370517*^9},
 CellLabel->
  "Out[425]//TraditionalForm=",ExpressionUUID->"e7f6ba9c-330d-4c62-be54-\
6706c0618b34"]
}, Open  ]],

Cell[" ", "Text",
 CellChangeTimes->{
  3.860066147395689*^9},ExpressionUUID->"b3ca5b7c-f48b-4fef-8664-\
7be998ec036d"]
},
WindowSize->{1134.8256880733945`, 909.5779816513761},
WindowMargins->{{0.6605504587155964, Automatic}, {
  18.32727272727277, Automatic}},
TaggingRules-><|"TryRealOnly" -> False|>,
CellContext->Notebook,
Magnification->1.25,
FrontEndVersion->"13.0 for Linux x86 (64-bit) (February 4, 2022)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "JournalArticle.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"edb60e67-8447-428f-bf83-9bc5b3088beb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 485, 9, 49, "Text",ExpressionUUID->"051258ff-3da9-473b-961b-d8991c9fcfd8"],
Cell[CellGroupData[{
Cell[1068, 33, 4437, 122, 309, "Input",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],
Cell[5508, 157, 910, 25, 70, "Output",ExpressionUUID->"96d8b17f-698d-45a2-8c73-e54b5bfca086"],
Cell[6421, 184, 542, 12, 53, "Output",ExpressionUUID->"eabb3504-d9b3-40c2-8a0a-66520194105a"],
Cell[6966, 198, 394, 7, 53, "Output",ExpressionUUID->"5b56d065-b6db-4b99-9509-c3bd8f569b25"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7397, 210, 281, 5, 28, "Text",ExpressionUUID->"0a5d41cb-08ef-4253-a74f-02384f62cb6a",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[7681, 217, 1109, 29, 100, "Input",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[8827, 251, 966, 23, 53, "Input",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],
Cell[9796, 276, 105522, 1737, 434, "Output",ExpressionUUID->"382c93c3-862a-4dc4-8015-498c6b8598d0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[115355, 2018, 740, 22, 77, "Input",ExpressionUUID->"cbb700c9-903c-4b75-ac3e-0e9c9622c628"],
Cell[116098, 2042, 12918, 239, 299, "Output",ExpressionUUID->"fae22e22-ca36-4252-9f8d-fdda0bebd6b4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129053, 2286, 1132, 28, 77, "Input",ExpressionUUID->"3994771a-8fca-4fdd-9d46-41c965a7d7b0"],
Cell[130188, 2316, 876, 16, 55, "Message",ExpressionUUID->"eb477998-1c6c-4ad8-870d-1c83d61ff697"],
Cell[131067, 2334, 11807, 251, 591, "Output",ExpressionUUID->"9f587c7c-0984-4053-96ba-aa0b88b57a24"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142911, 2590, 1828, 47, 170, "Input",ExpressionUUID->"a01ff745-b666-43f8-b696-6e1333ac5b44"],
Cell[144742, 2639, 17588, 312, 320, "Output",ExpressionUUID->"af690101-da56-4880-8e17-f3ba13a15a26"],
Cell[162333, 2953, 724, 16, 72, "Output",ExpressionUUID->"aa81dbed-e516-4371-b601-29079f0baf84"],
Cell[163060, 2971, 894, 22, 77, "Output",ExpressionUUID->"5abfecd6-5120-4e0b-bd0e-2fc507013c6e"]
}, Open  ]],
Cell[163969, 2996, 480, 9, 49, "Text",ExpressionUUID->"7033b8f7-5c56-45a1-9020-9cdc55035473"],
Cell[CellGroupData[{
Cell[164474, 3009, 1017, 29, 100, "Input",ExpressionUUID->"6c5d7d70-2cd9-4263-a11d-f84acde67975"],
Cell[165494, 3040, 529, 11, 55, "Message",ExpressionUUID->"dac9a440-5b1a-4164-bf14-fcf870238fd1"],
Cell[166026, 3053, 311, 6, 53, "Output",ExpressionUUID->"ebfbfbaf-7249-4c47-9bfc-9237c8f2944d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166374, 3064, 970, 28, 100, "Input",ExpressionUUID->"c2e84982-a21d-4cc7-8381-259b833932b1"],
Cell[167347, 3094, 509, 11, 55, "Message",ExpressionUUID->"ef79ad66-a4e9-4062-8389-1576c3d3d839"],
Cell[167859, 3107, 292, 6, 53, "Output",ExpressionUUID->"e1c1d5bd-101d-4287-98b2-0dd13487beaf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168188, 3118, 1133, 33, 123, "Input",ExpressionUUID->"f71c0ddd-dfc5-4a4c-85c2-5423c43051bf"],
Cell[169324, 3153, 653, 16, 58, "Output",ExpressionUUID->"799ee944-0138-4a74-a609-061d92b5ea14"],
Cell[169980, 3171, 467, 12, 56, "Output",ExpressionUUID->"e7f6ba9c-330d-4c62-be54-6706c0618b34"]
}, Open  ]],
Cell[170462, 3186, 119, 3, 28, "Text",ExpressionUUID->"b3ca5b7c-f48b-4fef-8664-7be998ec036d"]
}
]
*)

