(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    568377,      10097]
NotebookOptionsPosition[    562585,       9999]
NotebookOutlinePosition[    563200,      10020]
CellTagsIndexPosition[    563157,      10017]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
We follow the derivation in Kolter (2011) with the aim of constructing a \
fixed-point counterexample with n=3 states and k=2 feature space, where w* is \
near [1, -1]
We achieve this by splitting the left state into two equal states.\
\>", "Text",
 CellChangeTimes->{{3.848632720901607*^9, 3.848632738020585*^9}, {
  3.8486340159286547`*^9, 3.848634057462323*^9}, {3.8489104946422167`*^9, 
  3.8489105216064568`*^9}},ExpressionUUID->"051258ff-3da9-473b-961b-\
d8991c9fcfd8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0.4", ",", " ", "0.4", ",", " ", "0.2", ",", " ", "0.", ",", "0."}], 
       "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "0.4", ",", " ", "0.4", ",", " ", "0.2", ",", " ", "0.", ",", "0."}], 
       "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"0.0", ",", " ", 
        RowBox[{"1", "-", "z"}], ",", "0.", ",", " ", "z", " ", ",", "0.0"}], 
       "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "0.", ",", " ", "0.", ",", " ", "0.2", ",", " ", "0.4", " ", ",", 
        "0.4"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "0.", ",", " ", "0.", ",", " ", "0.2", ",", " ", "0.4", " ", ",", 
        "0.4"}], "}"}]}], "}"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"z", "->", "0.5"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "1.", ",", "1.05", ",", "1.", ",", " ", "1."}], 
      "}"}], "}"}], "\[Transpose]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "5", "]"}], " ", "-", " ", 
      RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "V"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pi", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ".", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{"P", ",", "1024"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pi", "//", "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"epsilon", "=", "0.0001"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Phi", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", 
         RowBox[{"0", "/", "100"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "100"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"1.05", "/", "2"}], "+", "epsilon"}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1.05", "/", "2"}], "+", "epsilon"}], ")"}]}], "/", 
          "100"}]}], "}"}]}], "}"}]}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "epsilon"}], ")"}], "/", "3"}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "epsilon"}], ")"}], "/", "3"}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "epsilon"}], ")"}], "/", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", "1."}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", " ", 
       RowBox[{"1", "/", "3"}], ",", " ", 
       RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi", "=", 
   RowBox[{"Phi", ".", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{"1.", ",", ".1", ",", ".1"}], "}"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"q", "=."}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Dm", " ", "=", " ", 
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", "/", "3"}], ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}], "/", "2"}], ",", 
        RowBox[{"p", "/", "3"}], ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}], "/", "2"}], ",", " ", 
        RowBox[{"p", "/", "3"}]}], "}"}], "]"}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Dm", " ", "=", " ", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"p", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "q"}], ")"}], "/", "3"}]}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "-", "q"}], ")"}]}], ",", 
       RowBox[{"p", "*", 
        RowBox[{"2", "/", "3"}]}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}], "*", "q"}], ",", " ", 
       RowBox[{"p", "*", 
        RowBox[{"q", "/", "3"}]}]}], "}"}], "]"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Dm", " ", "=", " ", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "*", 
      RowBox[{"q", "/", "2"}]}], ",", 
     RowBox[{"p", "*", 
      RowBox[{"q", "/", "2"}]}], ",", 
     RowBox[{"1", "-", "p"}], ",", " ", 
     RowBox[{"p", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "q"}], ")"}], "/", "2"}]}], ",", " ", 
     RowBox[{"p", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "q"}], ")"}], "/", "2"}]}]}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", "V", "]"}]}], "Input",
 CellChangeTimes->{{3.848910053020782*^9, 3.848910152351247*^9}, {
   3.848910308449559*^9, 3.84891030984326*^9}, 3.851936641725163*^9, {
   3.852099656777422*^9, 3.852099660756007*^9}, {3.8520998283982353`*^9, 
   3.8520998330051622`*^9}, {3.852100643443104*^9, 3.852100647045465*^9}, {
   3.857312621661829*^9, 3.857312691960071*^9}, {3.857316711815258*^9, 
   3.85731676509906*^9}, {3.85765391359242*^9, 3.857653919307899*^9}, 
   3.857653970095665*^9, {3.858190355111109*^9, 3.858190364445321*^9}, {
   3.858190515783284*^9, 3.858190528972464*^9}, {3.858876324873047*^9, 
   3.858876333921012*^9}, {3.858876385002718*^9, 3.8588764260865726`*^9}, {
   3.85887647029799*^9, 3.858876506244452*^9}, {3.85887669984844*^9, 
   3.8588767055162354`*^9}, {3.858881430642562*^9, 3.858881510308144*^9}, {
   3.858883366534091*^9, 3.858883382611308*^9}, {3.858885434042835*^9, 
   3.858885456073851*^9}, {3.858888431841683*^9, 3.858888432347713*^9}, 
   3.859047404927806*^9, {3.859048643808484*^9, 3.8590486522963123`*^9}, {
   3.8590491395002947`*^9, 3.859049147978513*^9}, {3.859049237576869*^9, 
   3.859049247399126*^9}, {3.859062089465765*^9, 3.859062113603038*^9}, {
   3.859062200258841*^9, 3.8590622040622187`*^9}, {3.859062358836833*^9, 
   3.8590625641802483`*^9}, {3.859063013418304*^9, 3.8590630206323137`*^9}, 
   3.859063583893763*^9, {3.859063668220086*^9, 3.8590637252259607`*^9}, {
   3.859146134565392*^9, 3.8591462302519417`*^9}, {3.859146292370948*^9, 
   3.859146422039569*^9}, {3.859146453515401*^9, 3.859146638356056*^9}, {
   3.8591468008988733`*^9, 3.859146962891985*^9}, {3.8591470388176527`*^9, 
   3.859147041015374*^9}, {3.859149868237216*^9, 3.859149887371408*^9}, {
   3.8591499376717157`*^9, 3.85914994677925*^9}, {3.859150007250124*^9, 
   3.859150043412981*^9}, {3.859150333192638*^9, 3.859150500928686*^9}, {
   3.859150538818654*^9, 3.859150600811595*^9}, {3.859150773876356*^9, 
   3.85915082002969*^9}, {3.859299417258461*^9, 3.859299420129928*^9}, {
   3.859299460132152*^9, 3.859299493417594*^9}, {3.859299745651204*^9, 
   3.859299762029562*^9}, {3.8592998135462*^9, 3.859299816487876*^9}, {
   3.859299879114441*^9, 3.859299882574469*^9}, {3.859302484337563*^9, 
   3.8593024845354137`*^9}, {3.859302524181265*^9, 3.859302526748519*^9}, {
   3.859302603862207*^9, 3.859302604167056*^9}, {3.859302657321434*^9, 
   3.859302668026701*^9}, {3.859302743472533*^9, 3.8593027549241753`*^9}, {
   3.8593027973036203`*^9, 3.859302797859726*^9}, 3.8593029219887753`*^9, {
   3.859303663370689*^9, 3.8593036745566177`*^9}, 3.859311772861714*^9},
 CellLabel->
  "In[108]:=",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "0.16666666666667812`", ",", "0.2500000000000171`", ",", 
    "0.16666666666667818`", ",", "0.2500000000000172`", ",", 
    "0.16666666666667812`"}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.859149889301654*^9, 3.859149947397287*^9, {3.859150018217754*^9, 
   3.859150043857176*^9}, {3.859150366530738*^9, 3.859150401561755*^9}, 
   3.859150459899066*^9, 3.859150501443945*^9, 3.859150545923251*^9, 
   3.8591506013542128`*^9, {3.859150776479782*^9, 3.859150820717265*^9}, 
   3.859299301106595*^9, {3.8592994648651237`*^9, 3.859299515542083*^9}, 
   3.859299764458802*^9, 3.859299816927804*^9, 3.859299883723217*^9, 
   3.859302489859592*^9, 3.859302527216609*^9, 3.8593026051027517`*^9, {
   3.859302657977878*^9, 3.8593026683152514`*^9}, {3.8593027468683987`*^9, 
   3.859302757218521*^9}, 3.859302798229822*^9, 3.859302922366246*^9, {
   3.859303666211153*^9, 3.8593036752566338`*^9}, 3.859311452811137*^9, 
   3.859311773138033*^9},
 CellLabel->
  "Out[113]//TraditionalForm=",ExpressionUUID->"3d9f6c07-bf11-47b5-b0e3-\
97b7d21af71d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"p", " ", "q"}], "2"], ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"p", " ", "q"}], "2"], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"1", "-", "p"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", "p", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", "p", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859149889301654*^9, 3.859149947397287*^9, {3.859150018217754*^9, 
   3.859150043857176*^9}, {3.859150366530738*^9, 3.859150401561755*^9}, 
   3.859150459899066*^9, 3.859150501443945*^9, 3.859150545923251*^9, 
   3.8591506013542128`*^9, {3.859150776479782*^9, 3.859150820717265*^9}, 
   3.859299301106595*^9, {3.8592994648651237`*^9, 3.859299515542083*^9}, 
   3.859299764458802*^9, 3.859299816927804*^9, 3.859299883723217*^9, 
   3.859302489859592*^9, 3.859302527216609*^9, 3.8593026051027517`*^9, {
   3.859302657977878*^9, 3.8593026683152514`*^9}, {3.8593027468683987`*^9, 
   3.859302757218521*^9}, 3.859302798229822*^9, 3.859302922366246*^9, {
   3.859303666211153*^9, 3.8593036752566338`*^9}, 3.859311452811137*^9, 
   3.859311773139926*^9},
 CellLabel->
  "Out[119]=",ExpressionUUID->"8137719a-cee1-4931-a806-951560f72fe6"],

Cell[BoxData["2.258871399615303`"], "Output",
 CellChangeTimes->{
  3.859149889301654*^9, 3.859149947397287*^9, {3.859150018217754*^9, 
   3.859150043857176*^9}, {3.859150366530738*^9, 3.859150401561755*^9}, 
   3.859150459899066*^9, 3.859150501443945*^9, 3.859150545923251*^9, 
   3.8591506013542128`*^9, {3.859150776479782*^9, 3.859150820717265*^9}, 
   3.859299301106595*^9, {3.8592994648651237`*^9, 3.859299515542083*^9}, 
   3.859299764458802*^9, 3.859299816927804*^9, 3.859299883723217*^9, 
   3.859302489859592*^9, 3.859302527216609*^9, 3.8593026051027517`*^9, {
   3.859302657977878*^9, 3.8593026683152514`*^9}, {3.8593027468683987`*^9, 
   3.859302757218521*^9}, 3.859302798229822*^9, 3.859302922366246*^9, {
   3.859303666211153*^9, 3.8593036752566338`*^9}, 3.859311452811137*^9, 
   3.859311773141263*^9},
 CellLabel->
  "Out[120]=",ExpressionUUID->"9a596a6f-87b9-4c44-a667-59cde88c0c55"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Dm", " ", "//", "Total"}], " ", "//", "Total"}], " ", "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.859149191983626*^9, 3.85914922435529*^9}, {
  3.859149895707061*^9, 3.859149910109583*^9}, {3.859150022633635*^9, 
  3.859150059087223*^9}, {3.859150730520369*^9, 3.859150740551572*^9}, {
  3.85915082659723*^9, 3.8591508271009207`*^9}},
 CellLabel->
  "In[121]:=",ExpressionUUID->"c937557e-f8b8-40f3-884b-a5fcfe331f43"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.858876507134753*^9, {3.85888840543437*^9, 3.858888440534205*^9}, 
   3.859047406743555*^9, 3.859048652849247*^9, 3.859049148735968*^9, 
   3.859049248116078*^9, 3.85906211444274*^9, 3.8590622044856853`*^9, 
   3.859062380151688*^9, {3.8590624456389*^9, 3.859062458873726*^9}, {
   3.859062541486124*^9, 3.8590625648014812`*^9}, 3.859063021694263*^9, 
   3.859063585185767*^9, 3.85906372574368*^9, 3.8591461291647797`*^9, 
   3.85914621133526*^9, {3.859146339487504*^9, 3.859146423470648*^9}, {
   3.859146460197674*^9, 3.859146472223748*^9}, {3.8591465059722157`*^9, 
   3.859146579932311*^9}, {3.859146619777937*^9, 3.85914663878272*^9}, {
   3.859146844146096*^9, 3.8591468555081244`*^9}, 3.859146965791225*^9, 
   3.859147041750671*^9, {3.85914921118747*^9, 3.859149224986719*^9}, {
   3.859149892060565*^9, 3.859149910463511*^9}, 3.859149952748466*^9, {
   3.859150019426694*^9, 3.859150059719651*^9}, {3.859150370120756*^9, 
   3.859150402466724*^9}, 3.859150460945736*^9, 3.85915050239968*^9, 
   3.8591505473709517`*^9, 3.859150602490629*^9, {3.859150733056058*^9, 
   3.859150827668908*^9}, 3.85929946703472*^9, 3.859299515714713*^9, 
   3.859299767450616*^9, 3.859299818766021*^9, 3.859299886695942*^9, 
   3.859302528688389*^9, 3.859302607615635*^9, 3.8593026715102577`*^9, 
   3.859302758563552*^9, 3.8593027996309767`*^9, 3.859302923514495*^9, 
   3.8593114529146137`*^9, 3.859311775991357*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"838be900-72f5-4ee1-8e19-bfc85be5054e"]
}, Open  ]],

Cell[TextData[StyleBox["Compute the correct value of w:", "Text"]], "Text",
 CellChangeTimes->{{3.848912947646468*^9, 3.848912977322949*^9}, {
   3.857312685079691*^9, 3.857312689669485*^9}, 3.858008087557022*^9, {
   3.8588764305400467`*^9, 
   3.858876440555578*^9}},ExpressionUUID->"812d4f2f-d057-4141-99e9-\
0041d5ad4212"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"what", " ", "=", " ", 
   RowBox[{"LeastSquares", "[", 
    RowBox[{
     RowBox[{"Refine", "[", "Phi", "]"}], ",", "V"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"Phi", ".", "what"}], "-", "V"}], "]"}]}], "Input",
 CellChangeTimes->{{3.848912930225717*^9, 3.848912932374175*^9}, {
   3.848975619105205*^9, 3.84897563277147*^9}, 3.8489771939460287`*^9, {
   3.84898420159488*^9, 3.8489842062656384`*^9}, {3.8590491635168533`*^9, 
   3.859049212426612*^9}, 3.8590553530009317`*^9, {3.859062122072809*^9, 
   3.859062125237114*^9}, {3.859147086955426*^9, 3.8591471003511267`*^9}, {
   3.8593026290482388`*^9, 3.859302634499507*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"faa6cd96-61f9-4282-9bec-90ba810909ff"],

Cell[BoxData["0.04463102417470833`"], "Output",
 CellChangeTimes->{
  3.859049212946423*^9, 3.8590492510829*^9, 3.859062125621891*^9, 
   3.85906220874627*^9, 3.859062614594304*^9, 3.8590630254394083`*^9, 
   3.859063589720912*^9, 3.859063729460816*^9, 3.859146779510818*^9, {
   3.859146847201599*^9, 3.859146858850822*^9}, 3.859146973108673*^9, {
   3.859147092239908*^9, 3.8591471007320957`*^9}, 3.859150063968799*^9, 
   3.8591508302791443`*^9, 3.859299303464518*^9, 3.859299468555089*^9, 
   3.859299520477912*^9, 3.859299768792584*^9, 3.859299819981632*^9, 
   3.859299887833221*^9, 3.859302529908565*^9, {3.8593026088363943`*^9, 
   3.859302635284334*^9}, 3.859302672721348*^9, 3.859302759510386*^9, 
   3.859302800596272*^9, 3.859302925374805*^9, 3.859311452953525*^9, 
   3.859311777050634*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"a60855c3-9959-4f57-aac4-33af35a25ccd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the fixed point w_star:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.848570432944818*^9, 3.8485704485407467`*^9}, {
  3.848570915714424*^9, 
  3.848570984363884*^9}},ExpressionUUID->"0a5d41cb-08ef-4253-a74f-\
02384f62cb6a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sA", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "5", "]"}], " ", "-", " ", 
        RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "Phi"}], " ", "+", " ", 
     RowBox[{"eta", "*", 
      RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sb", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "R"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wstar", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "sA", "]"}], ".", "sb"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.848570984364477*^9, 3.848571676353101*^9, {3.848913024643092*^9, 
   3.84891305207668*^9}, {3.848913722679961*^9, 3.848913736469101*^9}, {
   3.857312703508958*^9, 3.8573127254150143`*^9}, {3.858881576657351*^9, 
   3.85888157809092*^9}, 3.858883395373931*^9, 3.858885471709312*^9, {
   3.859062619219288*^9, 3.859062624336109*^9}, 3.8590637363758297`*^9},
 CellLabel->
  "In[124]:=",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0.00001"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1.1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.851991153216415*^9, 3.851991186354488*^9}, {
   3.858190544665009*^9, 3.858190584057885*^9}, {3.859055921411811*^9, 
   3.859055926789782*^9}, {3.8590559717750053`*^9, 3.859055972759503*^9}, {
   3.8590560485311813`*^9, 3.8590560502588778`*^9}, {3.8590615960310373`*^9, 
   3.859061654179517*^9}, {3.859062634927911*^9, 3.859062724209175*^9}, {
   3.85906293367338*^9, 3.859062958929349*^9}, {3.859063053119652*^9, 
   3.859063108279401*^9}, {3.859063152872786*^9, 3.8590631541807737`*^9}, {
   3.859063917700698*^9, 3.859063918535165*^9}, {3.8591473446983547`*^9, 
   3.859147344752347*^9}, 3.859303092490806*^9},
 CellLabel->
  "In[127]:=",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyU/Xc8l//7/4/be5MV2VSoNFE6iZRSaaJBpG23JKXSVBpIZKRBMluUhoxk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    "], {{
      {RGBColor[0.1, 0.1, 0.1], Opacity[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxFnQfY1MTXxXc3u282m03sFZBiARREELChKCgqoCAqYkWxd1HEAnZsiAKK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            "]], Polygon3DBox[CompressedData["
1:eJwtnHn8FdMbx+du37n3zszNTtqFFmvWilRKG5VCinZEi7JElpBdUSrZW1RS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            "]], Polygon3DBox[CompressedData["
1:eJwt13u0l2MWB/DXqXPrd84puYWopMtJN8VpkS66kFQ4nXFpRkaYqTFd0BLJ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            "]]},
          Annotation[#, "Charting`Private`Tag$658949#1"]& ]],
        Lighting->{{"Ambient", 
           Hue[0., 0., 1.]}, {"Directional", 
           GrayLevel[0.6], 
           ImageScaled[{1, 1, 3}]}}]}, {}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1l2uwVmUVx/fZ7/vus9/z7v0e5eIHbEoJKqVRC7qohYxXHL9YcTC1zASE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           "]], Polygon3DBox[CompressedData["
1:eJwtl2uwlWUVx9+zN+c579ln78MdUslQwWm6OFZUk1GSpWFXb1T6oTEQETC1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           "]], Polygon3DBox[CompressedData["
1:eJwt0ktsjVEUBeDT9t629/bvLdFK2k5UE4NKPFJEJ3RCTGlJqCA1MOpjYlgi
IpEI6lE1MDUQQyEREoqJEFXRchMTRkJqQuPRVn0nx2DlP2udvdfe++y/rX9o
z2BlCKED8lCuDeEG4QfyHXbhZ7IQJmjrnV9CL34J3sTE6hCWxLXh5+A5rUvM
DBzDT9WE8M39LLzIhdBSDOECfVLcH9pvWIUvrw+hswrnN1YIYRm+ohTCNJ8R
HvUVIXyuS3Vivb8wxWMUv5il8yJtAerFrableeXgrbsrWarb7rxAW+B7Hh+H
Mq0bP6C3J+pezlJOlbhKKPH7Aq9o8+LeQaPe2sXVuS/CjLtreEVDCH18WmjN
cD1L88U5f8E+d3dKac4470HfPthtxgY1ap1rYJrfVXmV/E7Imc+nN4s9xz3E
fQyKG4D97sey1EOhOnlEr7u0ZjWmrGlN7NFse8V2OW+FD3F/3rpH3DA+VJ18
477X6bFJ7Ep44O2XfJto72vTPzJDq1Njo/NOeTvgGW0bfkTsUbwfntp5I94P
h/FD/+feXEjvGt/3pLtFea38J2DcXS+9Bx7quQxni6nWbTUe4x1wr5B8ot9a
/Cu/uXz6d+M/PGCOFn5z8jbALbmPxE3S7xt9u9xueI13ltJuRuCn/IzXTXqO
93G7GaVvETNLb9XX6WLa86bYM+9h9T7J+wi99H+4qm65
           "]], 
          Polygon3DBox[{{3612, 2303, 2647, 1542, 1541, 3106}, {3349, 820, 
           1621, 2677, 2455, 3348}}]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt1FuUTmUcx/HHaVKhLrKWXNTiXstaITFDSDIzqClyrBySKOcMcj6+RoaR
UylSjA4yDiN0VFSGYTCKZobhxmJZC/cu8vm3XHzf3/f/389+nmfv/e7dZtSk
gokNUkpT/dxomFJ4qWxFSh5K6VF1t0YpreVP8ml8PX+Kz+Y58nqzlObxfH6T
L+LD+MjmKWUap3TY+PHqYn6Kz+Lr+Hme4Vt4Ld/Ipzhnp7qUF/IyfiDW4uX8
GL/zcEpn7C9fXa2usF6VOk/9X5Z59ZbKTBPXhW+wEF/hayzHIdSZc5nMwQC8
jj/wF/7EqxiKt+2tytjv+FnsQjcsxjqsxyKsNm6YPIdq5OEn7MYYx36W+ega
+1KXyQvohz2YpndE/obDOI/+KNSfI3/HUfyAv5GNIseOy+7YgG+xETPwMaY7
vlduwnNxnuuokBcxPNZQF8qOLVIaZ+wI/gl64BjGYmDcM8fekXPxJeZhHJbg
BJY5PkiWYifmoxwvYQJOxp6M+VdWYiIW4Hu8jPewFJPxUdxD+8qVZ2RJ3Hd5
UK7FJJxGTaxvzlOyb9x/HMAavIspjhXLHViFF7ES+/EhxsdcxhTJ7ViBPtiG
ffgi/jeOfxD/AXyOF7A19q7/lpwdzxZb0DuuQ/8zORqzMAqf4vnYk2Ob5UjM
xJuxB71ecgjewGC8jzn602U9LuNKzKf3mqxDbfxfcAmv4J+4V/gxnplxv8pf
UIUC9Iwx3otOD3rW3pcR3pUL6lbGVvCLPD3g+YhnjOlkTAN1TdS8Ia/lnXkj
Xsef5Y35peg7p4v6Mu/J+/D6GMO78jHWuKLOb2oe72pbvavqa741Neo26se8
1+f06vUq9VrrZekd1durvmuv5fyW3CGvyg2yRi6X1XKmrJQn4//KD8qhcpfM
k9tkttws28V3SD4R3wvrdLDGHWs/ot4jn1bfliW+JV6PVMbb661RN49vlWta
zZvFt85ei7lpUhfXnKM2dbrLJxgn0gA/g/XdgpTLB/KVWf/f9lTAi3hWjOMr
iEeWsnmGmyL1ck5u3H+ecdLj9mJLqc6E20nL+9/we4h+yB8=
        "]], 
       Line3DBox[CompressedData["
1:eJwl09VTFlEYwOEXEFQU7A7E7u7C7kTsxhYFCwME29Exxj/MKzuuDOzu1ueM
F8/8dt9zZme/3f0KSyuKyzMi4ioFWRE3tS4z4oZhSW7Eg+yIhzziMXVUmT/R
pzzjOS94ySte84Zq+97qO97zgTKzj/qJz3zhKzXm3/Q7P/hJrdkv/c0f/hI5
ERkcs5apWdQjmxz2mNfXBjQkl0bsMG+seeTThKY0ozknrbfQlrSiNW1oSzva
c8qeDtqRTnSmgC4ctlaoXelGd3pwKy+ip97WXnpHe2sf+tKP/gxgIIMYzBDO
uOZQHcZwRjCSUYxmDOX2jNVxjGcCEyliElusT9YpTGUa05nBOWt33c9Mx/d0
ls5mDvedz9V5zOe8vQt0IYtYTDFLKKHS+lJdxnJWsJJVXLC2WtewlnWs56L5
Bt1IKZu4ZLY53Tdbuex8m25P75CdlLEr7be2Oz0DKtK7Zy/72M+B9LzyI67Y
V+n4IIfSu+IIVVRzlBqu+8216dviOCfSd5HeO6c5m67vG7yW8f+/8g/ywl05

        "]]}, 
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwVzzczRGEAheFPK3VWXHZnxBmMzlYyjVD4AQo9ZqS1wkijVGjxA+j9AqGg
k+OqtXKoPLd455zzfvfe/TY5OjE8nhNCGMNWbgj9+SEMIJ0XQpvMFoRwWBjC
rH1uX+ICc3a73EaRXi0nMY0pzHNH3uvQG30jZmcwaA+h1dmr3akXyxo5g1M+
hjeuyy6RtdEz3Fl0D/2d65alsk4e8OnoTvjgeuSz3zzm6/VMdB98OruSe3yZ
voRr+wZfepzfR5N3y+1l3EZ3sO/kt33ivFdv5irsBn0BI/aiTDlf5fv0HcT1
FTxE9/XMi/MEfrhdroWr1NeQ5O/xyP/aT7JKrmOTz0b/C392Ahv4B3rHO8U=

        "]], 
       Line3DBox[{2706, 2907, 3114, 600, 2276, 690, 635, 2952, 3727, 2849, 
        2951, 2908, 3256, 3826, 1101, 3255, 3580, 3641, 2850, 2953, 3581, 
        3642, 2851, 2954, 3728, 2939, 2852, 2955, 3729, 2940, 3067, 3551, 
        3723, 2956, 2942, 3068, 3552, 3724, 2958, 877, 3069, 3802, 879, 2960, 
        880, 3070, 3754, 2853, 3289, 3575, 3643, 3071, 882, 1149, 1148, 3644, 
        3377, 2854, 3375, 3821, 2948, 2855, 2707, 3726, 2950, 2856, 2708}], 
       Line3DBox[{2709, 3295, 2963, 3115, 3296, 3299, 3297, 3827, 2964, 3298, 
        3300, 2909, 3258, 3411, 3716, 3412, 3257, 2965, 3645, 2857, 3072, 
        3583, 3646, 3378, 2858, 3073, 3755, 2966, 3302, 2859, 3074, 3756, 
        2967, 3075, 2860, 2968, 3733, 2957, 3076, 3553, 3730, 2969, 2959, 
        3077, 3554, 3731, 2710, 2961, 3555, 3732, 2711, 2962, 3647, 2861, 
        2712, 3582, 3648, 3379, 3462, 3463, 3078, 3464, 3833, 2970, 3380, 
        2862, 2713, 3649, 2863, 2714, 3650, 2864, 2715}], 
       Line3DBox[{890, 337, 2141, 498, 338, 2142, 499, 339, 2143, 500, 2144, 
        340, 1267, 501, 1155, 2565, 341, 342, 1995, 332, 343, 1996, 334, 3734,
         2716, 335, 3735, 2717, 3556, 3689, 2718, 1321, 2620, 1322, 2621, 344,
         1268, 502, 2145, 345, 2719, 3651, 2865, 2720, 3652, 2866, 2721}], 
       Line3DBox[{2732, 2868, 3655, 2731, 2867, 3654, 2730, 2983, 3389, 2982, 
        3737, 3390, 3392, 3391, 3478, 2981, 3388, 3838, 3585, 3504, 2729, 
        3632, 3693, 3503, 2728, 3692, 3559, 2727, 3691, 3558, 2726, 3690, 
        3557, 3653, 2725, 2980, 3301, 2979, 3736, 2724, 3305, 2978, 3303, 
        2977, 3828, 3424, 3386, 3387, 3385, 2976, 3381, 3822, 3584, 3382, 
        3384, 3383, 3477, 2002, 3496, 2975, 3495, 2723, 3757, 2974, 3117, 
        2973, 2722, 2282, 2972, 3116, 2971, 3423, 3304}], 
       Line3DBox[{2743, 2869, 3657, 2742, 3499, 3498, 3836, 2741, 2989, 3121, 
        3791, 759, 1052, 1051, 3394, 3839, 1329, 2740, 3633, 3699, 3505, 2739,
         3698, 3562, 2738, 3697, 3561, 2737, 3696, 3560, 3656, 2736, 2988, 
        2987, 3738, 2735, 902, 3306, 3824, 1048, 1049, 1047, 3393, 3823, 1045,
         1046, 758, 3695, 3120, 2986, 2734, 3586, 3694, 3119, 2984, 2733, 
        3758, 694, 3118, 1158, 3307}], 
       Line3DBox[{2745, 3428, 3429, 2992, 3310, 3739, 2870, 3079, 2991, 3125, 
        3143, 3766, 2871, 3080, 2993, 3126, 3602, 3767, 2872, 3465, 3354, 
        2472, 3260, 3355, 3415, 2873, 3414, 3356, 3817, 3623, 3315, 3484, 
        2874, 3081, 3589, 3658, 2875, 2751, 3660, 3661, 2876, 2753, 3662, 
        2877, 2755, 3663, 2878, 2757, 3507, 3664, 2879, 3508, 3590, 3665, 
        3401, 3466, 2880, 3467, 3357, 3818, 3624, 3127, 3418, 2881, 3417, 
        3628, 3666, 3497, 2882, 2762, 3668, 2884, 2764}], 
       Line3DBox[{2763, 2883, 3667, 2761, 3416, 3500, 3501, 3837, 3631, 2760, 
        3482, 3483, 3124, 3608, 3765, 3199, 2759, 3399, 3400, 3398, 3840, 
        3510, 3509, 2758, 3634, 3705, 3506, 2756, 3704, 3565, 2754, 3703, 
        3564, 2752, 3702, 3563, 3659, 2750, 2994, 3701, 3588, 2749, 3313, 
        3314, 3309, 3626, 3804, 3397, 2748, 3395, 3413, 3396, 3259, 3805, 
        3312, 3311, 2747, 3229, 2315, 3123, 3198, 3197, 2746, 3587, 3700, 
        3122, 2990, 2744, 3618, 3803, 3308, 2985, 3427, 3426, 3425}], 
       Line3DBox[{2765, 3430, 3431, 2996, 3316, 3566, 3806, 3082, 2995, 3128, 
        3262, 3768, 2885, 3261, 2997, 3129, 3782, 3144, 2886, 3468, 3358, 
        3359, 3669, 3263, 3360, 3419, 2887, 3471, 3469, 3470, 3670, 3402, 
        2888, 3083, 3591, 3671, 2889, 2766, 3672, 3567, 3706, 2767, 1848, 
        2768, 3673, 2890, 2769, 3511, 3674, 2891, 3512, 3592, 3675, 3403, 
        3472, 2892, 3473, 3200, 3787, 3609, 2998, 3433, 2893, 3432, 3629, 
        3676, 3502, 2894, 2770, 3677, 2895, 2771}], 
       Line3DBox[{2772, 3434, 3485, 2910, 3435, 3317, 3318, 3807, 3084, 2999, 
        3130, 3265, 3740, 3266, 3264, 3000, 3001, 3819, 3361, 3362, 3085, 
        3363, 3593, 3678, 3267, 3364, 3365, 3086, 3474, 3594, 3679, 3404, 
        2896, 3087, 3759, 3002, 2897, 2773, 3680, 3568, 3707, 2774, 3569, 
        3708, 2775, 3570, 3709, 2776, 3513, 3681, 2898, 3514, 3595, 3682, 
        3436, 3437, 3479, 3438, 3003, 3151, 3576, 3683, 3004, 3489, 3490, 
        3487, 3835, 3486, 2899, 2777, 3684, 2900, 2778}], 
       Line3DBox[{2779, 3439, 3488, 2911, 3440, 3319, 3717, 3619, 3088, 3005, 
        3131, 3269, 3741, 3270, 3268, 2912, 3006, 3625, 3718, 3366, 3089, 
        3367, 3596, 3685, 3271, 3420, 3421, 3090, 3760, 3008, 2901, 3091, 
        3761, 3009, 2902, 3133, 3769, 3010, 3092, 3571, 3742, 2780, 3013, 
        3094, 3572, 3744, 2781, 3016, 3096, 3573, 3745, 2782, 3574, 3710, 
        2783, 3597, 3686, 2903, 3019, 3320, 3809, 2913, 3444, 3145, 3146, 
        3098, 3762, 3020, 3405, 2904, 2784, 3687, 2905, 2785}], 
       Line3DBox[{2798, 2906, 3688, 2797, 3036, 3406, 3035, 3494, 3747, 3627, 
        3407, 3152, 3493, 2922, 3446, 2921, 3720, 3445, 2796, 3033, 3711, 
        3599, 2795, 3825, 3031, 3030, 2794, 3773, 3018, 3097, 3017, 2793, 
        3772, 3015, 3095, 3014, 2792, 3771, 3012, 3093, 3011, 3743, 2791, 
        3233, 3232, 3793, 2790, 3231, 3230, 3792, 2789, 2920, 3272, 3798, 
        3577, 2788, 3770, 2919, 3007, 2918, 2787, 3719, 2917, 3132, 2916, 
        2786, 3620, 3808, 2915, 3443, 2914, 3491, 3442, 3441}], 
       Line3DBox[CompressedData["
1:eJwV0DdOQ1EQRuFBUBEsqAmWO7YDNRUt+JkkgRtyAyuA1ljAKqBGIgeBKM0C
MMGEZxG+Wxz9M2dmrp5eabIynnVExATa3RELPRHz2C5E5Po59VlvxKzc4ooY
64voRBca/In5PT+Abzeb+ke+KJ+4fqzYDXyZ7/F/KPBrGFE/2F82/1V/2qnJ
H1yb35kNq2/lqJ0P82N+g7vhhtKeXJcts6P0rvqKG5SXMpcN/t38UH2QbvVv
+n31jnfz9C3YVb/yp/yM2wvU+Db/wudyVX/OV9DkWvos/SuU8czV0//wxrS+
6mZK1uUSFvEPQSBAZg==
        "]], 
       Line3DBox[{2822, 3165, 3244, 3166, 3045, 3252, 3251, 3797, 2821, 3163, 
        3410, 3164, 3044, 3335, 3458, 3830, 3621, 2820, 3161, 3243, 3162, 
        3043, 3813, 3334, 3457, 3333, 2819, 3159, 3242, 3160, 3041, 3812, 
        3330, 3456, 3329, 2818, 3209, 3241, 3210, 3715, 3637}], 
       Line3DBox[{2836, 3184, 3254, 3185, 3055, 3183, 2266, 3538}], 
       Line3DBox[{3056, 3336, 3337, 3046, 3338, 3814, 3622, 2823, 3167, 3168, 
        3047, 3170, 3784, 3169, 3548}], 
       Line3DBox[{3450, 3451, 3452, 3037, 3324, 3323, 3749, 2812, 2933, 3038, 
        3340, 3815, 3339, 2813, 3153, 3453, 3154, 3039, 3714, 3535}], 
       Line3DBox[{3536, 3182, 3537}], 
       Line3DBox[{3540, 3351, 3369, 3350, 3541}]}, 
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwVzj1LAmAUhuETZFlD9QuEFodQIhqipdFJlyCCBAnJpcS+iAaXRqmhqZa2
IAgCoaVmQdKlFsUtai9qTJq6Gm6ec+7n8PLOlndXayMRkUdjLCI3EbExHvEr
i3JpKqKdjCjg1D7Hn8ll/sL9g3ld9yhXuJY+MxmRRYfb1HXlE9/Bl5uefYvv
y5S7Z/4F37o3blv3Lm/+30INr7oPbk/3KW+5LA7xYz/ih3LN3R03j2OM8nUk
UNI1uQXUMc2dYAYV3T23iIF5x1uXfFWm5TW3b74yH8hz//4DSWUrzQ==
        "]], 
       Line3DBox[CompressedData["
1:eJwVzz0vQ3EUgPFjcG9rQI06IJR+Bj6ATcLQdJNIGQy6mSwdxUs3H0CTJmIx
stpqQaQ32jAwMRCDRaf+DE+e/3nOuUk7t1Xf2BuJiHUcJhGr+YjjNOIoF3HC
r9wZj1jjU3MbTSxrZ+6vvat2l+Yb75rvb9HxHh2LuOMSn2vb/x1d7dd9omfe
i9zSd3CPH7s3PdXfeYnb+i5e7B75S8/p31zmC+3Trs5P+NP3/a4BV/QZN109
Q6IfIMWm3azds95DQWvgSp/iD/9xQn8w93kS8+4XMNCmzSsooqYNAUs0L48=

        "]], 
       Line3DBox[{1674, 2376, 2377, 2188, 2271, 2270, 3786, 2127, 1936, 1959, 
        3728, 1937, 1687, 1978, 2137, 3756, 1979, 2138, 1981, 1995, 2564, 
        2563, 2403, 2007, 3736, 2149, 2008, 1716, 2019, 3738, 2155, 2020, 
        1727, 3701, 2031, 2161, 2032, 3658, 1737, 2043, 2167, 2044, 3671, 
        1747, 2056, 2173, 3759, 2057, 1757, 2067, 2178, 3761, 2068, 1769, 
        2321, 3793, 2322, 1779, 2332, 3795, 2674}], 
       Line3DBox[{1675, 2379, 2380, 2189, 2273, 3764, 2272, 2128, 1938, 1960, 
        3729, 1940, 2132, 1962, 1980, 3733, 1964, 2139, 1983, 1996, 1985, 
        1706, 1824, 3653, 1717, 1832, 3656, 1728, 1839, 3659, 3660, 1738, 
        1846, 3672, 1748, 1853, 3680, 1758, 2069, 2196, 3769, 2071, 2179, 
        2072, 3743, 2323, 2074, 2181, 2432, 3810, 2433, 2333, 2434, 2675}], 
       Line3DBox[CompressedData["
1:eJwV0L0rRXEAxvHH4uUS5R/gri6LSYlQFIXuDZHJGYzsDDYvi6z4L/gTbIok
JbcsLkZFVi+fOzx9n5ff73TOKRfbta2WJIt03JqsdCSnbclJe3KGDRzpTl7w
XF61r9EGv4QFjtqX7Rf8JU3IV7bxUnIjj+EtXuum+F/7kzzJ1/FOP8P/6d/k
af4d7/VzfHqST3mW/8Kqcw+2BflHnm8+E9f1j/qaXPI+VezEQt/F9/H9tCl/
+NY9HJCf3alg2Zl9PJQbtkG+VzeE3zRMR7ZX207zX9h28QD/AT/wLJ0=
        "]], 
       Line3DBox[CompressedData["
1:eJwVzzEvg2EUhuHTRSkte2No4h9oTP4Ei6WpKMVAJSZDZ2lCIpgMOjWR2AxW
BhWkEjYDSwfRSDCwWNT1DU/u59znffN+X6GyMVtLRURJ9gYi/oYiyumIPs7j
HPZyETODEWn9mDuTpkzzqUzEBX8pV1zJuV++reft2vy1PJgX7B5xnO9w9/Js
PnJ+2e5Fb3H7eia5w79xa+YennAH+jn/gd/cJv7gqd07f2j+lD63hSHD3vvC
TvK9eCNL9iNYxUX+Vs/KXULnV/iC3rVb1XNc3RsT3Kg+Jut8w77L1/QiPpkn
nWlKUXa4KdzFV7t68r/6tvv/tFs28w==
        "]], Line3DBox[CompressedData["
1:eJwNzr1KgnEYxuGnpdKhxbWlpCEbKsyPogQRnJzesXTxAHLrCIIoMJzToYjm
wLbwCPIIWrNwycaWEryGH/fHe/8f3o12JzlfiogGessRzVREC4OViDN6ive1
iGQ14l43kmfyAz+wz9Cq/MSv8zX+md/i6/wrn09H/PMHtIA5X6QlzNz7RqLb
lfewjzRSaOrL9BBHyOFPt00nbm/6r0sMdVn64dYEX/jEo/5Kv2P/Iv9giGOc
YIoKru0KdmPcyG80482vvivfoqrr0ztc+LYAfEcpmA==
        "]], 
       Line3DBox[{1681, 2245, 2246, 1951, 2399, 3725, 2398, 2131, 1954, 3726, 
        1955, 1693, 1812, 3650, 1702, 1821, 3652, 1712, 1830, 3655, 1723, 
        1837, 3657, 1733, 1844, 3667, 3668, 1743, 1851, 3677, 1753, 1858, 
        3684, 1764, 1864, 3687, 1775, 1870, 3688, 1782, 1907, 3722, 2536, 
        1908, 2103, 2342, 3797, 2537, 2343, 2115, 2260, 2259, 2116, 2266, 
        2267, 2123, 2465, 2551, 2464, 2124}], Line3DBox[CompressedData["
1:eJwVzz8oxHEcxvEPdecoNpuUQUy3KYNNBpOibJZbjjj/CYWB60Z/VmU63YSU
kdIpsxlh4PwdlMFg4HXDu+f5PO/v/eraMlODkzURkcVfMmK4LqKzPqIvFbEj
t1FpivjlhrgtdzeXlwf2TfnDDXAbeppbl0VuTX5x/dyq3s492lf0ZTxzvdyS
nq++5xf1BdxwPdyDfb76npuVM7jmurh7bto9x+XkBK64PXuaH3fnuDE5ilv7
Gd/BZd1Z7hNH9g95wrVyx3oG73hDyd5sb2nw1j2CV1z4xovc5xv5Wv7btzL2
U3eFS1X/p9z1JmV70g9R1JPcORIo8Alb2e9LfEG/lGXc4R/PNTzA
        "]], 
       Line3DBox[{1792, 1922, 2684}], 
       Line3DBox[{1793, 1879, 2545, 2209, 2652, 2668}], 
       Line3DBox[{1794, 1880, 2546, 2210, 2653, 2669}], 
       Line3DBox[{1795, 2548, 2547, 2211, 2688}], 
       Line3DBox[{1796, 2550, 2549, 2212, 2111, 2689}], 
       Line3DBox[{1928, 1881, 2186, 592, 3226, 746, 634, 1957, 1801, 3727, 
        1683, 1891, 2347, 3716, 1102, 1695, 1989, 2142, 1814, 1704, 2001, 
        3757, 2147, 1823, 1714, 3694, 2013, 2152, 604, 1725, 3700, 2025, 2158,
         606, 3766, 1735, 2037, 2350, 810, 3768, 1745, 2050, 2352, 3740, 813, 
        1755, 2062, 2354, 3741, 816, 1766, 1897, 3719, 1866, 1777, 1903, 3829,
         2577, 1872, 1784, 3815, 945, 946, 610, 2643, 3784, 659, 1449}], 
       Line3DBox[{2358, 2657, 2662}], Line3DBox[{2359, 2109, 2121, 2666}], 
       Line3DBox[{2360, 2369, 1924, 2213, 1923, 2671}], 
       Line3DBox[{2361, 2462, 2463, 2122, 2461, 2460, 2692}], 
       Line3DBox[{2362, 2552, 1885, 2191, 2219, 3781, 2220, 2491, 2389, 1944, 
        2387, 1804, 3754, 1691, 1968, 1810, 3647, 1700, 2619, 2620, 1819, 
        1710, 3693, 2623, 2624, 1828, 1721, 3699, 2627, 2628, 1836, 1732, 
        3705, 2631, 2632, 1843, 3664, 1742, 2635, 2636, 1850, 3674, 1752, 
        2639, 2640, 1857, 3681, 1762, 3710, 1863, 1773, 2088, 3825, 2524, 
        2526, 2527, 2528, 2327, 3713, 2089, 2439, 2337, 2338, 2339, 2294, 
        3715, 2664}], Line3DBox[{2370, 2553, 1926, 2214, 1925, 2305, 2673}], 
       Line3DBox[CompressedData["
1:eJwVz69PQnEUhvHj3EQUbkWjNIv/gQlJFmeg4gw6DVyDyaIzuNm1kIiw6cQf
iBoobIxMdkTcpBHMfgjv3nOe53x3dzcO0/3aQkTsSSkbsSO3mYiybi5H9JOI
lv60f8gBt6l/ZcZN9d1SRAevuEv0Nt7ABuYqVtAt+9Dt1krEyF7Ube5ZXrks
l3o35k6wlzmXHrc6/x6e2t+kI123Qy7H/XHn2LsM8K4ecXlu0XwhD+Yp96i/
uUQfeXfJ3eBP9rb8cKf4F3bP7Zpn2JX9zFzH1tyty0Sq/uOaO9b/3VkwSQ==

        "]], 
       Line3DBox[{2378, 2381, 2382, 2190, 2218, 3780, 1798, 1676, 1939, 1961, 
        3723, 1802, 1688, 1963, 1982, 3730, 1807, 1697, 1984, 3734, 1816, 
        1707, 3690, 1825, 1718, 3696, 1833, 1729, 3702, 1840, 3661, 1739, 
        3706, 1847, 1749, 3707, 1854, 1759, 2070, 3742, 1860, 1770, 2073, 
        3771, 2199, 1868, 1780, 2288, 3774, 2289, 2204, 2543, 2679}], 
       Line3DBox[{2383, 2384, 2385, 1941, 2386, 1799, 3752, 1677, 1942, 1965, 
        3724, 1803, 1689, 1966, 3731, 1808, 1698, 1986, 3735, 1817, 1708, 
        3691, 1826, 1719, 3697, 1834, 1730, 3703, 1841, 3662, 1740, 1848, 
        1750, 3708, 1855, 1760, 2075, 3744, 1861, 1771, 2076, 3772, 2200, 
        1869, 1781, 2290, 3775, 2291, 2205, 2544, 1874, 1786, 2698}], 
       Line3DBox[{2555, 2556, 1884, 2557, 2306, 2307, 3753, 2490, 2308, 1943, 
        2560, 2400, 3802, 2401, 1690, 1967, 3732, 1809, 1699, 3689, 1818, 
        1709, 3692, 1827, 1720, 3698, 1835, 1731, 3704, 1842, 3663, 1741, 
        1849, 3673, 1751, 3709, 1856, 1761, 2077, 3745, 1862, 1772, 2078, 
        3773, 2201, 2324, 2325, 2523, 2326, 2087, 3794, 2438, 2334, 2335, 
        2336, 2676}], Line3DBox[{2584, 2585, 2610, 2681}]}, {}, {}}},
    VertexNormals->CompressedData["
1:eJzsunc01uH/Py6rRSmlIdJQSKLSxNOOSkVpkB0RIiOFyghZmSEre2bv+bT3
3ntv7vsVSgP53e//f/3xOef9Pd/f55yff5zzONe57tfrcV/Px7jOfUTTSEGb
moqKinYnFRUN5b+01uVjCT8IeCapmUP1NUxEsCGM+JMVD92fud6Grb+BUh6J
11pLBHT0Cbu/lEiCwiCfWs1LN4FRvTqteI2AyyUHqqt6g4El4sOrDiMuuFTM
P+Dxl4AzTZrfnp7xgdm1bbSiOisi6s86nvNvEKA0uMR0vcUNjF4yTAi+osPk
2Z4rlhScB0vWgo44QbGFq8O+Umacfmq9J4KCrw+eTkjXsIfXZwXeT51hxb0k
mbk8Cr7Rbds4W2QD/jvqJjamj2BcnCVXLQV3PPnj8kDIG/huaZAZfoEL27Y9
kW2n4L15yVvsCi3B6M+7fWzeAnilceumPgrueytpe0H4K8jj6qVbIwvh8tGL
5EEKzq24g5/mmgWI/rx2dEDgFsocCVz/D/5IrUx5E50FHBJyeXHmrAEeID1R
rKHgUz6C/k1ylrDCyV16VIdAnUgJCbXlKsxaFD2xciEdxD6pHPJdJSBwNvmy
M7WfyMRo6Iv61jA4fer8lT0+M5BjbHaz/tkEuObGiKWUf4Udr3S67zwYhrN3
3sk8iJwHhnLMXXcuBvvvAfKq+R3IUzNkEHyVjJGnv13fFRwPzDT1jz+31eHG
TWlbCSDQUMVN2ZoxAWqvePf+ZCzCQrJqmGoxgT/YVFrTnn6FnzOnj330ckc2
nSb9eDKBl05yRl6+mgrF3/WG+B8WwEwQ6VRGHoGbu5Q4hW5kQD+/UKWAcSt8
dNe7XR1NRr74rOWGzzkwpH1y6eHPYbDtZm7qtp7H2ZY4hOZC+B1wUXXH4Rn4
a9vL//bLBNLZR0436ZfAk+8cYqOWJOzmKjh67VI3vHm3+dDT5VIQFMzexOhB
oKW/wtU9QwhfxmgKV2cLQHD2ZGLJAIF692yrGyPswTAApm8G5ECY47evHVME
BoTcVtBv3Qc7+A3fPWLMhCcrD2Q81glw6DRoFFbyFNmjsceL+W8ANPc4CO/O
IEFN6rSS0btucKihZtcIToGpN6wXL1PPYPfMPX77HZOYTnoo5PskFRg67Juq
l0ZQlEfeOodmHh9r83w1YM8C0+r2mnSbNoyof/3wtBkZDTyVVI1s8yEwOJfX
YdUbozLiS1ILCGTzeyU5q1ACpenab9L12+DR0+yZcxJkpDU0/n3iXjnw5p7M
kJ4dA1nil8Wk5Cxum82XjTlYCU4CYsy9zHMwHeyTdLlpFE1ZpgQ0SitgU0bE
/cJOEhz9ZPLjMEcnpo77qqlOlMHZe1aP4uUImH78+NbNxAqUf6NyXTylBFbj
ydzJzRUwlv5MUSrTG8aNnnYGexGgWVk5SnQSuHPoVO2iySXUyBfo+DqTB7cD
WP4aDhLI2m9omLroiSohINTNmgOKPj0ykxME5oi6vLuXzgJiBjtnc5oyYYul
fpoZZc6nev0bmjY5iywffNwWMeoD/ua1Jkb0BF44d36cbaIJ40Ocs+peRgNV
9SshhY/zaBQaSTfDOoJhppKfg/jToSVjuP6j1gTqX/7RTPNkBu1BLviJVBGc
iD5hrM/Ugmu/GHR135NxOsZz7olQJdy+N53uwdgCDPhh8PhNMu4Iw9iu5log
km23PB2bgLDtOqCtOY28t17pLobUQl8qf1Xxh3kImWWvVfo4hLoOgsce1VZB
SbKxovEtMkjnnVgt3tSGyZyrARY15fCDYy9LrBIBSGW4eaWrDDdGNj4Z3imF
V5Uya7pZBPgVmN1YnknG6x3532abiiHE9fNsWBoZ5qiPkY44vcB0pfUPYfvb
QDRl8e+PLgJ9ZxvVbMw98MinIJMp2Tw42VGxaYNynkl7T2gc6/PCw04F9w5c
zIG717w1D40TeIvPpL82gwnsI2lOUVllgXdtsStB4bnh+J/0pvD3IsZsNVwm
tp5Q2j18keUdgVykjkSPg1WY9Kgwhk4gEjS2N5FbuUh45lYBo/x8L3LtP8rl
dzkDTJ/n10+OTOKUR+GK58wUxkt49RzmKIP99kIeu58Vo2evCYvzLzL+cDw4
cluzAZ76eDaERI7An6X4VVWFOUyKueaxybIROnh47fWvzAFjutyHC6KjKDy0
p+dbSw3Y+9Y/jiogQZiQfWyZSCdu+pi5v7q9Avg5zK5GMRFQmKKxe89gDfax
D/gMbSmDJF+uCG5fAu5vMK3Scecjr+ibpEfbS8CsnUHoYzkBRtr6R7Nko3HK
Pi4ui6sIyqrPu1OxEaA7nnrsjasKtnUb8JxaaIRJl2wn4R7KeZ7k1slWdUHi
s0CS9+9cKNS4tXmRwrMJ6YjOtww3zPyqE/hJMwd2JxYUuo4S+DE6sHHSaxMk
vHGrymHMhjk26+lLFB3/oq5MXfPSTuTnp+UtFy+5gfe2Tx06WQQePEAYdkWW
YGvs3N0938PhKt728lgkoY3oxclfW7qw8LDXfme/DGgRaRW5yDOFrx57/Ymw
mUJtsbBDpA8VkNSVeHbQIQ5kqSO53v8kI29U48n4r83AExk8qHxhEjqdu3YK
kqawmvPoIZ+OemAwlPMqG56HPK+R7du1BzFxMMgv+loVmISGXXp1hQwVnF/N
aKvbcOzzyDXLxjKgVjxa0MNPgM6Xh/r3b1ejgIKuUahPCYh7PV9mCqScW4Gw
bv2yfNxxXlfw6J5i+BBb19JQQfG5oMO3xZbjUX2LxnpyTwEcMxE5fMiUgN+N
7cnkX654N94p5oN3NQxHlltX9xLIXO6RdGrYAB13xevtTMmF/W09u7gourEb
tvfxa9piR+wqm7Z1DnxTom69OUKguWLPY+razuLzp8YHW95lg4nGVT5dCs9q
7EH3GfTfisjZqMe+jfoAhzZlSNm1Evg4P2Hm9Xge9sf75V+aCwOfZ2sVLYpk
nC/O7lNoaEevlrcadMIZwPo+OYY2dRKvml+6QLswhVFsdlT7xCrhZWr9Qn5p
JRTu7Z8oDCWjy6E6NvGTTZCpd7NiX+AUpDV5pFO1TuKVSZpgOe0aENYVF2Gi
WQChNDk/tfuDlPn4VskZXw5my/NpNQfIsPKWWfwEVQe2FQfa3F0sAfMjXy59
3UHAtpwxz7XGOpSlnrqcYFMMS+lzienvCXATZ/55i6EURzn7mQ+cLwR7j5uf
3xZQ5ne74q7kmAyk9nFwn/6YD10tKcwv0ym5KoP+yznVCBQ9XVlo+qME7gu/
qXLuI1CWquWGJ6sTSBlZjdnK5MI594e1nyg8g1DKg37JG/gpMCIu1jgHeopa
le2GCfxmf9HtWiIjSn/rgj3V2bAnW0L/A4XnpIseT2k3LEU2X6uxbBhyAGdG
nxpzyvkX4HaUOxCcifKuWaT3RV/g7fdpqXu2ZIx9tV9Err4NvZzogzrY0mE6
iYVXrGYCX8oqvD3ZNo3t5MQaucFy8FQ3e9y+VAfn+yPZ+8PIeKJ+7dGyeS2E
7152a1mYhBE6syr5oiksv0LHSW1ZAV/Lt06HcM7D9wuf6gN1RjD1uLe65kYJ
aBtWqxoYk+B1bHWOObkbbZReD3ccKIYHpbsPi4SR4RiHvLOOYCvOMRaxhhQU
QKnompW3FAFSX716muqqceQpG/M9nnzg0eM5th5MQLoXp2pYSTGeWbWmmWLO
g/dbPAfaiinrq6hfxZam4Rne5Iu3J/Mh/tn1XhOKbvBsXfypPB4G5+6ukugS
cuCeSVTUKoXnHdTPaO9dfg81275rr/LkwC3FbLnHFJ6/Jz3xC+7jwHG9QyfU
OrIhuTxO4wuFZ3F6rYWiLa9FWFrnMsPj7OHxNfl1tnkC3Z4YcNDkpuIPKyrp
1y9CIDBXqLuV4mcVZWceu7e0IbKEMvifT4X07h3nx3AcVZvHYiS7ZlBv7cs3
wqkEqJhQYOllFYy01R48eISiW5/cD7M9Lgd88W1Vz3wcFvV5Pd7tmcVwf+fG
FN4SYBwe9BbaOws2tzja6D3GUTGc6a32zkKYfPH4YvHSPExoyZjlvRvCXUJi
x1iK8iD8rIWIWCQJ1p7XJTA96kalDaPuTsNcSHd7cEIoiQy/d20LMLvSivIa
u7bIRucAX1Gm2p2bBMS1WmWn09TgCeW+Epf/8LPru1x1OAEGJhrK8+nFGFTG
Ru7yy4HGbcbs9E0ExqgX1440pELBV9FZrrRsuC99s0WPwrPtNiniklwg4MDh
NQePbIjdP7iZnaIb8TtlJS+u8+EOXdGQB57ZcOUD951UCs+D3/e/Y39gLnJz
tnrQtM8WFHz/CF1dJLBEydUtOzoRN5smcTt0BIIxy7AxqxYZjzGGf1qqbEf/
nHNvThxLBLemjYi2+jEs7dHLLsudxfs2XhYjHLnAdvpUgNKHbAhaPejoStF7
JhYqcY9t+dB80leRT20IqvWs+jXoFtDcif+M+kI2vI3ffln++iRwkiLzsoqn
MbTp++FQmiww6jhBp/9zBrZH/5KT7h/H21+cxrmuZAJ36+jZLKt5YHLiZGo8
O4KbnKY2C1PyKuOWezuMJEiQ2/P2koZOL57BjJL7fJkgJapwfsySDO07Hb5X
N7Uh6+ij7R2mmXDV9aVdozAB2m7dt39H1eLHRYfVj78y4TqvBe+7BMpcm7yl
UrtUDJllXepPuLLg9kMaqXeUc46JOb2uhxNA+u4JMRaTLChZyUk6OUZgpM71
t+P0V/FYZbA4dWcWPNUJP1lE4bnicOyH7XvMRW6X8/TQKdmAwBKpXeAHgW84
IxluPY/FwSPKf+a7/MFMLPrQ6B4ysrtnv6D+2onRGX5iIxgFZkfucbT/GEU2
/Rit5WdzSL1s8+coUzJo9AbEreEnpLf4PGPzjcB52vaNHS5JIE/QPIze1g5n
XnVQn6To0Ogm5njduQSoXpY6Pjk6BLKLvKy7VufxqM5zBtWtCZCxlXUPV+Q4
LEsOhh28MItRNzzN/wQkwJRX0I5r26eh4pxxzrGjU8h69OoxH9avkJTEqt5H
moX8sCdRz+PGkGpP0b7Fs8kg9Ws8tPH6AnQdPdq4+mUQOdLPbjstkwrSMkxN
zYxkaGziNIhw7kTxtXMcZvZp0DeM1mJnCfReydQrJtVBQwbNzHpmOpwos35e
WUog57yB4vncXNAQ5z9RZp8B379P7qem9BSNjKyduw/K4LBz8lVB9UzYTEfL
Uf0fH7ziKa+92UQk/MEK3Vuet7C7Y/5R7k8CDa7uok4JjcJLZ/bkMr/wBRGQ
e7DXiYScF9UKZIJ68Kr7zp6YiCBYeRBQG8s2indZF24H0s0jT2V172hlCLDs
f+F3QgzRrtbxypkSAuXpy3eVqX6GwI63nU7yRVD0ktzBXEMgH9JKJn71g9Yo
LQX5khaY2CulrD5CRr/9Z7u1zP3gNu7WrNzdA9d2z8QvRJIwwrZQN+lEAGTe
GKjiGxsCPZamvCyaBUz/eOYw7YcgqEuzTLu4OAaPQPv6s8pZZChiYL99KwxW
FMXenQydgiXB0sM2gVO4vbCX9nRmJHg+r/rEJj4Hz2KPkF2ujKGC0wG2o52x
0N+QsmlSnIR7S+9v30vVDZ+3CjPs766GL6V35XPuEUgwSvVMltbAJR+rBrEj
qdDUkwGaCwSGDzBGf8AHuMB7rjMwIw3S9fnpmik8T/TP5NGPvhDhoz6W8fqv
FRhfWfc78JvAqxUMYVduROJdaL1GH+EJ+zWGSzi9F/CRt8tJ5eYBrNH6IJMV
5wa6gfxco/QjWBDmYceePo+ChCmD4ks7oPp//fv2X8NP+c59oS6qBZbLHTpe
Dyk6+nJeKrvJDCReyrRqO7fCnrKt3BJVZDwvVD4Sz2MNQuGl2RbPu8FcbPtY
dRUJpbpV7ooZvIfaCzSS572G4XHJ4zt7OucxZtTv2BdJD1AR3vNB3WkSaF4f
+uURP43Pn9B7DvYGgHqKzrkl8wWMNdh5+PvJQbg+MDUfrRkJEexPLzdQdGCQ
Vz3ozqvnOKQ3yir9Oh7ydy+rd1J49hd6ca3ph6FIkcGjVU42SxgLzac7TeH5
0jDTU/elSIz4fKOIdvjD/3He/rfjTS98ctQovFWmAaPeVCQGenquBB92gLF6
Tp//3FsxRQmo+J41FLHUu5On++oVmAxsfx6wQsnPh6rvBpyPw5iTh45xR737
5/6/+Pja9Iy6gT/D/tSPKhLIBYTd0Bk1Brno1XSX7jpgDPZk8JGl9AnFN41/
kmyg8f6DB9s9yyB64xjdRBwBHG3n5tPSHIE5r3CLVEMROOwL8/epJiBPsAVO
G7jC9tLybQXf82HMLIXRqpWAKN3QfCMvD2AoYHlS8i0fZA7PSkpQ8NoS8SW+
Ti94omCXPq5eBIR2j5NMDQFj+1Te4FFfaP1TPjCtVwp3ZC+dKkgjQPb2TIIL
qz9EWBl+PBlXBVq7btCEWRFgSqVE/e5TENg4qpS2lLVAdoJh0sQAGZL3vPOh
ngyHmrC065UHh0HZHvHF7DyU1pzhePs9EaZ6Mr/EDBLwidRj/fakK9p/aREd
PpUDRqGsHqW/Z+BrkozwWts4lNLv9vd5lwW1jBf+cE52AWt8P1taNwny1d6V
esTHwViRmviR+DIIufomyTmSABp72dCI5HBIfnqtqEI1HTikUjWWKX47bJH4
y/9tDCjkFqoR+6vAzzDrmpc5gac9rc3TT6fArUjNVeEfE+h4blOb2K9p2Pgp
4XPTKw+mb+o8bjtOxqpkH6o0pQ4Yu+uQn2NaAJyZnr68lFzKk/8s+eVfX7jD
/YN7QSYbekz3u/v9IIOQqP7bxxPNkHLB9q/aoxi4laM3t6oyg5cFN9JJNhMo
8Hi/Tt2BPPi4J5y+X3IUvb7oZUwPzmHE27v3a9pTYFonxTh6lQx1LS/uzT2o
x9+JeFwspgTYvz2lM85eQOPaeU/2rQPIxPVF6/jBryBjy/+Nj+JftHM2hYz1
ESiYbE+tsDUEute39yuuEqhT1sLXzRqInLuln2qH+8GLX9S7pNYJPPpkn2GA
pifK6eroxRb7QtWIfhZDNIFvc2h4uf2LQf1wW95icDZsEvZQk/xL4Lsi5S3c
b99gE6/hFbt8HxAeO6SQoTCHagqFLJV7x/BU8o0tHjtS4fkX2iKFaTIOf409
xM1YC/IH/duTWirBw+PaXg/KPjurxN6fGFeGiedpwS4cPmAWtk/vnA/Fr7uq
JwVsKlB+a8hT+uIgaFl7/5VJaBZHG0LHWyLG0Wpn0W7ad1GQGe8tfsasDZfd
9T45BZMxcqVtu6t1NDQoeFPfKiDB94+8Tmvy3fhhuZ4l4FgqGEmcLtxK+VzP
p/qe5C4nEI7OvrXvjzfss79MRzIj0OJyJFW6UjXemVawLe/2gatdvI2jJdM4
I8PF1ft8Et3W2vjXRHzhzVAnU5hEB/4pvHrb7hEZC058eleo5AGfwj6vb/q2
gFLDSuk5nP0gleZDezkuDj5/z+PsCSFwX24vTdnDMhgNOyafI5cEay0uV3at
EZhlrvNcPiEADMutVbm/+8Dgn0nxz5Scc/IiJyeHSQNSl99d7NJz+j+ue8e9
aU6d16wH+p1s2vLiBLKuhHXNP9QE5q73xlSSHVCj42r7WImMHPKNKpHPTOGk
7MoTYc0RSH+Z80vWeh6vNOQwTZ10hCHLLrePags4eNubUc5tEPY5kML/vAuE
0xeiF59R/OubiKTJY8FoeF/2kcX1aCjMuu97fuQzGQ9fO6WUV9CGLG+D3eYu
v/ivvddX5Z3FKuLFYNbi8tK6ioAfMR8HjHJNYI2VOjK/Oxvy3BNf7x4m4OXF
I3N96+/Aqoh+stSvGHyFIwupKgm4rF+k6BxvC5aXPSvU2Gvhs7K/sJg6AWZs
LU6mbxzA2swrkW9sBOzJ6ZzKp+eBy+rw+MawN2heteWYokmEpVXzbYsFBBT7
rgs82FIMPIXJuXEwApcSD7VffzcPnfqsVOxOKeDOwfbeOIcER0d87HtedsPb
aw0hq+tf4Xy9P6PzbwKqDHZOM6UFinBP3hPnvB8FbbN9jwMyNeCoElUt5x8C
WtkEul7LR0KwT6Meffg4lFwO2cF1YRZ2ze+kfrnnKwx9Y/Ize1sPJoMRHySv
EjBJ3lI/5x0BoldLz/ibVkHvyrIkrzUBu3Ufqww9D4fmhc+Kr016Me/49GHN
2yRkVivgyu1JBI6C47P2r7vQleWjfdIICbu8N9hCf6dBhazM1rm8XBw6rWjr
WUTp60YqP/adyIImr2f13vTV+CRMXT1KlcBunuWE1qFM6NZLKZ6zTEVRZpbI
oDlKT1q5saekLAyOXTq3+CP1FvDfPbbwrpfA6QmmOeq6XOj2ZygNuR+KM2Ze
8QsUnSO7RVN9XwiD49yXzNjf1MMhgawpkS0EKt45umdfWhFMPnKSUuv5AMv9
eeWDFD9/EmN3xaI5AkipTLIL7ZHA9Vz5iOoygVRyRm7CKlEQWcovzUIMgsbW
PU5HlufxrKD2BdGHpWASkPPmzK0iQDrB/YNIYNQtW/9vHvFwLsxzTvzPFFS9
66tIr5zEXfnj1+fLyuDXoAvXL9sFuNabpnciqB8PZoZJNQiVge+GjkadYSeS
BIkIre1kCHFfmRR7kQlyLNa7xbKHkLZHJC+XmIcOsZ6XHVKU3i1Om0Y2nIfu
qM939eqGcUpxhUdXvxTS1d/ce/N6DhdXsqo3R47CTjbLp4xlBbBLI1klk9Kf
S0xD3uoPp0P6VaVN0WWFkKw7mDQ1+Qj3Ve/Y/J/8oqSe0PiyxgJyQkXkgz5R
emAt/+UZyRI44zUaK34iD5gEA7+9ovC+zJR9sPa8Fng28YynUvjv+5JNa+Tt
ipnn1RVIfwlQr8DIl9p2QL1t/WrfNIF7YPPbb3/WRVpZtESFozKApk/4eP8o
gY/KY1xV/zrihrpIjmtJFqQVLm3KY10Ao5v8Ry30hkAuK+hi1c0EeKJ5a2Vn
7gRG+CXK/Lw9g8eCDEjn3ibDFqqYc5qc81j+ZGD6VO8ICrP5fPpZ9BV2BruJ
dK204BPrzwXVZWTcFHE78/StDPAeZx9a+ZKDT//URMUUEujFmcSQkpYNAyV+
ozel8mGJHGxxL4bAskWV8bfHC8BNcviU9udOiOXkmW/vJaH2usWsImcJPLdl
S32YMQHD/uqR15OmkT4nqeh9WDWETux/kHVsHKbmJqgFKb6089nOGnupMsin
w/EbUvMQZ+DHHRU9jIO/72UVjlZCR5HPJ3auOTjHfXtSuWMUI/t+ydUVlEFG
QlhNkSgZ4st51bdZtaG+YLb3xQflkBMXXUKnQQBPlVb0FqsydDeoT6X/UwLk
3/da+0rJOOI9Q+I7UAYxsRtFgveb4HYehwbjf+45j4n78/YlYH5ZqqqDXDGI
sj/aqhFDgMCuUpVjhmXQvKxtJfEmDG583ebL6EpGreTwheiqNhxOE8v6GZoI
YsXDG2mTU7ik5mVlfXYKjbvzHYx5suC6iHxrfckAqnlF93x+uIB7b2bqJRcU
QdlhmbNju/Kw//7uUfrXBDIflFWQNy0HjwqxCV6jdjguN3+KvEjC1iq5yHVy
FbA/GZjnVhuGe9mJt6rE5vF1YfmaYGI1kF7et7gSOQ7C1BP1A5TvnS363Ula
u3pg2qN8Vth1BjoYI8aXsseRpwI4uL9XQcq2YWeHM/OQ1quVUx00jO+OR9u/
ya0G5+Ti1IYjZPA2ecfnRtOOGZedunZLVcAfdqHa0VYCXSye91uFq4KnQ4DN
0cMFoGScF3q8m4Cmx4dvh7jkQnwvrrFeCYasdgcLBykyXmd6fnDOvAMbWE+L
hPglgvMlWp+s5Fn8mybXeb5jDDt7Jw2BMi/1knYVgqWD6O+m8fJuzzyy73dS
5p2pgMynOgyGt4tAl6GkY52GwOz9Hdd1xuuBrSBUMf9tL5hmd6a+f7WA7JE2
CrUuDdB7b2wfl/gMnGSsEpftH8el6qKAh6m1sOlkebpuHQG6JfWF7sp+yNbP
nLmcVgii39VHr3YQeP4Ug6INhw06DsLzwEf5EKpS8GDbHAFfiPJ9VKppcI+a
+bMwczDMJhroHvpORmsm0Rs8pc144cqiz/mtibByQ9Dg7rZ5jO/ntYHSEVwS
ezas2FYAHi5W/LIzfXj8XHM4r9wCpk0npMmRa6HyzXBzylonMPFsq5ClJeEV
ZouAQZlmYKbvzJM2nAHqxkSR5aBx9KyNa+09VQebLofOUTcRsHK+L0xMOwB9
9Zzppb0LoGiHI79YF4Gf8zbf7V9XxaspHPofmvLgawYVw8HPBGgGZGhR58ZA
DVPw85+65aBv9HN99TqB/QEqj3WWalEMS4u+8yZAc6uV4hqZwsMOqeuH9WPQ
UX99YZA/DliojvecjJpHtuXVy4wGw2jx9Hpp/mohQKcGi+xoJ9o86E94eIWE
1Hq/rmy72QARb6TqK0aHYOK9+S2hrfOYkM900tCzEcQqTu/YTMzCV/+N91/a
RpGh0YYnSbQaKtd3qvc2EGDyKY3Z7nA0dt24P/ndOR/0l+sX1boJLCr7sVnn
gTO0GNy12iyZB4FfJW87UubkyMaTVkKkCmdpWZNy++LgR2ZrSCnFn5h0C2s7
P3xB1Z+Muqc8A+BdhCbVj+p5HP+qeXX2xxBO/LKR8FUphIVZzw+G1K1YpipI
532QjN1S6XmbV+rgyyDzRYnCEThCW/Pa2WEOi0r7f+22qIUDJ5fMJgtnQdpX
tsLp/hiWnIjRsD1UAa15xjUPygi4Frl5qlsrHUVzlzFUKw/ezq9e5O4kcDev
3d6SvHDIS68zOvs5F0gZKaQwbwI3i+65s7G1Agska2o9/sTA2X62UlNKjg3f
wsCddPATVopf22pq9wngyeDx0k/zaM1wv+kUxb8m4xpPxLbnQUing/KWzw2Y
Kv1m6/NkMvI+ad1a9rIKCpbO7ddjHwa313QNiW/m0VLScP+aWQUoy1wcvcU7
A+XJ+st2rhNILry/1F1eArd3sVdqhBMwIdwlQu9UjEfqiyJ4FnPguNq+7qZa
AotJG2naWmlgMnVojTkzB76OGYlbUvyAR1pdoeZKDugQahzGXDnwucAzUzCU
cq4eNFx4sq0chefOqkXaRsH19aGCAUo/knVu7+hMdkKaPLajL3h9wfDR7ke/
9s9jda0r3eemEVRYF83Ucc6CeMatA+oODTiWIPG7coGMK4wLwcY6JXBXTVRD
GOdQ5KKH4nXdUZRhjFCwnUwHqllzHrmSHrhi/mhEQ4qEy2yOJNb1IpD55hsX
tT4Bexfn758jptHZTKbRaCUP6JOHk6elCeAmxuOL8muwhqM0O2o5C9yf2nEL
viFALtzP7MJgOZ4pXaxvupUNSXtL7LitCOR/Mv9xfLUcuELtaN99zgaGbTtO
dlHeV0P83q5nPOXIVG8x5mgSDp1TabQ2lH4kKXxubA/DUzyU3qKdpuEDD4gq
hufMLTi0aKITOUjGoRFSmFRGJhhdvMgv0TaLT3dIHn1B0UOz2Q52M8kE6Mmc
XwmhawatfbWnNSh6o/s1zlZ1WwYkZlG1lfUNA8mlzuti4jzuvdPfFGyaBn1e
Fn4X6ybgyw4R/s1CM+hIPPsUM5sKM6OfHmSdGgBzfvojmLWActZUvXVOEbCT
ZjXm0dUZGCjlFPCom8BmmRZbZEiDFbGtfLsGRmE0UDOFRDn/OR+bBYy+R8KP
E9tTNAfnoFKGdVQGRpEQ4Kwif0yDyyEqW9UUJuHVp5M/RNumkcf/zMfrF2Ng
ugcSH98kQxmHgW7f1g48VyRhV/gnHf5wTxvXNJNhuoWccvZTC3rluUcpGWRQ
coP/YGw6ga9N08KnQwrhXsuhgIU7mUC7K2OTVxwZMnYYktUiWlG9snenJGsm
MOywOhe8QmBmtNKdb73RKJ3VdUFYwA+Sj4VO6FP4D9lnUn7gnSWo2PQHfqD0
06KE49L7nQisuJDSUZFZidIZgRoPB/xB6OXeSA73GbQLpC0Jt5nA3D5967/M
obDpKqGVbd2OD1ojto5aUPICfdNZqtggiHnelglX6uD9Ob6aCHkCDTWGF8xf
OoFdqVBmwUAbyEZ8a3zqQ8adISfiUnNcYPhPGZN6ZQ88lFzL1LKh5Pxf2jJa
tzxhrbDShcV7Bp49Z9SuM57AHQcszA8cjocepqyNFedheC+UvUOiax7nzBZS
JEm+EL9mGV39ch52ue6sL7o7guKX62of6n+F7XOSNGLN4zCyufpBFdssym9y
pNtXFAQ0t7YHul4k0Py0jtinsjq4J3GJucwgDdxC+UvdfhGYml6Qu1ESiT+f
a1229/MGUZk8xTuUOdWr1efz6/KC6UPn5MkXKT1asGjfKSVK379p+sHErRaZ
2pISBt97gJ7tgodvyxQ+TFzcZWE0RdGxT2N83f/u1y+Tbxw/TDMALyp/fTpV
sYAfDtRouap7/3P9XUbNnCcZo4CyGe3T0XNY8/hG2Vv6gH+ujzULYuk53g/n
dP3fb/6zgFbbX5M92Z2hX3JxJd14Bj7vkncP/jKBZgvsO9e8IuDbhb4hLJ2D
3HaLTPK7Uez64MbgHxMNlrHfAr8ZjIGYy+uBwZNz6NAkomoU4wPJCpa11eQZ
EI4eOrKyeQItvow8jBkLA72Pzl153wjU3cMy0s2giaYcr6l3Xk2BL5ct+723
EngovId3MbwJ9muo3hhrjoH+9xKO9yk+ZadZumR3JxLHWQMP7eZ2p/QPm+Zp
Cj7qu4s4+SQMXh+IWnhA5wfbGOKWHXrn0fbb7YOX3w/jk7JNhsEnbOGGU86R
jhUyVrmI2f043oL1T5WG98n8+770fwveoeTe78acA/u2HNznOETAsZ7ffJ/j
X/5zfd5XQ4Pu8Ax4KfOMM2eagDU99VAL79f/XF9pYSmT554O29ttnkpS8t2j
V89sTLus/rk+g06tZOl1BnCdsz67bYYA5ic1lypb34DGJE1NrlMLuJ7VefR3
lowa2jkNV+2e/XOflqFXx3Of9oJjuMqNTFUSpiVUa8r8sf7neplzzW4Xoydh
JFxGK85jGiHZWyph5t/z8r3uWsPOVQJFTW7n3KezwXW+7Xx68uFwKvcK1a+1
LvDj354pO0jCdLeHQopdKsBdXMrzjKIDHleefckxjEbnAtsPD5+9h+s66Qt8
TCSsbp+7TPX2JRx+ZjTaWN0HvzpMD/ZQeu/Oy28WeRqeiwjzPHRalPg3z/+3
8IdRm6JzGPPh1s3ReuVOyvPOWy0c7TUD82VasZxvZbBU147m0QQ4Bipot+2z
h9Zx5qLXAW1g0LOkMBpChijbPQs8fC5wXnrQOeUPAS+vh88eHQvA0PCtyVMX
g2DuCKf8+7/TsGX4tzTPlkmQk+TPUnybAU/u2m9wtrZg+eTzcJ9OMoYzfO+U
d4gHnpUudXnvCuTkfvv1mzOBW6hYxl/SJ8LNAx7B8RWpuL+DevuhEQJZr37f
p3s+GbzO5ylreESDklPFkxuTBKV/62sfDk0DF27rQ2fUq4GwsXqt/ohA2kBv
m1BZSm5Joup7crEHbqnX1zkbk7BoUdoq9lQ+LDIdfLxxZAIYVWS9FzxncMnm
kIUOD8L2VCXHGBIZbxrHLkydaAR3kc6UA9eKQY7rjLpOPYGKyHGsqiMBaFuP
F2om5sG2jb3aImMEdi3UhgqZWiOrlGHt6fwskAxS3f7RdABM3LLKZc8v4PDl
Q0KGlJwZFqpzWYI8Bb5ztqrhyZP4wn/F5zt/JSxdMcuZUFwApTeR1R20A6if
2Jn7k1wO3E2WrPHlZKCPVLxG96wJk+2ff91TVQrv/waEGfsTMOeomcvSlodD
T8jddu4I284P1Cv/GUNYDpOj8p5F02BD/9XreVA0wHI7lqsNb0h03aTRJOP7
+6cSf50uhROCKXvL2fPB8PeZ/HR1AoXkw5bAvBJqbZHT9e0QyNOc7HupPI93
+50mR8XrII6Gf/b1yAx0JzhYL58Zx4Opiv5td2tAufK+x2FhEuh+2znWUdSN
KrrHvPuvVoKU49t1zmAShLW51Pl/dEM9y5bWUtEeEFPZbdx8m8DQ6rY4u4Va
fDSyaXMgYxTIBQ+Nq9guYJGv644bGQPoefTZ96a6dPB1e3yfWWES511o1w/b
TiO75dv6X5YlsFpfzPGuuwZVavSyiFIyMtjnmjWy1oLqynzlzRUyhFdPnP74
8hp2LuS8HOdpgVxhaS+6LxQfifSyl91bjk5fcMHPMQLiOI+8vhZKQokddOeb
C7qR4ePFr31vMsCImUmFdGwKP/Amv7b8NIVVbNPnSmzKAY8viIyHheM2xQaN
zwwESp87sTc8tgnY+I75/zIYhwuyPP2pqjOY6H55lzpjI3x6omF5iJKrj9g4
nNg29RrLG1WS+w7Uw4rSQu3HSkr+V+YgjokV4SmTb2f2GIaDgJDFli+8ZLQ3
isrhLu5AmqC/PDG2GeDr3zy+sjGJff2ecbThU6huKrZP7HglXNAtv7ZTrBjS
jnJCeS0Zx7RuFMKLZgjflpyscGEKDlXdidPfO4WBjQVWdwTrILY36/FHSv/V
Xp+5WrE3ACWuc8Yc/14ONe7ef5z6KD3XzFXy9bYcpLE/7xykEwYGM5Ul51+Q
sWe56lkgVzverqHJra9KBym3dUaUnETah3RHWxQp34ts3/enHRUQPyTqpJNa
C4OP62K93cl4I46wdmFuAC53mkvKb6YgsoKT/tbOKfSXelzqaFkFx5zTrm8p
JsBwbpPg9/0JuCa3pf5+chHUnu+c7J8isGeupfKWQzqKbS17eCUsFC6MaPf/
kZhAv186O2wUZ/CK9nwNWacMjJnEJ8bLaiHdw1OUqYuMLI7UK/S2VSC4nzjy
d24CpKZ7/RqrplFCaPfsLY0yuEanabuYRUBzXuwQ4ZSDskk+XLdp8yBIzu++
HaXv3z1fR7a7m4wdanz6d/iCod14fMBfbBxzXoln18vNIo+XqWB/cSGEf7Q2
439dCvGfFiZPvKDk9ONGmY5clF7Go6Wl4zIKedYCd6hc5nBao2CjKqcA+K3F
NxkuE+jOxz6ephyPi9HaHC80P8OFP60qoqpjmJC38ZR63xy6C1pyeVlmQPPy
zzFL03BgUVbjHRklMM76AVv64UwwW53fF0r0ADl++4lHmiSMvVX6u/JAOjwx
WPN99HUUCEP1M0Zhc5gl2/Z++FQCaD5usmvVm4ScYiMvUs407vhgXX5TPBFM
t1OFPXCbgTl6kuEzkwnsuS7j23sgCUQzPK3DbQg8GXlER5W9Aka87I4/YM6E
P0ue4lOuHeA1Ju3Ic5OM+TyWnc4s/uDiGu9LZ90PCkPknzfGFxC3BMVOhH+G
6SFZIelTo7CN9e8jYm0OOdoPHZ/pC4GH1yoL7MonwJbnMmuBwgzerPz1O2Qq
HHadNcgmWczA2oVX5n98JlDk++jZ+2nR8NiyUdgpkIzKvweeaJxvg7s3aoLF
9qeBM48EDd35JtjrabbutJ/AlurpZcHfFlD+U3y/gnQHPF1K8qh+REY+sen2
3g6b/2v+Gz7vfpRDsRXKBM+WdlaRgUXJoHChMQp+jqp225kj/HrJwPQohwBR
+eV2l4l4ODc/NKBdn4l9xINEg2ECr7JF3jMojIATLTE77knFYdxRfwnbJQJV
4/SEatzCQPrzLs7tDe/R8buvbuofAm1ceugUU8Jh0CV/zt6uDSIXJvjUykjI
2Gb/iIahEThavD7UGxLg4MX+/GtINawFx0cR2RFwyZVN408FAfK6v3p3FRUB
t01xfPzeUMjWnrP5MkYA06/393Z+zITL6cl2dveCQKYgknH2KxknQ4O3yE61
4tQqv4/3/URY+cSxkEYiYJXH6meEWhJoi3RaGn4IB4YGR0bHEwSStjCqRTo1
IPeT/h+1sQlwyNVC6IbePLas9LS7sI+gRKLkpragQoj7wO66tZvAYo+TG3yJ
L+CBNgervWsedFV3uhRrE6gzUxPyZbQauajebNHxjQd7f13h42XzeO1D+Vwq
9TAuPOSqEp4tBNFQrY8LXZT+Kx98yHTeD1YF7Pdrf8+FdCWupwc+UHTmB1t6
3J8KnLnam/p4PRa4lQoNvXPncbLlGWfg1WG8vINlU5JiARy0V+qBVgIT86K3
nFOPBx+dzUxwJhf22B6I7vtM4A0WI54Z7XJssn/893FrNOxOJF03Vp/HCOpd
VTw3R/Cg1dLv0eEcKA84t3eM4kdnhLxJR1bKcIrpSPERhkjg5Y9qrw8ksEqB
Zl0usRwPsa5t3mX0Bf6IHLP0CxoDh9yBeb6lWZwx3Xu9dnca+Hc++CztPoob
jxfWy3LnMGKfQXnYUjTsWo31aNo8Ao36QrseJ86jkmme8COOSBhSey7UEzIO
IrWfhx1gFqsFXzxaXY+izDNb4fk/U2B86GXxwctT+I7PUPFoYCxIm+y4lRo6
grSyQYU/7s+jevbyrPdRb2C8ckLrM10LoALvoOMfMr6YLTl8qfYD6GifYnqC
naCn8sY8eh8ZZ1Nc73HIucNadP+JYeYpCBaprzA/Po35SmZdPxnD/sdzVLpn
xypBlQXNz/92CE0QIBnimKt76RXYDDxct+1KhyDVIceQWQKa6OfFX5RbwilV
K8OjZenQey/mRhUFt9gUWDXfZQ07e8dF+WozIUbw2b5cyj4h9IdTL3S/hSMH
746Xkin5bsj+gB8lJzeWcWy5kWkDRc/4LvnGzUBg3rWX/dcnQP7ZxP5dj1Ih
+qtt4d3jAyBekSr1MX0BrIu85ZZY40Fkp6D/nGUrLAtI2FV9XwABW3rPU5Md
EE4vrS9DXYOm+6OSXz4l0G3Ht5+7+aKh44b4ptXEYtzSvCvmZxGBfPU8Vjbs
0WB1rWpW62MSZh6FV4JzBBpTS10WrY2BY2tp7Pe2fIARQ5Ly4ncC2Q/1ipVN
x0PhHsbeE1yDUMp5UtT5zgLWuM19XFvNBTvpiuHNJVO439j3ozdpEj7bHKa3
FKqAqnsOuz/KkYH9SOorR9UO2Gr3kOwRGwPx5za7pyYTeMlJUd9IqxRrhPtT
o00igMb7FMvZDgI5Yvlu9t7NQ12mv7xxiqGgSd99Uu/oLBJdEb4vH41jfojc
RZPpElD+7b+3dJ6MfpLyrsf+NqNLSGHIz4wUcL2dyzOnMosdpdvNJajGcVx3
5uqP2FIIkt27/wg7gQfoVXPqxxvwhltNYMC2ZJCKnBS2PzCLz4xsB29pjePQ
ucMWT+hL4Zdr28h1qxlU27z3zgAlF+z0sPiUNFMEZaYl70fPERgscTKlK4KS
e7w+2NIkZ4BNs/GDohQS/n4cdpJvvBuVHhYQZ63+998P/As3uK2sdMy0DuQr
4oGfkruLhBh39HXcBaWln/ws0j3A5KNK3xFEQm78TI5VNYFPDeLhdgIkzKwQ
2FvC1weh14/8Wbnm8z/+XI+OL9YnVRdgv66x9W/DQZhe7th2ziYB6DlmJCca
5kDzXPSXk3MjwFwlveVVXimEzN8uVaHuARXfacuEjyRIPlse94g6E86UVVzY
t52AzIRvXAMDjXBF6s37rkNpEHGXxmCY3AAjspWbDh4hYNvbp71MmxOAEJmk
+SLZiE5nROxG2AjU2tbukFMfCwU9zPm0o1N4/PWPE32np8DmXnpBgn0OKBa3
mYAyGUO9DZx/Xm2HtUHdhwE38oBe7mKyMKV/shymHZI5Hgh/1ExYdrtngQBV
Qxud4ATSxi6m7Xs1g8mhKtw/zUtAcURqt77KHL6K0j2xHDyEynVfRYdM24GG
XrNhsXgEZQdXc3cKzmOlff9qlnAS1Ln+jliwJ8MlHb/Rb9ktePsHVXnhqXJ4
lJA92S1IQjOrHU/qF3qRvl/PLMI4AWb0d2Sys/eh7l4pVoP2cHjiQS+jKUCC
rrcVe1gNCFD9G7oRKFCBYVcNaT7k5ENL9j26/RcovMzAPqvTdXht7FvbxfNZ
UM/WrsESQ8atAr0xDc6tcDGUlnfntWwY62e2abnUh23Sjzgv8ZPQQSZVYPDE
B9jq5bWt/ccsvOFJ0+pIHMPBRZVnutKRcMHupR2n4yxOG99k0L5JmfeBZDJ7
p/3/tXNe0Un3I4CjC+Jygvi86cm4k3emZm78zT/Xh4z50YRVD4OL/4v745Xz
yJyl12Pk6PLP9dR1sZtZvaYh/HREzenwSSx0nT4Ff4PgvGXitxJnAhlX3p07
xFQJzD/iLrSrRMFTlYdUuWZj8Mf0hk/dsTlsFzWNndpjD+9JSwu1qQQ6C3Sb
heSV4qELVxMNGGyBSz/UQJ6KhDftBtS8Gfox/np++EbKc/DbTlMt5U1gl+GB
N3eHKijOKhzBy/bve7//LXj3rZlb0vXhsHHdPpFmlXJO80n5jF66UH7/o3K4
UAT8YW7UrfhDgEC+oczm6qfwvk17ucIzEqD2+e613wRIp3OKyjbpwP2bEx94
BGPAv9lkVfwXATMB8bnXMrShWuVwkvyLdLDQNa1LnSPgWsizbfwhWrDFYnDV
6DmlLwfrbZmoJKCufi+vRpEWyHv6kr0EuoDx956BUBoyjE+b2wcs6EPlsTLD
e9JewEXNp+U6RcDl15aLUekZ4M6fMN4kPwqk4gwSps3BJI2MmStTAZRKwSLx
k4BhPelun/lgkc8H3fj6smIgrnN4a+zVLmh1E92e95MEQ4ma2uL+cXDzeGVQ
M/8Aeh/8ySQTtoAX9cIad2hkgBXFuS9YlCMtucekh5Ir7xSlv1DviQLjvz+z
t5Vl4/vUd9XsPQSmy6TVNVdHA11hXpjl/c/YrefooUbJAzccRBaiOeNgqmdE
iOtdIrxgafOonSZQdzw4c9eRr3BiOkspZvc43Lb+fCjFcBa/v6dLFnIsgslu
hfjhyEmo+iphrzU7hS5lwjskz1TB053bbB8rauLRH1zxHRsEjLmbP/JNeQXd
5qXZdxcS8RvzxwZcIgDqdkq4m3rC3HOqY0cpz33Kvyrgi3oJGFw50qWVmwMt
E1q273aQYOqIcvHO4D7oirSyPy6RABryJ17Vr5OBZobtnJp5M/iw9Bwqxyho
lHXgC9AikEb6+siLrxW465eqIkdBARz/sOcLfyWBm57ayj13LsKCUef42eNh
cITBhq9qiMCLTTSihgNZyDFYL1FPGwI/L+gf59MgIacBe4ltcg/OGefGFmnk
QNueUTWNZgLrzjbuvSQTAZrxaRLOt/Ih/kXY5q5iAp+7vpZQ9U6D5n1J91Vo
CuBaDucKQcntV5ULE2vP5MBy/a0bSq8Q1iWeWCQ+bQPXXVfNs6PImDg3fTL/
qRccZN5Dn+XXCT9u6bK8YCejwKszz6YsvMHzk6pWM/bAhH6Q6CZbEgonfjva
PO0DEgZT7jTv22BPSxWNdDgZD28+9+LpN3vwsn6gv017GvC9xUemxklsWT0j
Lv89ApgGzMsmPYZBpK/FmalzHnvYydt6T/37Pvy/hRsfbhsrmW+GC68+Me9f
J2PRRtljD9J/73eV/z/+38VT7pR++Lo1Ai5mU0mOUHT1/LuOnnvH9WDf8qah
XdubQG54quQwK4HTp0o6pOl0/u2zp8S66EK7YFzNVkicIKFF8M3ufXEW/+Pn
EZmMzryZHAVMr5dKZSh6zv9A4cYvCR24ucCTMtU0BhFOG6SsMUreJwe8PJjn
Cg9ojh/5u0bgbhePxRZ1Nzwkflb/brc/8KyWlrs5TOPBp0rux9ImIeoIlfLO
SVdQalhmellTBcfEv+zgfkPAL6qm0Hsa2v/j54ScvKoRRTKa5JB38ap1oFk7
g+mnm//mh1FwLeTQMgHNB5MFZs09sc6j7uRvm0SocLq96ESuh417DZamVyj9
LvG0yRfpf/t4yuqZko1THcCyTCXjYU4C52d58l/sGkEy/HhzrtsouJAOjoZS
fCckxDhdKSsJ5M7ZnLg+2AT1dsocgitkjB/kj6yRzwCB3+xlQQcm4Pz1O02l
H2awYbOH58BGCXAN0R3TvrQA8Qfrsn+M9OD2lJ+D3btbwUhQgSFtgYR7OAmD
awadEB22VfdDRhGMz7B0uuW+QvXgxahIiv4HL/IWDxq9AfP1TSd1ZwjsHm0o
GYo4gxKbOgdEnmXAp9+LLnxVC3CdzfnNalM/9F64KXVGKwEUuTf13XGYgfNi
3f5hVhNgamApG+HyFVgvsSnev06gnF0db0ldJQh7YFv7JYTDB+oi2coWcC02
92N6fTs+bwr+dm6qHQZnRmNP5RFw32WM0LJLQLvs6pqAwWIQSillvXl3FgvZ
qI2Dd41jOL6hBeNSsPOYntVuI7DCk58spuQGPEqvmt4W5cOstafmkswskg2T
y3axj6NdRmqRuGMplFXEGVe1zyB54YkvuXocrT/SBrVylUAtzV6648wzeEZA
6qNN8wSeCk7PN1/Ih7FSNfdjbNMY2v96OWF9EmuRajahOwN+d5uLHPpNxm65
OpZvsU3wSnlYPdAqAyzvBlsvl2SBd3PRloABAk/3q9WJ8kfCtoGpkl3rbXC3
wfpkgTMZK+41BTtzR8DAr0UTk8luYJHdf+pnPGXuyqbYhc5GgPKBxZuMlyfg
Jf+2TTcqZ1CKwfuii0QkHGJQUotXHgZZj1K/rLF5FE1Olru24Q926deFxJXG
Yf+AaGGexSxyLKr5XPgWAjECo9xWbeM4yi9dt842i66VJx6/v+b+z/P59mVe
yO/X8fjlo+tZ0R8EtsXsU3Vt/ABkjnXp6+15oLirNDizk0ARN261ZzGOYOc4
6Mq4Vg4bfimj9EEEqulPNYgUOcLdlW5fB+lOaPmR/cz7NBmd6kPSR7McIUay
+WOqbAs8mb1gun+JjKsOhioXSK+hkSrcjjmrH9z0TJqsuhewgSu6tij3I1i1
n/Ql6jrhbynX7v0sZOQ1O9LWa2sHfUq25W6/R+F1KledrMUcXjDfong56RO0
jKXvyhIbBIXa5LQ95guo35J0O3HNFToY+soPn5oGPYsICwHGKdw9+ugzz9Uv
sJH1y39+fhy2iJgWWWyZxVMGUtLre/3g993ws0faCVSd4xNQILKhmTP0vrNn
Isg6ZGQMFBJYvNSqG65aDG9KG0z+yMb9f84XliqibebkFpDbOp5NuHYQBhW2
TlNb/vtejsHn04TVLwLf0pTtkTtnjkZkO3/himhoUhTZzD8/jtPyRjkPts+C
QkTPOwt9c4CJHMnLFN3e36wR5b43GFgfGT3tTnABSd6YlV8UH9rdZbJFhjsE
M+9q8jKM+/7X3ivhgzbttXEC+hXO/IlRycLh+f1bcra+gmCuVYXaWyTgF7rO
67SrF+4Jp3/vdM+GcRmWHi2JAcya8dA+ELGALAyqgTR9qXCi0ykpx3MCtUqP
b2Q+ncHV1ggbtrR0eCT8+nEI5xwudUx2N8uP4WRLiY+PThr8DVh7cCCBhKzx
P/QDsBs/Mczw321LhLNHi37+kGrHTzsueHxLI2FgtZ5S9P4GSJfgfcMQ1oSl
cOeaiBEZ1QbXK5Noa8Ehm3ol2omMV1zS6g+mtGFwngg9vXgaHHktm7p4jsDV
yJ0Weu71SHOFnGOtkwjPGNIbHy3X43TvwfB9PWRkqK3ass2hHBKPCn/vekXG
pruT1zJOt+PfujQV729JMFB3wbefso+MJqH/vKIe4QwV36G6WFCWY2c8vKUJ
A8Y6mkpJZPx/2PuuoCq6blsFQQkSBAQRAUkGVERERIWpiCKCEhRFUCRJzkEJ
kqPkLEiSHCXntIiSc46S894NiiKCevurOk+n6n84Vafq1q37vY5azJ691pxj
jrF370aTwHflcEQFHIgSbTaQICKBEUGZ/R8GULFQxxe7w+nw+o6ZB9UJDB2g
jhq+7tWJ/jA9iclVSIL4VL3guTu96KcsJ096LRGZPGHeV12VAy2dUW6Ny2vw
kcZPyIP7C4puZaxd4Mr8nz8PE+wlMSDVC0c8DH8EdhNB2/PTplCzLZziNx5Y
+14J+o/WlLm6MJAMlf762tsfnCKMIkaTKkBMjk7DoA8DzpD46Y/tQUB1VJdd
YbgSCDsn3ffh65lM5f29iCFghsncpUpFUKxQJvwEYXDslPbkI+dwiLxokPow
ugEsGAzRUAwGvjXCwx+ORIG2bcDT7e1BkIx2krYlJ4KGsvj51x9ToDdBQ5vj
JhOcMbd+tfkHg1+npCjJcH8kH7Tr4z9wDgkfNSAZxudp29Nqva33tlB7aEiz
dQ+DGybEB4KFweImkuITnz7FwOCwwL3frY3IrUux8W0IhoKfhojxmfjCfgU2
GX2pDmRooDO0hZ9nZL430zRLGNzke+ru4klEbRrzPp/6+qDBQyosyCoHqjWM
+/kvEpCU5q5y9t9RUL27CpVk2f9rfUdHyvKs/XcNSOue1p+tx0DRvvDNvVR/
YM0frwXSdpB3PKuddRuDbHNV0dHvccBiEmG3T2cW6g1Upg05VsFrUwRe8WcD
C6sgq8vuAuS+38jaFliCk705wl03s2E/icm5mhZRWIj9xkH4jcHR2z3NfBTv
4dx6+B1yFwQUtQLj6dUYnPrppZvI+BGIE6e1yfXLgfv8poDnAAZDtyqKJqui
IermMOXbzy0wK8H4+vdLDIyShedhOgH3s2/7jrMXw26MZHrWDAYHUtRL2doj
oZrtJKOT00ZNhfqOiyp+XqoZIcVOqe+g6pLQBcmEHFBZemjri2FwvkHApu1p
OHgUNA27K2dC5M2yS564Hjxi55tCUAuD+2dZqc6q0iKp8EcLQf/oKH7qoHhG
D/jLL3PyQ0wq7P7IdbT/gcFkQ7klFwqFG6d3L7cIJ4GAAVGk/icG1bUajKn6
odATu/Gz0YYZyTOH6uTiceiDzh16uOUCTV7VEI7Fg5Mlf70/zq81/tEef5VC
oXfrNpepdRRwZ3833d3FYOpT8LSJUyhw5U4pnBHiQKTfzz+px+OQtvbZUug5
Aek1ASXrzBCofKlGZMb3eYjpC/H2XCjoNNxIsVbxBGpy/owpHF8qu0b90TkM
atXqK9beVcADOLp/qBFDWYvXWPJWcuCOs1lNI0sT1DyqWhJ1wJB3wVmGIYF8
UClckNsOGoTWpQ7N7X1EZGs7qVGxVAz3BbIw4w/hiEVx0WUFz9OWqu5B15FI
uNLqL/WblgjKLx0pD3IOINkPF7rrTeoASzRL7v65Cop3iA29KdNI5eDo/IcP
dfC15RGZy9EriDpmv+IEfl+cM+W/VMfe4Pf9g9xAPg8xGxrxfl3DQORHNuM9
+1jwXLr0NKa7HM17HfZJ78Xg+Y3zY9rHE+BmmZ3Dr55RRKXNn8ZzlgBsO1Uv
BKaKIOE4cZoa1tAfgcITvkrToJxFdZm3pwba1g/onxEkgCt5P8Ng/Qhq4j+S
S3atDuzPH5aP3yGAz+qIU1zRAEq/9rNUlL0OPG4wMK1IYGgmbZ9eUkgz5Nar
WkUUV8J+P1FkOjmOyM6ZNMyUrYPC8z1fEZQPAtPeilUIQ+fU7N6eCy+EG+Fu
NN/lymFkoHWBdQpD+UuM75o4A6DMQv7sxlYJHHs6Sh/XgSFpztDdB4fywCKc
/9z70lKYWwp+7Da1DAfXv/r1u86hc5X3a8axBrhOJ2OsQzkNvzQvrh3QWUMa
PiwcPiS10PmtvUTAYw2+Vlk9FTz/Bd24yNa+ZtEA1LUbhFYVArDnfgqdKx1G
RQHHnz6Mq4fE9meJil+WgFfjZQuMzaNcR+GqoKA6EFB5TJ/mjcHjkfTHv7Kq
0IzxgNKuRi3U9HA5M+H82GJU2X2j10d8M+KWqypvBNTyJWr4EnB+vGp85XRT
LpAtjh/hOPEBGAXcd82eYvDoTvml4kutsDZfG5dRmwr7abLVX3IQ0Y+dJ/ur
1QdRQ5UZE9OndGgdlNz9I4jBn++0TN+oO+Ah0/6XTKXJYMRJ/vlCBQFt+YRT
bNgOoygP9tsaihlgaGE1RR29CHU/thgIUQvIdLomcuFGO5gYJCVX4HnK3Qw7
f13RS5zhjlKBNUUIkOgfInbgffvug9LTfeUp4CtyZ77pfThoM7ykOHtDD51j
gBxyEwzRDGdWhB9ugX1GSf1Gwl1QNcHB3niKiOyKNHb3nuP+wP6DBwter4/f
CzBRL7qKv41qMQ40DoD60udpDXg/dxmdG3YRj4faN9qr0kdCwXNOjs7RcgKG
2qQiIxPX0NJRy7d75l3AUn2k65bsOHzdfSfzfX4N8UtLP2CZ7YLrInwbinh8
Xbj9scHRWbyFYXHxpZwPlAlQbNssYggBo8vOZgGqeGu6pL4dDQ1Z1rmN+Dxa
dmT4NdsaAbkcyxy+vsFwl3ng9JV1DBVOsqSaWOSh4lcHmT9QR0MKW+qMKJqF
50JJ5kpry+hyenT+k4oOiCYriUs1nQZT69sCi8GryDarrywgpx3cWyRmQzYw
xCs25tfpk41uFgmf7r78AY77Pri5+Q1DAy3vz5bkpyOSLJX9mE4UxCOt57zU
06jiZFhd4t4qsnh9Tp6irAXqlq0YnzHNw8FY+Ux+9mU0ICPk+3mnBZQCsi4o
GU2DE4NdmdPYKlLPPzqkR9EMYiRKn0N/YCjl+mfLk+IpqEuiOJIxNhLoXc5G
puP6lvf5mzkH1kR09Ve9GHf/e8iseXNN1IyA/Jd2Dto4jqCEGp1tZ9y/SX9O
vadxchLFV48cbfy+hmh4PMnvbzYBuerubflfGGrZGJJ6axCHThYuGrKRvwf5
44zbCbsY2keyc3P7TyQS9DI90CQUAd6C1Y4TdwjozMVZwy6DUXTO9MXN1JUC
+CL8pLVOdBz9UArR70peR/lhoQdiGepg3OUZebkjhqgk7ncK8zZC8mj43lZR
EdA+8GLPwfX22xPuL3qGQ5HufMF5c5Vw4F6UI3f+jSGtttJttVJ/RLoQnbBg
EwZRvtlnjHzG0M2Ev361O+so7b1nSAFdKcRo8qnw1RKBt5vmfS9tLzos47pf
Z6cApIKTy9j/YCjkLps13Ywbqu01F5QKCAXJrMtC/v/g7JfKDy9YIgpa/QeM
H0Kg02/IM467Cw7F7BPzY8EQtiPLF14cBLHffDsok2pBhjY++0EFhnyuUhXe
mXkLk7omkgWLbTApZl/5+R6Gxk77Fa0IO4O1F/9gKx7/NPfH06a9fFD8MHHq
TEwwsOoteHfg+N5HOYbiztcwr+YmNBQWBL/dpwxPPB+DCNs3QjGnCEixYPjF
VelgYJMn4yWTGwHaFyMuqlEERBJr+9sOfED0x/EC89czcO0YzerzzlX0Vn/S
SrjsA9z3905/VzINKyQlh2Ol1lBYSb27oG4EDF3udLz/dAGmbKWPSvQtIbaG
msJ9Qx+h96aR4M3qPjA2f+AxFElEh921WI9vvwbeh7vnH2mvQfhh3vZK22kk
ak5/7ORWGoiPip9OD10GvdtzL06/mUdyWzE39nMlQArlhJx43Ap8UT84Hsk1
hw7IlZg/3U4CcVv2BjnLedj3PmdIK2oZvbhhnqX5Nwp4he/s0qiNAUGGP+jQ
aQJSmfhZx1TvBqtHVE9Eqs6BWFKDg6vtCrLhrro3eTgEZHXVWIx0F+BgmGbZ
i+YlxNzcz1gtFA626jL6rvh+fhzyUGcp94L+1GkyKspAkKt5/ysA5wE/x6o8
G8cIdAx7rGj9PBR0KQwDGvC6Yj5dyVnAGAoNH9bnJCb94KqPrnzAadzP00eb
XdQcREN3gsxjxd5BkkMrh+8mAWXznHfUDhpC6QcorDlU3f+jnnSqEpBa+b2M
2I+yhy3tzqGe661oYfk/P5f+/zp+P6y0sFGuDJLVXyd4jeG6dOiYk4G8B9jW
8QQevNYOk+RtV+0lMfTEdOGmvY0RKGz3nVH+WwqSZ/UyXo5jQPSo8mZs9oJL
Wc30AeQVEE3x6P0XXPfqDMw91NH0gdh9oi0BEn3ARzwpY5JFRM1ijCnZJGbg
nEWmP6vTC1I9bxWetBORje4V7x87mjCyHdwnXjMBFHat+/e/X0fXc0+FXh13
gd+CPZM8VCvoes5B4+DlOZi7+OGLFmUEVGac2v3CmQVUDINub7YwuH/HxV8v
QBvOp+eY06gNgD5zuMfhJ0Q06VjDT5AxAP+/XfeLj+fC0dPfYXgDA3F6ku9P
DmnDu6odlrYdDFwtA2vz0z8iGgN/CZb5cOA4qE99m4ihwZu/bt3SSQMT5rPz
sSL/889V5LV0WnamuuF+z76AfXtEaOlgOLxzIwJORL1g2wpvgsRHvY13fDCY
GeNfTWN3B13mSwGTC4PAIj8Z40BDhJuPerw9+KPBO6B5N7t3GmIydD8xC61B
a4yNWoVEIpQNurzvEh4B93GWY5JxBLhV8/wtjUcAtFotn2+jmgXnMqETr06v
IpnP+l3L1DWwrhZD7atKRMUW2rSv4vugrLdXY68EQazAtwvXyDHU0bpPXae/
C4WLfDurfykNRGekC9/ddAdZdaOPPLjvu8gV0fDHoAPuVb7qe3GyHVSfeGWv
ixOR9zCQzrR3g3F/tcihPgzJW6vPYCG20MNHWzB6qBJGHvTqOI1MI3Nes6rn
dqvo1bOzXdLkrdDnJBNpPFqMtPIeXpz6QUSyYSlvO191Qfb0rwGPE0OgcTZn
8wE9AfXOSQ+k83aBqIDwwZpeDNULX4k7fi4SSMdv1Vm8rYDDKUmTup5TiKLg
Ujet0xqakln6UpDZDIeXMwhLPz1Q9yGTjKQ7GPomZoLVsrWDTt0SuXvWCIg+
GYrP611HZMQfK4+LW0HOeR7RtGGo50RyzthUBhzqWTvaoFgB/LcD44ZJJ1Dr
QqXCkvI6MrbXv5ie2wCdwxan02qeIVnTN+rbfhjalrePG3rZBEeay0SGY5fQ
Oy1OYXXtBbQ3Lsfj61oKre+zZONrx1B/gEqazeg6umMV26/5oQpoa9keNSWm
IbvkP3YVuO5WdbF7KFJTDeLGXgllwYvIxMAnOChyEWWGV8mTHM+DJW7p710u
Y+gYD8esMyUBlVxuXJTsy4ev4ztNyXazIPNWonnmGK5b7r2bmCQmQPYRwXm9
3XHYSc75at20jopCq/VXqsJh+X2z7tsfC1BQsiYYc2MJieukuK83JwN1YbXJ
1sgctIpTH+NiXEFRvKNDUQwJMMNFTOtwI0DUdQU3Ku0RdIc8Ku7m/TxQ9311
lSaAiA6i5pgDEX2wkX0hVIUhDyb4V48aT/TBJKnp2kYoEVFTfE5iqnT8H/eR
33FlSTvTcfSKHb7pjq2jm17bRhjfJ1D88lx98scQijWOzyTvJ6CQ2rTbX3gy
4aLptrHM3jiIlrz77h+yjnSWmFvnnSohd/zk6ScXFmFT4CN9UskiuiCgvCRy
uBag+AoNaQ+uD/SmB4U+xIE6oXeF8n0FUIoj3sxMDP26scPPmV0Keek3PvFA
FVj7vrXpkcNQ7JVxV1fKz9BEFdfjzFANXjJxCfZFqyDbybFyw28GvIRkyAIf
ZUEXM+f26Voist4MYBHG+4fRxNLnEU8TPKikVcnuxJDu4YeWjrjuTe1UoGOt
qwQbkzIjoRYMnUynry1Jj4DgssTKU9LV8Ify6U3C6Crsi3+zKHA/BPXonSAf
eDUDms4Zs9eziSiYKfvrtz+9KJ184rJ/XxpYJTIuqQtgqKLZ7crtGx3oS+wi
r3tSMghtrEiH9U6il3GH50/jevJGL9lY/Xod0MzKupx0LUEa3Utp5Dj/y59v
k14daIEsJ/mgtvAh1NlwmKrbmoAe3+Rmn9Zogrs/jW8sD3Ygg+N5OeMJRCS5
d7tO8GozOBkciyI2YbB1iHMwTT0esRc9kdp+VQ0lnMp3RfsxxBav8ohkyAaF
yitGCORWAMYcUS/Zhev8xvKI3NpH6PR1t+WFM1UwLfj3qF0bBmI7h6/NgT+y
63+u/3avCjRvb3D9HCdC5r0Oz9iEF6iXWr/NEesBqfUVU9m3q6heKdcsKmUG
sbzpt7JLrwAmo6Nrr8snkNaPteemv9ZQ0m+HMa4UnB+ofd7ut5tFPD6H2Xr9
VhCXzVHN2aEm6NF+HMBYv4woqfeYsak59FHUlimeuRYUKoWcxykX0Uy4XmYN
Xj9Ov0j+Xh6rh7Ta8Ey+g71IRFK0oJ6OiE5vnTd7/r4dilf3lxdqVAMjyc7g
nWEiOma/fLi+pws0rxR4YRWFSE740ODCQQzpvSmqt8jsBJrYTc/GDgycL3yp
E14IQ+R8MkoNrFVgOspadvuf37NPRqhXHrJFshq7EZr0FfDsIrscHc6HjAVJ
9Yz0snBQKkub70UlJL3Ke5vehYH/Hyndmj0fdFN4kZx0rBLO87JE5lzEgN9M
LmrlrAm6n5/RLxnTAf2OffrzXiNIK2O5k6dmHTE1mF+i9G0Ht9hpU8OQGfTF
90fI0YOrCKaI7wIiWuDYxu6p16yLaP/UTECnzyKS2Wf7VG+hERY33Ff0xOoR
5aNhsfYqIqK67PP+WUgXqDgUbR6K7IOX5NHZVu8J6EIZg32qTTc8MeWoN2gq
hrbWsS76WSLKDrYvLi3qhtVmqyR+PH+9tdeMu5nxqJ7y8HUS2krI3Amu6+vG
4KXaNS237mhEdYdwS2KoAnKX3l5t9cLA+1lcvVdZCOJio0qYKmuC6/viFE47
LCDb1hC5wRNLyH3qWvtttiZ4GftYJjI4GRn+pdnwOIkhO35rxpzznaDk0R4U
wjoC3M9v5K61r6P3vJLZ53g7gF8saDGSrgWWnsg8IgYTEY0XoeTJJfy8Av2o
H7ZiQFGFzqQdzkbCHb3JD3+XA8eHcUrOdgzsTvt8/fknEyWbd4iwlJTDer+/
GSrHYOIed/YRqlS0fSuH924EggmliRN+nvPI6lEYewzDMnr9Zkxh/GIDKJT5
fkyhUYOkZSWax/oY+vHiXOFr0xawz7xd1fl9GEyTe/qeshEQOWPI9Sd/PoMG
RZP73eQ2uDVy5URXKRFJNF8rqiHF/anEdAptCQY3DcZjF7tK0Z8fu0Z8pWUQ
GNhQVVOKgVLphMubhFJUyJ7ys/ppGch+MXsSX4lBjuFgN7djEeqPXGqkmC6H
iI8Bxk1Oc+hYmv4lWwZ8LggfWzP5XgNcYvcdHjOEousSecq7WRhKtrZvpTpZ
D63D5ukimhNg7dcQ06C0jgw02+dON9SB693u1tcK/eCl+Kin+DIRmbV/KOI9
UQekJ66f/snXCAOtIeFR0vi8PiNlJFBfBy80lgnCThjcXWms57NqQGdPT57m
piiF9nfZN4oc8X2e/Hp+NbkBKZbHVWYGlEBme1k3RQgGL66P/1y2qUP6LKPl
XZsl4HrPfZ0nbBZ1JVoyq6+sILdwQmpNWzFkCM7VTiYUoeLoeySZ9RiSlD5x
PM+xFDKqy1aoNAdAkEtl88d5IrJiH18/YFoG9lTv1hlEm+GQ2QUTXmUMvSkY
+RyjUQLnOSO0zGxzYXRj3Fu8G/flEblwgbwUuAe69EcOFCKOwcYDq7MYsie1
WpmXSgZ7NqV3SdSzMJ5069qy7iry+NEfOHA+Hi6b1p+uYFiFnua3dHk2s+gT
W/Jn1epMkFHmXirOWYITg58Kg2wXEJeQ0v7c16nw3lbj9Y28BTDmrGBfc1pC
9btPFfc1JwLX+DVhqoJ10N23QptyZAJxJtJLBXPnQEjUV0aNtVXwyTT2VBCd
Qd/1HviRX8oEXl/4zaK+AoNi9ijDfA4ZXvLz/V2TCv0ODx/tvcPQog40Zpk2
QDJH8v0b9IWg956hc/0ShugrWfLY/7QBXSFTvQB1ASRQ+n869o2InB+SKM1J
dsO7c8yUc8v50GJfyn9MfQ5dfNb+gfvNChJUYdviO+oBKmJLw+GS3aj+8m0/
A5wP2+o/yfqT/2e/9pyPr+eE+Do8cCR72Ds/iQLtA1J7LbIgSEX7pFQEETn9
bbKmd+mDnELrA8eJmTCenpAclLeOzPTOf0q9MgFMV53Ye2hSgeaQ/8mOgVV0
d676hKPODHDe/JEU/ygRnuln2QPNKvIefxYw5T8LAbF2IQWGsbBwsoR24xeG
LlXGpwT2fQRtirtPBkLfwcUPmmqjfzFI4Eus55MxEV+NcU31m7CB2hpzBY2n
M4j3TMaX+x2ryP9pk+xl3gKoNrfxPXdhHfGcMWl6TDeFdueyfW4n5kKLIb1l
T2M9fBE0bLtaQERBvRysEytdMLmtR9lyJRfZ+MtLBB/GUPwTlk6z5U7YYbI5
oI73e/vRmQM+IUT0rNdl3rmvDcK0+VZ+SWmhv6PZCS+fYkj5nsnxucFW0PIY
73CcwH23hMaMoZYnaB51u1WWXAoGQwGhdGN4XJUFFpuocFDq4qXkIinDeUzi
K/UwhsJr/ZNLHybAsDj2WYimDEYZ4tj3BbugHGbFu9axGIohDCgZNzTAXaqa
Hi66PPTiyWC4VwOGGjaMtJuCK6Di7tUv7Pdr0D2dPb+oAgxJqZcaQm0+PPA4
1vn3BBG91yeh9bo6CA/UlrYsK/PgTkSYa1zKOsSnPFhjlptA7OFem3/Ks4BU
V/PE4mITaMlphn/3xNDelP3luEuOoPWiKddwuhuWjS4lhf8mosS1ZMO6Theg
0mT2NZfsgraLwxFWzBhk3c8KO1LhAGrc2T8O65fDg0SFfL5hDJ7+cTO4g9db
F7bXVDFRCpofvhMGcZ/rOfKL6aK/J3y5Q/sruKgM7g00kPONYsB60WgkmOId
TL6430NLWwXCtf3eM50YhOzJB7vN+YJW/rbeZEgdnMuaJTPOx0BrqaFKozcQ
SN6GdrnnjYG3+VSpFz0BGPfvOqhRxgMTZQPaGBkF9zvhB+huEIBeNji55Gk6
KJ508nOdzYfgpyx2Wyt4/NXY6LH6CBid1tHfmUhCo5M2+Se3MTCxlxtdv/cB
Pqgo/5ZIxHm7uPTrsFE9tKfMlu0dTQO68sdnQvwaYSbaJjIgDIOki6ryVxWD
gXK74+xp00aIE/785RLOl73R0rrFsglwi4sma0UtCgg/xn56bGPIv7ZuEPNM
Al7KjiGmAh4UFrxV3oXX+3b1BQ6KI29h0zrG7OE3LQjc4UgX/IOB7FbBK1bV
cOhz/Ol0sTULpNR2NtrXMfTXs0vz89MUuF5bkf/5rDO6snDyVONvDPZLddn9
dY4AwgR1hJ11KYi9CVeJGMBQmdm5mU9TaTDe+IXyLE09qDHXmS8mYEhQcvG9
ZksWuD+UJWjQSKLScYnMKTyfVUO1NvHvryF2gc8pwqgRuTpO6osHYVDeYhy6
XZoMmQZ25y3pZ5HVs/TrBWKrsCl3I+0FVgoB3wdPy8+twPEIBrPMJ7MIUcvQ
XauuBYdS4Y/nwnpQTbL4B9pJIkx9taczMckETf4QyeXhJVTUF/P9HsMC5DiW
TnusVYDGrvC9hNh1xEU+zb/VPA62xukabFglxK3/ZHU+iqFztSemGh+2w+Yt
f4ZcqwoYLPrQaM6xAOnuzP314UtoKpF0VCSsHs6/U6wRzVyG+A2GDbWhOXTj
mTvVenc93E00Cec2WwM7iYIYsQ9fkAqrcT28q4dw4YJbqyV4/ybk5s4y5oHd
15ydd8w1EChkRrc1uIb26hYi86NL4cHi0rYz6RdoMue1jJ7DYHYhZNNjoxDq
RSZlvyzHQjmLzF/US0Q+YvEjI7s96ISookHWZipkMzVfOaUzC5yKD+gHBFdQ
dOyFF5/sOyDtSW4nfMPg5FurNMqDmUCT/UVR0vE9tB/7uPRnogVe/qhKkEkn
og/kysrSv9qAqrFurng5Gdl8+y10HvcXxQGOv0kRzleGaWK8OxhUPInce6aS
CIzzi3crzoaBJUGyyZa7CeyPdkuIBRHR6l3ZpEz7bshJ/pS+totBlEn0PpK8
D1C12XzmnUgIlIrKsV2oxdDD2XLM7UYGGorUF1C4Xw1JgmLVtnh9nLcUnGin
cRBPmXru4HTOC1aeTK3o4PUn0Hqj64x6KIxmJTbcOhAMyfKHGVu3cL29Y5W7
3yEZYXd+3H0ACbB0q4Xkk98AvP/W2l31gIB8VUuc0nB+9rnMXzODx6Era974
rRgEGyk68dUfguDdPqqxzJ8YslT8Y/30egJ66ysYGiH2AWi+HuwNw/PpjVvO
P6RmJx5qe3Q2qcgdPI6rSQDeP20/5QISGH1Bge+Bwan7QXAxL/1nHD53ynp9
V8TqY9Ds13cytObvwU9FvVQiYAQwKwFPe9zXP1DO8RT52QasZRb8nngcB1TH
8HLRA6rjg6tP0gYBpvHy1MYuhqgjHNL5g94jOSprC06SCBjxv2mdjueTxOBu
Trr0RjxsdSTKsMQVZBjuEv75HqpZ+kDE8K4zwG2Gkf6uQKii/u48v4ehNa4f
RaqlIehPlq9hLEs40BqY7s7jc+Q6G6U3di8eEjUTthioS0EqwzNyHu9nzTAi
TzjOa6OPBVWirpdC9tkL8jK4H+T4dpdgsZwOZE3+pt4fS+FWB4fL8Q583+zy
LEh480Fe2yroAmspHONof87UiKFVSU9NWd4iSE4izv8wLQUmRVGNaTxPR7Hh
oTuWNvAp3vO2ZFIg9PbbPXv/G0PV9FYKNJf8ELlHVUq9WRg0CjGcLsXvd3/+
fgcFXWvxCLKz/h30LuAXJcH9E48zmNVrU81iAgLnpEgtPwSCrL2X4NE/GIr4
5Jp8R9gNHTlGm0G9EQoXcs97W68Q4YSMjwKnRTfij1r9OvOxCIqlfdPbJTD4
/O2FJ/C3IgrX+AJm/WIYjEsO6NLA9f/Q/Z2t4M9IKUxehyG9GBrWv7icwXXk
6Ttfr/Kgz7D6rs2e/FYZuLf1lpPgeRYyzoRswhMIy2c/N14UCBYmhfG6eD6R
UXPsrb5WqLnAa99Z31CwjaQ0/+f79cOdnnbhapbizps8985oOkHWOHvIX/y+
RGXDLeXm5JFjcntay1YgCB7gUf7n+5STLBf0g7YlUNrY9SY68VAQr0o+f6CO
CFEMb35bcnUj20NlyWsttXBQ+IqF1xIBindqTpRrDaEzJd+CfFrzYPMtaR6b
FBES/fhPm90YQGQvrb1LsvNBnW27dR2/7k1XC/5uVmNUOa+hrykQBC8Z+F64
49fNIZ+TnQ02gxwny4NFFKEgSRSQacfz756KDjRxsBDnm/QkYaV0gOdDnYWf
8TjioULYSqUt2trZvnfGIQiu8BNHb+Nx6s5QDHYYuELYue2sgK0QmLOqn/+n
/u/1RkQoMbmhQ+u8SSErQSBBysdZgdfD8EicGX+IP8QQy+7l0oTC0WrbF334
dcunmA1DK83FP3IprVuQ2UNLfrMWFx5HWucgSZ6QD/pp6h793iEYLMeS+pvw
+mf0XhDpOxEOOpnp6lROoeDfezJQ6gQBXVFc5ObwGkM/Pv4y824NgyXCbRlN
o1U0HFS8MUo5i9IqelbVx4NAJPMjU87fFST74PrN+dRZREIsqTWw8gG103r9
b6omwYbOmuHl43VU/bCC3z4iFPrWKLXKKmdBy63OR5G4gv4YHPt4rTMK4k1Y
qG2FR8H8809RIX0CejhyYYUi1hMyq2pcD1HPAFvk13P6DGvo2cG5Q29cg6Hk
15XXOaJLgGWmiWF/FhBrZv1AAUUM6AQc0rplv4aCjJiv9Tyahsh3C8ntqWlQ
S3GBxhPntyMLJZ+eyAejjMuDPFxSIWByNUeDB+cT5UTnZ3ffxcAAbWDtRnEY
5HFspZ3DeU+yZa+PsSwRAo9PmVe6/uf3R/3fwjloz7fsjjfBkfcK7JJeGKyc
jXoGS24Q7tX7k2emBXTPNRklaWEAMXyqV7T+83PUB7yuoHqyLkDO8R3rrBiw
PZv6wPTKCzjl1bq6mvC/p+psyjjwAWn7PT5cVFcNcnzK71VxfpvLVjwfed4a
6GmeistmVcHWyqIAlToRuBkM6A5xuqCwnDeUUZwDsDjhoT2N+/8noboqzxaa
0dXq1EWxiCQ4jh2ZpHgwgKQ0pbMGiwloZsf46puaFrAjaXywcrMRRVj09l+Y
JqKnWY3ZgqNt8JZRMmS3A4NzF7fjN0i9EBq5PWmiUQUH36UmNOB+lUZTgXSw
7SV6S0Vy/k5VJd6HG+vPKDG4o85m2K4gjZ4d5hoVZ+uG6VuWl4V4ZtHvo9Gn
hgpWkCUnunbtbTP0pCROjJ1fRPJxL890ui2iSKd7sxfpG+HXTFk65702NDT7
6dRtEyI6ormUbB7TCYX73/zpsXAC/oa9vDhyfD50Z8hlP+qGcTfViZxu/Lo9
ltZqXKGIV6fDmf5ZJXCRNTkUP8dAKld1c6/VDQkdP7F0VacVPIouFFBPLCCa
J4MKy3WL6FS4QvLL203Aq60bSO7TBabCtf5DzETUj+VvG5B2w0O5CLnQLgzk
hCOkUnOTEOPpxu1fMhVw6IeBU3caBtYvKZ/zMcUhGpH+l6HP6uF0BDsZ5aEF
dGWk8pRhyBLan3iNrFa/Eb5SOBaR3eyHsAuR2WYNBJSfU7e5g+ucQ+qsHwUb
MfA79d1z+WABqpnUrhukKwdmtTmTVITBn8B636MhOSivX3o/E08VZJ+QdnXc
P4+82lJICyOW0fW5ksZS1zr4NR/10YtjCFjreq6EfiCgXFaFKG7WRsjtpBG4
rNICJ+XGTMZ2iMhU1fyk7tdG8Fim5LbE9X9hzt0jAWE1SBd1MKe4l8JyEtOO
4ycM+nh1DFRWK5DRhbnoXskyuBV0nSaSbA6VlKldI7ivoEFl5gI66woI/VFz
vNemG46w0Rz/00NExRJfbh4UrQIRqd9VQ7+qoKMkUKEsHENnlyrvbPJWQ6w/
y5dPZ2ZRDQnzAUqJVUS3yrvxTiQfrgdJRq/ITsOkEKlTm8caajv2fKY0KQbu
oWYq72cr0H116PsLmzkkP/t4d0cqHcoYU2Q2fZfg+lE5V4uEBTTX1XxX/lPy
/1q/65q8FEXhg0jK61TGUhABHa/rf+l8vBmmW1bffmnH68335XOmUG90PJJj
QAfvx8i+51dnfi6jIrHWYJqwOaSSkUKo96qF+b+FnhJ4fdZIKZ/M6g1EVFKX
PZWiKiHEW0fGAMdLtb03SWM/IirRgbtKIRWwyXzqsFALBh6ckud57uei6i7F
g0mvyuHC4ZIt+xwMkplpnE7j5+LPMau2vlkKzwx9a2K1cX3u2xwwfeMzOrGS
RegmKQHZVjm1Oh8foM8lfcSBzzH59p2Il9nvodqe8eFIZiGa7jnkZ7+IIRV6
2hNPJUKgm+2FUt0IhsxLZvq/nYmA0GtJpTf0yiAMU0w99bMdiNeHRTZEMZiO
uz0xMmwJgYJUp5iPDsJKOk3EiAwBna1qP2br1wmunKk8CZ6fQb0r1Kk9kYhO
lrw3a1PohDN/eIKitqahvPjhejPjKpr/qFqmTNIFZ2NqSXvGR2CpUKzVznQd
edhThbmKdsODe3ae6fgc0a6FxIzuYNjM3+hh7wgCrqOq6idr5kCggDEl6PYy
GpV5pa6E99H9NyGmXIemofP7CDl77SrKXLyucuxTB5zm3BJ5hc9lapFdakFL
b1hdeuTMdhbX3QH2ogqTc9Cl5rEkYrKMbjDwvOfp+wzuXGd2mlOnQZ7vk9R0
8irq8Iyd77zTAhnCTmbdeBx6YVXRxAsOIBr00D8L11fRKjUZhn0Y2rszZlLM
mQt/5RhuTpCVALGHzelVHYaGPnBFFqeVwMSjiUPKpCUg7Er9hQVhSNo0yCmI
rBRy+00MGKxL4FjoxaP/6K77JZT35NK1wXXsGvUpXJcWWmzObadhqFTLa8XB
owbkFW5/v5dZDK4lR+T/0Z/vlPMqjT5oooX0tWK6I0EQRE4elInjXN8V+70b
nFB2J/s8XW4QME89npnA9/NqaCmB8moA0nlBCPceCwYO8gPuulNVKG49/vKt
CSJy/5nONRDfhc9lOpPm1fdI3JtacUEIQ+mblozhNzogluLegnI+AVwaBa8f
/ziIrpqbXlflbwSJbudMXYyIyObixQ5Hd8MX66ERNs58GLpO39IXivOCqNI+
Y/0+wAIEX/V554EKnVFGHs4Dh1WdmwV2V9CG5ZzVuG0dtLuOza+sTiKPD/5b
V6bWUMLCh46Hpg1wOdPtYZXMOvoikr6r/XgS/eK+/+rHwVK4FHWikL5tFdVd
P3y76OwMop1I11y+Vwnx+SG7JycwND+mrZoFYRC2at32QKsUGEZJafJHMeTY
SXW78cVHSOCKDRtWwv1ut5ijKe7bd7mnO/9y9SDfcmWh/v1FcKV43s3zQSNs
aFz8yhaJAQlXaMHEmh2EbF48x/XiMzg+EuMcccGA+1G9zmC1DYxcufVRiRgK
euG6tXoUOO/pG3xopu+G7++TLWxulUNCnFmuHyOGtPKvRglWtIPI8hXdGX4i
yuv0yn4YOQDRT+eFOzhK4ERPcisJnv9JzOQiHcMrZFgTtrTvRym8DJEYUMdx
db2tVWFVYxizTxqyGSiFPRmS75HjGOK+Gq10pM4TbOTPR0ptlIKXA0Ue4z//
f7B6eey4fSqoc9cJj0SVQIiEdwddD4bi86LOz8jkQay96MGXT0tgpZbBvu8o
BvaG0lUnHTsQD7o/SoeKQO/53AGjDNy/v7G2Vi8oRB4mN5lKXiO403mp/Rw+
p1JjnGIa3NPQCtNa+8hKNSSnufy+0oBBFlHzFt+ZJFT9RXzxZ2w17Dsy9+5R
MQZPeCeHL0TkIzXO2TcvM6uhqiZlC3D9w0cmuNqimYpi96bPfLevAvZBjYCF
VgwUr4T8CFqKR4GVXIaUd6pgRZ2mNToXgyUpVfNQnhJ0I6Yzqf5YFSxZz61O
1GEQQLHlfSA2F628jOhKulIJnKpDznZ4nFodYYk2rjSUUvVk6RFHJdh4zjEY
h2GgSrhwKLweoQhKi6I+uwpokb23fCQP78eRAyz7wsrQjaCI9G9j5SDaJu+s
g99vgV+amOVyAbrS56TycL0cXhrW7n6UxUDHu/aXYnIzIqvPXWfzLwN1R6Pa
g44YJMzuYc+uNqB0tU2VOsEyuJLbVhAej0Hl/SZid3ANkjo1867HtgwsCjR7
qKKJ8CSkpufoRC9iVbn6kWyvGByZf2hp7BEh+2ZZBuPBLqRp9rSbe7MYHvmY
2HLdx31TzN5qzZMWdIuaEHHMpwQqXR1XuPclgX6rg3DHDoaQHXvJyroXtKrY
igphzWD+8J6KgSmG9FozmAwqLcE0vUwp/soaMrmpeq92cBqp35jMnjE3gzX1
RfNswhd07GwSj2nlGnrC21odfcQFlsw09hhftMIErV2H9QsM+Ukl71c9awUF
CY2E8N4usNhLVF+gwVBXw+Or6KA1LIIge8SPLpA8+WQohRpD7FwXBTiTTWC/
pbzWUNkwSDkQrPTLCOAqNEf9xcsMTO1m2dzqy+Fiiuq7R0MYaJFuFIXmW0LI
apRy7FAh7EkFJkssYXB20yZ9r8wK3FlzM/pc8uDXxpdbI0QMMn3Jc7yIVsD7
8Mu9xJM5MDorsJy/icE4GjjTv2AFQQffZl99mguKThm0XhsYdKlarjvdsoZ1
c5f5l0uFQCarYE6Px7cx6CIp1X8DA94BspWKdaCjuX9Lteif/z+AZDnCnUGt
06JejzoehRh0ZF7fw/063ci1p2GX4SLtiGeSUBcibDK5P2PBUGqh4IE/ia5w
TeiyEPFYCmr9TLuRgfueDJ/mnL4YNxBvVDCuUysFsrm5G86TGGJjWrveIOkC
lL4HNgzNGyGhgPJKbgSG3umVHn3kYQtfb8tGivCsobuKxhKq36ZRms92G0Wb
GeTRxuzbNmiDpH1rmXFyGPr20H2Eq+YRRAg9XhNV7IKKIfugwaMYOsXK56Rg
JQdRYkctpd4NQ01qYPl4HQGu/ZWQn4o0g7Khz4f3JLrB4Y59/+BBDPrTGEKG
zCyAUpGEzT1pEeXN2FS/jV1EfLruJY1btuDo/Dz5gFg7bByhk38miaG3vz6z
/DyiCSTCeRRUR7rhzXrGgZ+UGHLvJ5l7oK4FPy1OrbidaIFzskvPhI0xyJ9g
ZfY5ZQku/j4UMRI1UGrTsmv/GQO7qRymCC8LuNp76ETi5RoQCevel4/jHTbc
8gof8HzOuQe83VtAqg/UlXZgCbH2fJnzNraH25++Gfq+H0DD0Z6f9ssSkUOb
MEvBTTdQzrlAVtHZBv1093Ye38fQhuGdmL4rhnD1MEWevl8H1Fx54RYliCGT
A87LFo6G4E41TUjdW0UHmX4a0V+aQR1WXiVh18xhSp+yofVGDWR7vNoKxvPp
vy6qQhJrAZPCpDJ/snH9xZrwpOALBr/PKWbJeVhBM8O88Fkohic0bsppcxjQ
OIwPzL+xgJ90RUEFh/KBYHwns5GAQWh0kzJ7hTmwt3oYVenmwtruyUZnvD55
R37s5+U0h7ZAjHL2USbw03I2H/uOwUfrGa/FZlO4dyom4Yt3Gnzgu2UgvY1B
4ignh1SnMQQeVNqeHG6DzNoC1CONIbLLdDL7kzTg5Uk3lrG9JGi8qcZQsoP3
F+W+TYUJA5B49/BR01gHuNEYxrKfx9AfOYbHmfMa8ED6jMPv5ja4uuyel4nv
m9QWVbPFGQ2wV9b0Z8XnfJmD8zFvPH+Vj99wXWoNz4tDqFachsHxNl9NAu53
5nw6tw/OvAGBYStjjtuJoMAn9qv+FwbzrQIfFRy1YUN5qg7q+qCdXTJKOZKI
rvg77GMtfgH8kZ+mX57th/piVU1ybyLSNwqSvc2rA1Tqi5KqxVnQp17ssvMN
A1sxvSOXb2nCnUI/Znn1NnAlnEkTkMeQqPXnofpE+I86P5RaefEiDxGdiLn3
6YXjILJkwsTutbwEkgFtLSaaDjjxPVa47CoGO/oX90bLLQAdZo84pFQP95tT
+yyyMDB/03HViMoKvKwIAlR1NXBUr8k6AvdzDGuOpKKOFnA8MM3thEkHtJy+
zi6J6yg0KfZs5qcVWJwStIv+0w0irNJck7tElHYw5EGAqyUEpMS4GmmXwMyA
1I7TNAbeVjkRrSpWwJ2iWry8kg96Udyb3WsYtPEc+/F9zgqOyYwHy3Lkgor/
UGoNXickpzhIX61YQYbeQJMtZw7Mlft3FuC8t9+mcj/pjhXEWIjYF0d/hja7
TxxkThhStW6QEZG0h4fpdVrB59rhle+QofgdDBmGSJotLWhAqdpfNkeVLpBb
alB+iPNGE1dahTfDK1CYfhvJp9QG4q5yuY34PmM6bJdN3j2COLUpOYUzQyDN
P9bBTUZEZnPbvpa3jWG9Wrhh4wcB8X9lqqizHkJ8b/lKXhXrAWkumcGF3SHE
Hu5jJDNJQDFv5J9lKLnC+jXp6PAfU4hgV3iDZ/86kj3dIiWIOUNs1kNz+2ud
EL854eh7CkNPkn9afKHVhOnpHO0Zuh74k/9KNQf3ufmh4f3KmgpQnvtL0kBt
De1WOFU0hk0jVChuIzhmAsVF+Sk/0TrKuwi/uVgn0IiQrMsAhRFckpaz7tck
oohjp4470g+gT7GtHsvO6jD1q+WwSdpH0J9Uy03YxcDiQqJ0mYUuFAfZT8i1
fwS1mbqhABz/OKkTmh6oC0K+/MttGfj6/Pfi/6x/nTJdc0FZB4Yom7b1bn6E
F+ZlmcM4/vTefFclrQ6kqbot3mzD8UGdF8E4HloaELhbog0PL8an0FcmgMbw
yn5aHG/Zd9uSQu4VfMvqM9H8lQxxnMfPseD9i5wCz7B2awMh58FN7r+JYHS6
748S3l+PPd56YXFaIPeHrY2QkoF6hJX3leK8YSA46vBN+xT84VadUBjLha4B
8SU2vH5+PrAmmTHWgAWy+9Hl10rQlplQEc0MBmIX2HK772yKL2oPCNUcn0Ac
jmNLCvj+aenrxgl+dYY3yYPSkQfHEOv7y1c9rhOQRFm9Y7aHC7jUyDJ83m6B
WxvxCn6aGMpUnKSvFrGEuAHyCh6HNnCYts8Ie4gh8sbtoUA7C3h85WsvgQKv
wyLrmiNSuG8N3DxwWtMMzhl5+2HObbBEMf1ZG1/PU+xUd/OrGXxodIg0p+yA
1X0nru1cxdChjhQD5Tw9MEwvE/U3L4S2kL+St5YxcNNlmn2khs+RW+GjQoIF
ECdI+0UY76OwS5zMNuvm8E5ViDN38xMoFNXaLOP9spEr6qMzbwYaQyaPhoWz
AHxaDj/fwuB7r3y9B5sZ6Mjolj+gTQPGB9aKiTjfrho/+WRjYwzPvljIqfEm
wyoHt3cMfi4Lp2Ikev8aALWtGumZ0gTwng7MpMHPMUc+7HJuqx5QHW9Uki5I
gPIOTIMex621ZCurG/TgimTQw53aDlhS96WIvoChoIZzHeoaWmB75g5XVCnu
W8rqr0Th6/1qfSUeOOlCoT9l2tMbCTCjZOH8GMfj2Q7dENnVhl9GArrF/J3A
cUXLzeA0hna26L/GhKpBmxdVuZ9UGywmj7y1V8BQuxvhpLbzIxjbI9CGPySg
2qxaiaSCUbSqkifx/rUOaFdl3qfuXUekvKq50/3jKD2m90bapB6cNMRo7m4T
kOlmLyu91RD6FV7vrjGtCT3uIkeKh1shlb6TSuQphnyOrRonN1tAqcj8bibz
LLrOKp2Xq72K/A/R9p0xdwTfi0sily7PIRqHovvhkSsIu30hAR8qQA+mdIF+
FYj2o77zm34MCVCohjjwu8HZg522R2xzgES21ZV/E0Ply/N0qMoFOE9dcbx/
AsG+ZK68v/UYevMrk1PUzxlSLnAWW/W0gbblg7oz+PzyzKy+UBxjBssvdSNu
FiVAyD4HaTp8376qiaZd+awHl3Jq7zqZf4RHtQEONThubJZCsSKgA3VLhURa
jTbQDPkjwYPznnEPkcUk5RFkeEkbpX5NApv7Qup1+LmfMVRgnT6lDZd/XW+W
fd0P25WXEknfEpFr+liH5XctENI7+culKRm+JtwniuPr/e2mNpnfPIPU+Lbp
82brSGdF3GLu6SQq9rvsG3baEN71lVd+bWkAF4arAgqxGHpmMsI94e4ItI92
Kbe+N8MZU3slWlzP07jHedFuvIbgw2wcrPm9cISdMjKrlgh3I7YmvvZbQYue
td+0z2dUz6KfF4Dzv9QiNcMKqzu8aBJUjR/LQ4knqspGCRhaid8yuxHnBs8i
lNNTHg7DfaWU81qdBKhVKFR85GkG40+Vueo6+sA6fjXCOYIIMrn+XqQHLKG4
z2MunLsWmgLr+o1rMESMTve4QfYWjFPpxb5p14LS2OfHT6owNLTz6aT4jD0Q
rR53Xzv7GVLsiBMs7hjKj7x/V/axDXDXdOTtnWyGt6H6PHs2GMrpFYEV6ddw
SOCip3JDB6iECkZb4X0hdT22Q19KD3YDd/IH76+gbyoXYxQ+zKHOVsf8onfW
ELT0WISRagl97c459l1oEV1o+xn8WNoGVFQLTh/IXEakoPPtstY8yk3Tf7RM
8RpkftxyUp9qgYScM+e7tDB0TKvwl4O7JSDS31QHB9qAb3dX8Q+uo9p3xB58
czIEqTCy9fdnukCpm+eO9DEMdbxJluxJ04SFUhoGGf8eyP94x+/uChGVXhK5
JGCqDjRPqFhJW3pA9taBI6ozRMS/N/r7/pQ6WPVfFKsaTIdXzIYJSj8wIPXz
EKmS1QKRw8ade2XpYPSX+rARjivzxbt9YtACNFtQruYwDAG7aYeuNBKg3IEt
oBU/lyzS+vMKLD1AKp9Fn/STCBkBoSdeC1sA1eHbhJKtWRTzVP18ZfMK0nN/
xS027wBFko5R83s9KKo9QrBzlIgu3L1owIfP33vhjo1PHLqRoOrx7FlSDNm7
vL78MMAVas+lia6mNsDlsu9ThXEYsmwNd6V9ZAfCnU+K3yU3w5+sy1vrFrjO
dz/a/bjYGqpNAuaik7tBL3Lmbup+nA81eHz3KVrAUxK9DEqfQvBqY1LtWMLQ
64En5R8yXOA+y/7xIrxPz/y5/4sf79NRlvbL2RqGELcVF7Gl0At6L086SHcR
EY/zSKR8iSZUH51+QjKTCe/rBcM+4fzMbTXekqanDdsxSUq9Aa2wd/ml1qYK
BvJx6g5CuL5KEr85up+kFbYeBrRSaGIgQ2Qj/33PElQjL3S5Hu+Ci7tStQys
GPAtYX7PJCwgaGfMgfJ6ExyzjPMwCcCgjoaXy2/EEmjbhgqmB+pByLrUtjEV
A0n69cNPz1qCswrbBMH4M/Tn5LedcsFAh0nk5z38uv9bn0v/i/+L/4v/i/+L
/4v/i/+L/4v/i/+L/4v/i/+L//+Mj/UcPX3JkYgaVN20M/T60a/Kx4cuGqj/
x/VUlGeF2lhXgd72+nMuw1nQ1Fv/Rc3yCSb/2/vxdv/r/XgvGo/GibGM19zz
eCqs8BcDb0JR7lczH8CYeATy9CkR2q/b74HjWaVLWyeOe0LOltBXklxGZCr7
xiXln+eFT10NekbuBulb+lMXlSthOZrAX1iOIbIhFd4bMoXQyBLI70DaA0pp
31aOjBKR3oHo+96UpbD6394bdvK/3hu2lF71LT1dAjXykzn883sWl2K6hVyK
N0Cr98nSwOkx8hLqP/nP+ld5NfxVOm9Aq8LHrF/PEpkU9i798zz7vATl0PCU
PTTpK7VF3CCCLh/D85iUAaCz2WN+8DYbIiI5TH5nrKBg1RK+ewfmkFNdgx1M
5UDIwdrANwVzyOqllpQd6wr6+ksi2EWpEIp1r3HYmIyha9lrQ+S/1xGX4uPk
CbIyUCuMty6+3oKOvDuQPSeMoRNq0ZTH6auhmZLr9vSfT2BsMnHrWhqG7Ew6
2RSv18GpslOFd1dm4SH2882C5AqiXKmQTmVtAuegDHvpZyugONv//UnvLKJO
l7vkttIIycL7hGq5CKCZW3JBL3YEkVEm6T6waACt223nKlaJwBHj5Wn7px3d
YXt25YdrHSwGT5xhHcHQM7fsa+LMFujLXdGYAuFyyFXIGPCYwhBlf6KISYI/
etoT8VG+rwSUGZUegz4R1Rc8ZTwr24/8q6Sf5xUWgn+8Entg3jqqz5nUiaad
QN5fNQ49YMkD3WehCbW6S4gy/qFmVMQC+jPv8VbQthyG8y5+rvFeg/QV9laV
gClk6CHM/az1M9AsGWh20hFhf8gp4WPW/cjodWlQ55lGsJDcfs7Hh8Fpambr
tXPNSE6b7enAjzqY3tyvPPYBA9rHAzGp3aXozgz3qySuWpA/tnrQE78vIqGM
7KNEENLRcpsTayoDHmelrdVJDEUdcjApEw1ELfM1Nwv/loCedZApxykMjXUL
1nDPtiMa6RXmqPJ8aBtsmQ/YI6CFmknq+u+DiOznSM2Zt3nAXFrx089yBWU/
A60v1HPoz9lzcl8vVsOrzYAFT7QK2aml5qS208h7zdZIV7sFXMPanydXEiDz
hltavTgeJ6CIpbm/ESiu9WxfxIgQJiabz3+sHY2eOUeXr1sPMbUWYXR2GCT3
ax5go6xFxYHPeWQDauFQmrO6aTEGpH26JvI2eSja6Nw98zs1wEl65I7FKIYI
iDmAassHWVSJ2Y2GlgHTnu2hOPx+W86/VXp8/B16auYaSn21FEiFh4RL7DD0
SSTZUVS4CV24IkS72pwPKfGLAnYxRKT1f5h7z6Cqmm0NF1FUghgQMQACKgaQ
oCKCyBBQUSSIioiggooioBhARaIiWUFAMkgGSZJzGOQsOeecWRMDWfSuU867
q7a7vh+76p665+9TqyY9m+4x3nd0z+7suAP7heqRqfJw+0bzePC5OILCp8fR
IVtlKrmxD8XmMUyHgnA9YVdmPecI3NeguX6IbQjf1i0iT0YFbBb9yqJ7bBIk
wx81OHF24vkWnrKk/mJ48jHw2AtxClTtiTFcVVqPQ969si+/FID3LafJOTYC
9m8NuPZjRzmKhLkMr+/OA4vMYd+3bwhgn9jxQTEXMcr1k5h3Vy7IZ1j3BaUR
4Li997kzbyK+tFdacE7IBvOINSWf2glcUP9+r/rNU8xYvapZ71Y68AUIeHlQ
++HBNhapd/rm2Mv/u6tNIw26X9nYO3UQOOvsV9Qllop2EU66RjnB8IEh7Y0B
hYKVA+FMMtU1yMmlr3WSKR6CD90Ti3gxjrnPmrw2WfXh/cubTLfI58HtYAf7
Ap5RmJFuqb0uMIhNtpzTcLsUHk6u+X30wiTorW6z7hbpxPaWC1qiaoXw9PtE
Qtk2Cvw0Z5HmpWnExlwfy0tf8yCLr5iRZ4YCxifP+E6/qEJh9TjXpa+5YHWE
/VOFHgE3N1F2ulsU4roQNzvDymzgleR8sS6KgG+6GuNdLBn4o4994Y1gFsxw
+B1qpL5v4GYVTk+2s/jKgK3NSD0NzhB8cS/GCBy0Y5GKe5iAI4QkE80Pf+i7
ZSy7mY1A49707fNqX9A89sPYFYHPQDlY/MaI+n9/WXLwvkVnHx5Jm3DXKMqF
vk18GpaaI8DxeCVj6bkh1DV7kbOcWQhbrk+/0H8xAbpvBY7JZffgll3OlW0l
eXDnQekN/UdTYBFRmmZEaUGra8Y9jdty4aair4iPBQU+H6Z3SVhfjy9ObPaT
Z8qGxfUZvencBLzns3R7/rwCN7JW3r/slgkPb1wX17MkwMQyTDLToQCnCiym
0ywygEPwk/phary6qrXlU0HkKzjN9lVRiCsNrtAaH1v7lUAjL92wjPRotPe2
KWF57gviyTJdvHsIXBdx6KSdZxWe3/wOLwhFw66e/smasjHUzOnQmvnUj6If
bc/4mWeCWgp/Ku/PQWC+PrF/a/MIbqahfU9nhDBeUz177uUYaBrKpnNT40Bs
yyXhyzVZMPhYQzT32wRM3D5rmGHRjSwSUru25GRA/Dvni5ZPp2DHm+OeW2Va
0UfeYH6lfzrE0j91OvyEApyH5rxSSuqR28n60emuNNBje2UmRp0XyiuzTjD/
qMTZW9qCr66nwVYbum3rqO/7ynVdL/1PD6Cz3mfX7JwKx614aapnCFTRzhM9
dCwcf+1QdfLn84Z5U//sNRwEFqgkS/669gUbjNxoefkjIHVVeH3XhjGUtfY1
4s8cQFHKGcE7hsnw/ePrc8eqesEke2gXO9sEthYtb4yiPj//4o3vZmVDcEpc
f1rn/AjaC/7cH/YtGR408tLpzY0Cc9i8wpmOAbwQYDuwTzwZnB+sSnt1aAIC
2ubuqMf0oq+r1eTprclgs4ffmdIxCekf6ItohTqQZ/HuevWDyWB5M65rnhr/
OWOaCFWlJowK8ry2RysZ1p6s1HtM1QdskSd2M3zNgF9nO4x3nkgBta0/Kvqp
871AetOLhKZwoP98sBcsUsCrwS3/+zyBhwVT7qYTQZjGdL8iKNMDKp9tKBH4
SUGBwKOd5eE1qDt6Nl1IORh4Dm17wbhzFB0z+A8xzwxi24Zb4o1vomGPWh9N
DDVfJdSGsh6pIPA5sWohaDQGGhMk5qdZm+Gx/KfeKmp+YKyxZRStioJ4+h2b
94UMwMyprsDtR8cw5Px7o0WvKDjxvmH+U9gwrKrfeuCiwzCutkuWDB2NhoVF
G14eqTFYEFecePt+AI+9ctqwKzoWFGpuzGhS59H1AxTWEble/GJJX38hLw6E
Nn9b5pKcgtacls8GoW1ofbp2367peGj+NvjAltq+wys4zq/5mAL2pWsWJ4OS
gBve72BZIjBL5+Pzj7L++OjO71bzzR9At7NFxiKdgj3+K21sW+rwUM1IJt+Y
N6if3KSwODSMQt5zn+RUhlHDa/7SgTMfYc8mQ72j9wvhwKiBiVgAgf0c7A+3
RHvAedx0q3hTK5zbNBo5GTKFwa+ydWJ5vWCK9ctdUcZuyHwxk7hachI3WJt0
ftngC8Ob1xz1fEFga6Iov1ZcMdwz1zh2VSMe4gZzbpv9JLD5vZ/8T1MvNFLe
YlZ41gVmGVTnzcUpeMZ/S+7RxUb89LH4sa660z/q2LVy1lZbosvgRJjdt0t3
qfMjuEnekM8QesPx+PllAuW66tL0s92RI3zquEfsP5+f/9/yq18q2W/8JrD3
zKeA405mmLNC3FI87Q3IlrFumgzLh5E1QUcPJxDwoDy3vLLXFtblFzJk/ciE
AcO4dSZ1BATrfMw0cHEG/+l1bLZdmXBtpYj1OyoXt6uPr3R1gXxGB/ldftkg
P6l+T6CSgGqpG56Rdm5QuCdnc/WxPNh/6pMtczYBM8+0VomOuIPSlLzLoP8o
OB3aPtR7bRBmzWe5ljM/gwWpt8dJvT3X9EdvW+tcXWd2gKpTuicWD14m8PIe
zVWhPknw8sYLU8mVFLg6deHFzq9NwM6fyx6wOxo+7ueavyQ8invAOqG4bBD3
MZnwSOQlw05Sr14m9SodqVfNIW5/WdUI5C4dNBEpHUTmrOdWjy8Xwd4besD4
cAoCftGrX33egsL3Q0VUf+bD1ZH225TJDPCpoJ2f4+3CS7N1voYKk3B9dHus
5flhDJGUfXq1eBhpBdYfLxNNgwZST6aQelKX1JOWItFrTiRNwVa2i6VMtk0Y
aytdEXa/CG5GbYYf/RRQkva6WrJQiV3nHFVfaBbAUs/X4TATAu4pSZw65otY
fJdBXt4rD574dejSUvWkfYR4UsrvJ8gXz33DRiIDDldJLMlS43DxmxLDseB3
2Ou/7XrzSCrwl1Z+O+9FYKl7ylQvFuLJFxMvY+qDwU9UJjeWqtIW6JSUpURb
8F35QxN+23hYu7HU0rx6FOcCug2yRwfwmYvLqRe02fCK1I1xpG5cTerGdgkP
vcAuCmilS0xZC1bhlNj4tgP+BVDDtD+3SIOAHztP8k31FCD9wNPHxWvzwYJy
o2UhngDjjPhMJ4MEZG0NDj8ymAvP02fXWFLfy8Gr5szeYidM7yfodtSmg1lo
YGMKVT9EKj3niz/ujGKZH9jWbkqD2JsuaxqKCRSrDD+TopiDSU5+m5edA6FR
fsNZbTOqXnL4vay2VI8enNKKSm7xMN/nc6e3ZRyCqusK317pxdyM99/o+Mrg
MakDa0gdOELqwANB5o1X1xHA09w5ci23HOfGnxlXcOfDSqYyXX1zAg6/2bYy
TCYPy7/R2Z72QWg7+SLMJIMAlnY1a2GDeJTTpsiJHs2B8Z+WAa+pepjblaD4
7bTDhVMm15V80iHpAUXBkPpeBX5XT3Zy2OOgtYO24pk02Dn1ZrS0k0DxkXiG
s3qpmFWwdD12+CM8en4/c+ehSbjn+D7NRaYTpWiMl26FFf+Hfmsm9dultL1Z
jXMUeH2kKEJ1fxWebjvXFHcP4ZtiHdvIYwJcGzxuq30swMRdciljT3LAw+eR
3udEAmx1DyfzWafgDQ9LB560LBB8l6JuSm3njGPe2Nmn5qg6cf9jvnYaLK5+
ujuWqt+OKa5UYH+cgHnFPhcKF/yo/fb6XduRSZAYKSh0ie1EDb89Bfe2Fv5L
d5mSusuG1F0eZpMZfu8psIvRykvPuQ5jkpZUPF9lw23Jp62vjxHAf/9j3863
ZWjxgm/a7GQWhO+j5fHxIODOa45+rteI0YQz7U7uTFj2X3GhhtpOsXOVGqy3
z+JBxxaOnVR9EhCxO+YpVXeFJs9d9VKNxlOS5ybK1/jCjFvV8dsnJyBJ/lSo
gXQv5pmD4axJHgyRemmE1EtspF4K8XsTttd/Co7cuZU2rdeCXhbmo293ZcDu
trl9B6OourEr/rK8WB3KXLfZTBedDnsT+rZ8kCdAwrVYVyi7FA/Hpv4yO5IO
xudkZeSp89THMCcjIfgV1DuZt8expQHNq5KTd2YJDK8M9xt8EIZCnUv3q6a8
YM2ko3HPxjGYLr1m2+I1gBKa9qY8rFlgQOocRlLnXCZ1zt5M0ZRDjhOQ+b7+
YsXmXrwj5rj+c2EyzPoN693TmIKVdJ1XxgZa0dnhlN03yRR4pTF58ogbBax5
bIT7ttajnlUtL4dPClhGmylcoLYzbbMVp+ysB2idrmN68CIV9tAJ7vi0QOC+
nG97TWIDMc8/LFXI2wOSSb3xjdQbn0m9kc0ufI9bbQTC9waLz3wZwitXkru1
/GNBZSXfwnqdcXjrzcBlPdOHbwPr3qWqxMPBKztPlsVMAty43ERH9e+cJ1mf
6ucngEN8VvVtqj+qVQym160NhwmvA5c/XUiB7GdSKb1UXfHTWkMhzdMbZbk5
Ss7QfABjNYjoL6Ag7dsdz9Te1iFlmauOsc8X/Bknpfc+H8FcjdXFJzOGcNX2
4Ys9iiGgQuoHWVI/JJP64aQlFweFuRdC7ptYeUVO4Om5LU084R/hiuRIrk4l
tR/ckz4d90qBJe8uXnX5JKhbwZ5wn5rfv79W+yYn4obXZR+q9u10gecJD7bd
VKbgfNaKF21PGvHXnK3yDWmXf8zjAX1jl2Zrq2A5uqLh1UECK/qrUUnUFNT2
tHQ//0VgxoBzXgfDW/Qy1L3ZMOv4X+uERyd93u+l6gR2s4OL51TfYPzDmN2y
0taw9i89YEvqAWUWlbeDdzOA18zsUU4zAaYKWqHfd7wDQZEA/84rpbDxIr/m
7UcElNkx6TH2hkBHzk1p7sgC8D9uFmsfQsCv1+c+Bn8OgmaS+5Gc1+oPf5z7
7+fJUMjzZEQpQlWMOePAbLaDa7VsBjy/os0tcL4P6Ft90Y6zA2eFNtYzDE5C
7p7bPg3xifBrS7uVjfYoOkt6DExqD8Ir5RHuAbts2FD7fTqJqQdfLIpahIxP
4MfXK6xF3n2Ggbtxj8KWKLC97vHlcdVK/BmNu6XC82CM5Fj7hy+SnOsjy+nj
XuO4c533ltsJfagRIvGgMfUzsDoHcB0cG0NXDlMR16FUeNO/OnW7cz+suesD
GduDMa6RtWrvRBlK/LwoyniDAJtOUYWpylHUQL1109sGkZdHQi50RSIck8+V
67kfAhZVPU9yC4NQX8/2PP8MAadqO6RNxd3wx57Eyt81dVi2XYehLpMCEzIH
h2lmKVhRLCoXsqYWb7enNFvdCoIm4Xdj2UEjuCdH9uYB2yE0PZxocXZbBORE
ukoLGtbj93f33W39KPhptp7R0TTsX/wHyYNJ/vQZJ0tE3RScueDBQt/RjI9b
DcISn8XDw90fLjfRTsFYu7JpYE47Smw3uy5y8TNs03zQUhlJQW4WmZYbkvXo
+0CKVqHHE6olV068gWHk9hO1Pr88jHFKr/fuKPeAN91NGwJlGnEx+7jSazUK
lvO6W2Rfcwarv3gqycuB0XhBh8C7jF7fN+4vhYE6llvytnFgVhq1wu/tFFaZ
embf02mFF/Zy0zlbwv9/q3ufdV3Jd+RWJaxaz6GtLE2g6Wxg88TVW0Bx+cPp
SZ4684fTD5/yHLjaArq+qoRY5RRuVWGeV3n1z/fS/m/zJO8MxrVteWAlm+du
nE71BbU3o66tsYTKHbQhmS2pkPEu2nhTDwHCotzj7csWsJX933kzyY1t9+kP
Hk6G5DXIrTxMQKuoBwP7refQotUgRzOVDwK3NNd4fSagX99cy3SfA9x03ibR
FtkPqZLnhuhGxuDk3Ks4Cd0EeNbq8a2w4CowRK0McVgiQNY82uR4TyDc2b1N
7iZPEYQUMnc0uxMwsUpNqA0CYWfW7jEr42Z03OJkFds7hY2uvzk+LiTAHpI7
kLyF5BSKqtob7Sac6+bJ1dCJAUOGpmMSOyjARryX5GxDPDna3hkYT2BAu7i/
kGccvCuP+RC8WIq7uXNkD14lUDstuzNoLBG4jll+SHtXgc7GG1cR1LitoENJ
d1ZMhZHNI0Nnu2OQhsV37zpqHmuZbko4ZJcE37QGAgpWv0aFEM0NP6j5JP/Z
z+bdGdlgdD2l3Xt9ODwI8Exi6SXwa5nmU9mkJBj4a52ClVyncBFdDL8pUwcq
iVm58cYUvP/2KofmsQJoYWDsrpAKhFvmY0VhMwQ2bts1f/RbCDwMCLVSjmgE
5t16suI7KMgVVKhuZpYJEuQ9gHzkPYAN5D2A8yl9wmYlE2D48MyIllk3Dktn
3PzwNR/Uft/VqnjQhPMiRPBtRgo8eTc7JPU4GVRIPktyWac/XER6VQLlwQSM
hnpful/Rg4Mqswd09PJBnTx368Rf527NaqfcT7QncGeL7sd1pxBCNx2s/7Y6
F56GuogbpRI4dKHy5/GXCYB2UTHiD3JAQ+ZmnE4KgRt25PNck0+H4xls8xJP
0sFA3icmppBAebXtAfky8RD9O381771MYN30+FpWC4FGnTN3H/JegLOpbreS
1TJA8kHy1btU/ZPFJDsrPvMYdum/9w/iSQPWjQaaH6g8xJSRm++AM/LujDrL
VJwK8nsWd9xbmoRDM6Ycs1/bYYGo7+Y0jITR9l7LqoBh/N7dI7TNbBivKCdk
0EMyvH467sNaXI427CrfdU8QON2j0KpvngxNE1XJe+9H4HbTINaVjVR9USyv
bV2UBj8DaO5Y5eaBSvp20Xg7AtXn21LVa7Pg9akePm3vJojcc2CioW0Kby8/
H1PZkwe8rqljlPetEEMXO8/KNoXNs20HS3KKQID0xbKkL15H+uKB53nKdc2D
8Ikz4fhFoxEs3hBt/4WzHN4sXTstsasfvAKDrm9aGMOYO/UTWZsLQEFGYMHl
9jhcYitW+qDch1/3MOzlZSqGaTkaN+Z1FJBn41hRVt2A+97G8X3nLATGxsfr
71P9IJRy0JxYU4hWscObjEbyQC0sPS+C+j6+192p6jEN8sKbWJvuFYBiBpfW
uiwCBHZLe/K3RyEWxN+wVsgFJZI37PrDs0j+lFlSi0G3GHp7hTOZLQdQzkTr
He2XUYh8kF/mazOEanzWusK2I8jcZ38g41QKKEgq11XmdeJNl7BW76uTuEk+
+f7nrBxQJvkNkm8huY3fyjt0GQVYlsvzrU+F6kcr1paPzuWD7sPRFBHjfLS5
rmF+QZHAR7/7i1W+FkL+syMzVZYFoHFdJ+B/vtuqy12TfGKkELaXJBsr5dVB
uU6gtQoPBZcpwMJ6qwzUZ7SjY373gm9l5+fjhuN41Lt/NDGnFCxuvlt+Id0J
ad5mj0wHJ3D+jP6JjuOVsG6z+qETjqPQvi544FvqAPIXAdf+HyVQohefEho5
DCHCWid+fh7Cr31HQvFGObSTdYmPZF3iPlmXCIgqp/MzHocC1T0O7YO92DMu
e9PnbRm0vXGONpOhwMnFSNpL0vX4LcpoSwG1/c225lZ2XwhcOJddJuhmB1e6
ncs+HMkGS19uPr4aAp903DGkbdaHt/NiytJDWdCctdJPa8MUVlw3PThs3I4C
h7fkiLPEw2e1zGO05qOYsCAy+fTyIO5uE78cfTET6k69LhLJ70L3t1rPLrVO
4I6ttur8o0X/wTlInnCtdmW8miPI5KUyVCoQ6FhsSLGxqACGo55Waf1xUP+l
+oQdL4Ev9nITnMJVoCN3Gi0u9oIl3YELij7juN/pUVsXVEEE95bpS0xjUDx8
05NzoB8lVM8mqEiVw4q9hYk6FQQE5lVmv1P3QK4OluTvCdn/4o4k5yT5m4pt
PGp11DgrZFQW6vUE31mtetAklQXHbKPDNtQTyFLIGDS0zRDtDjvu+8WQBaEn
he9X7KegcaRU37f5RuzQ+mm4+CAe5GNGz7z7NoZ2oobu9Vf78dnvF+Jb11P9
soOJ0LnRduQ6XBPErzCJMSNRCQqUcvAkOQ/J40ieK50l3G7/BR4XKuR57qLg
8LR4Z8ipGrjHKtahV1cHbRVqmZZJU3hQwGelvn8NOJx7oLapehDkNioWrj09
gh38nY1nqP2WkD2aKNo3DC57xowpF4eQ/2TWcYNNlbBC7OM4bTUBG0TaA6W0
vdDjvv3qM65Z/+K8JP9A8g5xuhfJDQSWP1YUUp05idmfaA71uWeC0cCv1RLU
eLfTP5bdpkELBFS/6RbpZcICzRdfrWQKBrXTZWS8q8PElWL1Crfi4ctOWv1l
+3Gcjf59SPBBHx5sZmtS/I0g16S15VxfE5qpdkRdFZ/C3zrz4gzyVf/i5n9x
VjXu2549rTBVI5DO9IIaB+5uOKISVw39ORPLm9za4U7aqSvN3JMYNJhSRJn+
AjkGlxJ90kZgwJXmRZ3FIHYrNz76mFgOMaXM+0+ojYLfRrRJ6h/A5QuLGnIj
pVCyvF6zrYqAl+4JLK93hmHb+StDP+wz/8XdSN5C8vWR6icmqf1wxFy1qaPV
AfQt5rCCJhP2t1RQUqj8pKpSx7KeK9BIvizV6M0A3VP58j1LFMy82iC6gqYG
R8ssCzZjHCjjR1lx73HUXFbc+1S1D3n9U79tLUdYHHtv94C2DvNviNC5bqdg
y+nEjDWzFbDwF28ieZHLOZ/n/Z0w8UP/c3TeBG55O514aagC7C8bDL/e1wWx
mwof0uVPYPBnqdDfkeWgQ1ttQHNiFLY63uJV4hlE/sK2OTrlEtgn6nTsDGUE
fmvZjTUGDKKLxOj6EU3qvM54VKZaQMC5kDXDLbcTUTr9O368nfEvrkFyIHmM
U4+qMnUeLfmaDNOuCIawRSPTkacZYJM9IjlOjT+yuiW0VlVhEDdO3BV7lgHZ
sn7jFpwEPl185K42UIUiBkWn4j7HAo8ene6S7DgaHrea8Bjow8/ufnOze3Mg
rclafa13FX4+Y0b/8DMF+e/U0Rc8K4GUv/gBkkuaxlSUeHYAk/uVqXXqk2ip
tSXncVExpB06x+2f1A6qK6wSpYMn8fka3fRzqkVgO61/WnHzCBS7vhyLi6bO
I6mWZIGwAnDZq9glSxmC4wYRBUWUYay6RCQYO+WB0kbOYq0gAgZPNEuuts3F
XZU5wQe+pv2Lr5L8w7lJ7lnaaGdeRKByRrfkIlUXCbGodXWoZ8Dx+xn+16h6
iefQpksOcsngXfh18yvPLPihWP/p3m0CvQt0MoYhCWQfrjBmWSgBcVEDRbl9
BG7i81llrVuFXIPH91fbRcHZr+drg6PGMPpzQMvB7n7MTkkO0lNMh/x19J2a
1lXYFyWzUDxJwfl1k36P7uZB3l98huRXlvfGFzE3wyzL3OXloin0KjrpvWtT
HniforyskW8Ei6QazlAuqo69bizVLpgD+6SW+EFiELwzJsN2W4/iBYFTrfV8
OfDZfiOj4eF+kFBzN0/eNY6BTQLvbnqlw+rPPZ9HzhCwjxiIzMkswwqu/NTQ
7ylAR/KTJC8mecayftoiVcdf/RCWX56aAQzW4nNHT5fAfOCTxudUfVa644Hw
kZk8iNU/PnV7uhiKmXk82NgJtBx+/qDJ8AveFLwVf+VGOGgSJUwPWWqx8+uT
uyFdFOztnQo8nZT8H7yT5Ja7Q2TaeCpBwzA9+ewBAgWTf7JEpSfDO5G7g1PZ
JfBg9YLGINXvstE03mthSwQi+3DBZs4eYDu9gfF82wSe6dXrTxVKhtE+4aPn
fdrgFy2tk4HMFFp1PlQf2RoHpw20H0YdGAKLXdfHjbpHkG5LnsPL5STQJeuH
G8n64Xmyfih2qXGveGsv6C11VIbxTmDvPZ2Du7fGAH+uV4HA0W4I5336+Anf
JCrqbGt7dOATxJJ1vwWy7udL1v02FLydNo1pgNkVyqrWj6j/d+umLysO+0Ci
7ScNDxyHlLjfVpnafdi98ELURT0JataX8J5tGYLnRekX31wewX3m0UWXBKLg
8I+r/FV7J2HLDx+7h4zd6N8waKZBSYRI/YHcucIRMI1IHnS7PoQveweZBjWi
YKQVojXkKZDHpa/TTt+IR3NkXmcvJsIgyRtILkDyfRYCB33FKJhQrX4y3bII
4sy2bnqiVg9VSo6FgZ8JNDxwy19QjxoXDsTvTchOhhVCM/KOpgT+kqY8nA0t
gvZTdJ9E7ZPgwtfZ19NvKCB9amcC88d6nOfyW3HqeRIMHbTt5lgk0OHWt09P
+AMxcscTMdaH7kB/nLidatqAqnXB9H3PKdi/uvoQTYQv0JH3cSuR93HvIe/j
3mimoF3qOwalTPPsXBwDaNoolmu9NRoKPfSFGrz74BW/HbtJ6jguO0wNvzHz
huifL8NKn03Aesf1lTmXelFOrKL8ql4MhJCcg+QiJN8wfmqlVM0AdKwpVS3h
GMO7K2zo2HJ8YXnsDx8nuRDJr2j21XcsUfWMWg0tfPJBvSNSi/bxrv+f1R8C
DX23tO7uABEdzzdrFifxCaMx5T2nPXjQ3GnSHh+FKV7hlFCGQRT1PGbBMBIC
vygUKWO7YTi1oT+QJ2kYEyNcrskmBMBVnkHz/Tvbke+gj2ii1QjyWyaxBqv0
wfFrcXtX5vZB2nn6qKmAcRS690yTycMVDBinB9VPTmFUyGaJiw1tIHf+UDbD
1VBYXnoQvvCTmn/NnJzO13pgQtRIREOH8/96HeZckginD2c2JJow2Q5+IaAI
GI8W3LX9x99D+DDDZcsYMBJLXSf0nQCOvalhHIeN/vH3VeS9XUzkvV2C5L1d
//T7703Vt4bYh1DsY/+R/IRh5N9jeeXZlxpwM5RQUO+qgHOOCkwO5wjkal6y
/TJ0EtzWZp4/u0xgFHMG4+d37hh9/9eDG3f/ed38v+U1958fkVbKgJ4VRzny
WwiIuCKjdVHBCDb/dT9XF3k/16K2sg3bgyZYaW+u8oSXAs2HfG3Ntd7CjmUu
s7KOPpCV5jR+ZDIOuZuil2PXxcG9S1a/99TVYtHQwyC3JgoGM/1oUraOBLNe
qaCkXSVIR89wd5cxgTferOesKY8CcDiMqydSUXRdzTN/qg8wfRt0+MSFWGDx
6zkSl3kYL5na36ykEBhd8IZewj0err31o+v6REGWvInJLN9amLSv7VRfifBc
0UkiKJHAN/QiLls/pYKGRJSeVE0mnHaP5dHsJvArm5COq+ozCGTc4P2dKw3o
bCSG+X82Qr7rROz2xiksO9XGWB9ZCG9+eQU+8iSAzvZW+pb6DOy7Q2l5/Q7B
Ie32ZNn8EIo7TznRbBvBr1JJF2NPpoLSX754M+l/BU6+c9/sWIDdoORxnepz
n+2R+aT5rQD4EjK2pGyvAIWxF3khDRSkyX7xouBCCTA2+NwvetICC08MdIQY
p5DOq0Do1vEKGBCOcpT5PgRLT0wfmN4bxl8Sa8uMbpbDe9cPhLASBTcaHhwu
f2CA+/lOZQXYNMKXTTWZbp0UJBolqufO1CJ/MrfmKqNEMNL84HXp2RRyOd6K
0g5txQhn4TwblXjgtd6xtzpuFBedasr3sQyiZarc6PCRLKj9yz+yk/7R5ONd
cXlqu93iaDtP1NqiJu1ivsCBOnDaPsF3To3A7oNsii6CZVi7RXWHrUoCWG/Y
m77xGgXrhy6zHW9rQFvzXf76DvH/4b8+k/7r4Q6PgUfMw7Bwz3Ywi3MYm24f
rXUpqYRwTaHepN8UfKfpnPY19TmemOr4crCgBqbjV94e1yaQfe00n2BDAd4c
qylTWJEHX1kbmw9UUXCDxhvtT4O1eGGwLTfncjyMSQQqaz4cR/eNt992uvah
7+G3W+hl8/7D79Dc/+N3viafP6vENwqcdHP4aO0gSrvMmyg0lkGFZMTubhEC
s/HIj4VDJkCobeP9IVkFxY93PBgYIHC7m+Ibj+AkLN1rscugOwBm3Rn2f15N
YN9jpbW0atVY+W5lte/pODjGVSQUen8c05uN5FZ9pPoyuRptY5q8f/mLgr98
h3jVdZ4uwVGI4TxO8ZMeROYizt0bNIqh03IwIZPa/1Z2kYcCgnygs2UwlvKo
HF7p0wmnThGIiwVRXOviMFCkYgdLsB8k+y+w86wfx7jwqiRP0X6MqTnpZj+a
DUl/6XY+Urevz1rIaa5oh6wMOcH7bpOoX7/ct31vMazYo+oQ5jMMXtbOFUOi
w9gZJBwj8zEfttllzrpS/y/77b4q7YYYkD9OV/M9uRSGChTGY74TuLm6znZ7
1SeceHLCzv+SDxRnPU/veDqGl4yy0w7xDSCrIkdVelAa4F96eJbUwz8CLmYe
6WuEJs5+i2kaqj5cdTnoa2EuLN8UPqyqNAC1/dwfHpwfQzP9YJXe4UzAwiw2
+zmqLt0Vc9jjawhOXH+x+fWCJ8jIWI4EBoxitu7BDuFLgyji8LN6FUfCf+jP
LlJ/Rl3XiX5qVAafUlgkNikTuJpVZerynSQ4fF78p9GTTvieFu3B8WESk1SP
XKapSYCOsWohddpe+FjHx9z4aQIPF+55tX9LFDA7Ku8v8iUwbk3NvjrRfODO
MDhqdjgZjAW6W1qT64CD/Szv/lwKwvcDVYUBHsB8SD916vko0Ii+MFp0G0Tx
H32HriSE/eu8SjbyvMpe8rzK/zYvNLN/LfPkaYSCrc78pqoUePRWum80PxwU
dIV/pxxNwRMJ0yYb7Qk8PDXpljBXALo0J8SvhCSijpFm7sUhAit0Dk7nYxDE
nP3hvfwrDFU17a5u/0HgRDC91/fQQHjpvXEPY9UbtPnxQSeequ8sHFrpVOKC
4ExNE9MdohwuLwwOZu4nUO69puXPi5ngTtbDx8l6+B6yHi4QJB3FtoNAXv3X
weMNR9H4Bk3VFqZqeKTO4iR2nkDKqO11o3vOoJv7LvVBdAVcWbLcK3qLQOiR
3f1zRSjcZ1ZhHjUvg+Dfmd5JBwbgW7FHL9iPod7lfCs3xgRo3bL/zPzbEfSa
ftr5LWAIzx1qLN216T/X+8LI9T7mpQjn6jW9UK0nsVEjegLVnmacUOMKgaoz
w2+tBQegZPfptu9uY3hnaMFgICcU1hy/aTi7fxgWT3gaW9CPYEeyo4zVZDh8
Xe/NtnbPMIpeOa5myjaCDd825/3ucfuPdb1ccl2PQZz3tjddLeRf5O+yWaTg
47G8ncfK7cCurkale00T8Nv07RE/Rs0vwUrtFyPfwoVx682CvSNQGDH9sPzM
EP5WLE9YORv0X4+T4s3MSwRNCtQ+/NUoMUiAjL9Nus6xF+CuZWZ2lT4JtE/5
tu4ZI8BNR+rRkecvQYnRdHYqIhHueAXa0Y0TIF527kvcFVM4JOzeXPQlCbyN
NrSKjxDwVGjDc14Wc5j/a73MkFwXWyofN/mlnwNMLhm298oJSLLIC76u/wpO
e6dyXSgahJ7Z1U0F0qMw4fQmWkYhHkosaeq1vWqgk/1XcfsTChxpinrkZ1YK
0Xnysat6G9D74g9JPik//KB+dC7uHgVqvP59fHqQ43Nk3ezyiEojQK2qfcRx
CurnnDjjbJ0MH7Zv65x42gc6bKOLIR7jOFze6PbkeDZonVvmhgtTIBi4XvC3
SRsIS1XoKbp8ghc011/1WRH4tFSbd190Md6rMtb/IR0CgoxhM5BNjYfMvwra
8xHXPJB0ZG8PBG6R/GK5neNovdm315alHwWGzAL3duQCTaei+/pL43iRIf3A
RFEfbl3/sIHxNILp/mPKrU7jOEtx5RC604eqbe81zu3Ig5wu7W+WVL1+8fWK
Yx1yffhC9mpuKFse/DTX2VthNY7yWV+FEk36UCQwmi/mPMIjEFLeYTKO7Ras
ATZv+9Cm7pe4WEkuVK42Gj7ONY56C5p+07v7Mehz9y/HuSxoEblSO7tiHLO3
chwUvNKP6VFSK7kWMv/PfVf1v81fFXo20k+WgSJ7zJyWEgEaSh4qlsEJYOj/
Lq/+cieUlJzU2es7CSa82wJ8iAS4/ZdODiJ1cunUarfKzn7cRdEdnC0cg/Rg
kaXs2HiQFnOn6WcjsI3FpU70ZSXs3bbR1fFiBhSWzxSu+zaG80x3mpb8E6H/
EH9Ni3s/7GRJPxtib4XxH61lWR+8Qhrli2GXfxOgdk4mphA+4Vz1yJVn2nUo
0+61kraAAj/fuzA0zIyB84GE243R/Vjy9bquzpkQ6nz7w41JPkTy/2v9/0/8
btyCA0WxFVzePZim85nCra/NL2lqPYZSySdnvdgG4aHinMTQ8Cj2/RxMFH79
9v+3dvqZrRG74xWGj+xsHqXME8CpNOuoFycFPY+LBngUK+BL0g/R4QsEvFQW
sHwiYQG+xgoznCV2kF4YKjk7ScBmX/fzhgcSoLctOW10VRHu6UJrTlcCbey5
/DyJCDD9NZfKUJCK1vEWpZytVD14NqGipjQMHv7FP5N8/4WtOV3rP2C+2+sn
Q1+pz7nS/fqWYgzQ5tmkpr0IxhxJ/ZdC1Pz+Kkj9boJaKOwh16l3hf1Zp+4n
16m7Wi5G9oQMQW2MjNXtsWF8XHCC+ZRgCdTTqfW+T58CoT1yT4OtW6C0oiec
3vwTvN+m01KjQ4FPlJ0fwiIaYLOqiP1hiShYwX9WeqEqD6T67IpWvutEPXkJ
3ruXJ0HrGqWIAtR5ETn4U76uHLnoKyWXpZKgx0oDD2sS+LCOvVNRuRQ/W6nE
9A4mgvGzTEG3MAIXSjt2hz4uwLUWq1YPxATBrt/mhgpJBK6VfksJmcrDM8dp
2+5dCYLR41ZnBKsIVDuk5NHtloXpnFVMShKBcFFxcx9zA4H80iJrLZ0zkPcJ
C/3N6QBQ+NGHGlT+OzFzZFeuP9x7tcYiOCgDONfqVTuUUZ/DX2fzVfoz+I/X
Cad4Z8CTpGjKuTgCAw87lbMcTYOCrM7eS8pZIEXurztP7q9zIffXbSbzfh6Z
953IvH+X/bQWf0cH3GK7xtZXNYkiFuY7PPM8IS31guJrqRa4xrjCvbh6Cls+
uBf4nHWBVLJeJEjWi4LJetE/jc8jpxucF7jqoUQ8T0wxnoIyVZSGjBrj/3Pz
/X+b3zQo87PfGQrGLMKRIQsEHFv3Ppzb/i6sPGzJK9dVDbWv1blEZqk+tUso
pEw5CRxIXkLyfJJvJfeNnCP3jeST+0b2SfccO9UzDi3bjzKnn+sD761jEmWl
0XCzLk67/ckkbNrzRouPswuc08Ve5qhFgcbNkugHOwks+ur2LMSkHPKT5ZrV
qT6oJbs5u8exDJrpOwS01Eow81VvfdIIBVh+BWm5/4/fPMde5BvQh4sbr6Xl
ViKE/9YXaGqk+pk8wYllz9ew/dr5Pd67M2Hc7/PQgvs4nijxbn94jTq27SIW
r67Jg3tCBStS1cdRYdW+rpv5fUjJ1j68YzIHNp0Z3SLcMIaEYl7O3sB+tNeS
OHbSIgOifY6soaMfw1DfSOJg2QCmx9F4PHyaBHvufchs/hoLKf2cW+zHCTzz
YmttQ1UYxFRdfW+zieoPGC9NfZglcJJ28wW54CDY85ZWg35VA8Qu7vXPtKag
8VybgaBDOFzjY1+zyqACjm2WYx+l+gClo9q6tEH+IHVnt+axxVZYzem5JeHR
FE7eebV94Vww3Nz2VX6d2CBVdzKsOF88ikpMrqIOMiGgTHILkouSnJesM58h
68yXyTqz8I5VlIUNg3AHe3/Vj4yix49RdZbHgSD1Y9U7164hrPuYwB2tPoIM
7Vzl51+5AH/JNd5LGkOompB+vqh+BNl/OihW+TnA8NNcjwtH4nFvSQURTiHw
u/b7nq5IJ4g+t9te8GoqWrAa5Cv2EnhzW7DX8OAb6MoTMo1zzYJ3R5ZeiNQQ
+NpIPXwHjQs0aw1n9bwthtdNe186OBC4vVCEdmTSBm7OtnywPtME1TOpuq4H
KRhV6Z/Yl2IDQPJGkt8mefCpGqf4c7WgPXb06dZvFPxh/eD60Slj2Jp4+HF/
SBc0jh4+wqQ+iR12nMzme11hj0lUYSN9K+xTab/gHTGFxV27V9TX24JWHk/0
Ovom6DEZ5HtL9SNJ0U6QEv3P9dJ/4uvvpU5vvDWJGzY+d8150QVJjySHdClB
MMN3NSv47AB6cymeZN8+hhlD9ft/FRcA/axouORvAiNfr4cL782QInj5xDEn
W3AWOPt2y6telKv/zX9GdQK3nmD70HIgHnb9tf/t/93npnK+XKzMagJnJPa4
0B7rxRm53u+eb+NAkidnbuZ0A35gPuo8nTCF3qX3r4VtrYJKGX4zpsBqzIcL
spIGFLzZtVwcu6ocUk0Hlpa4CJTqGG97UlKFPgkrXsbWxcArpsQvat8rcaht
exBbKwWZykvWMlgXwrLRLsGeXQRml7QfuldehVkNwp398pHwWIFz3c611ejZ
31idP0XBW1O8R9d5ZAJcV53n2EB93+1SixSFanz4+afGzqZQ+BSu4zJwug7n
5Ll2f8qjoMEVNpqc7M/Q0Hat6pH1BOilql9JhF48ZyUfdtU98h/7v8XFVrpR
tg42WevNOtdQQNMm9uvhUmNwZea9lH4lBzrTT8dIUX1Z7pe0mrPfHeGDkG64
om8hPGHRw2Y/AuxyRVp8NnkDrXwo24xWA5xgONLb+YICA4uJytqlITArnJ36
QkcAfa/PFrVQdWr3WCHL3WvGUO+i6Do4n4Qlo6ybtIep43/f0+l3ZvagX217
JHNhCmnUXvVvmW+Ee/NxfBoOCKj1oIFPaAolby1djfndBnKy45BFFwNFJN9H
cnqS/7fj0IF8r6fke90j3+v3o4Grx6fKIYQt1Mz1IgF1Q7eCQjg/QkkX927H
O0ehp/2X19ZfBEQecPmVvskD5hnf3WhxiATrtEI8/Z2AizTKz2n0vIHTxMan
i6cCqgydlbcrErD96dBCh1gw0Iz++3kOtPv+nOew83KdfnnwR+hnXvgmtESA
hKVu5xs2F2jlO8/t4xcOP2fjzE1mCagpzHjKg27QQ/JlkssU/eGGh4TfDAvu
QNaps+MZ/3NPYOurL2M5lmDuZOw43ukMJlNSjwWpf/eWyoR585p30CXPIR+p
3IB71ORvX8x0hVjb2CMPLClAQwj923PEyOfM/+Wvy0h/rdRNv0P7Mjfm+Nma
lVJ/v/rznOu9DeYgRUm6TM/yDJiUWRs4qfyUCseTq6OOoO8yaDFhMAg+M6dc
kwfeQ1lOyXbhj6OwS1jwYbREItwZesTQQ42TfNqXNBUiIkHVI7AsZHoSAvO+
y14oacPdJzxopDcUwAi5X72f3K++RO5Xl2kWfNPQMwKl5xMfmg4MInF1Mna+
Lg9oaC//2/kVOv1/zq8YrHyq6ftwCo8c6DT4OtwCsdttkhRGc0GK1MNI7tsc
JvWw8cF1FwIWpsB7vNXiY3IjRorPp4lx5oOtBAvrmDSBpRE0OiGupZBQoG7o
kZIFZiR3/PSHp5E8ylEMDbo6cAf/w8K+9EnYqfHTURQT4O7bP3yC7w83Jfkd
BwOZZ13UPOHySra2zw5SrVwyQ8+kwf4vqW+7Sgi82vl5612BRIg23nnnGVs6
5H2vTBWkxgfuHENV4YM9KCHEXjnxpBBqST6S/YdLkpyydUxyy5cSCEkPlf/J
NIxrb6WaG7wchrxz6Vr3CgdArltn5SGeUQxnzeT64FwFn0UkzLmz4vE6ncAv
1tvUdn1ml642LQVjZf21YqyFoB1Aq7Iyk4LELptH7eLVEB78Orz/bRPcrTyT
Mbh5CvM5IyZZ7WsgdPeR2cwWapzUEtjRsT0djeaCm410A2DDm7goBeo4YIzm
ixzjS8E06fbg4ccf4ZS2fBfrIIH3a7V3DeUmoUPICq4PU/6w9CzBOj+jAyQr
vjR1EBPowJMZ3xJZBUpqH/qqqHHnFt3BrqhPibjJsdL7wGt/WGVRKF8zQeDl
RMkUJpN4XMkeRXPMzQ+2dM/wr6bmbwn2nfuLuj/j4PG5VK5Vfv+RL7zIfKGU
22yy7VwnMESdzfrCMol7FZ5kO/SVAhHkOZ1JEPjs2deZ83tiUXYu74NtgC9c
q9P41PyNQPXR9XdXl0Ti5heV+7eF+EBXpEGFINWPMQky3zAS/YSuskL6oit8
/pWP8sh8dJ3MR7V6uwsvzxAY/Hu7/NricMxxj9j03ccbesZVw9TmCLztfymR
nyUUn6Zv1Gx74wWLkQ2vBecJnGbSg8WpYLy7uZTHq9LzP/IXA5m/zro6MdMs
UPt/Oqv5YmgQRl0sv89z0xPun16YVKfOf1/vo0U7uz4i72mRM377PCC6Unyi
m8qfXxGQsj3rj6GEZ7qfijs8+ivfaZL5zlw5veZZMgVWmLOz7VOrw8CvS/J3
HZJgQ6n6KdMlap447Lu0u8EHt7+11jPr/QBHuZjM9X8S+ORQ/jdJdk+8lRpw
5rqNGxw3LedLo/LTrhxfHkl6YGu6G8+Clyuc3Xxk41h9DdAw3LAWW6bguOrD
vjl3NwDO9RYcrOXAw+635w7VXxrGGyRzbn8L7qbbH88pFYDvUd6K29EE7pZU
y7xO1dFFwbdVRJYJFDuy7MwV7YbMj6ZtRba7gl2omlkXlVvqL+60fPIea+1S
+vX93oPygFH3MpWzLSTmlj9/j7fuPpmS5HOGuTfdehwa7eBp/Pyw394pVEps
uX7snAv0fOgbuyHZC0ssFpcWnCeQ/uSeMMZod1hDrhesJdcLBMj1AkfS94mT
vk+B9H2ryDqPFVnnaSbrPG8PFPZzGA5A5++9uc3aY+h1zy/eq8UDNKUKOVTz
esBcvj6vuHQCl8yuORlGvoNvm9Q5vNQHQDSk0Oy18Ri+35V9tmudKzSRXIHk
l0mulTWwRfcXgWPiOirOJQ7YspE1cHiHE4j3/5jtpvKg/YIXAurfoEdwzsnf
vQ7wOKHGu53K33975G9fbouYdul4crjd/zmf+E+85Z2JwDeZBmBNkXD7bkXB
iydNOk6lPYYL0XT3++/WgVKtqfKVSgoO3z1qN7twC/xJforkK3T+8LxPe5d6
uKKBiaXJ6vkPAvJOvXqn43QH7kb94QwkZz7zh1+5fbdsobsG5GppnGh+UmC+
imXdgoQH8JBcnuR+JL+2W2exTKgX1IICTO+9n4AqwqvwLkcEGD73vVV0pR02
PZZ31907BdWdPvOnVnnDnWGtubLPCLIhSqce9lF9LqeyS7n7F/jAzU77/H0j
6H0M2q8kPYUzmwq9uR1r4CkTd6kr1W8aC6vs3xJgBMe2nXY7KkfVsWScdPsr
TtZvrjm0178D+NmLc5KnJ3C05OGWRwxfqHr0JOdN6nN2JB0Prnb0hN6fjl1P
0zOg5q+4p0nGvV7+Chvmpk7Y97698+noBB7M1Sp6bFAG9/0ZpjK+ELg+paXL
PSASapMVu9dLZYDVP+jzd5Yjq3qNxlA4NTBU/+AAjujIDpn4p4KK1rXTO2TG
UIcj98rBZwOY4//hhurplP/Q7dpkHBPyrd8U/3YU3wy3uBx6MIjZRnJPD/PG
gyjnY5mRU6O4GMd+N6FkEOeXdv/acjn2P/T8U1LP33DUPsbsREE2LPVb5VEP
mrECbtdY4kGL5GtI/iPmD//fHudZnbrm84/bcUdQ9v5l1ikMKONRGraMgfR7
4oqMR1uxJWibQr/rFPYUVB27TBMNuwzmHpz/2QESqfYz71wnUWuErXzQIgsM
nbSGxQ4OgYfDzPeHkSN4gns2eikSocEga7VLE4EGamP9DZbvYai48ZhdQgaU
ft/s5FM1ASH9NqqM1j3gOXtXdN94FPzGnhfPaKYwUZXhWNeyL9zeoiedsdwO
6mPylxcqqHF8kV2NO8MDEgS23thvnQ20ay4rRCkTqGl2dgO+LEPu5423dBmT
QGx67NyHui68+XHd4L6ZCTxeR9deMJkPFdVDUY/ORWB0n8clVWpeOB+6Yu+P
Z2VgqbvNm1JMwAF6rqYIzQDkTr4iO6edA6Wj8qVBiRSsetve/KDaGuNYIncw
r6+HmSDbuS+1BE6qOx2VKHmAq4VOBHvqZwGH/paJZxmdeGt2QsNgcQKDls3a
ecJK/4MHk/zo7/H7lLAxfOaR0X+4tB/Nce6Az9Mc8FUKo91oXgLM3GcDrlPH
RYKfkF1hWDWs9/9qU1RFQIRAT77I0Aek5z2vUrg9GxRZZZxujlJQLqfBxrLK
Ct86aLQecqmF2aGX+icaCDTfwTEWZqONuwPpyi+nZUK3ef39QdtWvBU5+mV3
7iRuLnx8iMGxErr+4iwkzzr+c6l7RQsYN1QGj9RN4sWwiO050jUwXmoYwldN
gOPEs81LUQFYyLDuOO36LKhjusvh6toJF4ra4imFEyjz1EJsw+9KYHZ+y6RI
9Z/s2bg/Yl0MHq2qC1VczoDgL/XSWmadEJWhOSmxcRJ3/hCUq2MtBRXp3rD1
qQTI63b4D1en4e/ZJX3etHQ4x/yljVW2Fepb959PODmFwq5aBabyBRDJciGx
c6IFOIJoTa6pT6E4Vly5bJYP17VGp0QsCFAcKyrgNSzEA/u69u2iTwPR+xrb
n5TVwsYOid6WdApmsPg8FZlLh/yfcVGf6GtBMXFUYLmZguERZi0mz9PgUUrM
Dp6DEaB/aWo27CuBaz6n3WN+HQLG7Cr2IUz90B0iJT56bxxfzTY4Nx4MgMWj
N5q2zY4Ce1fdjbCZAbw2wdqgRvWTEeR+RVZyvyKQ+xVvyv3WqeceBZktHCP3
ZweR5VeK5vmqCNgoEvkl79QwFJ5qZ9jzbRhVfkvLiImFwuHUHLtB8SG4Wuu3
3nh8BCtTNLziVYNBo+fLYpjZFLRLNzxebdOKSpnFtAqFcZDImUnEahG4IUDx
zhXhUlB6YBouNZQIOp4sXyYPEbgxa2s8568K2JTEWiDIlAh3SX6I5OtIfo/k
XCTfQHJ3SXFnSd4h3Nkn2b5l5SjeClyyM7a2gTzS1x8nff1O0tffS7++PYc6
bpvmPSXdj9TCtL4JR+WHaIjveXK14cQEWlkYaFMKeqGzrCB5UioA1HzvXzqg
2IdlCV3c/E3jeN63VNhrTQI4nr4cE7jcj1z5x6Snw8dwZLJn8LlhItDy0lfP
tROYF9Pi+t7UA9o0Om/lRKQB6+ARof/57n5X6BX+MO334P59Z9qrhjS4Scbh
jWQc/k7G4RVkPb+ArOdfI+v526bNg0931cPYkahGEzcKCkvxhsh+sIUvf62/
G5Dr7xsCu/OH1FKAk1bj0u4B6jwoPa4fP/cKKk+vX3RJpo7rxsLVvG0E/BDU
b3Wht4eJv/hZoT989pnrgnYxtb0PuzT3dVL1w4LIL5p71vBzX21GZXsOJBXH
MXeXEPDz9a4cwQwXMKqI64g51g1O3PGS64UmIUjMp0JkMhDWfbhv8nvRDV8J
GFlqLxOwUpRr7OHV97ApevX79RWlsIs+w/rHQwK+lRQmi/J6weBf37+vJL9z
V+gOqVA35MU1J1rW1lF9tyjXJp/T90xgVd6/f/9eeebP9+8dnUweL43S4MRz
92seVF2Q9Ii/L7Y7Aq7teiwh7pqM1evWiVyg9s9OWaZz7VGewHVV62SQ4wAa
ueY9D94zBhftaVhaKtJhv/3FXLGoUYiYZpm+0TyAJ9TeME7WFEDs7a+y64sI
ZFaPlHhRFgZNkbdDpqayIbPDLPrjzQJg8ZvjdDg7gBytPpHjnGMQyVp6dO/d
fuC5qLCxUXgM/f0FrseaVEEwyXlJ7kvyJyanfpSOBcN7B4YZTQkCx2O8R9/c
rYTLjGfrdqrVwvME96OME1No1/6zqOpNDUTJijky1rWBWEjH5hLZSWS4au17
T70aeK5vmhXf3gVskmImp7MmkK3po+RZ+QqQ2XfuXRo1b37c+BtZAz8Bf9CW
CuueVDikdu6WUCuB6Rqm4yK/QuBI/h2PdbvTYJRmzwb+JAKdN85fvBKdAsEF
Ow8dMMoCgbiDdkZjFNh/3kGZ60kN8nuPf+sLTAYbPckN61M8McX7x3DKtkLc
5WYmsD6YgBOXtEUuFlFgbd+O568u1iJdwTJf7dlMOLtKZH67IgUyfwRdW7em
EXfMmP1me5YIwtZn895tpYBuxyPxHxea8L5ZkHLT8QRIv3no0U6qbv4o4BPY
KNmAVdwjIi7PP8Aacj/2ALnvWo7cd52wePTZZ7ERmI2KOEH8GsINUQWNifR+
/+v6R4ZbaRPuKAX96VUqa40JaLfn+R2+zQqezoevo71ZCvm0AlVMzwhoWKlV
+XibxT8+J3q5mG+phsDHcvZ05jIn8HPJS2Wd2CwY1Xe5MO9EIFHR8YQ3vAht
XlU/3LA6BBjsv9x2qyfwxhNTozyzR3h5XeeBvuFM6P2HvLyLJyrmgFwbDJmu
e9NIO4VOYUml/jMFECXjJhC86f9h772Dqti2tl9EDKiAgCACCoqoiKhklDBE
oooBBQMICAgqqCACSpSMSM4ZyQgiOadJziAZyTmzViuoSL5rv/bep759a1fd
U3VO1Xurvn9/1dVrru7Zczyje45ntMGWKdodoo5EtO17j/T63QLYh+eVv4R+
55VyeF75XqyRg7h7Fj3bIzo4wDuKcs0PuFBYlQAX3a5i69v+iCXZCn0j5eV7
YmIp/DiC4O4cmUyJWiQSvv3IZz8p70fYJ57GNT/gD2o2pxrOhTUv/pmK7RjK
5rrVdfdXI7AlStLaXWmHAg2poo+vCGgH9S0Hr7jP4J81kBZ7tg/I58tLxLbO
o7TSB6bKjk1QW6fENEM7ABGbupkFn+fQ8i1d+Q2aOkhRyDFuL8OQmG6off1k
DngxlkXoBWcD01tZt3SSDmwR4F+yYc0EOUmaO5zbckAS31/Hje+v68f3153H
daA6rgPFcR3Yivd9dsD7PkfifZ8PXpilDvs8g46W8jp9dB1FtK30yvQ1xaBz
s/P6a1Ic+REZ6313ayjsXjtb3uCUC/vw/s62eH/nGLy/8588FOfROO+3q6Z4
8b4G9tu1jxx9iUHgsWsc7V6vwLZVxWyKdH6Spq5gW36MnA4pfXO5mQdMiWLN
r0lx6m584LvprhfAwjcb/4gtD+ybB0IcSVy5SVL1mZE1SDocSnahzvurL/NR
vC+zGd6X+U+u/7d+zT/zr31+S9KHoa0iL/t2JUP4WvyDL3H/6tcchfdrjsD7
Nf/Js3EehvN7dexa0ckYTG2xO7sjJgNtV6Z0XFZA8DWzd+x9KmkdF31wtjkn
HW2cL0+T2If+qjP1xetM2fA60z91OBWuw9lxHS64wU4wysfAEzPhls5KRcUs
5FUW74pBke0wWxOJhylmrrxaSUVHVDLWzmkU/1Wnyfy3+s2/6+eduH72PZiu
N5aNwVcyGXbj3kyUxn+Q/P6uIhgPi8iJz8JgnJIhRd0zC7kLxNTojhT+Vefo
iNc5fsHrHP/Uw6G4Hi7H9fDzGOWk6fcYHDndqH+yuAgZUkZvk7ctIOmZjPKF
UAwi0ian7JeK0dCTk9Rqtwr+qhO8idcJSuJ1gn/qZ25cPwvi+ln8KF8jpo2B
d8y+nLf+Veiw0VeBO+l5MEPph03dw+DgIZ3Lmy7VqOmnA8+mad5fdXYL4v9n
nd1tXG/fw/X2Bq6364Jf/5huIgL3WqwCxZMWROVGxvZQIQf6x3dhX7OI0Ea8
utR2rBWlkI/K6K/8qx6ND69Hq8Xr0f7U4XdxHc6F63A6ayrTUwoE9Lrq4lPG
4h40f6tu376kV//19Z8V9zPZgfuW0OJ+Jv+p8+f9TQey4TrwqqS3ZGZkKhxn
dBCW/oqB4MlOY99d/9y364GzyGD59DgKpr2ROSYyjfQe5t2/Sm7///k74G38
O+C/O/7uI5y+UUG56P1zi5HyfgyVh5/cKX79n3/XD+8DSI/3AZTC+wBS1v4S
sLYdR9eYA86Xek0jp05RMM2zhNvVt1Ods5uA/nJs1zl2DLmtXw7PVTf4x/O/
ui+XcYWQB+sMqHr5Cwb7khI5+mb/+bp5/q1/Nwvev3taNvJuQ1gKSIkWa0h/
w2C0/ug1x6oX/3geNbzvcD7ed1gI7zv8T8cH6ccZzK9GwWJQ9565FQyOpZ1o
cp17CF6bkQtiNB9h2/g4E893DP16Zmvv4WcP5tScLt8LENgKndEPKcXQjXOl
mjOPrSHmb30k3+J9JP/pd43wvnXP8b51kW9+963z+1sfXiW8D+8/ned+EJXs
i7QaWBveu/OhEQb8tS2UfhL/fl+5OonX4jszSkEk7wgNgbRO7yezLQ8985/r
Tzcb82xO61ICvC3ionu9hMHzUftn65HPYL+/utOn9gQoGRMLoyZx+08TO4wi
/vm6/RMfYPjd7y8I7/eX9PJ3v79/Oj6+pXWpY70ZeMQjL4nuIc1nXvugize0
4Sfez/oM3s86+Mfvftb/7nhCtwt93KtaC+dsQrzF9DD0WlbBPi36v9/v7xLe
3/wL3t/cEu9v/k/Ht07JRzH/0T+YPX6I93SgxPkuGsqpjCgIOfW48AwpD6QU
i72fv91b4o7iPa+xzhBovruFuW6ANC8f7M3jtnNASvrUSbdFc2HT5VmP1gSG
BsqHDVlWGOHg/kY9zYgsYPiVcPH0BgZWPzoPaKm9k1hnurf2zM8f9m7fZcO0
iwDbCOpumSNfkHDTIQc6jUp4OXc0/cgsERQUlxnuFjWgShPincurZXBazP2p
URAGVbo6uXy8+WjVgkOpuhmBsNU5usYuDFnu9dKaX7BHzu6q2yMc8yG7/0P/
CdI4ZYOGdX/ZeSP/U9q5w6dyoWKryLO6MdL6GCfRL7FIB7yfswV0z2fD4p2I
AYmCeYhdkFe6sdaDBo299UeGq2CBSkqkOJcIDu+MqPRfNyOVkSCzPEI5nJ0d
9gki5SHfdjBeSycglC8w4rcntRSuPwutCu3GEL3kiuDBWTc0S2zkLDmcD8TH
U6dXSesyl0OENg2zF+LjOV7bo5AL127KaSqPYmgrK0dLsSUlDFfKDt2vzIbD
+SLMZoEYOl7jsjHcVYHEafJtjdOjIV51YmPUloCkQ8RsLeW/IOZJsafPnmWC
Utjx+Xw0CtH5XUc1RqfRAPm596Znm+CC2hEH8uFZyOZ+tSP1+jAyKRy5wz9e
A8VqAcdW5glQ9nJpkuZWB5pJu7ErlK4SeK/rta2zYuBVFWfLIV+LWLYMtFBZ
lcHM2Zo6wwAMhFnXR4O1Ckh50EuBJmUEgbzv6zorMZBvuenqyBqPoh5O3Dqe
UATOOm9XJkn57xaBxzzcZ+3RZw/hxxkDeRAtVXia6g8/9vzdt6+ZvEWCPhnf
5J/mwqnhvrF9Ixi6lLn8xnluUeIkU2OWrUgOfFQLflhUjKFS409kidIIzV3j
/JyXFgXb7zg4vqUhIn/G2cER7U502Fv7oqZbJlAZ5G4Nz50AyjNVG1F2kyjB
af8J5+0NIFwlzzIyPQcO40+kUjUH0IawVTdEVkHFrtcSBXxEkPevvO/D0I5I
YUop83Y53JEV5fl+AgOu8WkJ2zO1KFrQ5PsRKIVFfuKbh/4YDPiMXPENKkJS
6dJqpWHFsC3jwi3TCgyINvbikrXJiJ5nWKfauRB+8LG/5CDlCwKmHpeZpI6D
q9g5R3f/PPhyYc/qNdJ1UOAo6jQjmCMn9z1C1ma5wFkcaMA8jKGyFWpVpbmF
ktSFquEo7xxocDdV6v9D/zcEiF7lyUchcUR99bpI2Jcjpf92E4NUYc9HFJvm
Ejvlas0bBx3BXGeQAd0noizrhbdGMe0okJD50IEtE26wVO6NDZhAKmeXxFcp
plCu2qH8gtNV8EuebezFTDU00+jkZwcRkWFucQzXpyYYsGx5Tes7CcF9OmGF
wxOoKrv2ZM1sDQxUsL9aJV1PnvtbAKseQAGK6WSUyhWQXEE5Fc45B4tC/g0h
usMo/ajPA63NUmC90vDp9XYiDFZKfRZ404EEZE5SfM4uBR3cl/UV7stqh/uy
bj3m1/KWHIMrP9yV9lU0IHntB1cSuErgThkdm0QkEY6wK7roCraiOapilvDC
QhB8YzPAYI1BsUfa0JfxMjSZvjBO/r0Qyi6sWfjIYHAx2ftLc30NGnl0kF7p
ZAGcGbXNI+RhYPGtU5F/NAvdvmzDdUKrAHr8PUbESbo6sCPFKV8gFhl4HnBV
e1AKHydfuViT7qOdWj6z2WE3qP0+/eSXUB4c188rTiXdx4wT7BvPAy5Avsr7
rtVHuaBkFBu7SuLbyPUolM45QO2u7zqrJ3PhsI9+qNUQSR/0f3oZwEuLfskH
hxfX5sA15Zyr90n866eHAWG97GjsCesxjY4cmE5LqA8j3d/GWt4Pe9XNJGJm
deSj5+wh0Hzq6ZP7M7D+7MWOXp4x5H5DTYOzvQhOHeG953t8HnwiNi79yhhA
HyOwfa+uFsCbLu/G0zUECFYwfj0U2IXyaE54HOvLA3FCqLRJBUl32t1wcvFu
QRrle+ce/soFv7A00WDS+B2OcF8XlwsCC+7vOpQxOVAWkvF1G2l+wsjK7nER
HrSV5VDcl6AcCJd1fJ5MGueyxQcy2vemEoMqXuUG8nagtufV6Ilrk+DkR/9M
snISndogC2P8kgMmO9TXy2tn4FJsmctY2SjaQt2ta5SUDVpcH0vvMM7DW3ZJ
X3OBQUTodCjYzpcNwpdX67Z9JMAb1+Gocp1udISQ6/2EIRtM76XfFCXdFxNd
xuXkkXhgigsyqc/Phn7j2NF40nryoYm2rO2oCLpPp5/7ZWsOEL5xpuSRxrmL
bBeFzU0TicODPGO9YzbwyPLcjeqaCch+JVJZojqFXKNtFlvI0qDHKq1zY2Aa
2K423dtLOY4+HhFQvPM4DdSfcRSm3ZqD+ZcUZ2Tth9GpeNr7M0zpMHCb2kDm
PAGc8wUptD/2oIt0nBcCZ9Nhv/k2XeVGDMkRl0XuqWRBSJD92ecSWaDmdJIv
aBxDZrc5N0MOS6NtbsXqO+azYA+1BX/YTwzlx6nc+NoTh65kdwmJ8waAyNpk
s1ELAZkfWZv35OxGLxTV9u+8HAXBnXeCZd1H0Ob9+fXyvFlUvP9pReRCHPxq
b37yhSITsXVWUsyS4kzQVuOZcblYkFCd+hFhVQ8fGsUFSuQxFNhhKOspFAML
v74ZGU10A+0lJu6lRALyKp88JMYXDQfxurxqvC7vJV6XN6vxXOxL+BgI1gUP
OcIMGhJ8cW91PRZCRw8WCaxMgi6raQnzuUnkf/qZ8pGQBBA1KD9RQD8LlTWW
e9Nej6JS1thq1eIkONZ3XnB3xjzcJJuhiaPrR2ejaeW8OVLgzPYPBxn9STrb
9JpZvV85FM1di6T9kg6Vlv3r12YwhJmmk92bVESrWbvOL1NmQn+nU//dXxiK
yzit8PRXDGI9e5n2BJUvTJ3Kq7ETIaC5I+dj+vb0ooXPmiNPbAJgU1niVkTJ
MNLydJchXJxDKiHnTsbs9ocwy8ap1zYVKLtlyFf6PYa4j+15lR3lBQVnJPce
HfwIOVdX4vYskuaXS/dgTr4bVIWVkLdp10B8XuppGRMM5Vy3OhF3ww0qjagf
+O5tA2d/Jk9iOhEt1N9XVsz1gH07hVj1GL/AV6lp58uxBHSxQeye34w3DNSq
6FH4DsK64NYPIczzyLzwy7FRsgCgnGmtkSEbg+3KGtvTCmfQ0ZVp4eLlUNAn
OOSD0BRoH3uTHLI5gURrphkcaaNBweG1+tEmIhK+LXNi13oLdIkwfRm8lAyP
jr/iSMcwlHD1W3Ow7QN0auXxFnqONHBWF2M9t4whF5nTT4euxqAjIzfUvIQ8
YUPxI/VX4XkknB0WSHlqEDkrmnerzTj913VskMxrZsp7rdCT2NnFR/ofVj83
m4MumsD2W9VzTRJfIKuBi3Z7OAHZtX3qvsBsD67URj8OqIzAyWefhjpHZpGq
2hYVgrQX6D35aAHUs8iw757HoPsoNIab+2Toh8MeX/9xC9I8ubu1fN9VfhPk
TLQLFK+MA403l0c3SJy2mS3onmIsSg/ZCO4r+2e/i//Lf/P4ixVmaw8CENm1
s81XczEU7xYlZVRbCi5H12YWqwYAGdZLxvPNgxZbid2QdzbsFjqdemxLGbpS
VXMkv6gAbUlSu3TmHQZUs11aBL069DXY3+XnLZL+VaS7KxqRAAuFzYUCA8XI
jUeUR6+ElGccl7t1ueIDMKkH+WSbR6PdjGYXcokY6s0+irVFfYQSvI+DDd7H
QQ/v45CzZbXb/ms3VHiEcWk7EtCpF7l1q9fyYDGfrDI4dwwKpTpW54nTKKLi
Xdl102KY+Xrz5ZHwWcQYViHXzTgC9qY3hS6bVMDNUyK6mvNEtOdMvZyUVxPI
su7QurNSBBniJ4f62zCkb6vyIn9PPPRKmu1OeZUHc2+TNa6Q8qPwU6EvuWVN
4FNvQZJlWNb/q3/EMbx/xNfKGQtfmw4kcnZml8sZIorT2/75smQO7HmD1Ryy
ykdaLebEwUQMkTftvZnUWwBtAxvK1anl8LmZiX1Jl7Re7Wu27aIsBdf7LM/O
CRLBZOsNMnSmHQldkNgiE1sGA7lLC24NGBJBfE9V66OBqNvRE6BSCPcL1hb7
+jA0Qea84s5ohQTvK4X7LOZCC2uXhCMpbxKZntDc12qKuEuDnArksuE+3oci
Fu9DsQ3vQ9GTLmysnt6DXHeAKGErAR0NVng671wK+n63vp676ISijH9aqbtj
6MQlY8qvl6tgz8KRDtcnPVBAnmQgWzqPLiiFTK8t18Aa3odCFu9DUYH3odh9
oXddj6SHl5mJGazL2miA8CFgT1IB9Hf4NxaS9MA5p6GC8yFO6GXCu7q1c3mw
aVHjKU/SA30K4acZJM1Q2V7rZaf9ORAmUOBGTjp+e5p3afU+DzS7gxB56XYe
eLF+sgoh6bFKHu9ln1ZbxLMl4UpcdA4M6ZzyOEI6vpdsJy01mTPiUGFM+qiX
B078miZ/+LWeqHQXCftmi7w1g7+kUeXCowpe+maSjrpqGxBx6og5in02Ish6
PRdcqHxrTUjjOc7ldPVAWBaSd80mOBS/hzffp2SUbIko8jWTxNWGNuTmvD20
42AGED8xnpIkzQ+DSzetj7dNoWbix9qrAxWg/cD4fvtCPQj2xRzqiyQiroa1
e4smdRBBt+jWMj8BY9uMqxWLJ1HN+W2c5OaV8BHX5z9xfZ6B6/M/+yOY/60v
1Z96+yiut+dxvf2nrpbFdfUorqu5n5zkWA/DIMubUz2ytATxrlpunaTPB4ed
Xv1tJRjIVJO/TihLR6dOpQhfnyiARL3LPUakPJGb8tuS6lgkCNxaJWxL+pd+
3vs3/byB91ng+FufhT/1M1PK/6mfT2SLuVGPka7LVVA+fr0FmV29pHCV+Ale
G1PE9olOosKfalzEj5Mod0/JonoCgrtdPWKiKjmwX6dhB9MrDBGLTgR+NqqE
QoZ9FNaOo+C1dlToVNEMYvtwlgrJlcH2sGmbW/3TMN5iZsL/eQz95LRJ3WlQ
DLw8Qxl5H4nALltfOHquFQ0zJYifPJEHmupdtfoKGDQc23pjeK4GbZvQbhKw
zwUTUQWFg9EYMAVuqS+KKUGp6pm0Je65UMdwbYm2iRSPAr6KLvxKg3DraO/k
iRyI6c5YaurH0C8WXhFut1AQpnt45VNKDhzeJ049SboO5YyUd1M7b4Bl17uB
LJJup5CrnvIN6oOjtU6U3inz6Pqynfk5qwKQqdw5eePoBNzdte2VcvcUOuab
/UrXKhfqxQorzrsSYU29uSpQuQ0pat+6xiqSDQzcW3o9OzHkvnRcXSQyGYzS
ZKV3F5H0NucLmTek+ew8H+nwhtIMLKRmaskocuDg2G42Ud0WENAevnyrl4is
RygOJMSnwzGhk/MU4UNQ26YVEYTmkI6f1Vn2u2ngSX7i5llxImTenf/AqteB
Zmls/fnDM8Ahbu96RA6GHiyHPImNLQTngFcXSw9mwRBcoHEirUv3ixi3Hj7s
C1UTnwpCarOA6viHme+kPOXT1L3l81ofwPCRe5VdVAbsX7ty8nIBaX7qSKb+
oisFVQkKzx1eUeAmh+jUuscR3435pw/4ptGvTqrKhutpMHx1InrdlKQznvRK
70Nf0JSfwwnj50nAePOc5vAGButi3V0yL19DYKSTlHSMJyzTGYpKM+sAC4P8
KaFzVYjb8+tBPw8MXv2glPR5Poc+0719k6YxjPTTbn25ZfwJXKn6/8dXnxL3
1R/GffW9POUYPDcwpFwt6XBsTBUqDdLD3rH7/sWfoN+c+Pw3N43c/4TfF0MC
XTUTvDaVSIYy/NH2klB4gfOPOH+D84k1h+S9YjOorjFirCV6DNnQFNNRvImF
Epyv4Dwc57a4X8ca7teBcL+O5ps+5NcKCYB5nHJeU+xG7osNjEEkPVmJcwbP
39zi+2+e57DuPUyjA4l7lfnueVdAuplMcsp7DHipt3b7kP6Xe6ekNlWdPpCf
js2Deh+4MSnWcSYOQ2Nm1zUFusuRAl/6/W87/OBzY/51M2YMsTM7PHj6swkZ
5cdJqoz5w1l3unqb1zPo11YOpybVMWQ4oW1wRzkAXJ8b3jhEeg6nu2fZrFqI
aCnDuqR+2hvcNeSsLfcSUEeA/RS1by/Itavw376TBEVBYm6PMgmoTD3Enyqg
G3oLmZjLs5JIeviUuSspbq3c549T+14BuQ7++l17UuA0iDyIL8PQlGvViqZF
IeQ7Uca3jqXAzVD1iEP5pDxhyTh1V3YpilkkZw40dYMZuyVZqZJJWHGcPMlo
MAkLr9iFHtV+AiHW7s59lfNwnMbiyruiPjjx+vrAbc00GKDky7paMAKJShyi
A/6zkPNWRazP6CPMnrWw+XW2B5nXa5llyxCQ310K1giFXGA8I37QoWYQCXBQ
7r43MofOibzlY2fJh7a/+b0X4n7vI4Xa/t+YWkCP70h5bjIRraawGmkzl8FK
YOCxVLcGeLV8htWAE0PXdQxfYapZYH9i0PLX2jBw6u9sLEmdRSuHMmOz5Cpg
2El7mPd8L7AVBBQOUhDQT4PlTzsF82G79JUaIscc4p7T3vLqyTDw3dAjiG+U
gkg4U+WL+mlwYVD0OBw6huR+DHCJkVdCmOG07sg4Eala57l85WmGLOpfVH3P
i+CnvTpHGGn9Gbpgm8m6EgNvqIJ6W7fm/eWj3oT7qMviPuoMu8p8GKdIcbmX
tgsV0QNqWi+lW8yEI1Wn1DL/iBfvH7oQDN1Q4rW2JdHnOZDk6UU483QScZlr
N70pmUTStxOnfualgvMvslGejhk0vmFMZlowiuwFL3F41mfCluDU1qCiVnSR
QvjXNOm5qHfPKB+ezoGaKUIEl04y6pBUWhGrwNBmDL36bHoh8Dz/ZlLPUge6
t/LpRknzV75nr5MxSRcJ1PqoK1MOwkuNfYTU/jnkty/pA3SUg3YT/9bLaBxK
WbuOVoWQ4n5ycgkDey0UvGfYYzE5CSo9pypvNk4go9CQW/MVFVB6aQ/fs9tz
YDtt/5b9wRDKrpKT72OpBkGxsbBP5+ahQI2XYktkP0poCDnkuVQOaqLpKsLS
RHD+6auB7rch3zr6cc+XFfB4QZbmhQYGc9P2pdt8yhGXLePOaJoyeBZ5vGm2
BQPbCRp9vocFMHlFaf2STzjsZrwafiuViLivHdStG2lFWhRCufsuJUJd/Sn2
uyR9+47hUURE3Tiam78o9fhtFmjgvuXOf/MtpzW79fBCUBs88j4p8n0XEZ1x
ubrrTGINNDwwvC1INQL7VWtdDz2cRZdevtP4AbXQxhnTFa86AysfWbtcEkZR
6ws9qvFf1X/5gbPifuDOuB/4Oc0957MWMPBw2mF4wC0JQvJCc9vYggDxqFoe
up8Cy2lurx9SjSO9HCJ95MA03H3K4mHFQlqHJVeixlSbULH7y6UJxkRgO0ht
OeJPRG7nNJO/Gbahm36H7mssfwIOdvs4y7Q51Movzh37Ygi95loo4TLKh8Mp
uUxtu7oQRsd0+K48AZUws19i7q0HAu6P/Rz3x57C/bHLds2eGJXsAbsXW+Re
qM+jzUo2zyczzeBtuudaWtokGEQfcXOwm0Aav2T79GQawIW9m7dqYhrSZrsf
be4cQ9Pka7vf9tZBz7Kj28tmDMq9NXhHv/mg6xaLzhI5//LBPvPytw92Du6D
vSvE6HtPF4Ye1S/Ebt00QoV3bkRpBOdDEudZ1R+OGCLsU2OguF6FNh5Qqnjs
i4cjdeppjAuk41dndfiN49DSTg5F4bxYCGItdW4fn0drY3VqEW29aMeMBR+l
Rh6U4f7VQ7h/dS/uX81lxxfQszALAkp9FG8uDSManlrWvqZquP6NcUc3SR+u
XefQL2MzAnBWECtdzgOC6mO6zwhDN7JCawQ9SpA+XyCamo7+S1dL47paA9fV
P7Jaw8uWMcTwuKiu8+17pLlE9ZjbKwgscb2dhuvtYFxvS/wS2+FmNQcO7Ddv
ZJ0bQjH38yrimytg4P3YUDwpP/IvT07P981BHbYsdFmNkWDgKuzMv4YhncOc
ds+UA1BIKVnL5XJ/OCDCdyeXQEBRVHXNLCe7UI6Dq4NUZgawaaTsf15KWn9u
PbY5mpYNRcR3wddJ67ZjxszEyVYMUW41a3i7mo8KQCNpfSUSDtXoGFz8Po/o
TNvNCGO9KGk7T0ZwSjpc6xV7FjI/i1QcThWVs4ygaZGspnbhLCjDfYnP4L7E
SbgvcWdErEezJgbtXZeXv3tXozt+N3TpP2TDXRbDSUtvDBn/8GuwJeWHBVYG
lYJhOXBJtEyzqwhDYVH211qyEWq3Ca3bxhAJS1lJ1Nz8s+i0HTVXt8woqpt/
ZRaZkAIduH4YwvWDJ64fBnA/YT3cT/gw7ifMQZUY9qGqHwrZ6w6p2s2j1x9D
x586pUGZjcXdDKcxeGyp4z4jM4NM+Byu1W2mwsKI/51s7n4wPrv9MMqeR7qW
ZD31ztFAM/qbP8P5Y5y3f6IRduGegm3qmbdcViaQn+KuWf5TabAmSXmatn8E
BkK0UgmOs6jR4zOvwfcY2HnxN+/EeTvOLenJPEzJZqHu+uZS29tRtLQidPZL
cRpIhKtRatycgJf+x39cIOVl4oFnPC4Lx8MlnD/GuTTOnc/q0R2PJQJNnuhe
js5WxLkt5gTHjwxYOzOZfTgEQ+gHbaKqRRlI9qPZJGImXM1nbQ81I+m3jMhv
N75VI5FIVi+yHj+wJcuj6v4+hUY7TF4zCkygeoWtdxizA+BH0bjmLroOdNi7
N0hRk4ja9yvPTH/0gRaBDMPuM41Q7UJXwSSEoZMhiR4FL9yAcs9MAY/bZyBI
F9Y9J8cQBd3uhFoud+ASurh/t2gH0G7zSZtWISK27LXK9k5PEBdeadvs6ATa
s10nzOiJ6FnQI60f8V6gRjGtuarVC/6/9jHVcRIQtX+lnsMOX6hMjhrTZe2H
FKm9WzKL55GIE2Oe2hk/2FJc9Y7RZxp0nlPp1BuOI7YDr0wOsCXCLpyr4PwE
zot6xyur3w/DoI60toDyHKIyRMoZnYGQie/PJ8P359/D9+fvYSug1kqagBOx
2MYe5yl0a0Ztf6VJJGy9tjvEVRhDpjy6kv7l9XBXSoS+/Gk6bMO5HM5Vcf6y
N6a9ivRcbzpPCLcd9IeHSR8e7H7jC+qihw0xWVK+w6wsV7FZjxJKvtzveuUK
fEKeIeEyk+irZ5lAy/Ikok4lV64++c/+DALzDlHOrh0g+PGdM981IvpguIpx
jVtBoLHEfPrmDMh/VgzqDB1FY9Ud3gZKcZDabfrcbKAfaAneVZ895lHjWEGz
eeVbePhInenpown45quVp1YzhZ7UtO8r5veHqS4/Oro5AnrCV9rQENgF+sdn
DbZxRQMD2SlBWtJ6aGOgInjEIwq+55qVU0sHQrPT9pW8YVIc0p3erd7Qgsgb
yA4VVf3z/pP/bXx3uwirdh8GOi5bybIZ8iAxwlBYsdUGCByWtF2bGJRYr7/U
4X4uoRrNNPxl0gw6fhqRR+t0oAhqonDuWSJKURiQL9bIhX1iR7VEnMtR50bQ
6EfSc0nQsJSN6kuBl/oKBJuMNKTz6WWQFCnvjKU5dsXwSxL8mDOxFa8KAtfh
pU8jRAzt06bRPfEpBRreSXOeWi4DDq0Xe22DSeuozWMXZo0MqOE+emqnTTt8
qrzqnHuXiJ77frPd/JADVH1bD5+eGIbdt6oD1BdnUY7cyy1sPwpBJ/FQ8wMz
AopIPXD8e2k3BEo7kqdzlcCavVWcPem896jSzzlFlkA2y/uYwSsFIP7Z04J6
FEPcZXZRTBsMaEe8n5TUYDacyj3mUCPVCUWRPdQSvQQkSGfAfL6+DJpbpVuM
eceg2sRbtenIDDqK1RQKOlQAvwfb/qSvM7D1YpJWMuMoCnVIk03xrAAkGqRs
2kCARNvJQkPHTvRA/5X7EeZyeKHYX5JzGwO6hIjuxROVSN89zFJJvBRUxigL
rt4eQ2OhEaMJ8jMounAhuI00zuOzA7wWMa2oM93sC8dTIpIu+FxpxVcO7OuU
S039ZZAjsjQ8wIOhbTR3n58MroayvowHw7JdwBneuOqoS0DbrWqvnuupga+G
dV1TrROwJZfRejFqEnk8OL72YrQGFPJSy9Y/k/QwhabO1fwBRHzR7y9aXgUX
aqxqksiJ4F55n6mh1wn5qgXz0wh0/aUf+HH9cBPXD9a4TkjAdYIPrhOi8fds
w/h7tmr8PVuq07L1/lkM5bVTGahyp6M3A4JjfMXh0GDT1l3QMQYDq1oiZhXT
iL1Cwt20sBQGzRQMJjEMXUYqKTFrycin99aDF7ahcNFLlDpo2xjKzlM/T3CY
Qf1392fsNSmAy3LrRV0rRdCY46mY50/K+6cKZb5xFsP4XE3WUc1hIN6Xsgi9
NodmV2zbre/mw77JZqORP75XPWoxUh3+gA4XqWn4bAZBJY/MfirpUfTjjHhG
3KlZ5NZrFcFxLwO0XTNclkr8gFc1Y0hoGkOjD0JrQuszINg1vGOnZTc4am13
EUgnoGy3jvTc72nw7t3pX6y7xuFGbtoF6cFpRGmlHn/mRypsweOy4d/i9dLi
RD2v1xQ0aRoW3/GYQNoXgwT4RdKAHI+/vXj8/YzHXxkHs7QvN2eBq+IaWQnd
KNrTjd7GdaSBNB5nn+NxVhKPsw5yVMZSBn/4BvByl7dXwe2XJ4qOFWeCOu+X
Ce61Jijy2eXOR9L1bIG6u9RPu5PyALIxYZpOyHhZy/pJiIg6V/hn0ky8AH2N
TTcS64PVbbcHLBfnkXDH8x1/+Hvk+3SgePoRoJgQ28FPNYcWZLhlKQuDIMEt
iNuEegKeruyzekA/jUQsvyidr37/X1/3oq/I5eZv6YfG4vcedEHzsPymYjLg
Qz782qWp6UrfgmiHZSdZm4nIlmKCIasrH6I2uobENwrQ7cokyKnBkLm1pFT5
eiJcW6+9/fB8ILrmoHiD7xtpXi3IThpYJYO0lXop+1gmGDBTURWS8m81ZcMk
p6w0uBLZa9lMMQHh0c4/0oKm0KyO42zqyUq4o1TPd0QIA/WaH4K/KhsgM9Pm
8j7XWNgMjvkVlYIBl6Xl7TaXMlC51eL4kz0SEhPuX7k2jUFT6ktVhpMZcHFW
OTJxLBS+H/U2ZhkjIn3NNpnnWi3o3IVv1HDwI4jR29jmt2Jwispkn8/+JOD/
eJGuuTMXKqOPmZ0+hyFLfiWVh+INKId9bbFQLwkQJq8x6zSH6G/YTtd1kPS8
6pTpckMRKNEzksn+0X+Nwmf7W0ZbMIwi39v+KB9c9cvtWvUw5HvP/c4esxp0
3b7xIYNuIsy/odIJrphDbLR+dDabgyiqSFNHqboIJlzaHwWT8ib+kudJHlQh
4BMvEZ46kAeZKiceHXiLod4fBzM+rFSiWdGetPvrCcClUvTMJ28OTbTocYaI
DqHz1IxbPikXArO9yhcg6f+4/Lid/A8SwVd3x144kwfLbY6idEEYGg5V/fTN
owJ5zO+c+sQSD8E7yA5/fTaH7owM3njDN4zM/FUpVu6Tfjf/DQv1ewxpUyXq
SpNVIM7uXd/GqknPUXVh95dwDPm0ZUjFX65AgmcPHq7fGgXG+HtCdfw9oRr+
nvDViIPRz64RMGLAHNSsZhFJIKpk7ksDcb2z10Mc56Cz+OBOd8FhOCbuWc11
LhVs3r+QM/k6DO4Vh64QmeYgkmq7xOWiJPDGfWJVr/32iQ3GfWKpM5KzB7sb
EaOMk6vrUVI+upFcJKyeAMY6yazCP8oQa9MU1hZH0ilzD79O0X+Asmi5rsNu
qYhKXrPJYAJDMtMSPDRvksB5uijGxycUyvQpvR6R4q/Rz18For4pYIv7ypri
vrJtuK9syqG0X6ezv0DjNKthUO8QvA7w1A/onf7rfk3g92sRv1/NuC9rHe7L
2oj7shZte9Duzoih+sNenC+H6kA9lTXjcxqCd5Y14wv3MZT1iN8nTKsGWtqj
dLVGM2Gu9+L0QBEG2jvWhrXpS2BTMyBOKSsR3pwcDNU2JgKtmuvOfIl2kDu4
jbEgNRU+nytnnMtsRfHcyoJPc4hIsrevLLXwA6zsyruZZ/wZdWMRW36tkHQL
4Wm1beIH6LKu3MfyFAO1jYjNEN5K5CP6bOvb3AJQM28Sdw4horvL/Q81BdrA
5EptmCRTOijYmdpxOs2gekOFPToKY+h7fwrxUKc9HMf5Gs47cf7fXsfIu7b9
CGLvgvDc0NM+24lo7NR07eyYFUx0/ubROPfB+exowNbImiEwDnxxe6xqDn3M
fvLFwOkdlODcFuc6OB+oS9jB4j0FtTzRtTxRE0jdfYobNkJhd/1vHojzEdff
XNT849dSF5LO//GGn3VvFQj/+CDUrhYLfDi/8vM3P4pzL4+TjGeGMMQq5M3z
tjgHXQujUDJcc4DRKU3925oYWn1nMui1pw4diHsvf0XDBsjevZ+QJptHpo4r
Eh9WBtFIno+YR+dzsLK/fB1YiMhGvd/bL7UTKSRzvk1+/N+vs/j/C6emN3wk
1RSNdu/tuGq2ggHhRzdXa5wosA08lU0qxaDI8uVukuyC79G6+5ZXbSEtanJw
qn4U5SV43amcmIH2LfFOSgou0NksohNEygsyXuQNtXFawM4nxjpv71jDUpue
7/hYLzivsnoSZubhmytH1/ybbMDM8nbzFvah+jhhrdj0ajjI+ZC7UnYeKOT5
sse9R9Ep+ukesoIWoPdhPZaYMg3e5T5vHY/XIKeHjUwshhhSelnY4GeSAJ1b
mBsHKzKRDF/Q+cV+DLVP6GjVbyTChb/5xBrjPrGuaXqxTA22IBXPzzJG4vbx
N1/FZX+Cyu/2xyk9siBui9lu+g5SnIEjDlGpafDKyNvutGIJsGaZL/hkYOiq
zZOhw7npMLHvrjpVwQQEJWCDq1xT6JNh2qd+dQTk0VOCP/KmYImmJjB53wSS
/P5yT5VeKTRus6Q4NUpA911Dfmhd7EIOS3ZLR5WyIfND4YJu+DwyKm3auXu8
D90M0Q4SO1sAl2ofVb4r8ED1Mb0eSapySGCc9iE96frWlymWNv+8AQnNGem1
V8vQ7GnV5w1ZpPt006/3tXArMN+lNDvUSkS3C4ue1DW5Q4kAxX3u9jYQuchC
He1HREWZNFPF4x5Qhvuv3sP9V2dw/1Umwacr6yWTsNRO2yxtMYlWKJpVmez/
fT/2f5e3sbWNls59hrOv/emZ1onoBlnFfU/CC/iAc36cH8H5f3s8/5f/5l93
9EZ9TRkC0ZcPNI6VzoE+sYLc2/QjNCXSYCZUHTDp0tR06eEI9PidUbGam4YZ
12Hta2ZE9LZF+PzuHW1QzT5FKUdZAl4ZjaH3vKeQpczMrrz9E+jiwXqmKeMK
OHorzHKxNBt8PxfvDCI9v9f6NOovnI0BLqXf3Avncjjf3T9ZSrveBkqNlscL
XYhoRKk5zIUrGvhwfg3nQzi/TMpSijIGQCAwljH69jzatS20VYHPH7ozzsyK
uoyCQpphMz/dLNq0SzTo3wj5t6/P/vVmMasuWxRj/5j38waGGPROrFFReEDW
nitEqswCSDenUnNpI+lHA5t5rVtuQE78HrWfpRz0p4l3upMxVNFVJ1x3yQ0K
8XnOi89zEXyeL+Lx+j0er3PweN2Ox2ULPC474nFZCI+nM3ic5cHj6X97nvy7
/HtlnM3s1Xl0zDLxoHjdAHy7STlFbh4JlFW/eYfFb77r1m/+T+ep8q99eexC
JTo6iPYWBGHwznyEbOs1Y6CJ+r51O9sQ+nrJsONe/xxaseUKSyTPBEU14J34
Poo89JZv2KbNoHeXn3eg2+mgM5JSQeswixpEnvII1IwgC8f0sfnQdOjqaE9k
XJpHPIeicoRXelF9ZQR18+5k0NrKYY2y29Chez+vnmwioJrquoPrLQ2Qg/s7
leP+Tpq4v9Nr3qNf3jkSUbnPtpP8tW0o6/0I9v1VGpzm+PFKUh9Dk2wB/rOW
NShv8s7E7fcfoG/NJpfrYCP6Wt/OzELKN+99ErlUKlkJCyYcC/ufE1FTSWvY
pFk7qlz5IrXskgyD9UJ+ffwY4tHC9J9XNiDBM2SnWesToBfneji/ifPXBsez
n8s1obeesdZrBNJ8M/M2OZFRDJx0I+iSMBFNfrIoSRnsQEMzjJay5xOAUir5
eMNDDA148SccVa9FX2e9dNl0o+FZTtK3jDwiUlbc7rpC0tecWm8S57LjgJff
wUX1QQtiKHv6YrWLiNZNAwL11DMhHd//8APf/1CG739gsXmoKKkzA9e1a7c/
fDaGLitVxhu8/ffn7fLbETsn11rEXslJ06WLoeaCA7/mZrwg2pjG/ZE2AfXu
2uzKZ+2B5Wj1GK/jSf+x+Wx1KcwtOnkCFI9QIl6zKbA5sqZzMTcZRPvMRacp
xiA2jTvkY/IMhAjOPVg/nAxCTvybdyXGgbM1/N2VvGnYO51lyXQpGVL8ZS7G
3C6HxMaYYZYADKVbV/Ze084Ar+DpiZM7G8FgsWG3+iES71bWknqWBVTNvVlv
rFvhvNUD2u2JRETZl3r4WWs2mJ+a5Bka7gUdfvLLJQPzaGaJ5Wy6aT4QTZKC
lTWGgIrq6Cn6tDkkMPhT9T6hAEoXo1yf1RCB4zgh+IBHMwpuLuRMYy2DfLXn
FxJM5hHhhYflll39EMD59oFkUSmMWDfU0gVjKPH4bodd90rAz1Y/JQEVQJTl
TyOuagx9Un1cwWiTBhRZ1gRO6/y/fD4zcJ/PTNznc23ikcinYQzx3ZUpaW42
ALLDd5lm7uTAljMPJauXMbi1GpZ1qO49tLp8yD1/NAiyRyy4V2wxuMantWtP
WxXs9N9MGYr8wx/7t89n+N98PjMd1N9Q3CEinblN6bF9Hehzm26KH+m+k8eV
hF+QwYB25bCFfGQ9jN9/9kqiKA5sR/ItvhMIqDlk7bHI8y4U5Xl+KYcsERY4
OjT71ki6bvtlxtlD40i5NL032bge0BNH8UDyTFR/ssiK3pr0/Mm0ta1HVILu
O37X15c74Llp1LjobQLibrmyar//MwjcFQ2kJum4POvthDUle4nVw/bfx+k8
IYiP8qPW1DCoOPd1BLLNoqyF5hHGsSYYPThDn8U8AAEMJ1v8zOdQxuU9Skzi
zUDbyHVMlnSe4uXT36rMbSUaVWITG6RcwfvAUcXXpLz9gFagA/rwEZHNd4kd
6I8G1whfhR92w7BN3yWQ2nMWNckWFX5lb/jre+65v33P/VkzcfjS6ii6nS9p
s8g8g9zQjMFR9ho4/H03ELt60F6Jm/GC9vNIXYhHVtq7Hj6kOcTYa0xAeV/1
xeXNSZSpPNDinlcL91dX89qujsJWcw3j0kczaL+3mqP1w3pQ9vh4WvnpMLyh
N8970zuLtNIZux5T1sByZoz9L9J4NioY2Ocb3iOPOvttTHsDYbvqqtSNFQyF
fe2Ss9SLQMyZk/qs2//FT3z7zflwfknqRU3kOoZaLxZKWgq7IndtbUbfd37A
1EUtvKOWCBG2EbXv2lqQ1beGs7N8mSCO+20+8f7tt9mD+216476abLivZh3u
q8n8eOJtIyne+4Vdp89uMoVxdXv+Lj+vvzhf9G/+A+dIw3J921g/SHaE7BZy
m0ceAWI3VRL9wJr+PkOi8xBo0sd/DuiaQ7sHujiDAgPg/SMGd2HqURh6IkF2
+vEsouGMH+UUCIGzrt/ZHvuMQQVT+rNfCjPIhPxgocd8GHy98JT3QnEbPHlx
1bEriJTvOmgzsyyZwg7J31wH50U4py4OTpTfNweV3U+swteHkaGZcu/j5niI
GHKlbHWZhRIl9HGifQTxJGlvNq3FgZygzCq1ei9MXuH22nmCgOL6f5UxlNuD
Ps4HcN6Dczr6376abLiv5hDuq7l1h/dgzwYG7IIjX2atnZDpgK6D7LgLcJMp
uTn2vgFFnfedoyPNsJR0waCYCoOeVNHd9KT74qSijDKIwRCdvxDPdt4HeN89
uuFxgojyaEMNz2p1IqKM14twcReQwvlNnJPJ/ub/qXX+fxtPLjvqueN8A/Rt
rxexkMYQpeHEBYvXT6EF5z04v4HzPZ2xKd10AzD7clQmUnEeaV5+z5PJVwAW
p8+IbJAT0Ly8lD5VZw/EPUD0vVYIBvH90pb4fukefL+0E65zqnCd8xDXOVn4
PmpefB/1MXwftR2+b/kKvm/ZDt+3HMJcY31reRi9uxdVt7dkFhnXaAuTCZVD
SsUNDQ+OTpSozGCh3khASmdzPbKKKsA8MOM0380ixPB4i6qvFobs6tZKCd6V
wFaTJ9wdTsovtNkFHzycQEt914+62uXCNpwH4py6/zf/GvhR4X0pSc95qCS8
7plHcsbh7VohRcBXxnqrKjoBmcdumBcgDD22Nb8mXFIMEyW/uQXOdXB+hbK1
/qrrONpxIaup/Pk0Kt/1Xc2vLx3oNSReDpcNIbk6YbrtqXNIVIf4ZKIgAw7p
j7GpTX6BaKHBFi4zUlxY1vpyRcQHivH71YvfLy78fv2784Ezs6J/8WIjUpmX
srs0kY5oWNKOyB3GIGkyLnZ3Zyd4pawaf8IIaEot997Yu1wY6/g8VuI/Cs2Z
0nSOjTPoWJGCVHN/EWSU3Dg9246hzIGAGIVzHoC+DepFXygAIXWEHS4gok+v
aJJd5Fqg14BdQM66GM5fYmZ6XImhB0meWhO+H4DLVSD0snQR9Mq9MUzdNoCC
Kjd19C7MI9+58yZjUgiCpGROc5Lmw3T2iZYNmg9owXNOeY2+BD54lrhIk/Kl
4fKZNa3mgyhtZjnr7NZCeFpJj2mp9SEVqTTmm+fmUXvvN77y+3WwsEvw2l21
cTSlLjl55sg0imZ0mnlZUAliV5Uer1pNIV3ydOyo9AT6eSKzwKGjDDwPX657
tn+StD4c4ToWP4k4R2Xy7HgqwI+PYthbrQLx7gg/z1tFRKPvhGaNbjXB6WPH
GckiY6Gmzbv94E4MXYrsljrX1gxW1zXtmNyTkXU+64ODezBEv8R7rPdkMyRM
yxrnNGGk+P9h5YJjIGJfUmN4nFUIzNgB+21dGNLkzC304XiMuBuafkgO5cMX
eVGZSaGP6GDKFTezd94oc7JDUngRg042xfRn/hjcFdCOHdqwR0fZSvvD3lXC
F+f38W6iGNzJU+LosTJG7QEzMXx9DRBPFLtKI9SNfG5m0jNszCM28mHp64QG
aJdc135PGs/Fy9KBXubRaOPKyqRvYwFQ5p4/zpOdBs47C2VfkMYfStXisruz
CY5P1zwZoaxGs1MCFt9TiCgyT1Ph7ngjxIUel2wKbIXTl369ihohoAUOM65U
xSZ40s37tL4GA/JxZqMHYinI+mJ9DW13PmxPDvU7UorB9TcNBa6p8Wjk7Cmz
8tZiqLajNBepx6Cx5NYVRaeP6Gw1X1BWT/5fvpdif/O9HF3I6FCmHwD1qFDZ
ksPzyHX0fT7BsByEe5WvBrzF4JnEdgPzx+XofFimeblULqg1dex85d8FRh8I
d24hAjJL01wVEy2EwK8dMSWJGGK7fl/P5gyClqTjlQ1bsoAC36+iju9XuYfv
V9HA3/Mr4O/57+Hv+f9xHX7UKOvhPAdn99XOJokPIzM1DUM70nMwi78nL8Tf
hyvh78mZmWoX7V/OI+Onb6d+UA2gRy6jLGZDnyAnyrgzTmgOCfZO6bdmDaMg
t3QsPiYNLLM9tvqNJ6LQe7Q2W5kwlL33o7qtaxN44eutAL7ensDXWzKdYzMr
ctposyc5SuMOhlTkn7OMddZBq+fgRX2SDrdOJ7f3ltUEjuJzw8gq96/6EU68
foQfrx/58ztaxN++o50XStq5XGuMNjr30JDmKerrtnxfRVqH8ztTO1cya9DF
y23USSokHbdzVf2ETCZ0XLyZ4BkZh1DMFd39oxhS5T768vRGBphSf9mtVDoJ
9cS5symck+jTlgN7HEcQnFgdmDRZx2CQK9KFQ9UHrIM0cq3TveGh1OWnn+bK
AIwZOu7lEJHRnUyFLyc+A/OJoY9PSXr4+NPbN9borSVEX9t/tZZ9C/e0Ts/W
k/SGTV5gwLMH9nCMr16w/7Y7qOwZkFmSDwG/zB20x0jPjbPVWak7nwl/+QCQ
kf36Hx+AA7gPwJ86+QSuk9/jOllnm6zxedLxpZuRpU6TJkCjl5nhM+YCvRoJ
245etAA3w9OC/RktiCt+UY5qnAgtPo8SNz5jSNesSNH0UiqYMHwPXWzPAT/v
mLFB0vpJNpFrKHU2C0qEJ1gLD+f+VR/BK/67PsLx/e/6iNZ283uBJH3bSGus
SM3nhnY4FsWVG/qBsG/npX0spPFcDlzcc6AR7dGUOw4K2ZB9yfVDw0UMqhbV
nIC7Du22e5+x/0k25OA8G+d7cF65WN+iR/pfLl4sXTcuyMLNV00G6tpvobh0
UfIOSd9uuZhKs0Jhhjq6ro51RfuCWdCuF+Wk4+manMz91V9KOHw7Ks+l9eYv
Tlaq/z/8xsJv/mf9BUfV7/qLSbz+YsH2OGeRmiciyN3rdZyvQFJlm2E8oRic
xOuapfC6ZiG8rrkVr48YwesmfPG6iaMR/NL1f+xTipa/OK9hJOHYPrSd/6YV
7HCH2Mck/mWicfxr4RNEmbpftgY5A/XjV1EnSOORL3w4M8juCKuiQvuUlnwg
j+5QdgvpeDeP0H1Xm19ICFCt3/xpawG16TXaR0j3JVpnB3ka/zuUbeAQGmjl
/Ren1v3NRw1/8/P4d8Bx/DvgBP4dUKzz1evF08Nw6yzxRmHQHHqvPau5yBMI
e7Ebd0L2jsNYSvnmgZlp5GJkYHSsJhxWcZ3/CNfzYbiev4vr8FFchxfjOpwC
1+FcuA7Px3X4f0p//mQMneApw2DI/t2RfGIMSsnZYL25swR4Xqfy6KwQodOc
4xrPbT80kdVrsbH2GS40265v/VCGXo6O+nKy+SAGeYWxh2kYTOE60xTXmR24
zvwzLgj/LS78WQcnietJXlxPzpLLczYPj6EoHa3ByJxpxPyq8P6zbWVw8/XT
n/IlLaCxtaNLx5KIri1yuq02V8AB3GdyCveZ9MF9Jk0/rNcOPq4B+T4G90Eq
DDWoLwraH68EpsaR8TlvDFyNtGJbNMqQVYrC4Qy5XHiz3sMxmIDBSpeh35fm
IuR8anqQjJgLj36WsLS+/gwMrNQsGy1EVHFx6MKOc0X/vh+RNu/jwIFp9Pyc
hrF//hhyb+nOqbheCjrhN4WWmjF4KzV/R+iRO4qQOVzxKb/wr+e9+G/P+21F
fy474yi0uBq+pETKmyke24tff+kB7oWV2/LjS1CrQ37THz6yNGuxQk5kXmAg
2hlT1oMh8ZXo3vk+LzjNUltpfDcPZIN2XvnSTYqnGv5Ps94FQJRS8KJiSh6o
4nm9JZ7Xa+J5/Z/rmAe+jqXg61gq7ntJjvte+uK+lzIrX4/35mBIe3Pdu8Gw
AJTVY7dYBmTDqbSvF7ds/uGn9FlfvlYDnmmfNd2S7AmZRt/GlhIwlKvtPGPl
WAK3FKV+yCdl/8UjcK6Ic7scuhu/SOORv5tW+DREC41/mMveS+cFV19WCuZv
/OF3dnAyH1mivVd5tQ8GeIEPpfzE3XQCBFbyirJEdqLVFwaiqtyVII37cE6P
/vbhnMB9ODNDS3YNrs+jiYhH0iJevciL3WniyaVsSPj+M1pndhY9uC9Oy/xz
GDl+N9Vrdy+E9+k+q4f7MTTQ+1D1I/iB36xJ/VXt3L98Mq1wn0xH3CeTl+fO
q/ek49eEKSjX4k3RYMYuy/P5ufBCfOumEYkXpVIFf+M3hVVP7kSv2lzY1x1a
sJvE7Qm17YT91rA75+Nt/dFcUNxclp8nxf0Yaj+yd1WxcEeTz8ImJwdsyFko
fn3CoE33wCuzwkz0+Ix4413ZEqjqFjtcRNJ7zSddEzS5Y5CCCE9R7IMisJN6
tiAah0HTmYHDzS/zkIh1edP1/cXQnxs2VUDSaRue28xCy0rRiC8tzWDVv+pe
Aa97Hf5b3WvK3+peM5wddE2LMVBeEt3wkctEST+IRyLEC6DDIvlKfiUGge8W
kzpepSGiiC4H6498CP+wejGxlwgHGXtO2VV/RjLnj3l5juVCiV/ux657GIjz
zsd9aK1GCzOOS1zPcmGjZ7fojQ0CpA6+lWFP7kSEzBtzDWzZ4Mt1NUYdEUHz
zUKs8FwL+nkzZ4RGMPt/3XuA/8v/s/zJ47wgpaAxZBluJHNBYQYt7KCvCHpu
BanTHsclj8Qgs6c7t8itYMDljh5s1eOFm9pEMg+HaHTfrbQshsTlePpKDf3O
gYXyxfXgc3GIX4rv+I9fJB2X4HCwreTsP/7umLzp8vbqBhBmsLhVI0Z6Lrei
Hh29Z3Au1z//1K4GkNr7sZBeDkPBYvP39sr8++8H/ttcgE88cbZqDtG/3zJP
Xz+E3IINivY5PYPrBAXv8fBp8OBjnhhWGYcl65/s6wUpsLTK3peslQIGnX2R
50cwdGbQYcnnaBrob+dhoNXohZfGw96T9fOoWFKqzEmrHI7Fi0utHZ8AiXgx
lGQzhRSt79FQhVeAUOX2bdcSJuH4jwCRPS0TKF1wxvNYcg2cYaCN1OOZh6kr
wS8ZNfrRRDCfg8yrKrgSIDTEGkiErlN9nuUSLUjau8x0/1A5bIxQGE/QY4Ce
XIg/GFuLrMimPG+sl0E6cn/ltjoHS5KT3Jsj/agvuPO0cXU12HUJWTFrECGi
5J3qZkYrMhBXUblwuQKkHzDsf6eAgdKAvGCCbyUqyDiMZRNKIW2HwIXntvPw
aG7bgMuhPnTmAguPBVkVVLmMPy41IQI4zjYYG7WihpLRhSpCGewtp5D6JYf9
P62deTSV6/vGSSoKGVKGTqmoDIlGRTeFNGkiOQ0o1VGkpEwZUuRIhpSh0Vip
yLixDY8pQ2aalDm2eb8hmVK//V375qxjrf7ot86/lrXXZr/7fe/7eq7rc4Fk
TTzHlKxX5J2YaHFQNwG5UNebNau7YUNbTq5fdC358750zql5uWBdrn84W44J
dH598ZtPqomM1sMWV58sGOWXr+6aQ4Ews56/w+I1udgqJKX6LQMePVny4kIv
RXwTBw8GGTwnqpu2dRVNvwcRwfOG1T92wch2yiX+dT35S1075Hw+HcTnVIY4
/WyH8rVHFBMLPxPlKcqXeVfSYOCz+burd7vgun1wrWFPA3lQd72Jwz4JBu8z
zpw63ANc3LUHOj5/ILc8NT36NiVBmeYdWuSVFmheXPfXsEM7aVngp7SDKxbW
HI9MU+5tA/vwHu5Fi1rJRsVhXnXdWFAx1RM0CO+EPIsRKL/bREJOcUxL7osF
hQML1AtfdIPaUb233AK1ZKH6nAvm2XEQKCPBbbOUApWvddPzuQqJZ7j1+80v
siANfX1f0NdXpcH29bXjuWQ3nktm4rlk2iaurmvAIGvur3PbMcYgFbtdl0oU
BQBdVkpO4/N7cpJr5MzpmB7isWvGhwxdfzC77LC1dX8tCakI4mgJ6CaGZy3X
qUYmwPzEj32jAmWk8XzA8dvfmIQpyeBvZj2vZ9ZvNY5LpeDSQF9eR91zwnHk
oVCXRSZkjZqprOloIKqJAWfaLneR8npu3305GTBjQ1Pt7BmN5IPq2M/HPF2k
WtE+let7AWTzbYWpJRRsUTptayNzn/Du+rqV1pUGwxyl90wSmSTyI3dq6s1K
ksSlUrXrWCxMHfwa9SGaSVKCZnTzRlUSZTMveWm/ONCKntlcYNkG00O7fa3G
WohoWOa9Y0YFEIH+/Dr05+eiP3/8eR2Fz+uV+LyWuV+6rDSlBWpaiHYCTzvx
mV16S+R4FgwyNHiVTrDmgctbaMvfvSLFoouLmo8mQzjqsbWox+qhHluK8zM/
zs9pOD/ftFJL8+9iQtvsg/epteVk7IulrNDGJNh+oD98kdFbklpwbJQ5m0lM
cyMc9PQToIsndd9IfQ+kv14rGe/4jghOvf7glWE8MALMV1YHN4G5vIekA62T
6N3oYVxzDIYXmIfiwzzUHsxD/R2zdbDpTgssujjU8AfruuX1m2t2PuUhBHGY
vj3R2Q7dMkpJEbwtRDVwvTNvWzjIoD+5D/3JWuhP/q/ut83Yqy6Dvere2Ksu
1Fa690l7KmmKCbbjLaGIk9yHEJN5URM94EXYA34Me8An930nYd/3f/U+VWWW
RnQ2VoPU+bBtN3SYZIRH93NUGQ2mW/+7X1juJLtf2HOWcr8p50fy7UZCi4lg
O2GUnAw0u9sIFPZaflvO7rV8hr2WYRKzbz42Z83/Oo3B0rm5cFaFY2hGddpE
36IQ9i2mY9/ieA+gHvYAZmAPIB/y4gyRF6eKvLhh7IlTwj36Me7R431w3vLs
PrjL2Ae3G/cgV9yDTHEPGtfTXqCeFoB6mhr2bV2a1LfFwF6h7dgrtBl7hUxQ
n9yE+uSfqE+O63hSk3Q8ptTpXYpVFDG//kVnzfxoeKoW9823kPZrbpgRVSP4
iSKHjMWf7WW6QxHZJ3FCMmWCS++EXPp05NIvKzoWdDWNNVdTAUUNPnHk6yvh
BuORNIhe7CVvlUBBk/i+th8xNHLanvfDvhv0375+nOwCRKz1yqCztKEsVJQi
h93vrZ+Z+mu+cRnm0R5gHi0S82hKyEm4hZwEReQkvON3XD/d9gMJmepTnHSh
h/jpBYav5kqCQt81z20Ki0jJ4jlLnZUo4jlP02Whbwqcw3zWAsxnWWA+S/jS
MoEvGRS542pqLWz0Ajj3WFCrVmSAEfKdwpHvNBX5Tk14PhKI5yN+eD4yzmsy
QF7TK+Q1jZ+bcNHY5yYDeG6yscGR7yTrc9fzWJQXPsWN1Aeej/3OkQrOrb1T
hOspMiDp1W50w5tIPxLcYTdAA75ShcJK1u/PHi3Yae18kzx/bvWVOz0FPG28
OGP+x5VdeaHX854X6/o/1aS3KBn4pdKFcjS6QNOF1pFxooF8Cvgjz92jAExN
xD7TayhyeqbZnVy6G7lno3l4qh/rdc7/JXn1f7ym+1m1Z7a5k/uzRfhydyaD
cN5a7Vtru2Gjd011jkYt2apb6W639xWIj76N9Gb9/oiEd2z1dXsylnZixy7T
ZGgWkjvsYtwGkue5ZhZsayVnHG0zxui5IIvzjxrOP4dw/hE98sXW3LYLzLxW
rN+e3kDmLvYprsn/h8vkhFyma8hlMta9t+auMxOiV/H4xQlUEXs1kfs7Z6XD
qEBqY4oUBd5yLv42Nq+J8JxiMz1/Opw9emTDGRcKbF0iN9E9cwgzx/lLsvM/
5xc6qFNxDLJ1qvEeDeakHo1x/lLdVjZ/aQXyl/5QfHpoFevz2mMi+jQn6gpo
z+3VXbkwGfrRD8ZEP5gB+sGkUb9qQf3KF/Ur5Z5CW9NLreDdvjCWdryN5Me/
rzCWzoLaTNIfQjqARyes3yyqmaxro8x7fdOhq/VGaaU3E4SLRgWNOarIvXwL
u0jNFOjxf9kyVZYC2tHzrQNer8l5a6FhZmTyxPnLxUnnL1dTxKe+eEORBbPW
mrrqP4O4S+9uJOfQwOAan7Qi6++qVBmcyfntNgTtlnDeE04DH/ShXUcfmgr6
0NQzj+uErayGC5oNnsZ6TOLUC48yXqWBv+CJepsCBmQIXgrbyPo+iQjuf9id
TYPQt0OGa08zQVV+t7SPfDXJ8VVXsl+VBGtRDy+epIev0JvOeWduIDHIeqPS
uoBOTpesPLm4moKHwxUnt9WyrltX9YWugeEwq6RkXlp+Eqign00E/Ww/0c+W
PdAjICfAhEUVxwt4L74lax3VRDkux4M2l1zqcdZz9pQUr23ipjh4xikicOtQ
InQXq504wHrOhq2YN8fvayZYllY47uCPhzx/7xNPdlAw1Kf9LXR3Htl05V4Y
/WA2pCFfuhj50j3Il+7JENil/50J2s5J71OuvSZjZlZa0rXZ4GhoqKdzmYLy
25XerTJZRKZF+kq6QtbEfdsP79uZeN8enw/DcD6Mx/lQRTtb+q1dJ7nq161h
4d5EzmhVdd9uJZCDnOc9yHmORs5zpQh/xX4BCr7HD8lFjRaRHp1nwtJ/Z0Gv
zBStAicK5i4d+VlUlEWyFVPbpU5kwi2tlMGrrO/LcpUNvIrbEgj96BurRZvT
Yb5Gm4byAJNkLzNcrHCqnAgoa/W97XoJBT1B1b2K7cATHS1muqyF0FVnmip/
zAcJ5CG3IA95LfKQ0wW8Dyq3M6H+vEaAuUUpkV+Q4a90NxOAFpe/1JT1/DLc
HhpkkEdal7+JtfZMB62nrT9qH1MwRfet38WddLI+RNrl7gAdZJEDHIwc4BfI
Ab6A3N2dyN3lQu5ukPPCxs01XbD9Nt+zLsEGUi7xl1nZgX/2IA7cg3xxD1qB
+8vGSftLDM6fPDh/7sf5swr3kQWT9pFPOMda4RyrjXNs8dqZAtoPWwhtMCbI
17adBCfMkAnZ6QwS/f2GO6LLgLZiV5iCIEVUlh+VkVI4D6tLbQUCP7LmjCUz
Bb5rNJCyHzZtGsEvJ+YlKZyXYnFeUprUE5qLc8u06NWmc+qYRGxF9DGD1xVk
Lt/Vypf7H4EJ9vTlY0+fEfb0FX8/PD/yXDfpG9u0a8GeEiLxd5fn9PgamGO9
rMRoHkXoMXfOnj5YCppGumPynS9ADjk/l5Dz44+cnzpZGocoPwM2/xkoO/KE
QZT5roQuScqd8B8+9Wf7D+noP7z9sJGex7ov9a7U4fO08yDldcW6pW9o8Ah5
kksm8STNj/2b+5SK3KcHVX3xHc9KQF3D+eAQg0lowymNj6qyoAy5Ohwv2Fyd
KuTqvBJ05OvO7YYf3OZHO2Z9JGleKtwcJA8MM0/biScyYf3yVW3HO8rI8Ky3
QmK3cyBRKSjBc38znOSqkXNz6yBtQgqejlsKoRd5+8+Rt9+EvP1PblraS+8w
oeaVj6OdYgUZ8LimeUgrF2hqbm+Uz7H2uEqT+i8JDDLfu93/4o9ieIccm2U2
bI5NSxSbY5OJnJlm5MzUIWdGm5J7adtBkRYPYY2XZ+NIC7VpFsfXB1CLfuMd
6DfWRL8xr4PKUAhrbvPm3SUf2llK5ok7mlgKR4Ap8qJTJvGiDUyXGK8f+QCc
fwSKxp3rIdwnrogPbwuDh8HzcmN820Fa/bjq01MtRGe7c7i6SSwwVZTLzBs6
IbF3/aj+piZyK0Z2mz9HHHxHjsdC5HhUIMdjXLcfQd2egbr9uA9wJ/ZuN6AP
8FqucW/PGEXErGYJSV/0JTPePNOdJub723NszCSe6knkqd5Hf84t9Oc0oT/H
QLhR8QonE5J1tYw0j7Du/0diBRY1ZsPZSdwnS+Q+fTc2U0qsLgPVm2bB31xY
+7K98OufRwog5pSF7JbNTLLARMR0j9kbomTvzTC5HAtpoZauL8tZz2U72owM
Pzo54sx7d6t4CNCQe7MeuTexyL15iPwZC+TPLEH+zMZpvuVeMz5BsyWjTIzJ
+h63KWkLvoyFkn185xheFPFZHar6jpkDfzve8ayqT/jl/0f3F7mtbbi3+uDe
qunK3lubjtltFZlLEdvGFPEhw1LiFH2748CKGKAUXl27qNVJ7PIVzJxrm8jq
5K47h/My4Ymc7M8H8hSpVoio8BAqIV83BcGlHc+hXMhsS9JfzcDQz2H2z+sk
yvpd5UYCsfBRdLn2kFcbCfpyobbvUSsxVX5TsFgoEiSQ412AHG8r5Hi/12Z4
uSl+hvQlWjX9/h3EoXXY8nNGBAhtNLL+tpwBX9QC7Zx52khf4o0tV7sfQyZy
rT2Qa92JXOt8zGcZYD6rG/NZv3u96aLu6oO66zfUXUMwR7xnDztHHIA5YnnM
p5/DfPqfmE93xPyvHeZ/yzD/+x7zvGmY503DPO+v3k+wxVePFJkeot69xHnz
iY9k1Wp33UNXLgDjFzrG/rHBM3HvaGT3KZl3oqz384nzCddqr6gJveI26hU/
/mO9wqn8O3cra45teqL/1TLFHeJ5xuyThOiQP6kPdwn24VaZ51BnF1UAD7dx
a3Yvk6y4JKJA4sMgFX2/W9D3+zf6fkVrXaplXWmg1H9j8GIDRRSqH+mZlHr9
8v0Q7Ic9jf2wc4vY/bB01C37J+mWwahHdaAepYZ61K9e3zQ19ujqaxTZcDgz
8ZZtNmzfrnQ0cHsaFPYX0xTdumBqhrWBkkIDUVspWdxllTuhq/ChrpKDukop
6hV7Ua/QRr3CEvMykpiXycO8zLj+/AT1Zy3UnxuXxZ+pH6CIyD2uAhuxx4Rz
g5OGiWYwMBSu188foYjNsb6nVvIhJErCSmXO2TswbRab/zlzEv/zEvq3F6J/
uxT925HIlziLfInVyJdQmMQR8kGO0N7VvncsHn2CiE/RdsvqWPe3dfvFNmi6
T+g/2bJs/YeO+s8G9CG7oQ95CP3JPahfTZVl61cvUb/am/nOQWxbLfA800kr
Fe4my3dZpXs2FYDBqMvSdccosrdh65LvnBGwhV+fv92pEG6W3cq4d7iDrBJL
6fy89zNxmNb3/Grvr88lx7mOexrZXMdtyHW0Rl/lQfRVVqKvMhb9hD7oJ5RE
P+G6Y05ujr3vAW43xzdHdpP7NzT8p46UAdc6du+zEPY+W2Lv88YhxqG9y5pJ
RIiyu7dGJxHXeTXzZFYcdM5j5zVCMa/Bi3mNQuT4nZvE8ctT/2GaFsAkTxym
O+RlVpEE/fxnoXIB8BN1OQXU5eL+n/4WB+QcDtWwOYedw2zOYdaFf+uTy1Gf
HPctLEDfwm30LYyf14tM6rVM9PCou/WJIrKONyNkxlzB+Nyf+md+Jk/4Rd3R
LyqFftFx3+Z+9G1y7GT7Nsf9lnPQb+mMfsvf/Xt/9+f/B7IXyJ8=
     "]], {}},
  Axes->True,
  AxesEdge->{{-1, -1}, {1, -1}, {-1, -1}},
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  AxesStyle->GrayLevel[0],
  BaseStyle->{
    Specularity[1.], 
    RGBColor[0.1, 0.1, 0.1]},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->GrayLevel[0, 0.5],
  Boxed->{Back, Bottom, Left},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{706.387751858264, 690.5263157894738},
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Lighting->{{"Ambient", 
     Hue[0., 0., 1.]}, {"Directional", 
     GrayLevel[0.6], 
     ImageScaled[{1, 1, 3}]}},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0], 
      Opacity[0.2]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{0, 1}, {0, 1.1}, {0., 11.957115956366373`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  TicksStyle->GrayLevel[0],
  ViewCenter->{{0.5, 0.5, 0.5}, {0.4346347192582184, 0.6295421018337128}},
  ViewPoint->{2.913850524808676, -0.018654490409865037`, 1.7202113617400259`},
  
  ViewVertical->{-0.5083585926336268, 0.0032545150858952223`, 
   0.8611393321798244}]], "Output",
 CellChangeTimes->{{3.851991175596321*^9, 3.851991188156067*^9}, 
   3.852099769026505*^9, 3.852099840152269*^9, 3.852100226701511*^9, 
   3.8521006529204493`*^9, 3.852102744002846*^9, 3.856790500789186*^9, 
   3.857306002990883*^9, 3.857311947626852*^9, 3.857312736106235*^9, 
   3.85731678740065*^9, 3.857472550671721*^9, {3.857472669108161*^9, 
   3.857472692148705*^9}, 3.857480400691743*^9, 3.857501084918508*^9, 
   3.85751684082974*^9, 3.857576042248208*^9, 3.8576555356399508`*^9, 
   3.858008094574027*^9, 3.858190373694312*^9, {3.85819053694692*^9, 
   3.858190561208508*^9}, 3.8581905935094357`*^9, 3.858876353012439*^9, 
   3.85887641584039*^9, 3.858888412524292*^9, 3.858888447610903*^9, 
   3.8590474227129908`*^9, 3.859048668743128*^9, 3.859055932660043*^9, 
   3.859055981347761*^9, 3.859056066521394*^9, {3.8590616015634947`*^9, 
   3.859061670247501*^9}, {3.859062639367021*^9, 3.859062726351935*^9}, {
   3.859062935406145*^9, 3.8590629610373163`*^9}, {3.8590630306016207`*^9, 
   3.859063110087426*^9}, 3.859063209105105*^9, 3.859063594284299*^9, 
   3.859063739203479*^9, 3.859063919321176*^9, 3.8591468638044157`*^9, 
   3.8591469757697287`*^9, 3.8591473452516003`*^9, 3.859150067947382*^9, 
   3.859150832550988*^9, 3.859299305542027*^9, 3.859299470963406*^9, 
   3.8592995234605303`*^9, 3.8592997719401207`*^9, 3.859299823649127*^9, 
   3.859299889982214*^9, 3.859302531927579*^9, 3.859302611165657*^9, 
   3.8593026756296463`*^9, 3.8593027617801313`*^9, 3.859302802811504*^9, 
   3.8593029283883667`*^9, 3.859303095524315*^9, 3.8593114531442757`*^9, 
   3.859311779704855*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"4644ca40-3f85-48e2-8fb8-609ed000a39a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0"}], ",", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etax"}]}], ",", 
      RowBox[{"p", "->", "0.01"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", 
     RowBox[{"-", "7"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1.1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.859303102362812*^9, 3.859303133370399*^9}, {
  3.859303200563332*^9, 3.859303200917244*^9}, {3.8593119194750147`*^9, 
  3.85931193848449*^9}},
 CellLabel->
  "In[184]:=",ExpressionUUID->"891cc3a8-96a2-4bdd-8f47-d24ac8335532"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJycnXlYTd8X/2+plMzSgAZUhggRTbrXFCVDRJkjSihThoyROUSGlEqkZIxU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    "], {{
      {RGBColor[0.1, 0.1, 0.1], Opacity[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxFm3n8VdP6x/cZ9jn7nP1Nk0pKI9KEimuer0LzPNCcIUOiUqYKFaLcKGOT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            "]], 
           Polygon3DBox[CompressedData["
1:eJwtmwf4FcUVxff/3tt5u29BkN6xoIJgo4g1KkZRwEJRmoVmQRCwAQpSxA6C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            "]], Polygon3DBox[CompressedData["
1:eJwt13u8T1Uax/HNOcf5/X7HpTDkEjGkRCFqoqLphjhuKZX7JUmFEJUukkv3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            "]], 
           Polygon3DBox[{{2734, 1086, 372, 2085, 2101, 2719}, {2550, 1130, 
            1129, 918, 987, 2551}, {2216, 308, 1096, 2124, 2097, 2906}, {2704,
             2075, 1392, 1393, 2076, 2705}}]},
          Annotation[#, "Charting`Private`Tag$1144390#1"]& ]],
        Lighting->{{"Ambient", 
           Hue[0., 0., 1.]}, {"Directional", 
           GrayLevel[0.6], 
           ImageScaled[{1, 1, 3}]}}]}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mHuwlVUZxvf+XHt/Z+99AEHRlJQOpBgUSBZxkVtAaE0jZqDojKDNNF5G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           "]], Polygon3DBox[CompressedData["
1:eJwtmH2wVlUVxs/73v2ec895EQTyo5Do6hgI4YVKhJSP8hZp06hNidqMqM00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           "]], 
          Polygon3DBox[CompressedData["
1:eJwl0t9rzXEcBvC3mXPOzlmElawoFhMXzpLT/JqTNpKLlcKd5HZtu1EucGi1
subsQlK4IxfbX2BLEx0UzY2GK8mFH7lgK0VMXt8+F0/f7/N8nud5f77vvpvO
Dh8faoqIzbAC/uYjKl52w0MHS/iPlohTyyJe5CLq0F2K+EqrOBvlOy33BW8t
RqyRmWmOmIYB2iSUaW/webjHU6ct0n7Kr4WqvhK9ZsY3/U/gAK1Au0D7jM/C
Ptpv2UMyj819YO4vfGchYkz3VWjjLztfLnvM84/cRb4mfD90Op+inYeKvoPF
dP9WfSWo4m91tst+yqX57/AleM43Tzvs7B/eYe42mU5o8HXR9+ic4HmZSztb
4Bvnq8q2862H+2YM5lJmK74FdvEcke3TcSmfdpbtbnsxfecr/uv0Hfi1bPey
Bbk83KZNOavJlHnr9nBSX4PvJt8ivgB38D7eu3wN/nGdw7Qec596/w4j/Kt4
VtLf6+7XU/a8QZuDDu9dZlzRsRfvbUn7vUVfp/M1/oF+Qu5oIf1D/fi5bH/u
8Aw20FbThmiP8NnmdKfsblnmMl6Dj3rndPa630bPM/n0f2X/2X+LplY+
           "]], 
          Polygon3DBox[{{2617, 1963, 2099, 1317, 1316, 2618}}]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFV3tol2UUfr/v8/fdfkuKClRSZzNT8RaUF0zNpaamFmUWNI0CN03nFc1N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           "]], Polygon3DBox[CompressedData["
1:eJwtlluIVlUUx/f5TvOd75zPpOjFpLw7KeiMQWmSl0bNvI1RTfbgaBSMY94v
VIxEUIkoRUbmpehBSx2jgXzIKRRNIu1mmKQW0Xg3y9K8X1H7/fmfh8NZa++1
1l7X/95dn5/95KxCCOFzvtv4PkhDuMrClSSE7u1CeB9+JetXWHspC2E03wbo
+iiEftC7iyFEsde+SywjWdmQrVdKIQxB/2ZFCBvLIVxOcvt8Lax9D/8pdAl7
fUSj0wA9ha8Fej9fC3QH9vrhz0L4Svi+nPkZZw3E/qvQNXxV0LuQa8XepMj+
/Ix/k6G38PWCL+LDYPyZydmboLsT9Bbk72CtK3QbMj/B1yK/EnopZ9yE74b9
ZdB7MstJfhV078S2d8L/iM3t2HyDfz38Wvwpw4+DbmJtM3RP5L9E/gvWtit+
/Hs68loP9noT4w+s72D/GeRfzPOpGsyG3onNJuijrM2AH5NZtoB/C6AbyM+5
4PNXILsf+43Y3pbnV/bvZr1THs9q5K9jay3fyMw1V9yKX/VTPb4JzkET+xv5
nkD3EmuL1CuJcx1YuwYd4XMV7HN5vdex1oTuFL5W1m6g35n9bvjQUraP8vWu
ovNTnVlWOnOxv5D1q+w/yBkDsDWd/UHQC1ibBv2v1qAPIX8qcT/IN/lYB306
sewx9v+D7lh27kR3JtY74ScG10y1e4/zzkTOmXI3peRaq0fGc14XdM6i+xf8
HPg5qXMnn6tzPkJ3Pfxj8HXYbCg4p8rtYuzVYi8tuv86tbPf8v+FzD7JN/k7
E/7N1LErxqnQi9G7AT2MtYeR24fMPGLtAr8a+jBrewr2IYG+lzNOFOyzfN+J
zDvID8WPi2X377PIVuTzIf0PoVs5Ywxn1SPXE/nRsft9Hj4UIsucSu2z8ltZ
dCznS563k3wXU+dTs/0PPpzD9l7kZ8TGBGGD6neQvWnwb+czqdnUvnL1FXRj
wTHJn23o90P/PvZOIDuM7zqyg0vGB83DJ8guEKhx/vCy8zWE/fvZ38p+NfqV
8MfZ+wV+HHw1MsuhO5Ttj2qieK6l7ocRwi32zvBfElx/5bQ5NRZqRs6VnJ/D
wiv22yvXRedCOREWqSfUG3WR500zKGzRzGs2NTOaneo8P5oJYUdtPs8jy66X
sEb+zOC8l7E3irUVqWOQ7vkKz9dv6KwKlunPXhsyG5G9J3E+drO/OLhHhC/C
1PGxMURYG/FNKjgHyoXi3RRcE+H/7dj4NnG/nMXWA6l7VbVcWHY/COt+x+aB
zDlX7tXT6m1hlrBLMY3NrCNd9UMzco/CT4iMlVegu3LW4/Afc/4O6NdT935t
3i/Ca2Gb7hDhVR/WBsH3io05wl/Z647+POitJZ+lmk/NjGl92a+KjXUX+Pct
uH4HYutIt5DjdWNq/JKOdFVvzVIPZOYn9lG+3kKmS+J86Y7SfTkqM4aoPg8V
PZ9HYmOPcq4LWTOk/qlJHH9z4tgUY8eS8V6x605UvdSfqqVq+lGFcyw8rMr7
XXHJV9X3EejjJc/yevROs78mte9/s3YBekPq2dVMjc3rJ1u6bzVLc/lOFhyD
YtFMajaF0TXQ76bGqj+Fb7rPY/eD7rxfoZen7l3ZmJbjibDwSMH4rhlQP0+P
c+xIncuGvJ/Pp+69Cbm/4uW73gDqx6+RGRG759X7yqF6ST4ot3rf6K57jW9z
6pnSbOk+V78fRXcfdH/sXVbuEt+lk+GXCX+RXRK5JvVFz7Hm+Rb7TxV9J+pu
1B0tvjExNqiHhyTOf3MwZghP22KfrZ67kJ83NfIbSW+lS/j3FnaOsHYa+UVF
45/yPTCxj/JVPXQsdn2EVcJA5Vd3ivCruui7Rney7i69eWqKzplytyvv1e3I
D4/9BtNbTOfrzaL+n5/jg/w9hMzBzHeK7hbVaCZ7szLXXmfqbL2vVDvFrPMU
g3pBNmV7QOa7f13ej3pfKJd6Y+qtKXu6GxWz+mli2fOtOW/fzhjzR+x5Ffa0
we+LfcaKzD5qrjRf8l3zpLtib3D99K7ULAlThsZ+b6gX9QZZmvo9ofeD3mCr
KuyjfFU8quX/9wCRQQ==
           "]], Polygon3DBox[CompressedData["
1:eJwtkk9IlFEUxe/0yvHrGwRRQaXBDFErURNJQ2bEUcNAQkRQcFWbaeEUIi0M
2qjIJIIRaC4rnMnFEELiRrBWaRQoiH8IcuGmRdDCMHWh+LvcFof37nnn3Hfv
fa/04ZPuxxdE5Ca4BAK+yBmbBIgQP88WOb0s8pf4AaiGG4RrBi+dyBJYDIhc
DYr8wlvAOk8cg1/BF4ZrzBLJ4D3moqdwd+Ha0B2A33DznsgN8t3Gswn28Uc5
a4IbI/7gLGc+XDveFtYhUIb3Ld4YXCFxEYihewXXCneFOAw64KbhpsCJWB6t
s0V9oJz6ZqlvmLNH1NcHV8Xd10AJ3H24JJof5PlOLZMgqrXBbcGtOqtT670O
6tmvgz3OItwz41kNup/AkyAuR1eD5ouzHA2cjXO2w/4rXBJE0FSCOvbfnN3f
hK4CrpZ4zZn+Dtw9aowzj0/0sao9/+9jGa7sokgXnpwQgC+Ei6OZ5L4hz2a0
QJ42Z7VrDzrLDFyrs/u1jhSYA3E8/3RWrCMgyn4OTQq8If+tkM1H5/QR/ERT
G7J+tK8FsA1XGrS/0+7s7fUPFFNzDXW9o48keQfIlwXnwQ3DdcK9QPfHs3+i
/6URzKDL+PZmlZoLTMP5cHl4R/H2433N+aFv76Dvs6FvgE7I94y5FGvvoBfN
e9Y0yGUfRj/G2gOOqfsIzGLb5bwBf5o4CALkHCRXvWeez77NTGd3DqBwZLY=

           "]]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl019ozWEcx/HvzsbZ7GyTP7ckhV2MJIlGyL+MWeNCY6kprGZbXFgtJcpK
cqHInX/5bw1NzPxpLVdqF5Lt7GxGiVLYFeJiXj/qvHt/vt/n9zy/5zzPOXMa
Wmqb8yLiDdamIpJcOSniSX7Eb/RiL8oLInYVRizgueqFvAgVmI06Y/P09+H2
lIjL/AdXsB/VxvM8t1L+Zbycn+E5mpE29lP/oPwCLSjUK0IKBcjHYf0Ml+CH
54+ot6JU3cdtKJOnYpvcjhrMV0/HUXkGD5g7k2vVx7Add/Wu8wSO4yROoL44
Yqf9d8pdWIwvOIUbuI8+cx/wEnzFGdxEN/qNPeSl+I6zeKV3ix/hMZYhi3H9
3ckZYgOWJ3P09vAdbMQKfMI3/YZk3+jBJVTZ52e+iNzkiCYXOuhOR+Tkoofk
C+mIA+46K79114MYloc4x1ke4WEe5Ry/S9bgMR7l9zxmzVZr9ljrg7qLT6tL
iiJeqyfspZ/HuZs/8jUe5PM8wB38ktv4KfeiUb7KdXyOq7iDK7mdK7iVZ3Gb
d03zznveXabu5EPqHfZYqq7lEq7hDFez64wt7PhiM1siNrElYz2vQzr5P7Cv
GE3WXCP7RKO8WvDTiVXsmP9NzAip5GxNKM77/1/6C+pMas0=
        "]], 
       Line3DBox[CompressedData["
1:eJwl0k1LlGEUgOFTY+THpn9QooIITRISLYwydSEMoTE7o0ULkRKjFuEsCgIh
BRdCyCAiBOkIIeOAjERgiIQZCRbOKEhfVL8gBBdtul5aXNzPOc/LfDGNd+7f
HD0REc+4VRtxRof0rD7QtD7WKzqpGc3roBZ0ibvO65rTLZ3QXc3rm7qIp96g
4Pz3ZMQLc9Zcdi7b/fHcO122H7J/bb9nLuqkuXoqomJ+ZR42Pz8dcdu5ajdW
E/ErFXHMb+b5Sdh/r4/44TzHV474xixfkrP7Q82zzwEzVJPn3V3WPS7RyxrT
bLn7pLt00MOm3apOscNHLtLNhruSTvCBbdp5a39di4zzPnltLrDurkufkPX7
DGjJLq3XyHGDFbvzepVHPEw+v92iLjBCxXxPX5JJvpO5TVvpZLAhot97NPvN
ztFEI5891+e+JfX/f/EPCzpPHQ==
        "]], Line3DBox[CompressedData["
1:eJwl00VvFlEUBuCp0VLcXYq7O/+ADaEJEFYkLFnAGnd3KO6uRQoUirsXp0iQ
4gWKFFqg+HPD4sk7OefO3PPN3C9l0NDUITFRFOUzMDaKcuSj+Ch6TP+kKHoi
c3nKM/YmR9Fz+YKXvOI1Gep58g1veccetXz5ng985BMF6gXyM18oDNdqRfIr
3/hOMT/CGr2f8he/+cNfooQoiqGXOdOtiXUdRzwJlKBQPVEmUZJkitRKydKU
oSzlKE8FKlKJylShKtWoTqZ7a8ia1KI2dahLPeqTQgMakm19I9mYJjSlGVnq
zWULBpi/pWxFa9pQrN9WtqO3fnvZgY50ojNd6KPXVXajOz3oSV6c9+jDDvOe
hjOCkYxiNGPo695c+4x1PY7xTGAik5jMdv0pcirTmM4+tRlyJv08Y5aczRzm
Mo/5LCCNhSzisPsWyyUsZRnLOaO+Qq5kFatZwxH1tXId69nARq6pb5Kb2cJW
toVZua63Q6azk13sDmeRS3oZ4QyH38B+MjnAwXB29bPkoTBr2J+jHON4ONf6
J+RJTnE6zM5ZznE+nHtrLsiLYT8uc4XskHpXw/xhTm5wk1vcDnvo35E53OUe
93nAw/BufNPBvmla4v//6j9D7o2n
        "]], Line3DBox[CompressedData["
1:eJwl09trz2EcB/BnhrS54cJhDkUOZS6cZhhzZszYZnbebLOxDZudKCm5kCRp
TZL8A27cieRCDjkUtaUZU3ImpiGikNeTi1fvz/P5/H7P8+35fX9TaprzmxJC
CN3UJoYw0mLO0BDmciEphHlyPgtIY+uIEHr0F6rTWcQl68VyCRlctV4ql5HJ
RevlcgUrWUWv3mq5hrWs47HeernJGVlyA316G2V27JPDZrbwxCxX5pEfn40C
nupvk4UUUUwJpfSblclyKqjkmd52WUU1NeygljtmdXInu6ingUbumu2We9hL
E83so4V75q2yjXY62M8Bfrrr9CGeR/1G/YtqzlPFD14wYI9z8jnfqeQsFXzj
k3m/PEMfXynjNFfMSuUXHtFFD4OU0MllnymWkz1HtzzFQz5TxG3zk7IwnsUD
TnCfj7yPdy2PU8Ak+0zkmPqdWYp6Aketx8txHFG/NRujHsth69FyVLwL/UPW
t+LZHOQmr/VvyA9cp50OXum3yNlkkmyPpPgbqP/wl9+kkuO9Gm42jJe+16iX
TQP18b7juyanm89gZtxXTpMZlCd7z+yRqjeLqWTp13Et8f//5x8rg2lH
        "]]}, 
      {GrayLevel[0], 
       Line3DBox[{2160, 2338, 2928, 2159, 2337, 2927, 2158, 2336, 2926, 2157, 
        2335, 2925, 2156, 2334, 2924, 2155, 2333, 2923, 2154, 2987, 2812, 
        2153, 2986, 2811, 2922, 2152, 2332, 2921, 2151, 2331, 2428, 2920, 627,
         2606, 612, 2427, 2919, 625, 2613, 2330, 2808}], 
       Line3DBox[{2171, 2345, 2936, 2170, 2344, 2935, 2169, 2343, 2934, 2168, 
        2342, 2933, 2167, 2341, 2932, 2166, 2991, 2816, 2165, 2990, 2815, 
        2164, 2989, 2814, 2931, 2163, 2340, 2930, 2162, 2339, 2433, 2400, 
        3060, 2533, 2431, 2513, 2512, 2432, 2929, 2869, 2532, 2430, 2807}], 
       Line3DBox[{2183, 2350, 2942, 2182, 2349, 2941, 2181, 2348, 2940, 2180, 
        2347, 2939, 2179, 2996, 2821, 2178, 2995, 2820, 2177, 2994, 2819, 
        2176, 2993, 2818, 2938, 2175, 2346, 2937, 2174, 238, 1703, 290, 237, 
        2116, 1026}], 
       Line3DBox[{2197, 2353, 2945, 2196, 2352, 2944, 2195, 2351, 2943, 2194, 
        3001, 2826, 2193, 3000, 2825, 2192, 2999, 2824, 2191, 2998, 2823, 
        2190, 3114, 2705, 2704, 3115, 2189, 2594, 2593, 3076, 2188, 2404, 
        2435, 2403, 3041, 2592, 2636, 2535, 2402, 2621, 3082, 2871, 2806}], 
       Line3DBox[{2211, 2355, 2947, 2210, 2354, 2946, 2209, 3007, 2832, 2208, 
        3006, 2831, 2207, 3005, 2830, 2206, 3004, 2829, 2205, 3003, 2828, 
        2204, 3088, 2641, 2706, 801, 3116, 2203, 779, 2595, 665, 3084, 2202, 
        2406, 2437, 3077, 589, 690, 588, 657, 1980, 1040}], 
       Line3DBox[{2235, 2369, 2958, 2233, 3015, 2839, 2231, 3014, 2838, 2229, 
        3013, 2837, 2227, 3012, 2836, 2225, 3011, 2835, 2223, 3010, 2834, 
        2221, 3089, 2642, 2688, 2690, 2689, 3108, 2220, 2675, 2676, 2491, 
        2564, 3053, 2889, 2219, 2441, 2480, 2897, 3052, 2598, 2218, 2596, 
        2597, 2440, 3083, 2766}], 
       Line3DBox[{2245, 2382, 2966, 2244, 2381, 2965, 2243, 2380, 2964, 2242, 
        2379, 2963, 2241, 2378, 2962, 2240, 2377, 2961, 2239, 2376, 2960, 
        2238, 3090, 2841, 2692, 2645, 3091, 2646, 2375, 2647, 2495, 2567, 
        3069, 2890, 2483, 2374, 2517, 2494, 1871, 2566, 2591, 2373, 2516, 
        2721, 3117, 2909}], 
       Line3DBox[{2254, 2387, 2973, 2253, 2386, 2972, 2252, 2385, 2971, 2251, 
        2384, 2970, 2250, 2383, 2969, 2249, 1586, 2248, 3016, 2844, 2247, 
        3092, 2843, 2693, 2648, 3093, 2649, 2651, 2650, 2498, 2451, 1885, 
        2486, 2524, 2523, 2497, 2968, 2876, 2570, 2485, 2522, 2521, 2753}], 
       Line3DBox[{2263, 2391, 2978, 2262, 2390, 2977, 2261, 2389, 2976, 2260, 
        2388, 2975, 2259, 1596, 2258, 3018, 2848, 2257, 3017, 2847, 2256, 
        3094, 2846, 2694, 2652, 3095, 2653, 2655, 2654, 2503, 2456, 3071, 
        2891, 2489, 2530, 2529, 2501, 2455, 3070, 2573, 2488, 2528, 2527, 
        2755}], Line3DBox[{2276, 2394, 2981, 2275, 2393, 2980, 2274, 2392, 
        2979, 2273, 1606, 2272, 3021, 2851, 2271, 3020, 2850, 2270, 3019, 
        2849, 2269, 3096, 2657, 2695, 2656, 3097, 2901, 2268, 2679, 2463, 
        2504, 2462, 3049, 2892, 2267, 2579, 2461, 2502, 2460, 3048, 2578, 
        2266, 2576, 2763}], 
       Line3DBox[{2288, 2396, 2983, 2287, 2395, 2982, 2286, 3026, 2856, 2285, 
        3025, 2855, 2284, 3024, 2854, 2283, 3023, 2853, 2282, 3022, 2852, 
        2281, 3098, 2659, 2696, 2658, 2697, 3110, 2280, 2680, 2470, 2507, 
        2469, 3050, 2893, 2279, 2581, 2467, 2506, 3074, 2879, 2580, 2278, 
        2546, 2716, 2800}], 
       Line3DBox[{2303, 2397, 2984, 2302, 3033, 2862, 2301, 3032, 2861, 2300, 
        3031, 2860, 2299, 3030, 2859, 2298, 3029, 2858, 2297, 3028, 2857, 
        2296, 3099, 2660, 2698, 2700, 2699, 3111, 2295, 2683, 2684, 2509, 
        2586, 3055, 2894, 2294, 2584, 2585, 2508, 3075, 2583, 2582, 2293, 
        2717, 2799}], 
       Line3DBox[{2317, 2477, 1757, 2316, 3039, 2868, 2315, 3038, 2867, 2314, 
        3037, 2866, 2313, 3036, 2865, 2312, 3035, 2864, 2311, 3034, 2863, 
        2310, 3100, 2661, 2701, 2702, 3112, 2902, 2309, 2685, 2686, 2511, 
        2590, 3057, 2896, 2308, 2588, 2589, 2510, 2895, 3056, 2587, 2307, 
        2559, 2560, 2798}], 
       Line3DBox[{2424, 2329, 2423, 3043, 2149, 2328, 2918, 2148, 2327, 2917, 
        2147, 2326, 2916, 2146, 2325, 2915, 2145, 2324, 2914, 2144, 2323, 
        2913, 2143, 2985, 2810, 2912, 2142, 2322, 2911, 2141, 2321, 2422, 
        2898, 3080, 2612, 2604, 2320, 2605, 2421, 2910, 2611, 2610, 2609, 
        2319, 3051, 2478, 2730}], 
       Line3DBox[{2729, 2640, 2687, 3087, 2711, 2908}], 
       Line3DBox[{2732, 2949, 2481, 2626, 2359, 2627, 2561, 3068, 2888, 2492, 
        2514, 2360, 2482, 2874, 2950, 2493, 2644, 2361, 2643, 2899, 2951, 
        2691, 3109, 2362, 2222, 2952, 2363, 2224, 2953, 2364, 2226, 2954, 
        2365, 2228, 2955, 2366, 2230, 2956, 2367, 2232, 2957, 2368, 2234, 
        2959, 2370, 2236}], Line3DBox[{2734, 2719, 3122, 2787}], 
       Line3DBox[{2741, 2398, 2479, 2724, 2786}], 
       Line3DBox[{2743, 2540, 2265, 2722, 2780}], 
       Line3DBox[{2744, 2543, 2759}], Line3DBox[{2746, 281, 2100, 880}], 
       Line3DBox[{2757, 2539, 2452, 2779}], 
       Line3DBox[{2760, 2550, 2551, 2796}], Line3DBox[{2761, 2555, 2797}], 
       Line3DBox[{2770, 2663, 2713, 2785}], 
       Line3DBox[{2774, 3118, 2905, 2200, 2788}], 
       Line3DBox[{2775, 3119, 2906, 2216, 2726, 2789}], 
       Line3DBox[{2776, 2357, 2442, 2727, 2790}], 
       Line3DBox[{2777, 2371, 2446, 2728, 2791}], 
       Line3DBox[{2778, 2449, 2538, 2715, 2792}]}, 
      {GrayLevel[0], 
       Line3DBox[{1342, 1689, 1945, 1503, 3051, 1343, 1960, 2098, 2126}], 
       Line3DBox[{1344, 1636, 1946, 1637, 2910, 1947, 1690, 1641, 1950, 1642, 
        2919, 1951, 1695, 1646, 1699, 1647, 2929, 1842, 1701, 1967, 1968, 
        1651, 2116, 1652, 1975, 1956, 1704, 1976, 1977, 3082, 1656, 2103, 
        1657, 1979, 2112, 1708, 2117, 1980, 1661, 2104, 1662, 2036, 2118, 
        1713, 2119, 3083, 1983, 1666, 2106, 1667, 2949, 1762, 2114, 1719, 
        2108, 1720, 3117, 2136}], Line3DBox[CompressedData["
1:eJwV0E8rhFEYhvGHaRC+hM/AF7C1oKxYySxQ/i+MmqkZGxsLVqRQo0SSUmSB
UBQLVmzIZsrCwmKSlBJ+Z3F13e99nve85z1tucneibqIGEBnNmK9MWKoIWKZ
h3mDm1oj1uSKPMorPMYjLRGbckVu5ynewqd+mjt02zyDHeSxiwV9gavm9riI
E90+L3LW98ryAeZwrqvyu/kl+VA+xhG6PP/ov+Vu+ZRfcYaetMZ9fMFvuMSq
+X7dnzzIV2lv/OqvOaerT/+Im/Sevsa3GE/nQz7NOOed7gP3mE13hRIy1h7S
XeARZV0zavaa5yfdF57xgn95+z0P
        "]], Line3DBox[CompressedData["
1:eJwVy79KQnEYBuAvKiP0JrqVXEvShsAMQStw8VRT1tIf0KHcu462Nl3tJgRp
UJAQlUIQfRwe3vf3veccVJJCfSsichzuRvQppyOyckhNP5Mz7vSqXNHQE/m2
F7GTiXiXbTpkvLuyn4r45J+x74/cjhl4f9F0W8gTtzw/+qkssLQtvYv6OUP9
QpYIqlwydl/59lq/Yps6yeYf94n9Vr8hxT0NRrap7VF/YJ9ftyf5zNz2Kl9I
M7E1ZYs/27fs8cEaoC8wOg==
        "]], 
       Line3DBox[{1348, 1505, 2912, 1350, 1514, 2922, 1368, 1525, 2931, 1380, 
        1536, 2938, 1392, 2075, 3115, 2077, 2078, 2079, 3116, 2080, 2000, 
        1999, 2049, 2050, 3108, 2051, 2003, 2002, 2951, 2052, 2053, 2054, 
        2006, 3091, 2005, 2055, 2056, 2057, 2009, 3093, 2008, 2058, 2059, 
        2060, 2012, 3095, 2011, 2061, 2062, 2063, 3097, 2016, 2015, 2064, 
        2065, 3110, 2066, 2020, 2019, 2067, 2068, 3111, 2069, 2023, 2022, 
        2070, 3112, 2071, 2072, 2026, 2025, 1494}], 
       Line3DBox[{1352, 1507, 2913, 1353, 2987, 1516, 1370, 2990, 1527, 1382, 
        2994, 1538, 1394, 2998, 1548, 1404, 3003, 1558, 1415, 3010, 1567, 
        2952, 1425, 1576, 2960, 1435, 3016, 1585, 1445, 3017, 1594, 1455, 
        3019, 1603, 1464, 3022, 1612, 1475, 3028, 1621, 1486, 3034, 1630, 
        1496}], Line3DBox[{1354, 1508, 2914, 1355, 1517, 2923, 1371, 2991, 
        1528, 1383, 2995, 1539, 1395, 2999, 1549, 1405, 3004, 1559, 1416, 
        3011, 1568, 2953, 1426, 1577, 2961, 1436, 1586, 1446, 3018, 1595, 
        1456, 3020, 1604, 1465, 3023, 1613, 1476, 3029, 1622, 1487, 3035, 
        1631, 1497}], 
       Line3DBox[{1356, 1509, 2915, 1357, 1518, 2924, 1372, 1529, 2932, 1384, 
        2996, 1540, 1396, 3000, 1550, 1406, 3005, 1560, 1417, 3012, 1569, 
        2954, 1427, 1578, 2962, 1437, 1587, 2969, 1447, 1596, 1457, 3021, 
        1605, 1466, 3024, 1614, 1477, 3030, 1623, 1488, 3036, 1632, 1498}], 
       Line3DBox[{1358, 1510, 2916, 1359, 1519, 2925, 1373, 1530, 2933, 1385, 
        1541, 2939, 1397, 3001, 1551, 1407, 3006, 1561, 1418, 3013, 1570, 
        2955, 1428, 1579, 2963, 1438, 1588, 2970, 1448, 1597, 2975, 1458, 
        1606, 1467, 3025, 1615, 1478, 3031, 1624, 1489, 3037, 1633, 1499}], 
       Line3DBox[{1360, 1511, 2917, 1361, 1520, 2926, 1374, 1531, 2934, 1386, 
        1542, 2940, 1398, 1552, 2943, 1408, 3007, 1562, 1419, 3014, 1571, 
        2956, 1429, 1580, 2964, 1439, 1589, 2971, 1449, 1598, 2976, 1459, 
        1607, 2979, 1468, 3026, 1616, 1479, 3032, 1625, 1490, 3038, 1634, 
        1500}], Line3DBox[{1362, 1512, 2918, 1363, 1521, 2927, 1375, 1532, 
        2935, 1387, 1543, 2941, 1399, 1553, 2944, 1409, 1563, 2946, 1420, 
        3015, 1572, 2957, 1430, 1581, 2965, 1440, 1590, 2972, 1450, 1599, 
        2977, 1460, 1608, 2980, 1469, 1617, 2982, 1480, 3033, 1626, 1491, 
        3039, 1635, 1501}], 
       Line3DBox[{1364, 1692, 3043, 1693, 1365, 1522, 2928, 1376, 1533, 2936, 
        1388, 1544, 2942, 1400, 1554, 2945, 1410, 1564, 2947, 1421, 1573, 
        2958, 2959, 1431, 1582, 2966, 1441, 1591, 2973, 1451, 1600, 2978, 
        1461, 1609, 2981, 1470, 1618, 2983, 1481, 1627, 2984, 1492, 1757, 
        1758, 1759}], 
       Line3DBox[{1495, 1629, 3100, 2024, 1485, 1620, 3099, 2021, 1474, 1611, 
        3098, 2018, 1463, 1602, 3096, 2014, 1454, 1593, 3094, 2010, 1444, 
        1584, 3092, 2007, 1434, 1575, 3090, 2004, 1424, 3109, 1566, 3089, 
        2001, 1414, 1557, 3088, 1998, 1403, 1547, 3114, 2076, 1393, 1537, 
        2993, 1381, 1526, 2989, 1369, 1515, 2986, 1351, 1506, 2985, 1349}], 
       Line3DBox[{2139, 1688}], Line3DBox[{1755, 2113, 2123}], 
       Line3DBox[{2048, 2120, 2138}], 
       Line3DBox[{2124, 2097, 3119, 1412, 1556, 1710, 2096, 3118, 1402, 1546, 
        2102, 3122, 2101, 2085, 1970, 1969, 2100, 1698, 1928, 2084, 2125}], 
       Line3DBox[{2130, 2091, 3087, 2081, 2046, 2047, 2027, 2131}]}, {}, {}}},
    
    VertexNormals->CompressedData["
1:eJzsvHk01t33/29OKBpEEY000EBlSHYhQ2UWCmmmpDKkoqQMyZhZZcocmedx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     "]], {}},
  Axes->True,
  AxesEdge->{{-1, -1}, {1, -1}, {-1, -1}},
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  AxesStyle->GrayLevel[0],
  BaseStyle->{
    Specularity[1.], 
    RGBColor[0.1, 0.1, 0.1]},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->GrayLevel[0, 0.5],
  Boxed->{Back, Bottom, Left},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{315.3717377431123, 285.47376720031133`},
  ImageSizeRaw->Automatic,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Lighting->{{"Ambient", 
     Hue[0., 0., 1.]}, {"Directional", 
     GrayLevel[0.6], 
     ImageScaled[{1, 1, 3}]}},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0], 
      Opacity[0.2]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{-7, 1}, {0, 1.1}, {1.2915561369033484`, 2.830651841389092}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  TicksStyle->GrayLevel[0],
  ViewPoint->{0.06848399197387896, -1.9761942227728846`, 2.7458999138210394`},
  
  ViewVertical->{-0.028104818151020096`, 0.811000901981772, 
   0.5843694517866674}]], "Output",
 CellChangeTimes->{
  3.859303137145255*^9, 3.859303201322892*^9, 3.859311453233371*^9, 
   3.859311788618948*^9, {3.859311919993745*^9, 3.85931193885882*^9}},
 CellLabel->
  "Out[185]=",ExpressionUUID->"1071dcfa-c095-4f42-b287-3109b1fb6d64"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
     " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"eta", "->", "0."}], ",", 
       RowBox[{"p", "->", "0.4"}]}], "}"}]}], " ", "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"tmp", "==", 
    RowBox[{"Norm", "[", "V", "]"}]}], ",", "q"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.857312764600555*^9, 3.857312798025824*^9}, {
   3.857312904046273*^9, 3.857312909765922*^9}, {3.857314189320052*^9, 
   3.85731421902691*^9}, {3.85819065878332*^9, 3.858190661081297*^9}, 
   3.858876572167068*^9, {3.858881605844059*^9, 3.85888162442651*^9}, 
   3.85888345832736*^9, {3.8590474762785587`*^9, 3.859047495503031*^9}, {
   3.85904753561593*^9, 3.859047537698944*^9}, {3.859047855453006*^9, 
   3.859047870363021*^9}, {3.859048696417774*^9, 3.8590487137321997`*^9}, {
   3.859055453104514*^9, 3.859055495591331*^9}, {3.859055904499709*^9, 
   3.859055914017281*^9}, {3.8590559643775063`*^9, 3.859055966513176*^9}, {
   3.859056076283925*^9, 3.859056110789381*^9}, {3.8590562418324137`*^9, 
   3.859056266065133*^9}, {3.859062141416057*^9, 3.859062187229607*^9}, {
   3.859062217390265*^9, 3.8590622445373774`*^9}, {3.859062707788527*^9, 
   3.859062774109733*^9}, {3.859062966941868*^9, 3.859062993795004*^9}, {
   3.8590631209041986`*^9, 3.859063124575926*^9}, {3.859147010719585*^9, 
   3.859147050356143*^9}, {3.859147218425756*^9, 3.8591472190720253`*^9}, {
   3.859147373760991*^9, 3.859147373909642*^9}, 3.859147675930709*^9, {
   3.859151095027693*^9, 3.859151096029614*^9}, {3.859151836585585*^9, 
   3.859151837298563*^9}, {3.859299376600576*^9, 3.859299401412448*^9}, {
   3.859299543426854*^9, 3.859299563239133*^9}, {3.859299649013667*^9, 
   3.859299649736368*^9}, {3.859299706933628*^9, 3.859299719983459*^9}, 
   3.859303225752571*^9},
 CellLabel->
  "In[131]:=",ExpressionUUID->"bcd75a85-a5a4-42fd-9cb7-137e413fd55f"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "ratnz", 
   "\"Solve was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 132, 15, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8592994195130033`*^9, 3.859299475931917*^9, {3.8592995439630823`*^9, 
   3.859299564594285*^9}, 3.859299651015707*^9, {3.8592997084059362`*^9, 
   3.859299721575346*^9}, 3.859299775739303*^9, 3.859299826835305*^9, 
   3.859299893424601*^9, 3.8593025361249237`*^9, 3.859302678847888*^9, 
   3.859302767130571*^9, 3.859302806385407*^9, 3.859302932733715*^9, 
   3.8593032270901127`*^9, 3.85931145443076*^9, 3.859311793562736*^9},
 CellLabel->
  "During evaluation of \
In[131]:=",ExpressionUUID->"42756e10-5193-446b-9bb1-45a6b2cc276a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{"-", "1085.0348326021249`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "1.6271273023294645`*^-16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "1.0147232705695312`*^-15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "1.2071003374691438`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.8590561207915573`*^9, 3.8590562513987207`*^9, {3.8590562853953447`*^9, 
   3.8590562895427933`*^9}, {3.8590621370878277`*^9, 3.859062244936511*^9}, {
   3.859062712026423*^9, 3.859062775805958*^9}, {3.859062968762806*^9, 
   3.859063003764666*^9}, 3.859063037925103*^9, 3.859063126209156*^9, 
   3.85906359950768*^9, 3.8590637568125057`*^9, 3.859063852134437*^9, {
   3.859146993637477*^9, 3.8591470508041983`*^9}, 3.859147219693242*^9, 
   3.859147374339026*^9, 3.859147677366959*^9, 3.85915007642023*^9, 
   3.8591508548645372`*^9, 3.85915109639118*^9, 3.859151837721479*^9, 
   3.859299308954796*^9, 3.859299377246327*^9, 3.85929941957027*^9, 
   3.859299475987103*^9, {3.859299544240425*^9, 3.859299564652402*^9}, 
   3.859299651289535*^9, {3.859299708678604*^9, 3.859299721636903*^9}, 
   3.859299775797634*^9, 3.859299827111514*^9, 3.859299893481822*^9, 
   3.85930253639972*^9, 3.8593026793290854`*^9, 3.859302767612673*^9, 
   3.859302806446602*^9, 3.859302932794887*^9, 3.859303227375152*^9, 
   3.859311454486598*^9, 3.8593117936213627`*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"42d87310-3056-4670-8f39-3974a56d4d99"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVkHc4lQ8fxlGShnTMYzscHCObjHy/RVFIR5pGkpVfiUpaMhIySpJkNGgQ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       "]], 
      LineBox[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAAAuVvkORf7j8GMTGPEK0+QDJ1ebcU
au4/mhEVVmSnPUCKIDu1x2zuP0B9gLXkZD1A48v8snpv7j+qOW6ZeCM9QJQi
gK7gdO4/x/ljocCjPED3z4alrH/uP09x/+4ksDtAUHtIo1+C7j9jZKcak3U7
QKgmCqEShe4/6cFEO+U7O0BafY2ceIruP/aJouUgyzpAvCqUk0SV7j9Du9L4
bvM5QICFoYHcqu4/mcvNAp5nOEANdwdKYa3uPyjgfetDPDhAmmhtEuav7j9N
RBljdhE4QLNLOaPvtO4/wEW4dna9N0DmEdHEAr/uP0p9Cw2dGzdAS54ACCnT
7j9awb3Fg+41QNiPZtCt1e4/zu9ZSNbKNUBkgcyYMtjuP4veh9+RpzVAfmSY
KTzd7j85XewiPWI1QLAqMEtP5+4/xaXWGjTcNEAWt1+OdfvuP15pIkJD4TNA
o6jFVvr97j8vinwCZMMzQDCaKx9/AO8/5e2pXdWlM0BJffeviAXvP3O5v9uk
azNAfEOP0ZsP7z/LNJIp1foyQOLPvhTCI+8/fshGgIAmMkCt6B2bDkzvPwRn
zeI+rDBAiJ2FYN5O7z/0owHu5pMwQGRS7SWuUe8/w7gNuM17MEAcvLywTVfv
P9dFqcpTTDBAio9bxoxi7z/tPYJ6UeAvQGg2mfEKee8/T1yqO3WELkBE6wC3
2nvvP4VZVeLOWi5AH6BofKp+7z/jte3zizEuQNYJOAdKhO8/KITE2SrgLUBF
3dYciY/vP2ciFaHWQS1AIoQUSAem7z8m3XAN0RUsQP44fA3XqO8/bPV+E8nx
K0DZ7ePSpqvvP3gUzzERzitAkFezXUax7z98PBaYjYcrQP8qUnOFvO8/HS1+
Khv+KkDc0Y+eA9PvP7ODQAW4+ClAuIb3Y9PV7z8X+L2rPtkpQJQ7Xymj2O8/
li/5yga6KUBLpS60Qt7vP1awikxYfClAunjNyYHp7z/Cucf86gMpQJYtNY9R
7O8/sdA/8mfmKEBx4pxUIe/vP4nXPGMgyShAKExs38D07z8UhErxQI8oQAQB
1KSQ9+8/x5f+sadyKEDgtTtqYPrvP4BKYzVHVihAvGqjLzD97z83we7THjoo
QJcfC/X//+8/o+yn6C0eKEAZ6KFE
       "]]},
     Annotation[#, "Charting`Private`Tag$659730#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 4.5647021787025},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {4.564702178702491, 30.67603392554249}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8590561207915573`*^9, 3.8590562513987207`*^9, {3.8590562853953447`*^9, 
   3.8590562895427933`*^9}, {3.8590621370878277`*^9, 3.859062244936511*^9}, {
   3.859062712026423*^9, 3.859062775805958*^9}, {3.859062968762806*^9, 
   3.859063003764666*^9}, 3.859063037925103*^9, 3.859063126209156*^9, 
   3.85906359950768*^9, 3.8590637568125057`*^9, 3.859063852134437*^9, {
   3.859146993637477*^9, 3.8591470508041983`*^9}, 3.859147219693242*^9, 
   3.859147374339026*^9, 3.859147677366959*^9, 3.85915007642023*^9, 
   3.8591508548645372`*^9, 3.85915109639118*^9, 3.859151837721479*^9, 
   3.859299308954796*^9, 3.859299377246327*^9, 3.85929941957027*^9, 
   3.859299475987103*^9, {3.859299544240425*^9, 3.859299564652402*^9}, 
   3.859299651289535*^9, {3.859299708678604*^9, 3.859299721636903*^9}, 
   3.859299775797634*^9, 3.859299827111514*^9, 3.859299893481822*^9, 
   3.85930253639972*^9, 3.8593026793290854`*^9, 3.859302767612673*^9, 
   3.859302806446602*^9, 3.859302932794887*^9, 3.859303227375152*^9, 
   3.859311454486598*^9, 3.8593117936616287`*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"8e96eb37-bae0-412a-b8cf-2b264295f5b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finding different incompatible examples", "Section",
 CellChangeTimes->{{3.8588766015102797`*^9, 3.858876656039743*^9}, {
  3.8590615585572023`*^9, 
  3.859061564197502*^9}},ExpressionUUID->"cdaed246-7d2d-4bd4-ab55-\
763c594c4588"],

Cell["Guess and Check:", "Text",
 CellChangeTimes->{{3.859048050389254*^9, 3.8590480567715387`*^9}, {
  3.859048120093409*^9, 3.8590481293137083`*^9}, {3.859302944088767*^9, 
  3.8593029502251587`*^9}},ExpressionUUID->"102b5072-7854-4375-ac95-\
da85f8f850ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{
        RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
        RowBox[{"p", "->", "0.77"}], ",", " ", 
        RowBox[{"q", "->", "0.81"}], ",", 
        RowBox[{"z", "->", ".2"}]}], "}"}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{
        RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
        RowBox[{"p", "->", "0.77"}], ",", " ", 
        RowBox[{"q", "->", "0.85"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"p", "->", "0.77"}], ",", 
       RowBox[{"q", "->", "0.85"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Minimize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmp", ",", 
       RowBox[{"eta", ">", "0"}]}], "}"}], ",", "eta"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"tmp", "<", "1"}], "&&", 
     RowBox[{"eta", ">", "0"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"plot1", "=", 
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"tmp", "/.", 
       RowBox[{"{", 
        RowBox[{"eta", "->", 
         RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"etax", ",", " ", 
        RowBox[{"-", "9"}], ",", " ", "4"}], "}"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8591472889722433`*^9, 3.85914730784096*^9}, {
   3.859147380405471*^9, 3.859147411997304*^9}, {3.859147502336302*^9, 
   3.859147547592536*^9}, {3.8591501824195757`*^9, 3.8591501847619047`*^9}, {
   3.85915093572861*^9, 3.859150937922926*^9}, {3.859151008560668*^9, 
   3.859151008832382*^9}, {3.859151372474163*^9, 3.859151425421136*^9}, {
   3.859151464244089*^9, 3.8591514652157497`*^9}, {3.859151617633904*^9, 
   3.859151635520959*^9}, {3.859151729174575*^9, 3.859151783692884*^9}, 
   3.859151814838126*^9, {3.859151854898387*^9, 3.859151885839718*^9}, {
   3.859299321149007*^9, 3.859299324817564*^9}, {3.859299574249734*^9, 
   3.859299627149169*^9}, 3.8593023665861177`*^9, 3.8593027894280443`*^9, {
   3.8593029530480757`*^9, 3.859302985589437*^9}, {3.8593030539823837`*^9, 
   3.8593030650900517`*^9}, {3.8593034258785152`*^9, 3.859303465194016*^9}, 
   3.859303619269696*^9, {3.859304695394019*^9, 3.8593047437806892`*^9}},
 CellLabel->
  "In[134]:=",ExpressionUUID->"8f40f9fd-67f1-4f8c-9b38-eed28c34c35d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.2051654238784248`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.0007637709444047279`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.000017904686837093178`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859147308807873*^9, {3.85914738472653*^9, 3.859147412815557*^9}, {
   3.859147503404664*^9, 3.8591475487037077`*^9}, 3.859150185846476*^9, 
   3.859150244753652*^9, 3.859150886485585*^9, 3.859150938957099*^9, 
   3.859151009814671*^9, {3.859151373305189*^9, 3.859151426284684*^9}, 
   3.859151467769183*^9, {3.859151621343783*^9, 3.8591516365275717`*^9}, {
   3.859151730283422*^9, 3.859151784712633*^9}, 3.859151815610463*^9, {
   3.859151858893196*^9, 3.8591518867635508`*^9}, {3.859299311163911*^9, 
   3.859299336418507*^9}, 3.859299479409315*^9, {3.8592995761034727`*^9, 
   3.859299585043943*^9}, 3.859299629817025*^9, 3.859299780975836*^9, 
   3.85929983731146*^9, 3.859299895280464*^9, 3.859302372827755*^9, 
   3.859302542997607*^9, 3.8593026830910063`*^9, 3.859302770977264*^9, 
   3.859302809590507*^9, {3.859302935152063*^9, 3.859302960966761*^9}, 
   3.859302992853497*^9, 3.8593030667185183`*^9, {3.8593034361557627`*^9, 
   3.8593034673170633`*^9}, 3.8593036214080477`*^9, {3.859304729659971*^9, 
   3.8593047444110537`*^9}, 3.859311454695758*^9, 3.859311795643828*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"d6d61172-50c2-4d30-bb64-26ff6508adef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.05048443426707487`", ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "0.00002666583852019908`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.859147308807873*^9, {3.85914738472653*^9, 3.859147412815557*^9}, {
   3.859147503404664*^9, 3.8591475487037077`*^9}, 3.859150185846476*^9, 
   3.859150244753652*^9, 3.859150886485585*^9, 3.859150938957099*^9, 
   3.859151009814671*^9, {3.859151373305189*^9, 3.859151426284684*^9}, 
   3.859151467769183*^9, {3.859151621343783*^9, 3.8591516365275717`*^9}, {
   3.859151730283422*^9, 3.859151784712633*^9}, 3.859151815610463*^9, {
   3.859151858893196*^9, 3.8591518867635508`*^9}, {3.859299311163911*^9, 
   3.859299336418507*^9}, 3.859299479409315*^9, {3.8592995761034727`*^9, 
   3.859299585043943*^9}, 3.859299629817025*^9, 3.859299780975836*^9, 
   3.85929983731146*^9, 3.859299895280464*^9, 3.859302372827755*^9, 
   3.859302542997607*^9, 3.8593026830910063`*^9, 3.859302770977264*^9, 
   3.859302809590507*^9, {3.859302935152063*^9, 3.859302960966761*^9}, 
   3.859302992853497*^9, 3.8593030667185183`*^9, {3.8593034361557627`*^9, 
   3.8593034673170633`*^9}, 3.8593036214080477`*^9, {3.859304729659971*^9, 
   3.8593047444110537`*^9}, 3.859311454695758*^9, 3.8593117970496483`*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"3ce3bb0d-c1ed-401c-8e93-a5cf91f1ec13"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 137, 16, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.859303437123329*^9, 3.859303468156961*^9}, 
   3.8593036222273006`*^9, {3.859304730446499*^9, 3.859304746358246*^9}, 
   3.8593114569345417`*^9, 3.8593117977275867`*^9},
 CellLabel->
  "During evaluation of \
In[134]:=",ExpressionUUID->"1575ee34-630f-4ac6-9ab3-507b2df6e1e1"],

Cell[BoxData[
 RowBox[{"0.000012734657861321967`", "<", "eta", "<", 
  "0.00006378790584798041`"}]], "Output",
 CellChangeTimes->{
  3.859147308807873*^9, {3.85914738472653*^9, 3.859147412815557*^9}, {
   3.859147503404664*^9, 3.8591475487037077`*^9}, 3.859150185846476*^9, 
   3.859150244753652*^9, 3.859150886485585*^9, 3.859150938957099*^9, 
   3.859151009814671*^9, {3.859151373305189*^9, 3.859151426284684*^9}, 
   3.859151467769183*^9, {3.859151621343783*^9, 3.8591516365275717`*^9}, {
   3.859151730283422*^9, 3.859151784712633*^9}, 3.859151815610463*^9, {
   3.859151858893196*^9, 3.8591518867635508`*^9}, {3.859299311163911*^9, 
   3.859299336418507*^9}, 3.859299479409315*^9, {3.8592995761034727`*^9, 
   3.859299585043943*^9}, 3.859299629817025*^9, 3.859299780975836*^9, 
   3.85929983731146*^9, 3.859299895280464*^9, 3.859302372827755*^9, 
   3.859302542997607*^9, 3.8593026830910063`*^9, 3.859302770977264*^9, 
   3.859302809590507*^9, {3.859302935152063*^9, 3.859302960966761*^9}, 
   3.859302992853497*^9, 3.8593030667185183`*^9, {3.8593034361557627`*^9, 
   3.8593034673170633`*^9}, 3.8593036214080477`*^9, {3.859304729659971*^9, 
   3.8593047444110537`*^9}, 3.859311454695758*^9, 3.859311797785808*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"e38acba4-4dfd-4afb-b30d-f49505e556a2"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV1nc8VX0YAHBEKA25y92XpIGilBS/NysNhcpMRclIFIqSURmlklRky85I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       "]], LineBox[CompressedData["
1:eJwV1nk8VF8UAPAxGMOMIZS0E1qUVCIq54WQ7GtIqz2SLWVJSaVSInuL9Csk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       "]]},
     Annotation[#, "Charting`Private`Tag$717380#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.11296167968745718`},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9, 4}, {0.11296167968745718`, 1.1846301511638437`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{0.4054651081081644, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.9162907318741551, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.09531017980432493, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.1823215567939546, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.26236426446749106`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.3364722366212129, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.47000362924573563`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5306282510621704, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5877866649021191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6418538861723947, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7419373447293773, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7884573603642703, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8329091229351039, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8754687373538999, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9555114450274363, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9932517730102834, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0296194171811581`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0647107369924282`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1314021114911006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1631508098056809`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1939224684724346`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.2237754316221157`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.252762968495368, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.859147308807873*^9, {3.85914738472653*^9, 3.859147412815557*^9}, {
   3.859147503404664*^9, 3.8591475487037077`*^9}, 3.859150185846476*^9, 
   3.859150244753652*^9, 3.859150886485585*^9, 3.859150938957099*^9, 
   3.859151009814671*^9, {3.859151373305189*^9, 3.859151426284684*^9}, 
   3.859151467769183*^9, {3.859151621343783*^9, 3.8591516365275717`*^9}, {
   3.859151730283422*^9, 3.859151784712633*^9}, 3.859151815610463*^9, {
   3.859151858893196*^9, 3.8591518867635508`*^9}, {3.859299311163911*^9, 
   3.859299336418507*^9}, 3.859299479409315*^9, {3.8592995761034727`*^9, 
   3.859299585043943*^9}, 3.859299629817025*^9, 3.859299780975836*^9, 
   3.85929983731146*^9, 3.859299895280464*^9, 3.859302372827755*^9, 
   3.859302542997607*^9, 3.8593026830910063`*^9, 3.859302770977264*^9, 
   3.859302809590507*^9, {3.859302935152063*^9, 3.859302960966761*^9}, 
   3.859302992853497*^9, 3.8593030667185183`*^9, {3.8593034361557627`*^9, 
   3.8593034673170633`*^9}, 3.8593036214080477`*^9, {3.859304729659971*^9, 
   3.8593047444110537`*^9}, 3.859311454695758*^9, 3.8593117982449617`*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"73d9f824-0c31-4429-bd02-c6eb2ace0ac1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"subst", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "->", "0.2"}], ",", " ", 
     RowBox[{"q", "->", "0.9"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "/.", "subst"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", "subst"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmp", ",", 
     RowBox[{"eta", ">", "0"}]}], "}"}], ",", "eta"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"tmp", "<", "1"}], "&&", 
   RowBox[{"eta", ">", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"plot2", "=", 
  RowBox[{"LogPlot", "[", 
   RowBox[{
    RowBox[{"tmp", "/.", 
     RowBox[{"{", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"etax", ",", " ", 
      RowBox[{"-", "9"}], ",", " ", "4"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.8591471807910757`*^9, {3.859147251865629*^9, 3.8591472739801197`*^9}, {
   3.8591477194585943`*^9, 3.859147868136196*^9}, {3.8591501484045057`*^9, 
   3.859150151192528*^9}, 3.859150280724474*^9, {3.859150903413378*^9, 
   3.859150917836667*^9}, {3.859150997441326*^9, 3.859151001615592*^9}, {
   3.859151109164513*^9, 3.85915111102879*^9}, {3.859151564418458*^9, 
   3.8591515932989073`*^9}, {3.859299327593082*^9, 3.859299331383515*^9}, {
   3.859299635175828*^9, 3.859299635559538*^9}, {3.859299671880075*^9, 
   3.859299691298479*^9}, 3.859302368585883*^9, {3.8593032397803307`*^9, 
   3.859303240768408*^9}, {3.859303475520176*^9, 3.859303475687724*^9}, {
   3.8593036291416073`*^9, 3.859303631700037*^9}, {3.8593047487707872`*^9, 
   3.859304752668633*^9}, {3.859311544653363*^9, 3.8593116145523443`*^9}, {
   3.859311700611129*^9, 3.859311744889326*^9}, {3.8593118596391363`*^9, 
   3.859311899924636*^9}, {3.859311945967556*^9, 3.859311946820208*^9}, {
   3.859312307535411*^9, 3.859312322104199*^9}, {3.859312364406165*^9, 
   3.859312371620018*^9}},
 CellLabel->
  "In[231]:=",ExpressionUUID->"f57be62e-c545-44e2-bdd0-66cf7c8ca389"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.1371690969023073`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.0002674337627070746`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "8.834650143926725`*^-7"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8593115741944857`*^9, 3.859311615035967*^9, {3.859311700993424*^9, 
   3.859311745290061*^9}, 3.859311798823956*^9, {3.859311864606675*^9, 
   3.8593119005506477`*^9}, 3.859311947131024*^9, {3.85931230813984*^9, 
   3.8593123231229877`*^9}, {3.8593123664503183`*^9, 3.8593123721476517`*^9}, 
   3.8593164885084057`*^9},
 CellLabel->
  "Out[233]=",ExpressionUUID->"fc776d80-3bec-4a75-a15f-b897ec47abd4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.11479182869437156`", ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "0.000049186731717734045`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8593115741944857`*^9, 3.859311615035967*^9, {3.859311700993424*^9, 
   3.859311745290061*^9}, 3.859311798823956*^9, {3.859311864606675*^9, 
   3.8593119005506477`*^9}, 3.859311947131024*^9, {3.85931230813984*^9, 
   3.8593123231229877`*^9}, {3.8593123664503183`*^9, 3.8593123721476517`*^9}, 
   3.8593164900461283`*^9},
 CellLabel->
  "Out[234]=",ExpressionUUID->"46628a71-534d-40e1-a016-7b61666dffcc"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 235, 31, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.859311576491291*^9, 3.859311617324296*^9, {3.859311703413487*^9, 
   3.859311747469406*^9}, 3.8593118013712053`*^9, {3.859311866921792*^9, 
   3.8593119027960176`*^9}, 3.859311949111938*^9, {3.8593123104696903`*^9, 
   3.859312325477009*^9}, {3.859312369049261*^9, 3.85931237443531*^9}, 
   3.8593164907798433`*^9},
 CellLabel->
  "During evaluation of \
In[231]:=",ExpressionUUID->"5524aff3-0ab9-4498-8526-79fd369677c6"],

Cell[BoxData[
 RowBox[{"0.000032616872505092204`", "<", "eta", "<", 
  "0.00009930383269042931`"}]], "Output",
 CellChangeTimes->{
  3.8593115741944857`*^9, 3.859311615035967*^9, {3.859311700993424*^9, 
   3.859311745290061*^9}, 3.859311798823956*^9, {3.859311864606675*^9, 
   3.8593119005506477`*^9}, 3.859311947131024*^9, {3.85931230813984*^9, 
   3.8593123231229877`*^9}, {3.8593123664503183`*^9, 3.8593123721476517`*^9}, 
   3.8593164908382483`*^9},
 CellLabel->
  "Out[235]=",ExpressionUUID->"29d76718-e5b8-419e-b050-afdf9a72f86e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV13c8lV8YAHB7jzuMe+3RUCQkxC/nJIlCVlFEISNCEmUnJbTIilIUSRkh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       "]]},
     Annotation[#, "Charting`Private`Tag$1575086#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, -2.1643882955658866`},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9, 4}, {-2.1643882955658866`, 10.16333342191677}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.298317366548036, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.703782474656201, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.991464547107982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.214608098422191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.396929655216146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.551080335043404, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.684611727667927, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.802394763324311, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      7.600902459542082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.006367567650246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.294049640102028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.517193191416238, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.699514748210191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.85366542803745, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.987196820661973, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.104979856318357, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.903487552536127, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.308952660644293`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.596634733096073`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.819778284410283`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.002099841204238`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.156250521031495`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.289781913656018`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.407564949312402`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.512925464970229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.206072645530174`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.611537753638338`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.89921982609012, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.122363377404328`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8593115741944857`*^9, 3.859311615035967*^9, {3.859311700993424*^9, 
   3.859311745290061*^9}, 3.859311798823956*^9, {3.859311864606675*^9, 
   3.8593119005506477`*^9}, 3.859311947131024*^9, {3.85931230813984*^9, 
   3.8593123231229877`*^9}, {3.8593123664503183`*^9, 3.8593123721476517`*^9}, 
   3.859316491311062*^9},
 CellLabel->
  "Out[236]=",ExpressionUUID->"eeb203f5-914d-4ce3-a084-03c02c001b64"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"p", "->", "0.02"}], ",", " ", 
      RowBox[{"q", "->", "0.99"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "->", "0.02"}], ",", 
     RowBox[{"q", "->", "0.99"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmp", ",", 
     RowBox[{"eta", ">", "0"}]}], "}"}], ",", "eta"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"tmp", "<", "1"}], "&&", 
   RowBox[{"eta", ">", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"plot3", "=", 
  RowBox[{"LogPlot", "[", 
   RowBox[{
    RowBox[{"tmp", "/.", 
     RowBox[{"{", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"etax", ",", " ", 
      RowBox[{"-", "9"}], ",", " ", "4"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.859147429240883*^9, 3.859147472129551*^9}, {
   3.859147600950156*^9, 3.859147684465543*^9}, 3.8591501345181227`*^9, {
   3.859150195439138*^9, 3.859150227855425*^9}, {3.859150927868464*^9, 
   3.8591509293384*^9}, {3.859151477024729*^9, 3.8591515030039997`*^9}, {
   3.859151545306662*^9, 3.8591515512852993`*^9}, {3.859299332754334*^9, 
   3.859299334096567*^9}, {3.859299639124544*^9, 3.8592996394963837`*^9}, 
   3.859302370675959*^9, {3.859302841640485*^9, 3.859302898710053*^9}, {
   3.859303049008078*^9, 3.859303050375264*^9}, {3.8593034922989492`*^9, 
   3.859303492460157*^9}, 3.859303638250362*^9, {3.859304823929578*^9, 
   3.859304828739933*^9}, {3.85931144449198*^9, 3.8593114691092243`*^9}, {
   3.859312281776923*^9, 3.859312293774685*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"314a3021-0cca-45e0-95ca-25cd662f6096"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.11320762519672621`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.00003198835316955485`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "7.847302957917301`*^-7"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.859147437703816*^9, 3.8591474729476633`*^9}, {
   3.859147601917449*^9, 3.85914768551467*^9}, {3.8591501295554447`*^9, 
   3.859150135861162*^9}, {3.859150196513159*^9, 3.859150228837398*^9}, 
   3.859150889990491*^9, 3.859150930753057*^9, {3.859151477934844*^9, 
   3.8591515038018703`*^9}, 3.859151552391745*^9, {3.859299316347858*^9, 
   3.859299340297399*^9}, 3.859299590622735*^9, 3.859299640149394*^9, 
   3.859299790462846*^9, 3.859299850915145*^9, {3.859299904221973*^9, 
   3.8592999277202177`*^9}, 3.8593023812949867`*^9, 3.859302556305561*^9, 
   3.8593026950740347`*^9, 3.8593027796825666`*^9, 3.859302820609811*^9, {
   3.859302853936452*^9, 3.8593029006595993`*^9}, 3.8593031527707853`*^9, 
   3.8593034945953617`*^9, 3.8593036406891108`*^9, 3.859304829118114*^9, {
   3.859311447162826*^9, 3.85931146967213*^9}, 3.8593118061635857`*^9, {
   3.859312288035727*^9, 3.859312294437825*^9}},
 CellLabel->
  "Out[198]=",ExpressionUUID->"ecab7961-2c16-4c47-86ca-b5a3533f0f50"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.16773891407113176`", ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "6.545135383997345`*^-6"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.859147437703816*^9, 3.8591474729476633`*^9}, {
   3.859147601917449*^9, 3.85914768551467*^9}, {3.8591501295554447`*^9, 
   3.859150135861162*^9}, {3.859150196513159*^9, 3.859150228837398*^9}, 
   3.859150889990491*^9, 3.859150930753057*^9, {3.859151477934844*^9, 
   3.8591515038018703`*^9}, 3.859151552391745*^9, {3.859299316347858*^9, 
   3.859299340297399*^9}, 3.859299590622735*^9, 3.859299640149394*^9, 
   3.859299790462846*^9, 3.859299850915145*^9, {3.859299904221973*^9, 
   3.8592999277202177`*^9}, 3.8593023812949867`*^9, 3.859302556305561*^9, 
   3.8593026950740347`*^9, 3.8593027796825666`*^9, 3.859302820609811*^9, {
   3.859302853936452*^9, 3.8593029006595993`*^9}, 3.8593031527707853`*^9, 
   3.8593034945953617`*^9, 3.8593036406891108`*^9, 3.859304829118114*^9, {
   3.859311447162826*^9, 3.85931146967213*^9}, 3.8593118061635857`*^9, {
   3.859312288035727*^9, 3.859312295626093*^9}},
 CellLabel->
  "Out[199]=",ExpressionUUID->"8f499cf6-48b0-4d57-838b-cdacca786295"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 200, 26, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.8593114622832813`*^9, 3.859311471686017*^9}, 
   3.859311808542912*^9, {3.8593122899842*^9, 3.859312296394266*^9}},
 CellLabel->
  "During evaluation of \
In[197]:=",ExpressionUUID->"14c65fe0-9ab5-4728-8572-d56dda77bbd9"],

Cell[BoxData[
 RowBox[{"4.399123741663303`*^-6", "<", "eta", "<", 
  "0.000013919984563963654`"}]], "Output",
 CellChangeTimes->{{3.859147437703816*^9, 3.8591474729476633`*^9}, {
   3.859147601917449*^9, 3.85914768551467*^9}, {3.8591501295554447`*^9, 
   3.859150135861162*^9}, {3.859150196513159*^9, 3.859150228837398*^9}, 
   3.859150889990491*^9, 3.859150930753057*^9, {3.859151477934844*^9, 
   3.8591515038018703`*^9}, 3.859151552391745*^9, {3.859299316347858*^9, 
   3.859299340297399*^9}, 3.859299590622735*^9, 3.859299640149394*^9, 
   3.859299790462846*^9, 3.859299850915145*^9, {3.859299904221973*^9, 
   3.8592999277202177`*^9}, 3.8593023812949867`*^9, 3.859302556305561*^9, 
   3.8593026950740347`*^9, 3.8593027796825666`*^9, 3.859302820609811*^9, {
   3.859302853936452*^9, 3.8593029006595993`*^9}, 3.8593031527707853`*^9, 
   3.8593034945953617`*^9, 3.8593036406891108`*^9, 3.859304829118114*^9, {
   3.859311447162826*^9, 3.85931146967213*^9}, 3.8593118061635857`*^9, {
   3.859312288035727*^9, 3.859312296452629*^9}},
 CellLabel->
  "Out[200]=",ExpressionUUID->"fc815285-db75-43b8-9729-53b43374f299"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV1Xk8VdsXAPDonmuelTvfcw29FGUmGTZJQiqRsYEGIskQIkMSojTIVDSQ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       "]], LineBox[CompressedData["
1:eJwV12k8VU0YAHDrtV3bXbhKhRCRIkXEnEqiyJollbIla1lDSiJlK0KiLL1Z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       "]]},
     Annotation[#, "Charting`Private`Tag$1268233#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, -1.7853137400595767`},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9, 4}, {-1.7853137400595767`, 5.395038973261688}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.298317366548036, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.703782474656201, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.991464547107982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.214608098422191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.396929655216146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.551080335043404, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.684611727667927, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.802394763324311, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.907755278982137, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      7.313220387090301, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      7.600902459542082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      7.824046010856292, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.859147437703816*^9, 3.8591474729476633`*^9}, {
   3.859147601917449*^9, 3.85914768551467*^9}, {3.8591501295554447`*^9, 
   3.859150135861162*^9}, {3.859150196513159*^9, 3.859150228837398*^9}, 
   3.859150889990491*^9, 3.859150930753057*^9, {3.859151477934844*^9, 
   3.8591515038018703`*^9}, 3.859151552391745*^9, {3.859299316347858*^9, 
   3.859299340297399*^9}, 3.859299590622735*^9, 3.859299640149394*^9, 
   3.859299790462846*^9, 3.859299850915145*^9, {3.859299904221973*^9, 
   3.8592999277202177`*^9}, 3.8593023812949867`*^9, 3.859302556305561*^9, 
   3.8593026950740347`*^9, 3.8593027796825666`*^9, 3.859302820609811*^9, {
   3.859302853936452*^9, 3.8593029006595993`*^9}, 3.8593031527707853`*^9, 
   3.8593034945953617`*^9, 3.8593036406891108`*^9, 3.859304829118114*^9, {
   3.859311447162826*^9, 3.85931146967213*^9}, 3.8593118061635857`*^9, {
   3.859312288035727*^9, 3.859312296955311*^9}},
 CellLabel->
  "Out[201]=",ExpressionUUID->"b5743065-5999-421a-8cc9-2a70088c2a2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"plot1", ",", " ", "plot2", ",", "plot3"}], "]"}]], "Input",
 CellChangeTimes->{{3.859299352568272*^9, 3.859299358075045*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"1ed30f10-d73d-4099-8473-5bd33b364b1a"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], 
       CapForm["Butt"], LineBox[CompressedData["
1:eJwV1Hk0lVsbAHCUpNxKA2c+70u5FMpUmjwlpDRxG4iIkrGkAZdQhlSiQmaS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        "]], LineBox[CompressedData["
1:eJwV13k0Vd8XAHAeHp75kfiSQpqLyqzsmyQyD6EUEimRMSpjUkJUiqhfoTIk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        "]]},
      Annotation[#, "Charting`Private`Tag$46417#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], 
       CapForm["Butt"], LineBox[CompressedData["
1:eJwV13k8VF8UAHD7boyZsY+1TYVSJPpxr6IQspVUUiS7FKWsJaVCRXYpKUuo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        "]]},
      Annotation[#, "Charting`Private`Tag$84342#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], 
       CapForm["Butt"], LineBox[CompressedData["
1:eJwV13k8VF8UAHD7boyZsY+1TYVSJPpxr6IQspVUUiS7FKWsJaVCRXYpKUuo
JGSLG6KQfSdknbFlnbH7vflrPt/Pfe+dc8857/PuyNpeM7NnYWJiimZlYmL8
ZnGL0be2ZNGBd89Z8xyJ8EySsc3Shix6aOnf04eZSTm4ZmJNFrXZOBI5nIjQ
4uy/2Ha6LPr1iP7RCvNm2o/DWf9kUU7V53R2ZyI007nhc2ZAFmk5XfS/7kKE
653pQyf/yKLck/eoyZjTXf4YaPfKos+uRTVNjPVIPQmFTlnE9ay2X9mVCNP+
SpUyN8qiBIv8mBXMqwF1G9llsug5tFJOdifCdwTmqymlsojt4S69Tsyn0g41
xBbLohTfoWHcNWz995tXQQWySO8Z/BSI2Zh8G5z9KIvOyxwvdvAgwpSi7fdY
X8kikUzOFrMbRKi/6M92zl8WDe83N359iwhzTz3y3uYri0q6FXCzmMWzIiem
bsuiU9fnUrS9iXDqcnpToJcs6lbStxjH/LSx6WWqiyzy/8EsonmHCNsyt6nO
Wcmiy21X1Ul+RKjJoZRRbCmLwlGwvSfmtMuHJYJPy6JOo7/hrZi9RY2YRUyx
fEkK/TH+WLyHt37/pyeL3Ade1+4OJMJLl3/ZPzoki3DmHOfvBxHhr9LWLlMV
WSS1c8+bBcwHRPtPShyQRUqDOQT7+0TI2jiv/FFRFu0Mnwg+GYzF+4+82bpd
FtG1DVl3PcTyF7kWI02URc0W2p4ST7D4DaSagn8yKD/iQiXpBRF25Nz5kTot
g3LdmsjpmFVe9FdGTcqg0DxdikYUEc5aZqAb4zLoXln2yNVoInT+e6RYaUAG
3ek/PNQUS4QXFm0/pDXIIOWopfDZl0RY3FGTFV0vgy4Kbp9NTCJCsSKFzOBa
GfSB/ROn/issnj8tzbZaBvG0eTtlvMb6yfkkWapMBr1W1Pb3SyHCo+KfX8R8
kEEaijTtgAwiTF4XinyQheV3nnL8xHsi3Or3ee71XgaxygWYETKJsPStTrhZ
qgy6oiIV9TGLCFUVux7ikmTQm3N/bJk+EaE83LrzMEwGmSyq3cEVECH/VaNL
t1xk0DUqnxhrNTY/z1TLrznJILHWunZiDRFqFElKOTnIINv0OctdP4nQkW+m
97ydDAo6qF9/ppYIq3KfWmqfl0FvdWetuhqI0Ger0ZjvpAwyFnsZ5tZFhIK7
Cz+w68ugp5Oy0R+7iTDDLJlv67gMOmd4/d98D7b/VI/auaPYfoYb0YM/RKhs
KHi8U0MGzfbMzrUNESElzkwzZY8MEhr6NCQ3Q4SBFRovE+VlEOmFyVzSPyIU
npJbi9opg+CQMZPkHBHqgIXCEDkZpOLy0WTXIhG+Hn2h4iYug7zNlKTcV7H3
+0D73sM8MkhibGVXEycJTp//9kSZSwZ1meEdI7hJMPhBKnUPhwwyzLcOtuQl
wc9dN9MlWWRQy+LO5/M4EhTbVDjOsSiN+F8zFdoLk+DD2E8qL1ul0b/Odu1T
O0lwv89uLrVGafRM8VjZC3kS7Lnwtre5VhrZVfiAgT0kuE8uNoizQhqx77v/
NXQfCXZlBzTdyJFGCXuPuGiqk+DuCiNX/XBptLw8v0o2JsG2dzVg5JE0at5M
pfSbkGBAiDYxMFgaddiV5L03J8EWQ9XiPF9plPjHyPOcFQn6dJK5ZJyl0fou
jbsK9iRYPzX5lnZcGoXvDODPDyDBW4323hFHpdGrNpXvwkEkKJM7YKCgJY0M
eqd67j8gQS/v1rnLqtKIy3mA+V4YCUqylIDf26TRRDdXKl8iCbqLPOl9y4Tl
98/mSnwxCYqusn7SWpdCPjZ+z2vLSLCizz+omy6FZO6rFPBUkqBIyvXdAv+k
kOGlN+xFdSSIFKy8ff5IoabIO0Xtf0hQ8Kg80bRYCvmujgqeYReCaQcsNw4V
SKFrZR96II8Q/G/bw3FyrhS6fO+AtqaAELzKNlJCeS+FklwJWq5iQrC0+vWV
u/FS6Gftuc5sJSFo9rXB+Gq0FNKKqLRRUhGC4+kbhw0jpFAzK/ONKnUhSHh8
nl/0sRRiy0no26crBB1PihR8ui2F/IL7iHhrIbh55HhytJcUevDCTvaonRB8
oXDzia+HFAqxlrwY5iQEy/hbL55wlEJej/j9XG4JQWLTU84BSynE7ObUYReB
rVtwWOHUpFB24UGdX/VC0EJX9djiASnUck/jY3WbEKSqXlHsUZJCye14ylif
ECSJVDCn7ZRCuwRYTV9MC0Hnbv9MTWEphDM0CyzAC0Om2uyobQQptG3gWemI
mDCMLu4N4MZJIXh9CmluE4YoUd28nV0KRT+gDHgdEoZCF5fWXJckUQqzdqiE
jTDMNN4+ZjYniZQkPeoqnYQhBOZNh6clUdzlp4VvvIShs8znd2yjksg3SvoI
eyj2vCFXo5dtkognpCwvqVgYnmlNVAtqkkS8B7q+7agRhpOVtbKO9ZJIM0xl
cr5VGAqnytMOVkkig24zy6szwtDVYeRV3RdJtK34k+H6ThEYMF76yuoTFp+a
3/qfmgh87hD9ajxTElXXe0xST4jAPIfjr1hTJNFF7mt1L51FYPW41KuIJEl0
1upDb7afCOxyoCdJx0uiZ/uIElrPROC6Q0bSkeeSaGBvYdN6vgjEUe4m/QqV
RJkCz4rUakWgjKNVkmWIJHoZ5/wbNyACdRx5kjwDJLH344dBLo8oDHV0fZnl
KolKD4p09TqLwpcUnZfqjpLIaiZHnuWBKPzoKPmyxk4ShZkuHpNIFoUtjg2J
w+ckUfTnGPar3aJwhJKWeP2MJNKuC+kuoYtCmmNg4papJGouStU3EhGD4k77
EyX0JVHStciuoHNiUIHKlfheRxKJ3Jpctg4Qg1pOfxPUoCQSuDadNvxWDNo6
RSaYq0mikOg9uJBFMehFdU74e0ASneYrOb0pLQ4fOh1LuKYkicKVTGzbjcRh
ptNifOgOSeQgxPom87M4LKXWx4vJSiLKWLuaPkUcNjilxqeTJVHMji/z4XIS
cJDqH68qiu130DB94ZIEnHc6E19JlESzFgS8wDsJyDahFG8qIInaq+TexExJ
QGFnzvgBHkk0E1QW4XaEDOUnBuLcOCRRQtDZ5i8RZKjuXBi3xiyJClXz6//M
kqHBxPO4xxtklFe1It59ThJecHaKE1kho4yNe8EnWiSh+4R2XOoiGX0N4uUa
PicF7zqLxx2cJaO/JwyTD6xKwciJ+djvk2S077PcxelCafjOuS721DgZeRGL
vFnNZWDBxNvYP0NkdF+dV1zvnwz86ewX69JPRuJMuprcbbKwZ8IidqWbjBQk
XGvDgrbBKWfF2JB2Mor9nO/ys3AH3JxgjxVqJiNdqetuiT5yEO/SH/O2noye
6J/PajKQhXKTBTHKP8moHGp1zoXKQBWXZzHllWREV+RvFGSSgccnHWKMyslI
eIRUWiUnDc+6wJjeYiwedA3VcZGCzpOiMU4FZET6vSJxpkES+rnMRdM/k1Hw
0LWPJF1J+HTyV/SDD2S0/Ykt03otGSa7pEQT35PRl5Z8hekLZJg76RP95h0Z
7ZGQxr9floBVLubR+5LJKHdXTNP9lxJw3IUt+mQsGfHyn8z9TheHzj7Dp2ci
yUhQdKIl86M4nHpUIRzxlIxcJH6pdziJw/nUu3EdD8jId5exL+ekGLyZZ2N1
5x4ZMd1W36eXIwaXK7TEyf5k5HOpmnb4thjcHFhPvOxFRsnUUVFFATF4b6b3
ApsH1o8H4l7Vf0Qh20axZLoLGXlrZYmpfxSFPOJ3Xk/ZktHRrN1NwhaiUNhi
KcXblIwua5XUBeaIwHjbNjtxIzJ6qfDJ4ckTEUi+/mX7Nz0yqiL7DiTai0C5
p9fTWCAZjUWXNkZJiUDFn9Pvw5XIaL6kxPxagjDM6ah33r+HjB4V3OpW9RWG
B0az9rbuIKOwKbMdby8Iw8Mszh9EJcmIptlJNZUVhjr/jeW85SWjFp47LJqf
hWCNwY/rxznJSFveYOh6jBA0sHp3gMpCRgnb3taJ+QlBk1u2eUqrEmi4s1Mk
R08IXsjp/1pEkUCkJr7+oDES9NzeWdb4QwI5/zkY0qxMgrQDBYE3vkugS89U
6v3JJHhbOxoKfZNAG7ezJZ2x80PARfOKc3kS6NyaCfcadn55Etf4YzRFArWr
/q2pC8fO23w/69cCJdDenRJrLTQCxO++8I7qK4Ee1zjR50YJMEB31rfTWwLZ
hbJ7qLQT4PkA0b1frkkglR97I2XyCJA06/jY2UYCXbeuOn7XkwAftHIf79aS
QP+FxrdV0wWhY8LJ8oINcaTXdPJXHkEQdhQMxLxbEUf6W89fCbELQp1WT/fI
JXGEVxrWeUzHQxm+l5Lu0+JIqPprbXofHnb7T/nu+COO6iTCY4rS8dDgcvjh
qFJxVCgQyrEE8VBRvvHzdV9xNHHp5VLQOg6KtvG95vQWR+fJT7hxwzjIctcg
LOmGOLpg/f5I/i8c7Or8cfWXkzia/2367EwsDgaFlErInhVHObY2d3sPYutj
7x80qYijN+3Kfu+v88Og1GCrfTNi6EvW1b0hm7ywS06DefqSGOr1fZrNac4N
P/YpsDdcEEPZaurV2yA3DI6R5v50Vgyxw1MHjRW54X4edsHrJmJocJRY/5uT
Gz6aa5RZAmKorkfI9dY3LqiG7OGGlBiaPiaqYbuXC8ZYRwTy/xFFFmfc/p4X
5ITmcZQNRStRdIW37vMNNnaYMPi3YttpUeTUYeKkuMQGB+V7Q8RMRdE3MbOr
i6Ns0L3otyC7vijy25jdl17DBp/05O7oOyyKdlQIMieHssEKsr/RE1FRtPS1
qb9fiA3ufyOYNNYpgjzCjK1jD7JCbyqPbV+rCIJZXR29O1hhmTLbrpZGEfTR
XDJXQZQVGlbQcr7ViKAtTp+ohXUW6DjcWxX1VQQt/BQ+LFzDAl/vSJs6GiuC
RHR/B+VYs0BcpsZ/r8+IoAubp/10o5hhy70/wppmIihjj4emYAgzjLa6O9dj
JIJOMu9qmbzDDMnc1WnCuiJoJvKD/28bZrjb0VTw6UERFGGqxH9MgRnq7HQc
88OLoITOBJvlGibomxL9/FytMFoqt+2J5GGCWj6HXZZ/CCPnB3zttza3AItZ
r27Md2HEqmPXNDq+BR4xy641FwojkdAic8mSLRBzKdteP10Y2eyItp233QK5
UpUah4OF0RQHJf1A4SagJMyOCGkJo7abKZfmbm+AmLt6HZvqwuhQuDDffw4b
QPdqcs24qjDyab6knXx6A6Qom2QWKQoj6eCK/fkHNoD1z0/XrCWF0YShkRt+
Zh20LLmvvlsXQm7MUaoPndbBN5NpAZUSIcQf2nbpkOcacD2kyyz5VQg128nH
vr2yBsTJSfPsX4QQZdPAaPeZNXB73LC9M1MIzWr4CgSor4EDAdkJvglCaMfq
7cqTzGsgI8tlR+UdISQ1YW7tHr0KIjkmNMwOC6HxSFmhu40r4JvvpPbwQSFk
vFzj/q9iBVBmp/S89gkhUyWhwTsFK0Cr99+ZmJ1CqIw5qG4gaQVMflq60UMS
QsEGRYQZtxWgY8WcZTtHQm4Lfj0cxBVwrYEld2GKhIKNF9xkuFZAwjG2omAK
CdU1krZZbCyDOUXOmrQBErr1pKiAm7IMXrHwD0/8JqHw24/Gs8qWAT1LVMIz
k4Ssv7rOlXssAzlZcTm2NBLSOqHS7+WwDIxjJHZHvyEhwQ4tvmMXl8G7u1Jq
X+NIqELz+coew2Vgcnq7+dpDEmoAaxW7di+DzM19offtSEi3Wmd73TgdtHsq
R5JsSCjleupn3CAdMFEPxKeeI6HGyoFm5y46ONOqml5jSkI/j//33vUXHbBm
HKnkhSTkJ+DRG51NBxdMT6y9IJPQ48LeX7e96WDZ4lSluigJBT44qmpznQ6i
zlqGDhBJyPi/0eULLnRQb+MgsZeXhPjDFIJe2dCBpnvIkYoVIrqMY3+srk8H
PdefsTouEdFDeafXPcfo4NbN2Dr+OSIyzovjf6FFBx/90s9bUYjoSvPhNX0V
OpAKrfGd7SCiPk3Le00ydFD8tPFYTAsRTbduK1QgY/lHdvL+10BEa7USzski
dPAsfjwx5AcRFWs4WTfgsP1mcJZK5WHxL9Lu6G7SwMssgeCqT0Tka8kecHGV
Bg5/EjF0ziKiopcNJ5/RaMCjYFdffgoRcTrc9zn8jwb+Vp1YN4wgogczlb8z
/9JAwM9TVfNhRNRZ6lZ5v58GxOstw+IeERFl6Db7zV4aMGt1II8EEtEd1srv
ye00MNNxbeSxLxHRmEmOvS008KTHO3ufNxHNadBzlZpooOJvyH++7kS0q8M0
QbqOBi6OPmOTdSaiQY4HLt9+0sAqJba+2p6IVAKbDLyqaeDgbPoFgjV2/yWx
TMUKGmha+LS98CwRbRTaOe5HNOBK/zplbUFEZgEenw3LaODdZo3f+5NE5HKp
1L2lmAYgS5POqRNEZHuzf+9/RTTQx97Ft3SUiLjPJrKjrzRwm3uwLUGLiJRp
a9suFtAAiZ/yEmoQkXv2kxzhfBrIwc9eGVMlIoto6w7qFxowJC0rhCkTkeR+
2YrOXBqgiDAtKSsS0SHbbSmDn2nggQTXt055IgrpvJjGhllOGv/AfzsRWf54
yKSTQwNlcqJG22SIaJVIHHn1iQbO7ZQR+iVBRDcWDB8KYabtlv/jLkJEaOC8
VMZHGohU3J9KIhLRNTHz0TOYlZQPuxXjiMguFgjLYa5VgaqXeIhI3PvQDDfm
q4f1Ntg5iKhx1i4bh3lGn72PxkxEaTQHa0XMN89XFI9vENCFg/HJ9pjXXQPj
u1YIiHLO8eNXzMEB/93+tURAhGSe79uwfHifr5wpniMgJfCQlIk58k2BatY0
Aa14l48ZYPsR/+JJekkloMS1B94c2H7fVO1fCBsloLOtKVx/MMt3TDf7/yUg
tR9jfxqweuWMZ+a4/yGguSPqmn1YPdVWHJ7ZdBNQytd0d3as3mU8O9xN2gnI
+PfNUgOsH8fJQ4bazQSkUKLomY3167fi670HfhPQubjPf/cw+mkiRiX+ICBf
o5+KgaU0cMW2o4btOwGN6vrkn8bmYdLzRdpSKQFFB1jrG2DzshrDf6Uzj4Cg
rDHnsyoaCMqoPfozh4BG/tOaG8Dmjbs4RLYom4DEz5s5mPyiAdE/zAMJ7who
HNcWF9FAA8kzZd9Ckwko/HK5gl0zDexi8nvp95KAXCW2Nk630cChbTSri1EE
RP+B3/emhwbMnSbaZIMJyIN3/U4vhQZ6fNK/EO4SUKZNyrOqKRqwDbsSyeqH
+duVxZZZ7H381H9q1JOA4sNj2GxXaGAZJSp1XCMg5ciXlOENGghsOctf40JA
w0xHw8NZ6ODpUktthh0B3Vb79v0cHx0Icz5/H2+D1fvO7JdAQTpIEjV69OQ8
AUk+H9nbKEwH2UdqdF3NCegJ7X7urCwd1N4rQfuOERBJKT/LQoMOzF7cfi0D
sPq+n1AZgXTQ/U41QPAIAW1X+rf57gQdUGo+HVk4QECHPz3WLjtNB+y4dwUF
clg9yDFDrl50ECZ9OTpdioDu8U4nvfWjA5KylFecOAH9ble3JT2gAzmLOGUf
AtbvD+6K72PoACaEZWuyEJDBpZ5n1aV0oHNkIbljQxCVqx1Ma62hA70+q+hr
K4LoRlVhx4FWOjCR2hXwZlYQHf19/dzsBB3YpHw/xT4giMx4hnizpJaB7TF5
nVc9gkjtdf79UIVlcHXk6WG1DkG07rf7YovGMnDfeUHW6bcgypgSiHp9dhkE
ZNLm60sEEbr55WFM/DIIOmk9bv9VENlEHvvOmbUMHk5V9m7mCqLtGsOE9dJl
8FQpomp/piBSuc2JAoeWQWQjvfBXqiCKTbr1RJS2DGI8Ln6wfSOI0k2aTE7w
rIBXuXtjouIEUXeor6OfygpIMY98ohgliLYEhdSfGqyAtMXlgOpngqhmMJ3f
6PIK+Hio2mH5oSBavFF3dOo59v0uvqR+4aYgKsr4LzlwZQWg8zWKSx6CaLNw
h3a10CqoWleUe+oqiB47l6asHFgF9VprPMhOEH097M1l4rEKmgYub521EURu
gXOWj5+vgra7PxfmzgkiU01Jsb7Pq6CvIrpvm5kgukZzq2RZXgWDdutNpUaC
qKksRG+BvAZG2Ox+nNbH6ttPenXo2BqYOr7/YwgURDxV82dXX6yB9drawEkl
QfRFyvTqa711wOSq7BW8RxBNrBAu6/usAzb+OEfJnYLoSd2jq0sf1gHfKXvT
U5KCiCW1Qr5RYgPgZ+t0KaKCiP09/ZT2mQ1AijigcY+E3a96dVbrxQaQaN2S
+8IriBYM9cIfC20CKa+rIoacgijRt+ek2vlNICf0m3eUBavvfXXiwXebYI9l
wqLwKh5Z38irFtDeAkrLTNRPS3h0XFoEFxi9BQ7EO/zRm8Oj1OrXHOdntoBG
r0q1DwWPlrcSbrlYMsHdT0yaL47gsfhuLcKPmKCoumvf0UE84tYd3e1WwgQ5
KSHjO/vwyPwAs13mHBOkxbyd5+nCI2P7k7KEvcxwVLd8Y6YVj9aExLbPOTDD
tsUertZGPMpYv7r0KoMZfjEjSCfWYPnh5JW51FhgCrPSnsBKzMD6WNkDFhiZ
o69qV45HOza72WEPC7xnYw9PlODRdbOcgROqrNADd+/k3q94JD4VJpoXywpt
vr08I/AFjyQE6uKfs7BBY9fCywsf8aj722nN7d5sUFOizbUzE49olxMsWels
UKH2n3dJGh7VdHju2RPMDiXu8N5/nYJHQze8Pm2T5YA88rue3n+FRy1uvud0
mjngasfReIcEPFLys4/niOeE1AcX352MwaMTTQnWbwO4YJeKz6d9kXg0QnR+
SA7lhj+Ho4uJT/GIEHbSQbmeB36N/PyD/hiPHL6yszuf5YNp2r+beh/gEVsh
YSr1LA5Gz1J6y+/h0S95z6y+CDwMfs02/tYfj/JTnhP6OgnQ01hmPuQOHt3/
5Bt/Z68YtN04suFyE49iI+ietRUkaJptyWVyHY8UEutOmOoLQnjek6jihkdn
mJf+4epx2P+xZ1KiTnh0KbZ0UVSeD0oXZe5ev4JHTef26M6J80CcY7XK4CU8
Oql/Ku8/Zy64KTwEqi5g/S4+1bpO54DTPzYMMs7i0R5H47nCXHbY5yV2JswC
62fCpNbFZ2ywbpvqZQ8TPHpnIMXj/ZAVFreYuFoY4pGrlp0MimSBcfsfBZF1
8Iji4yF7o48Jhgy8DWeCWD1P2j4pJjHBW0/L40aO4FG97OuC+Y+b4PQU7WP2
QTxSZ2enC82sAUKGfe9/2/CIXl52gomXDpgt743JSOORe2P6CZ2pJTDLnjTH
JoFHmU1NFy90LIIGuzbO3wQ8MuEy2+CunAffCLOEzzhsPXdVc6JqDmR/55WK
5sGjIvLXfUoNsyBU+piKNQseJU8VpnJMT4PFl98CgtYFkEtSi5jy3inQsroY
ZbAogPQz1eQUbk+AZwV233uGBRAPh2mvCBwH7qTEzpReAdTFLO3DUzoKDG+0
TDu3CqDdmZH3a/RGAJeStvhahQA6fcmmVD/2LxjIrDtPLBZAajsEr9bCQVCw
60zS3s8C6FqD6k4jln7w9N1g/7EMATTmYcEtkdsL7GVdZC68FkA/IvZdwkd2
g/9eLV32ihFAeUKXtPpTOgFJ4u7bsHABdGJR5UPVSDuYjOUZfRcsgARVTRpD
LNtABSl65zdfAVTc0XjEZbUFJERIO7bfEEAs3WHDB+ubwXVc5vtpJwGUOuR+
aH9dE9ALVZlkvyyAEDn/XOhEI5DhKleQOiuAfq5L97I9bwD0YH33Q6cEkCT+
Is323m/QwNz2yfi4AEra7lY/UFgP0gIuzl3VxPa7/QHr/f31wH+NciBQRQCN
jLbRTgzVAYvbnl6xewVQAzGZCfysAwpLG/mf5ATQ9/LemYy+OsB64xG9RkwA
cV6MN+MTrwc9MwT1QTxWn5D2Hh3fepDrkuSzzIldX3FaN3ytHjym7CrFb+HQ
9fiC1OCY3+CSfe6GPA2HJiWcu/fpNYDDQ/8B7WkcgmH1m3S+RiBgU3PXagSH
LpcZ5af9bQRjvaYV13txqES32SnnchOIbr+qm/ILh1488DUSNmsG8z+fn2RN
w6GgAyXMIuat4JeuRLhEEg79c67cNtTeCpIrUhsORuFQWRGH6ruzbeBUabHp
lSAc8s55c+jRhXaQ/WnE8sdFHDo23Plzz5lOcF/hWvyf0zjkn9+542FTJzj3
fqVnyRCHkuOoNSz6XYD7Le7iziM49Lbve6igSje4GnP4SogIDmkmymWZzvUA
TWJl6mscDiX4ZMRane8FpOdG41/ZcUim7PdD3cpeUPnY1pmywI/KE96wdof1
ARn/MA/9Jn7kKNDbmMDZD3rtBv14H/OjacUZVV/TQRC14Q2N7vKjFMNTL1Jv
DQLjWAG2Z978yCRvGvEmDgJUqxVKuIqtrx95n/R3EKQpJ8WLHeNHaw1uP82u
/gU2dSrW5zX4EaXtoWjng79A1L5eJkmZH63I7IgqevcXhMatpcvI8CNdo7TM
jMG/wGPLqmDXBh9K/y4VHWs6BHbHz91xWuRD+9O1t91yHQJDBx5rZk3yoZb8
1O+ND4fA6auFVUo9fAj9BUtMxUNA47dwq+pXPqQU93j1k/gwYEts/XfsOh8K
u/P7TGrNMPim4vLlgSPmzWb9J73D4FYDi3eNDR9acCaGkP4NAyrzgU0DYz6U
mXdXRFZoBDQ4Pucz28uHcKrHNk2sR8AjFvmmF3J86AjZnxzrPgK0X5a/aBfj
Q53C9yIiAkdAXuOMuBUXH/rw1F8kM3kExB8y2n1plBd9EtluFD0wAsyaRqbe
9PGiwMOt+zJnRgCfs1/OcCsv2tOeHRS4MQICkrLUHCp40e4Zj1oP8VFwhY3n
uPtrXoTvP3A4wnQUKLVU2/pZ8SI2q98OtfmjoCzkp7mFKS8ayRY/8BGNAmPN
Wh0FfV700SGU4Fw3Ctwyfu/sO4zFSx6juQ6OguyAtokjorxoPXnzWS7XGNi7
d+jGWgcPsnyzp7rWbAwUDw7btTbwILXWm5cCzo8Bg5hRi6xqHhTz4Ok48coY
cGamHjpfwIOOK+p/H/MaA5md/1aLo3lQkN7yfvXoMSAfvBHkY8GDItTdzi41
jYFC9S1PM0MedJSYL7vVOQb0/jHZ79HhQeSHqc1z/WPA4RzbiZ6DPMg7w9Dq
xdQYSNvPy6tB5MHOK+h3E8c42P5H9MVKMzdyeWrAHqA2DvIixYObf3Gj4iif
E1qa40BHj3zz/XdulL9edXfq6Diw+yJtafWZGz1eo1OJxuMg5fFOiaLn3Oh3
VXtttN04kD2k8vb2KW506NHq68TQcZDJ87g8+Tg38jTduF72fBwcGPjT+1OT
G82S6IFN0djzH4WQxBS4ESw1s6h8PQ4ce3oeFHFxo1vIvGQidxx8DLjnuPqd
C/WeLPju2TEO1Mw7guWKuNDMjHJQWs84QLv2vjHI4UKXFw8J1vePg+amtu6E
V1zIP/i89ezYOFiUkz95xJcLfYhNb0qhjQONmgZFPxUupL0sl95OpIDKxG0G
7/ZyocEPxjcNRCjA0OP21Xo5LlS1/0RFnjgFWIvJvSYLciGF2DuuzrIUcBf7
+H+b5kT9bqcnrZUooFqAvLCRxolq8k9w3D9OAadGPAR2vuJELnlyYzb6FNBV
+GOvcTQnqpTLNVcxpADq5WtXXt3HrreXNagypQC+vIp2rUucqLFMPuv+BQow
P+tUGCjGifZu55eI9aCAXD15Fi1BTqTz75dQ8w0KIKiPn1zn4kSjR7VF2G9S
QJOY/cDtZQ50M8PQ+/wdCjDuvcRxo5MDjfl7vKy8RwF6F89aXInmQAtHj2k8
j6CAdGORV3LhHOhJrcLHGy8ogAN0jA8Gc2DzGahsEk0BP6QtfK29ONDFPUJv
1uMo4OjfUylnzDlQvR3IIydTwH9XTszqCXIg8QzbqAcfKCDRgkODk5sDTTwp
CpD+RAGrOj/u/2DiQPk1Xsb5ORRQtOOYyNFZdvTqQuPvti8UcGhcS+tIIzuS
aP8ZMVJEAcrOh8IUw9kRh3rlqMkPCtjpsUOewM2OKr5s+/y2mwIc/OcWVpjY
UZZa8+bPHgrIePKt/O8yGxIVDAmb7KWAvamnLT9T2NC+L48fyvdTwP6eBw9N
frKhXQ4RP4KGKOCIztjI0xA21NdJzCmboAA/09ycW4FsqKRuh33JJAWUXQzw
u+jNhva719bmT1EAvCNMUnJgQ1ln9b+/naGA4x+PH/t9nA25T+Zy289TgIlo
+hteDjb0ci5AN2iFAiJ2eLotbLCiI9nb/1xYpYCWA0C9d4kV1WWW3lddo4DT
Rp1NmaOsaHKHOvHvOgWcC+JkMvjBih7vCWiQZaKCK1MOFx8FsyKVRSU5Yw4q
uIPkJdhZWdHJ+WQOT0EqyJs6QdBcZUFFgwFTOwlUMCPqwH1zjgXNehqqdWO2
vZ5KHxlgQebyQQLqJCowlJNrqyplQTatfGZjwlQgFSwRHnyLBXUoK6isSVDB
2RyN4FI3FjRPyEyOJVNBZJ+V7+IVFqRIe1tyQJIKOFXjnK6Ys6DLtd389lJU
MDtKOq6zH3ue1JuYYhkqqDiB22KdYEakBZ4vCjuoYN1TkXbkLzMK1tKdyMd8
KNlw2rOLGTWcTcdp7aSCrGXsK1DNjAzuHVc8uYsKot5zFla+ZUaiInXbrXZT
wVVe5uv3rZkRM/vA8nFFKuBtXBhiaWZCGk0uIXdVqIAs4s/Z/JMJJdXtvjuG
WcGGQ+E1YkKevEx/T6pSgfE/0ZtHcpgQafLHMOkQth8BLU6vZ0yIyuOzJ1mN
CkRNHu0dNWJCcl3rUUkaVKCXok55Gr1VHqWG69SGVOCTFsoj+nij/NbubwVR
BlRgvbd8GYiulHNdWOdPs6EClYORLxs5VsoXFzc11zDzHbGHNkvL5d9nOhNN
LlFBqQHvo4CW5fKTSeTRNczizpYi38KWyyni335Z2FJBR8Y/VQ3m5XKmcekc
vD2W704ZT5UJWrlrVjK9wJkKgOy9afnSxXLTg5fR0C0qqLokPzWStVg+sne3
/1FvLN/kxonkxMVy0jnm4BTMZtJSFFHfxXLVvaYedrex+ZEsGeLSWCy/BL7/
oNyhgkdiS52UrwvldXrFLsz+VNAk6FSR8WW+vL06+6DzfWxeWExj5bNmywcX
Mnl5I7B+o0vtvsGU8mDbNy7zOVh+e96phttRykVHP8i5fKaCmKjx6FdHKeVf
JvVqhzFvd3I/852JUi4SaT3WlksFkODXyeE/Xh5Rd2N/QR4V3L4S2x1xc6xc
x2M3s1chFUxwNfxJvzpSHkVusG0rp4J60yNjrXqD5TO4IvLkbypI3PfFOFR+
sPyAeRrL6QYqcObf+/Uo12B52ncQX4YZH6mKt3s2UG74Kqz9eSMVPL67aC4V
3l8upFx4S7kZ65/1jd6oR33ldmGuP2zbqOCCiPvEvcCu8smBRK97PVSw2mJd
MqvVVX5E9r76IOa4p0ZhNpud5fWx8y+1eqmgjV1RSdO/s/ybyYDmKmajxcnr
yz4d5bE3yv64/qECrWanFfdbbeXSueuGYJAKZEPtuS64NZV3no7bHztKBSFa
MwcNdzWVnyaG7p/F3DM8XXa7orHcvFc+X2+MCm58xrupZzaUc5WQDJcxpxie
+VV8p758q2f3J1MKFbDe/3vvm+jP8iKctt70BPa8gX+jDz6Uld9ov2b48x8V
yHwgRB2P/lZ+1CZ5XnCWCgp9VI9y+peWb//tLnMeM0XI99Ujw+JyaY1J4hRm
PUMOy9DJ/HLJ/VuXueapgHBD/bmseWb50nr/nz2LVNCe330mwikC7POK/SW2
jM13FKR6B0aDPWxFeFPMkTfSfS9Gx4PuJZ6VEMwZsRpN0YPJwFA3/+Mi5qsW
XEu2fO9Bx8Wgwl8rVDA3Zvp683MeCCXsT7Rdw97/nFte9cEVAPon2pltUgFL
WOXxx5yVoKpSKyIAc4MDXuz4k0rgJ9fkmon5qnTmt/JnVaDrnts+5i0qiH76
h+NLQjXgu+8+k4l50VUnPj6nFhSo1Of+Y5oA3SRum4PuzSBIlc9Um3UCLD+J
ccPnN4O+o730q5iFmbf7Ta81g+qB/4zDMJtNa8WnP24Byly9vB2Ya394tUqk
toLKTadue7YJUHxr8ARbXzuw114/6M0+Abqm3M78lesAAnkexDjMNNu1K2VO
mKv6MwsxHzglHHSb3gHe8uSxrmDO3GVYOkXoAr1Kd11ucUyAhK6v+9v1e0Cs
+PL9K5wToNBYF+Q+7wHZ1wKl72HuqGoxetbZA3KkVn2SMBM+Tzvr2/eCqPl8
z3bMTx5vS/12tw+EHXx95yjXBPDVeCaW9rUfeD8SgYLcE0DJ+OC9ksi/gLs3
cCCYZwIMxzebNX/5CxZs9s/HYY4bvbZ9vO0vMD52ozsbM4t/dg1BZAiIua7v
bMPckbUD55w4BM4dPVUjwzsBArhFE0XfDYNe66AruZgPni5wVfoxDGqnp8cq
MVOSLbR0xoax/8HrR9sxmx2O+HtNfgScXTz4mI55pwOPfE32CBgg2JzR4JsA
DVXreTexc/OhV0EqRZjv4xMfhnaMgpJHO7x+Yj58Qf3sG/ooGBBjiezEnLJw
c61eHTuXhvg7LWG+JfdPe3vZGGCWX3m6j38CSN3929BSPQ70ey/NJGF2P1JN
2ddFBaHTjsVXcBMgkbg/9zU2l0/wwewemH9OxvsKiE0A/bBMNV/Mci/dcP+s
JoDgkQnTCMwd6ySVj70TQPpgm10pZq0yu0CFgUmg4SO+GycwAVxifuu93JoE
/FKJ6yKY49zVCHwyU4BvGyiWxTwvxZs6eWkK+NdlLqpgTgvMrc0cmgJWrwVc
zmHGaTML7x6bBt6dE8FvMB8RcxmI45gBWfffC2Ridpxry+DaNQNOGBmE5GKu
eJNxhOIwA3w9OjQrMd9iMbmcTp0BZQPB9cOY+ytfZe+Y/gdiw2MiZfETwHLb
K1nB1VmwoNBT9RyzX3P2pwzeOZDj/gHFYk4OLNGEknNgffxK1ivME71dVtfg
HHjDsc04m3F9FDHy98M50Nqh/ruacT37Y5YnxHnQHvi6dRlz1ZfY57I75oGP
Gk/TJmbq5TSpokPzQPJWyTc2QWz+yyo1KFbz4ExsgBsec9WtzRvHk+fBLStT
uV2YKeOewyyKC2C19/amKWa+mKDrCVoL4E64srQlZmWdiC1lkwVwbET74AXM
PskfJS57LoColGHVq4zrrajm5UULwGTqRsYdzPtrL1b5Hl8EGvHkC68w38nW
T120WQIKb3aVDGCelQvusvFYAh6eqprDmB3jy3jr7i6B04flvo5hPvvw4I03
b5bAqcyhyGnMhy5JAuPhJYAvWp9cxTxPnOtKv0oDKq+3DpIIE8D5yV4+ojcN
tHRb/ieC+S/TVRAQQgN0u1RNccxN0z2pFhk0MNNyaa8M5o81VTeYJ2jgLyDl
72Xc7xvHd96NDr4ZtT3Vxjw01wKq/engaPYPRR3MVo78nspP6eDDuVfVxzHr
nQ7q5vxEBzLJmmMnMe/c55qWN0sHrD/y+k8z7h8CEOe1DPjNdyNHzOcMxj2/
+6wAv53WL59gHgzyNQkLWwHwR3txGGb7EgFFy1croPPlQutTzB4Kh8emvq8A
4n0LWiTmh7jHZ0W5V8Fkl/hGAuYvLXs0r8WuAtbCBslMzId5y8U03q8CB+7X
U1mYy46Z09hKVgH39b6CD5hr83w/JfSvgrPW9ZqfGfFj6mWrd6yBJu8S4ULM
fOfdOSTz1oDeefPNKsyRL1iGx3+sAYNYicfVmEXqY8pzO9fA1uaawE/Mcprl
t/XW1sDjcAVCHSO+NH7S8+g6yN+0ojZhvjL8ubG2aR28amKd7MX8zWUp7vb0
Bph4tOj9D3OA87Xrs5sbwFp+IGIWM3Si6jviN4FRPO/7OcxVV/+sWh7cBNEk
3cYFRv6Xf1xQu7MJAloX1+iYOyyjZWhsW2CsdrR3C3PcGYEVN+Et4HNqtZ6J
iPXr9OPm0V1bQGItv4QZc5+Zf1C7wRYQ59aIZMU8ZGQ/kvd8Cxz7SNrOiZn+
RrxNHccEs4+NDPBjPvvGEi0JM8E3klwfcZgLk6OyP0szwU9Tu30EMPu8xj3Y
rcwE2U778gli3nzJckjMggnuEOgXI2Fmi5uIXY5ngvtPVfSKYcY/LT7/dQcz
vFiVJ74dc8L1cPE/isywJN8kneHtpy91sxxihiH7Ug/swKxO5rA0Ps4MxeLv
6+7EbJtpajZ6lRm6NjpckMecV03RI2Yww1AnHVMFzFqZJZzqOcwwZbasluGf
4U+rLxYyw9VbUscUMf+xUNHJ/MkMHSpj9ith5hgOBNpUZjjSn7u5j7HfLeFD
1/awQLlrxU4HGfUZoi5GHWCB7bnZLQy7Vpd+KdZggW6OmRoqmO+F2ypznGSB
hZzNnKqYMyU+KiS5sEANHFfsIczrarrb6rJZYOPHxSfqmN94eOJ37WOF1bfC
O7QwH1BdeLuuxgo97T32AsxVKzfUWiAr7GrzC2R4LOjGRX8zVliRKr4DYlaI
vp7depMVui2/vaqNuaDomt7dUlZo8jer6hjmEwH/ek//YIXmpmL8Opi7jl67
treBFablNVowvFbnHtMxwAqVH0sNMQz73UYUWNmgbffNRV3MtSyud7v12WAa
fLRyAvP5mkniJzM2GPTXXE0P81SoS3rweTaobHzfi2EBIZeGfW5sEPeZOM2w
xS5n8sPnbDClcXunPub+k46FBzrZYFKd0fOTmBeirsyGXmGHV2wVk40xf9T0
OVPnyg7T/ffVMuw49qyU5yY7vOnQsMBwv1rJo8cP2OE3wzHdU4z8egRlQ9LY
ofr12FGGk2XKTYMo7HBgGhFNGfn+avv6fZYdsgivqDEsfGNCknmFHVLye88z
HFopNBHIzQHfBL1NYfjWVdcg/z0csPOfmYIZZsNssS+3XTlg/ZGu/eaYOU/v
Eyv04oBZ4QQThis2dALpfhzQXpr1GsNqpzxO3grngLuKuLMZlpuvHvb8yAHV
XcvlLDAvq3mRrs1ywNL5C6ynMadWNty09+KE5lzR0WcwB5zqtPL144SB/1lm
M3ymd0AzIpgT+paOVDDMtTDL/i2KE1Y9tPvHsKscMYaUzwnHLDd0LRnzc8+y
oHKJE2bxcE4wzMt/KaF7gxNmtOVtMDwS5xjwj50LpvGqCp7FHJ1z57iEMBcs
sv+oxvDyQGLHjUNccEX0eRDDZVqDNFlvLnhp5ireCnNsLaVHLZAL4ujOsgx7
nJkrMwrhgntiTxxgWNadJeROLBds5g4zZzg4abtI81cu+N/dk1EMG6w7qt1d
5oKVJrO4c5g7i+a8++9ww518nJMMF+xM3/8uiBuKi7cuMxzz4gLVKZQbFgf6
cZxn1MOt5tzSS2544oOjLMMdMkmafIgbev39dJrhthA9Vg0OHujgp13IcN7i
RskWjgcWs/BUMRx1+YvXDxEeePtfXiPD5kekxkx288Du7V/GGG6ZWfjpYMgD
tRfOEi9gbjr9+ml0JA+09AxxYDinwuLE+UQeOPgh9jrDz/fxMMm+44Gfk5/6
MnyK++b17Hwe+CRb+RnDDaUGFpVdPFBE3jyf4d/baGJzUrwwAn94g+HaOcNU
wyxeqKkg4G+NufVo3H6/L7ywUYZ6n+G+F8MlWSW80JXtyxOG/6n6tPDU80L8
PpE4hkk+6Vs/p3ihocSOXIYvsrCc01Xig/5Bt4YZdjA3GvU6xAcDLC5RGfZ4
F+fxTosPRun994/h+8f3hbCe4oNVonWrDGc8uZD3/Rof5Gg/IXiR8X4SvuK0
PvPB6syuIwyv27EkuBXxQRaNBcgwR77RjqTvfNC8mfk4w6KWI0fWm/ngnkdr
pxjWShR0Kp7ngx6iV+wYfrTNtfKQCj8MYpZ9xDBZRfb2vq/8cMcb+i+Gx0Bu
kRnih+3Bqg0M55w8tnbzFz+0PeXYwrCunX1AaS8/HOf70MOwe+T7YH0mHCTp
FEwwjGaVI+z0cVDw0QCXDeYn6xUtD81wcLPtNh/DFlwWpMzzOGj7lQvPMFX6
VuysGw7+ecUnwjDhVHGSfyQOZiekb2f4yoejmbG9OFgSqqXFsFJR62TxCA5u
HDTUZni56opi/zQOEgZMdRgO73uYs51JAIpE6BowXMBbV/B5uwD0Tm46zTCX
s3llnZsA5El+6MJwy80Rtn+3BODUb0l3hl/eu3mccFcAJqp89GBYOT7219lI
ASi7UHyT4XM/extHCwSgkPjDQIa3t7kKciMBOLlIucfwzMCGmcIvAegVoRvM
cBBduuNGrwBsMpl6xLAh62eRmBEB2PjiUCjDwgJHrYqmBWBXl084w4PirQl9
NAH4el/RM4azdl7p29oSgG/S5yIY/h/BKFeF
        "]]},
      Annotation[#, "Charting`Private`Tag$122480#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.2548649280144698},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9, 4}, {0.2548649280144698, 1.1835946324912083`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{0.4054651081081644, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.9162907318741551, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.09531017980432493, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.1823215567939546, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.26236426446749106`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.3364722366212129, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.47000362924573563`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5306282510621704, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5877866649021191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6418538861723947, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7419373447293773, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7884573603642703, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8329091229351039, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8754687373538999, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9555114450274363, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9932517730102834, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0296194171811581`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0647107369924282`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1314021114911006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1631508098056809`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1939224684724346`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.2237754316221157`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.252762968495368, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.8592993587178297`*^9, 3.859299592753327*^9, 
  3.859299803743803*^9, 3.8593025656905813`*^9, 3.8593027156449957`*^9, 
  3.85930278351999*^9, 3.85930315663378*^9, 3.859303407268199*^9, 
  3.859303523850588*^9, 3.859311462923294*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"d8ed63cf-930c-4042-a31f-94a090f50ac1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"savep", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"saveq", "=", "0.9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", " ", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "->", "savep"}], ",", 
      RowBox[{"q", "->", "saveq"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tbl", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"tmp", " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{"eta", "->", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"etarun", "/", "40"}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"etarun", ",", 
       RowBox[{
        RowBox[{"-", "9"}], " ", "*", "40"}], ",", 
       RowBox[{"2", "*", "40"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<data_smalleta_p\>\"", ",", 
     RowBox[{"ToString", "[", 
      RowBox[{"InputForm", "[", "savep", "]"}], "]"}], ",", "\"\<_q\>\"", ",", 
     RowBox[{"ToString", "[", 
      RowBox[{"InputForm", "[", "saveq", "]"}], "]"}], ",", "\"\<.dat\>\""}], 
    "]"}], ",", "tbl"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8591478963915453`*^9, 3.859147900806654*^9}, {
  3.85914809654113*^9, 3.859148161033266*^9}, {3.8591519082582407`*^9, 
  3.859151943029388*^9}, {3.859303769063648*^9, 3.8593038344679823`*^9}, {
  3.859316073248765*^9, 3.859316074698859*^9}, {3.8593165050327673`*^9, 
  3.8593165238137627`*^9}},
 CellLabel->
  "In[242]:=",ExpressionUUID->"d09a18d7-9b7f-4f68-b9c5-bc2959304535"],

Cell[BoxData["\<\"data_smalleta_p0.2_q0.9.dat\"\>"], "Output",
 CellChangeTimes->{{3.8591481325202436`*^9, 3.8591481620017033`*^9}, {
   3.859151916642953*^9, 3.859151943984337*^9}, {3.859303772956738*^9, 
   3.8593038356354856`*^9}, 3.859311463775826*^9, 3.859316076380149*^9, {
   3.85931651152909*^9, 3.859316525283044*^9}},
 CellLabel->
  "Out[246]=",ExpressionUUID->"c449b67d-08e4-41a0-a055-b3f580d46346"]
}, Open  ]],

Cell[CellGroupData[{

Cell["On-Policy Error", "Subsubsection",
 CellChangeTimes->{{3.859304194568185*^9, 
  3.859304197300437*^9}},ExpressionUUID->"7af9fa1a-63ca-48b4-baab-\
9d3b703a4b7c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sAo", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Phi", "\[Transpose]"}], ".", 
      RowBox[{"DiagonalMatrix", "[", "pi", "]"}], ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "5", "]"}], " ", "-", " ", 
        RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "Phi"}], " ", "+", " ", 
     RowBox[{"eta", "*", 
      RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sbo", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", 
    RowBox[{"DiagonalMatrix", "[", "pi", "]"}], ".", "R"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whato", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "sAo", "]"}], ".", "sbo"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "whato"}], "-", "V"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"eta", "->", 
      RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", 
     RowBox[{"-", "9"}], ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"Phi", ".", "whato"}], "-", "V"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"eta", "->", "0"}], "}"}]}], " ", "//", 
  "TraditionalForm"}]}], "Input",
 CellChangeTimes->{{3.85930420059586*^9, 3.859304225879834*^9}, {
  3.8593042640312634`*^9, 3.859304350035604*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"549cb410-7778-46d0-aea9-d723707958f8"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV1Xc8Vf8fB/B7ray4tqx7b6Ehq2TzOVlJkRJJlAgZUfiiSBKKKBVZoSTX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       "]]},
     Annotation[#, "Charting`Private`Tag$122903#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-9, 1}, {0., 2.2586216400450883`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.859304270750745*^9, 3.859304275988585*^9}, {
   3.8593043104887*^9, 3.859304350969974*^9}, 3.859311464432479*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"b674132e-3fa1-4022-bf2d-139954965d13"],

Cell[BoxData[
 FormBox["0.04495921580917043`", TraditionalForm]], "Output",
 CellChangeTimes->{{3.859304270750745*^9, 3.859304275988585*^9}, {
   3.8593043104887*^9, 3.859304350969974*^9}, 3.859311464438612*^9},
 CellLabel->
  "Out[57]//TraditionalForm=",ExpressionUUID->"d90d8385-afb4-4ea9-acbe-\
85848280b87b"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1134.8256880733945`, 909.5779816513761},
WindowMargins->{{Automatic, 0.6605504587159885}, {
  18.32727272727277, Automatic}},
TaggingRules-><|"TryRealOnly" -> False|>,
CellContext->Notebook,
Magnification:>0.95,
FrontEndVersion->"13.0 for Linux x86 (64-bit) (February 4, 2022)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "JournalArticle.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"23ed9b7e-8a37-48ab-8c44-9de7928e5403"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 485, 9, 40, "Text",ExpressionUUID->"051258ff-3da9-473b-961b-d8991c9fcfd8"],
Cell[CellGroupData[{
Cell[1068, 33, 8288, 210, 305, "Input",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],
Cell[9359, 245, 1113, 21, 39, "Output",ExpressionUUID->"3d9f6c07-bf11-47b5-b0e3-97b7d21af71d"],
Cell[10475, 268, 1721, 41, 43, "Output",ExpressionUUID->"8137719a-cee1-4931-a806-951560f72fe6"],
Cell[12199, 311, 899, 14, 28, "Output",ExpressionUUID->"9a596a6f-87b9-4c44-a667-59cde88c0c55"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13135, 330, 475, 10, 28, "Input",ExpressionUUID->"c937557e-f8b8-40f3-884b-a5fcfe331f43"],
Cell[13613, 342, 1542, 23, 28, "Output",ExpressionUUID->"838be900-72f5-4ee1-8e19-bfc85be5054e"]
}, Open  ]],
Cell[15170, 368, 326, 5, 22, "Text",ExpressionUUID->"812d4f2f-d057-4141-99e9-0041d5ad4212"],
Cell[CellGroupData[{
Cell[15521, 377, 797, 17, 51, "Input",ExpressionUUID->"faa6cd96-61f9-4282-9bec-90ba810909ff"],
Cell[16321, 396, 886, 14, 28, "Output",ExpressionUUID->"a60855c3-9959-4f57-aac4-33af35a25ccd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17244, 415, 281, 5, 22, "Text",ExpressionUUID->"0a5d41cb-08ef-4253-a74f-02384f62cb6a",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[17528, 422, 1252, 31, 67, "Input",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[18817, 458, 1277, 29, 49, "Input",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],
Cell[20097, 489, 216809, 3572, 670, "Output",ExpressionUUID->"4644ca40-3f85-48e2-8fb8-609ed000a39a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[236943, 4066, 893, 26, 49, "Input",ExpressionUUID->"891cc3a8-96a2-4bdd-8f47-d24ac8335532"],
Cell[237839, 4094, 146051, 2421, 285, "Output",ExpressionUUID->"1071dcfa-c095-4f42-b287-3109b1fb6d64"]
}, Open  ]],
Cell[CellGroupData[{
Cell[383927, 6520, 2229, 45, 67, "Input",ExpressionUUID->"bcd75a85-a5a4-42fd-9cb7-137e413fd55f"],
Cell[386159, 6567, 863, 16, 26, "Message",ExpressionUUID->"42756e10-5193-446b-9bb1-45a6b2cc276a"],
Cell[387025, 6585, 1577, 30, 31, "Output",ExpressionUUID->"42d87310-3056-4670-8f39-3974a56d4d99"],
Cell[388605, 6617, 7833, 152, 224, "Output",ExpressionUUID->"8e96eb37-bae0-412a-b8cf-2b264295f5b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[396475, 6774, 237, 4, 48, "Section",ExpressionUUID->"cdaed246-7d2d-4bd4-ab55-763c594c4588"],
Cell[396715, 6780, 259, 4, 22, "Text",ExpressionUUID->"102b5072-7854-4375-ac95-da85f8f850ba"],
Cell[CellGroupData[{
Cell[396999, 6788, 2834, 71, 122, "Input",ExpressionUUID->"8f40f9fd-67f1-4f8c-9b38-eed28c34c35d"],
Cell[399836, 6861, 1571, 29, 28, "Output",ExpressionUUID->"d6d61172-50c2-4d30-bb64-26ff6508adef"],
Cell[401410, 6892, 1368, 23, 28, "Output",ExpressionUUID->"3ce3bb0d-c1ed-401c-8e93-a5cf91f1ec13"],
Cell[402781, 6917, 605, 12, 26, "Message",ExpressionUUID->"1575ee34-630f-4ac6-9ab3-507b2df6e1e1"],
Cell[403389, 6931, 1302, 20, 28, "Output",ExpressionUUID->"e38acba4-4dfd-4afb-b30d-f49505e556a2"],
Cell[404694, 6953, 20499, 392, 229, "Output",ExpressionUUID->"73d9f824-0c31-4429-bd02-c6eb2ace0ac1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[425230, 7350, 2323, 56, 122, "Input",ExpressionUUID->"f57be62e-c545-44e2-bdd0-66cf7c8ca389"],
Cell[427556, 7408, 786, 19, 31, "Output",ExpressionUUID->"fc776d80-3bec-4a75-a15f-b897ec47abd4"],
Cell[428345, 7429, 602, 13, 28, "Output",ExpressionUUID->"46628a71-534d-40e1-a016-7b61666dffcc"],
Cell[428950, 7444, 753, 15, 26, "Message",ExpressionUUID->"5524aff3-0ab9-4498-8526-79fd369677c6"],
Cell[429706, 7461, 537, 10, 28, "Output",ExpressionUUID->"29d76718-e5b8-419e-b050-afdf9a72f86e"],
Cell[430246, 7473, 27447, 547, 229, "Output",ExpressionUUID->"eeb203f5-914d-4ce3-a084-03c02c001b64"]
}, Open  ]],
Cell[CellGroupData[{
Cell[457730, 8025, 2104, 53, 103, "Input",ExpressionUUID->"314a3021-0cca-45e0-95ca-25cd662f6096"],
Cell[459837, 8080, 1368, 26, 31, "Output",ExpressionUUID->"ecab7961-2c16-4c47-86ca-b5a3533f0f50"],
Cell[461208, 8108, 1180, 20, 31, "Output",ExpressionUUID->"8f499cf6-48b0-4d57-838b-cdacca786295"],
Cell[462391, 8130, 551, 11, 26, "Message",ExpressionUUID->"14c65fe0-9ab5-4728-8572-d56dda77bbd9"],
Cell[462945, 8143, 1116, 17, 28, "Output",ExpressionUUID->"fc815285-db75-43b8-9729-53b43374f299"],
Cell[464064, 8162, 25511, 488, 229, "Output",ExpressionUUID->"b5743065-5999-421a-8cc9-2a70088c2a2a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[489612, 8655, 252, 4, 28, "Input",ExpressionUUID->"1ed30f10-d73d-4099-8473-5bd33b364b1a"],
Cell[489867, 8661, 56322, 984, 254, "Output",ExpressionUUID->"d8ed63cf-930c-4042-a31f-94a090f50ac1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[546226, 9650, 1735, 46, 105, "Input",ExpressionUUID->"d09a18d7-9b7f-4f68-b9c5-bc2959304535"],
Cell[547964, 9698, 410, 6, 78, "Output",ExpressionUUID->"c449b67d-08e4-41a0-a055-b3f580d46346"]
}, Open  ]],
Cell[CellGroupData[{
Cell[548411, 9709, 166, 3, 25, "Subsubsection",ExpressionUUID->"7af9fa1a-63ca-48b4-baab-9d3b703a4b7c"],
Cell[CellGroupData[{
Cell[548602, 9716, 1627, 48, 108, "Input",ExpressionUUID->"549cb410-7778-46d0-aea9-d723707958f8"],
Cell[550232, 9766, 11998, 220, 229, "Output",ExpressionUUID->"b674132e-3fa1-4022-bf2d-139954965d13"],
Cell[562233, 9988, 312, 6, 39, "Output",ExpressionUUID->"d90d8385-afb4-4ea9-acbe-85848280b87b"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

