(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    114407,       2346]
NotebookOptionsPosition[    110138,       2266]
NotebookOutlinePosition[    110935,       2291]
CellTagsIndexPosition[    110892,       2288]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
We follow the derivation in Kolter (2011) with the aim of constructing a \
fixed-point counterexample with n=3 states and k=2 feature space, where w* is \
near [1, -1]
We achieve this by splitting the left state into two equal states.\
\>", "Text",
 CellChangeTimes->{{3.848632720901607*^9, 3.848632738020585*^9}, {
  3.8486340159286547`*^9, 3.848634057462323*^9}, {3.8489104946422167`*^9, 
  3.8489105216064568`*^9}},ExpressionUUID->"051258ff-3da9-473b-961b-\
d8991c9fcfd8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"param", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", 
       RowBox[{"1", "+", "param"}], ",", " ", "1.05"}], "}"}], "}"}], 
    "\[Transpose]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
      RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "V"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"epsilon", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "param"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1.05", "+", "epsilon"}], ")"}], "/", "2"}], ",", " ", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1.05", "+", "epsilon"}], ")"}]}], "/", "2"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dm", " ", "=", " ", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}]}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}], 
      RowBox[{"(", "p", ")"}]}], ",", "q"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"what", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"LeastSquares", "[", 
      RowBox[{
       RowBox[{"Refine", "[", 
        RowBox[{"Phi", ",", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"epsilon", "==", "0.0001"}]}]}], "]"}], ",", "V"}], "]"}], 
     ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"param", "\[Element]", "Reals"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"what", " ", "/.", 
  RowBox[{"{", 
   RowBox[{"param", "->", "2"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"Phi", ".", "what"}], "-", "V"}], "]"}], "<", "epsilon"}], "/.", 
  
  RowBox[{"{", 
   RowBox[{
    RowBox[{"param", "->", "2"}], ",", 
    RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dm", "//", "Total"}], "//", "Total"}], "//", 
  "Simplify"}]}], "Input",
 CellChangeTimes->{{3.848910053020782*^9, 3.848910152351247*^9}, {
   3.848910308449559*^9, 3.84891030984326*^9}, 3.851936641725163*^9, {
   3.852099656777422*^9, 3.852099660756007*^9}, {3.8520998283982353`*^9, 
   3.8520998330051622`*^9}, {3.852100643443104*^9, 3.852100647045465*^9}, {
   3.857312621661829*^9, 3.857312691960071*^9}, {3.857316711815258*^9, 
   3.85731676509906*^9}, {3.85765391359242*^9, 3.857653919307899*^9}, 
   3.857653970095665*^9, {3.85989693288984*^9, 3.859896944490634*^9}, {
   3.859897496931375*^9, 3.8598975945161552`*^9}, {3.859897902003407*^9, 
   3.8598979206232347`*^9}, {3.859898432342708*^9, 3.859898538002281*^9}, {
   3.85989857821306*^9, 3.859898582607389*^9}, {3.859898733660108*^9, 
   3.859898739319944*^9}, {3.859898922338215*^9, 3.859898927499708*^9}, 
   3.8599089226791687`*^9, {3.859976797797181*^9, 3.859976832973092*^9}, {
   3.859977124610374*^9, 3.859977129792815*^9}, 3.859977256340473*^9, {
   3.859977293909544*^9, 3.859977303975683*^9}, {3.859979542759618*^9, 
   3.859979551035636*^9}, {3.85997977767616*^9, 3.85997983483222*^9}, {
   3.8600696420253077`*^9, 3.860069679266094*^9}, 3.86009438417838*^9, 
   3.8600946899753304`*^9, {3.8600948466189938`*^9, 3.8600948787968493`*^9}, {
   3.860095501593268*^9, 3.860095525596113*^9}, {3.8607065688594627`*^9, 
   3.860706569512347*^9}, {3.860712799696726*^9, 3.860712803179474*^9}},
 CellLabel->
  "In[399]:=",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"p", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "q"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835369123*^9}, 3.860069328347806*^9, {
   3.860069650491766*^9, 3.860069679579013*^9}, 3.8600897404731627`*^9, 
   3.86009443676361*^9, 3.8600946903854237`*^9, {3.8600955117812567`*^9, 
   3.860095526147727*^9}, 3.8607041934691467`*^9, 3.860706569730085*^9, 
   3.860712810335791*^9},
 CellLabel->
  "Out[407]=",ExpressionUUID->"22062154-e778-4a4e-a623-2fe091948a8e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.9999598065796963`", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.9999955340644108`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835369123*^9}, 3.860069328347806*^9, {
   3.860069650491766*^9, 3.860069679579013*^9}, 3.8600897404731627`*^9, 
   3.86009443676361*^9, 3.8600946903854237`*^9, {3.8600955117812567`*^9, 
   3.860095526147727*^9}, 3.8607041934691467`*^9, 3.860706569730085*^9, 
   3.860712810359542*^9},
 CellLabel->
  "Out[409]=",ExpressionUUID->"68a448ac-e323-4c0d-9b46-ecb3c0d1db75"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835369123*^9}, 3.860069328347806*^9, {
   3.860069650491766*^9, 3.860069679579013*^9}, 3.8600897404731627`*^9, 
   3.86009443676361*^9, 3.8600946903854237`*^9, {3.8600955117812567`*^9, 
   3.860095526147727*^9}, 3.8607041934691467`*^9, 3.860706569730085*^9, 
   3.860712810364851*^9},
 CellLabel->
  "Out[410]=",ExpressionUUID->"1e9eebe1-fd61-4934-97f6-5250183446a0"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835369123*^9}, 3.860069328347806*^9, {
   3.860069650491766*^9, 3.860069679579013*^9}, 3.8600897404731627`*^9, 
   3.86009443676361*^9, 3.8600946903854237`*^9, {3.8600955117812567`*^9, 
   3.860095526147727*^9}, 3.8607041934691467`*^9, 3.860706569730085*^9, 
   3.860712810366997*^9},
 CellLabel->
  "Out[411]=",ExpressionUUID->"0dc4ecc7-81a6-42c1-a1ae-2787c87c3a08"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the fixed point w_star:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.848570432944818*^9, 3.8485704485407467`*^9}, {
  3.848570915714424*^9, 
  3.848570984363884*^9}},ExpressionUUID->"0a5d41cb-08ef-4253-a74f-\
02384f62cb6a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sA", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
        RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "Phi"}], " ", "+", " ", 
     RowBox[{"eta", "*", 
      RowBox[{"IdentityMatrix", "[", "2", "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sb", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "R"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wstar", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "sA", "]"}], ".", "sb"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.848570984364477*^9, 3.848571676353101*^9, {3.848913024643092*^9, 
   3.84891305207668*^9}, {3.848913722679961*^9, 3.848913736469101*^9}, {
   3.857312703508958*^9, 3.8573127254150143`*^9}, 3.8598985463718767`*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56"]
}, Open  ]],

Cell[CellGroupData[{

Cell["(a) Our vacuous example", "Subsection",
 CellChangeTimes->{{3.86007042093302*^9, 3.8600704260049133`*^9}, {
  3.8607064227487803`*^9, 
  3.8607064303169727`*^9}},ExpressionUUID->"81c795fb-2099-456a-94aa-\
2650a32156f4"],

Cell["\<\
Example of vacuous example with RR. We find the point when eta = 0 and then \
check that the solution remains vacuous for all eta:\
\>", "Text",
 CellChangeTimes->{{3.860069299944767*^9, 3.860069307859617*^9}, {
  3.860070387467526*^9, 
  3.8600704135964413`*^9}},ExpressionUUID->"64f07ecb-e4bf-4a69-aecf-\
ed2061176501"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0."}], ",", 
      RowBox[{"param", "->", "1.2"}], ",", 
      RowBox[{"q", "->", "0.44"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dm", "/.", 
   RowBox[{"{", 
    RowBox[{"q", "->", "0.44"}], "}"}]}], "//", "Total"}]}], "Input",
 CellChangeTimes->{{3.85997900439428*^9, 3.8599790959643707`*^9}, 
   3.859979176201169*^9, {3.8600955349580917`*^9, 3.8600955351830063`*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"cbb700c9-903c-4b75-ac3e-0e9c9622c628"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVkGs4FIgChj2tQhfhuDSOy2Zpj1PJRrKKL7eYi7kad3IYWVSjJ0qIRiGV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       "]], LineBox[CompressedData["
1:eJw92nc8Vf8fB3CkQaKkMstKVkb2fN17CRllh4yiJEVlVSKyUpqibGknoaIk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       "]], LineBox[CompressedData["
1:eJwVjmk8lAsDxScUUTTMFdKCVLbLvaFCnZvkZTYzYydR0iKJutIilCxJUYmi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       "]]},
     Annotation[#, "Charting`Private`Tag$8934#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.0016802347120117315`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8599790191385*^9, {3.8599790517144203`*^9, 3.859979096467621*^9}, 
   3.859979176499426*^9, 3.859979582766142*^9, 3.859979865159339*^9, 
   3.860069715837981*^9, 3.8600697957429123`*^9, 3.860094699893985*^9, 
   3.860095538324773*^9, 3.860704225219227*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"43495f4b-8add-4053-bda3-d73d12b7638e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.56`", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}]}], ",", 
   RowBox[{"0.56`", " ", "p"}], ",", "0.44`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8599790191385*^9, {3.8599790517144203`*^9, 3.859979096467621*^9}, 
   3.859979176499426*^9, 3.859979582766142*^9, 3.859979865159339*^9, 
   3.860069715837981*^9, 3.8600697957429123`*^9, 3.860094699893985*^9, 
   3.860095538324773*^9, 3.86070422523064*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"13dc6f95-43f6-4ef0-b913-ee69a98f273f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["(c) A small-eta example", "Subsection",
 CellChangeTimes->{{3.8607074859599457`*^9, 3.860707491988151*^9}, {
  3.860707780497072*^9, 
  3.860707785228855*^9}},ExpressionUUID->"7be9c3ec-8034-4c91-9814-\
745f9e8a8e2a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"testq", " ", "=", "0.44"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"testp", "=", "0.1026309679849605"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmpwstar", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"wstar", " ", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", 
        RowBox[{"q", "->", "testq"}], ",", 
        RowBox[{"p", "->", "testp"}], ",", 
        RowBox[{"param", "->", "1.2"}]}], "}"}]}], "//", "Simplify"}], "//", 
    "Flatten"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmperr", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", "0.0001"}], ",", 
       RowBox[{"q", "->", "testq"}], ",", 
       RowBox[{"p", "->", "testp"}], ",", 
       RowBox[{"param", "->", "1.2"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"tmperr", "/.", 
    RowBox[{"{", 
     RowBox[{"eta", "->", 
      RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tbl", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eta", "*", "0.1", "*", "10.0"}], "}"}], ",", "tmpwstar", 
        ",", 
        RowBox[{"{", "tmperr", "}"}]}], "]"}], " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{"eta", "->", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"etarun", "/", "10"}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"etarun", ",", 
       RowBox[{
        RowBox[{"-", "9"}], " ", "*", "10"}], ",", 
       RowBox[{"2", "*", "10"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<geometric_a.dat\>\"", ",", "tbl"}], "]"}]}], "Input",
 CellChangeTimes->{{3.860706529208823*^9, 3.860706530727314*^9}, {
   3.860706786728518*^9, 3.8607068029476357`*^9}, {3.86070687174236*^9, 
   3.8607069516332912`*^9}, {3.8607070479094954`*^9, 3.860707100531664*^9}, {
   3.8607071776075897`*^9, 3.860707350691289*^9}, {3.860709860566053*^9, 
   3.860709861761714*^9}, 3.860710112380823*^9, 3.8607111994493637`*^9, {
   3.860749781286549*^9, 3.860749796641528*^9}},
 CellLabel->
  "In[545]:=",ExpressionUUID->"2f18b637-132c-42d7-80a4-cc8db18c95f6"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwl13c8ld8fAHDrPtfm2qNssiKysp5PiIbsnSikkq+kyIgGSdLQINIkySij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       "]]},
     Annotation[#, "Charting`Private`Tag$67575#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-10, 10}, {0., 43.89776913338595}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.860706946510812*^9, 3.860706952366881*^9}, 
   3.8607071038716793`*^9, {3.860707183019127*^9, 3.86070718994456*^9}, {
   3.860707221300453*^9, 3.860707285603095*^9}, {3.8607073175630817`*^9, 
   3.860707351138185*^9}, 3.860707414557578*^9, 3.860709867447113*^9, 
   3.86071011336839*^9, 3.860711202163068*^9, {3.860749782890647*^9, 
   3.860749801694645*^9}},
 CellLabel->
  "Out[549]=",ExpressionUUID->"c9d2b016-6081-4874-bc6c-fe171a041aba"],

Cell[BoxData["\<\"geometric_a.dat\"\>"], "Output",
 CellChangeTimes->{{3.860706946510812*^9, 3.860706952366881*^9}, 
   3.8607071038716793`*^9, {3.860707183019127*^9, 3.86070718994456*^9}, {
   3.860707221300453*^9, 3.860707285603095*^9}, {3.8607073175630817`*^9, 
   3.860707351138185*^9}, 3.860707414557578*^9, 3.860709867447113*^9, 
   3.86071011336839*^9, 3.860711202163068*^9, {3.860749782890647*^9, 
   3.8607498017236967`*^9}},
 CellLabel->
  "Out[551]=",ExpressionUUID->"5bcf2b5d-98e2-41d3-aae7-a542e4a297e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"testq", " ", "=", "0.44"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"testp", "=", "0.1026"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmpwstar", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"wstar", " ", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", 
        RowBox[{"q", "->", "testq"}], ",", 
        RowBox[{"p", "->", "testp"}], ",", 
        RowBox[{"param", "->", "1.2"}]}], "}"}]}], "//", "Simplify"}], "//", 
    "Flatten"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmperr", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", "0.0001"}], ",", 
       RowBox[{"q", "->", "testq"}], ",", 
       RowBox[{"p", "->", "testp"}], ",", 
       RowBox[{"param", "->", "1.2"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"tmperr", "/.", 
    RowBox[{"{", 
     RowBox[{"eta", "->", 
      RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tbl", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eta", "*", "0.1", "*", "10.0"}], "}"}], ",", "tmpwstar", 
        ",", 
        RowBox[{"{", "tmperr", "}"}]}], "]"}], " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{"eta", "->", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"etarun", "/", "10"}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"etarun", ",", 
       RowBox[{
        RowBox[{"-", "9"}], " ", "*", "10"}], ",", 
       RowBox[{"2", "*", "10"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<geometric_c.dat\>\"", ",", "tbl"}], "]"}]}], "Input",
 CellChangeTimes->{{3.860707357488406*^9, 3.860707384448019*^9}, {
   3.8607077589735622`*^9, 3.860707764605277*^9}, 3.860707939948984*^9, 
   3.8607098699814653`*^9, 3.8607100375836563`*^9, {3.8607101059734297`*^9, 
   3.860710107704302*^9}, 3.8607497992505302`*^9},
 CellLabel->
  "In[538]:=",ExpressionUUID->"9225aeb5-e7a8-46af-a92b-e1da5ddd1de5"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV1nk4VV0XAHBDQkmmO5nuufeWmQwJoX2bqAwhEa9ChiQvhSQlmlTCJ0SZ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       "]], 
      LineBox[CompressedData["
1:eJwl2Xc8Ve8fAHDjnnOv6+LeayRJVrKyV9b5oEIkmSUqo6W+kiRbw2iS7NIu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       "]]},
     Annotation[#, "Charting`Private`Tag$67246#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-10, 10}, {0., 6.163413987592848}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8607073751486177`*^9, 3.860707386363454*^9}, {
   3.860707760386652*^9, 3.860707766829159*^9}, 3.860709870975059*^9, 
   3.8607100614856243`*^9, 3.860710109877632*^9, 3.8607128122534523`*^9, 
   3.860749799790756*^9},
 CellLabel->
  "Out[542]=",ExpressionUUID->"0b301b4b-f962-404f-98bb-60d503f95304"],

Cell[BoxData["\<\"geometric_c.dat\"\>"], "Output",
 CellChangeTimes->{{3.8607073751486177`*^9, 3.860707386363454*^9}, {
   3.860707760386652*^9, 3.860707766829159*^9}, 3.860709870975059*^9, 
   3.8607100614856243`*^9, 3.860710109877632*^9, 3.8607128122534523`*^9, 
   3.8607497998271847`*^9},
 CellLabel->
  "Out[544]=",ExpressionUUID->"be4a7a78-ea15-4a15-a5ad-34953f836e28"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["(b) A regular example", "Subsection",
 CellChangeTimes->{
  3.8607078115763483`*^9},ExpressionUUID->"2955ed88-dcb9-4e52-94f3-\
4d0c06b7d02f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"testq", "=", "0.61"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
     " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", "0.0001"}], ",", 
       RowBox[{"eta", "->", "0."}], ",", 
       RowBox[{"param", "->", "1.2"}], ",", 
       RowBox[{"q", "->", "testq"}]}], "}"}]}], " ", "//", " ", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dm", "/.", 
   RowBox[{"{", 
    RowBox[{"q", "->", "testq"}], "}"}]}], "//", 
  "Total"}], "\[IndentingNewLine]", 
 RowBox[{"Maximize", "[", 
  RowBox[{"tmp", ",", "p"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.86070747408921*^9, {3.860707515641883*^9, 3.860707661305273*^9}},
 CellLabel->
  "In[240]:=",ExpressionUUID->"fcbf14d2-3d89-49bf-a50b-03875d9d5147"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVl3c4FYzjxSlKCBUie7TerMqIcCQp49qyZWZl91UI10xGGhJyS5RQIUL2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       "]], 
      LineBox[CompressedData["
1:eJw9VmlUjW0bTSGUUGgg4i2Rk0LDi/p2vCUpqVSENKhkTpI0eJ4zdJpnQ2gy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       "]], 
      LineBox[CompressedData["
1:eJwVlmk01QsXxpHKEMpQl4oyFC4yl1LPvblS5yDHPBOSMmQsMguhkotKhkqj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       "]]},
     Annotation[#, "Charting`Private`Tag$24841#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.01731806219560144}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.860707517563512*^9, 3.860707661701914*^9}},
 CellLabel->
  "Out[242]=",ExpressionUUID->"38f247ef-5b36-40a5-abc8-d07ec80f71e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.39`", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}]}], ",", 
   RowBox[{"0.39`", " ", "p"}], ",", "0.61`"}], "}"}]], "Output",
 CellChangeTimes->{{3.860707517563512*^9, 3.860707661716234*^9}},
 CellLabel->
  "Out[243]=",ExpressionUUID->"0fd082cb-8f3b-42c0-b77d-049cb2e183e1"],

Cell[BoxData[
 TemplateBox[{
  "NMaximize", "cvdiv", 
   "\"Failed to converge to a solution. The function may be unbounded.\"", 2, 
   244, 6, 16687389020483916043, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8607076625308228`*^9},
 CellLabel->
  "During evaluation of \
In[240]:=",ExpressionUUID->"b0b0d6c2-5d46-4f17-bc0f-5d04671affcf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.1436871200035372`*^10", ",", 
   RowBox[{"{", 
    RowBox[{"p", "\[Rule]", "0.3517824537869842`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.860707517563512*^9, 3.860707662551051*^9}},
 CellLabel->
  "Out[244]=",ExpressionUUID->"605f661d-b27d-44ba-8d81-1c0ec98849b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"testq", " ", "=", "0.61"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"testp", "=", "0.35180"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmpwstar", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"wstar", " ", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", 
        RowBox[{"q", "->", "testq"}], ",", 
        RowBox[{"p", "->", "testp"}], ",", 
        RowBox[{"param", "->", "1.2"}]}], "}"}]}], "//", "Simplify"}], "//", 
    "Flatten"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmperr", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", "0.0001"}], ",", 
       RowBox[{"q", "->", "testq"}], ",", 
       RowBox[{"p", "->", "testp"}], ",", 
       RowBox[{"param", "->", "1.2"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"tmperr", "/.", 
    RowBox[{"{", 
     RowBox[{"eta", "->", 
      RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", 
     RowBox[{"-", "7"}], ",", "10"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tbl", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eta", "*", "0.1", "*", "10.0"}], "}"}], ",", "tmpwstar", 
        ",", 
        RowBox[{"{", "tmperr", "}"}]}], "]"}], " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{"eta", "->", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"etarun", "/", "10"}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"etarun", ",", 
       RowBox[{
        RowBox[{"-", "9"}], "*", "10"}], ",", 
       RowBox[{"2", "*", "10"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<geometric_b.dat\>\"", ",", "tbl"}], "]"}]}], "Input",
 CellChangeTimes->{{3.860707696486603*^9, 3.8607077324636707`*^9}, 
   3.860707935758834*^9, 3.860709876324484*^9, {3.8607099493986807`*^9, 
   3.860709949912313*^9}, {3.860709989234474*^9, 3.860709992804434*^9}, 
   3.860712056371478*^9, 3.860712093623225*^9, {3.860712128787417*^9, 
   3.860712152552796*^9}, {3.8607131409524117`*^9, 3.8607132354061117`*^9}, 
   3.8607498066162148`*^9},
 CellLabel->
  "In[552]:=",ExpressionUUID->"adf0a706-2cd8-4640-b17c-9b1a837093b3"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwl13k8VF8bAHAzc8e+G7sQla2QVNJyHypFCv2IVLJVki3KklaVLWUpQiGl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       "]]},
     Annotation[#, "Charting`Private`Tag$67904#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 2.1549370080625185`},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-7, 10}, {2.1549370080625136`, 3.281074367276047}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.860707712861354*^9, 3.860707733122018*^9}, 
   3.8607098775698*^9, 3.86070995879137*^9, 3.860709993532452*^9, {
   3.860712030811879*^9, 3.860712058617024*^9}, 3.86071209475458*^9, {
   3.860712150070209*^9, 3.860712153161475*^9}, {3.86071314163948*^9, 
   3.86071315383946*^9}, {3.860713191463231*^9, 3.860713242364057*^9}, 
   3.860749807804961*^9},
 CellLabel->
  "Out[556]=",ExpressionUUID->"e3a4cae7-9245-445d-8316-ca57dada2543"],

Cell[BoxData["\<\"geometric_b.dat\"\>"], "Output",
 CellChangeTimes->{{3.860707712861354*^9, 3.860707733122018*^9}, 
   3.8607098775698*^9, 3.86070995879137*^9, 3.860709993532452*^9, {
   3.860712030811879*^9, 3.860712058617024*^9}, 3.86071209475458*^9, {
   3.860712150070209*^9, 3.860712153161475*^9}, {3.86071314163948*^9, 
   3.86071315383946*^9}, {3.860713191463231*^9, 3.860713242364057*^9}, 
   3.860749807834632*^9},
 CellLabel->
  "Out[558]=",ExpressionUUID->"eab2f7f8-6715-4bc8-9ba4-c06655198fc1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scaling and stretching (for the paper)", "Subsection",
 CellChangeTimes->{{3.860751298726534*^9, 
  3.8607513051374073`*^9}},ExpressionUUID->"b9e00a75-94da-42f8-a671-\
0985f703217f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rotm", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "theta", "]"}], ",", " ", 
       RowBox[{"Sin", "[", "theta", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Sin", "[", "theta", "]"}]}], ",", " ", 
       RowBox[{"Cos", "[", "theta", "]"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"scalem", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", " ", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"rotm", "/.", 
    RowBox[{"{", 
     RowBox[{"theta", "->", 
      RowBox[{"Pi", "/", "4"}]}], "}"}]}], ")"}], ".", "scalem", ".", 
  RowBox[{"(", 
   RowBox[{"rotm", "/.", 
    RowBox[{"{", 
     RowBox[{"theta", "->", 
      RowBox[{
       RowBox[{"-", "Pi"}], "/", "4"}]}], "}"}]}], ")"}], ".", 
  RowBox[{"(", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}], ")"}]}]}], "Input",
 CellChangeTimes->{{3.860751321664393*^9, 3.86075147444412*^9}, 
   3.860751706636428*^9, {3.860751776428892*^9, 3.8607517786607447`*^9}, {
   3.860751816480197*^9, 3.86075181954006*^9}},
 CellLabel->
  "In[575]:=",ExpressionUUID->"859755c1-e0be-45e6-9452-20091d208af6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["k", "2"]}], ")"}], " ", "x"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox["k", "2"]}], ")"}], " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox["k", "2"]}], ")"}], " ", "x"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["k", "2"]}], ")"}], " ", "y"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.86075144171702*^9, 3.860751475308524*^9}, 
   3.860751707561615*^9, 3.86075181990152*^9},
 CellLabel->
  "Out[577]=",ExpressionUUID->"876b8cb5-3706-46a9-a897-0acf37545312"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{2272.2935779816517`, 910.8990825688073},
WindowMargins->{{0, Automatic}, {17.67272727272723, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperOrientation"->"Portrait",
"PaperSize"->{Automatic, Automatic},
"PostScriptOutputFile"->"/home/gauravmm/print.pdf"},
TaggingRules-><|"TryRealOnly" -> False|>,
CellContext->Notebook,
Magnification->1.25,
FrontEndVersion->"13.0 for Linux x86 (64-bit) (February 4, 2022)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "JournalArticle.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"edb60e67-8447-428f-bf83-9bc5b3088beb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 485, 9, 49, "Text",ExpressionUUID->"051258ff-3da9-473b-961b-d8991c9fcfd8"],
Cell[CellGroupData[{
Cell[1068, 33, 4594, 121, 332, "Input",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],
Cell[5665, 156, 1109, 27, 53, "Output",ExpressionUUID->"22062154-e778-4a4e-a623-2fe091948a8e"],
Cell[6777, 185, 809, 16, 53, "Output",ExpressionUUID->"68a448ac-e323-4c0d-9b46-ecb3c0d1db75"],
Cell[7589, 203, 663, 11, 53, "Output",ExpressionUUID->"1e9eebe1-fd61-4934-97f6-5250183446a0"],
Cell[8255, 216, 660, 11, 53, "Output",ExpressionUUID->"0dc4ecc7-81a6-42c1-a1ae-2787c87c3a08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8952, 232, 281, 5, 28, "Text",ExpressionUUID->"0a5d41cb-08ef-4253-a74f-02384f62cb6a",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[9236, 239, 1105, 28, 84, "Input",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[10378, 272, 225, 4, 44, "Subsection",ExpressionUUID->"81c795fb-2099-456a-94aa-2650a32156f4"],
Cell[10606, 278, 331, 7, 28, "Text",ExpressionUUID->"64f07ecb-e4bf-4a69-aecf-ed2061176501"],
Cell[CellGroupData[{
Cell[10962, 289, 922, 26, 84, "Input",ExpressionUUID->"cbb700c9-903c-4b75-ac3e-0e9c9622c628"],
Cell[11887, 317, 18724, 332, 295, "Output",ExpressionUUID->"43495f4b-8add-4053-bda3-d73d12b7638e"],
Cell[30614, 651, 553, 12, 53, "Output",ExpressionUUID->"13dc6f95-43f6-4ef0-b913-ee69a98f273f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31216, 669, 222, 4, 44, "Subsection",ExpressionUUID->"7be9c3ec-8034-4c91-9814-745f9e8a8e2a"],
Cell[CellGroupData[{
Cell[31463, 677, 2587, 73, 193, "Input",ExpressionUUID->"2f18b637-132c-42d7-80a4-cc8db18c95f6"],
Cell[34053, 752, 14971, 269, 316, "Output",ExpressionUUID->"c9d2b016-6081-4874-bc6c-fe171a041aba"],
Cell[49027, 1023, 517, 8, 101, "Output",ExpressionUUID->"5bcf2b5d-98e2-41d3-aae7-a542e4a297e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49581, 1036, 2425, 70, 193, "Input",ExpressionUUID->"9225aeb5-e7a8-46af-a92b-e1da5ddd1de5"],
Cell[52009, 1108, 18877, 335, 316, "Output",ExpressionUUID->"0b301b4b-f962-404f-98bb-60d503f95304"],
Cell[70889, 1445, 375, 6, 54, "Output",ExpressionUUID->"be4a7a78-ea15-4a15-a5ad-34953f836e28"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71313, 1457, 147, 3, 44, "Subsection",ExpressionUUID->"2955ed88-dcb9-4e52-94f3-4d0c06b7d02f"],
Cell[CellGroupData[{
Cell[71485, 1464, 1095, 33, 147, "Input",ExpressionUUID->"fcbf14d2-3d89-49bf-a50b-03875d9d5147"],
Cell[72583, 1499, 14889, 271, 299, "Output",ExpressionUUID->"38f247ef-5b36-40a5-abc8-d07ec80f71e6"],
Cell[87475, 1772, 343, 9, 53, "Output",ExpressionUUID->"0fd082cb-8f3b-42c0-b77d-049cb2e183e1"],
Cell[87821, 1783, 366, 9, 35, "Message",ExpressionUUID->"b0b0d6c2-5d46-4f17-bc0f-5d04671affcf"],
Cell[88190, 1794, 319, 8, 56, "Output",ExpressionUUID->"605f661d-b27d-44ba-8d81-1c0ec98849b4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88546, 1807, 2539, 71, 193, "Input",ExpressionUUID->"adf0a706-2cd8-4640-b17c-9b1a837093b3"],
Cell[91088, 1880, 16034, 286, 317, "Output",ExpressionUUID->"e3a4cae7-9245-445d-8316-ca57dada2543"],
Cell[107125, 2168, 507, 8, 54, "Output",ExpressionUUID->"eab2f7f8-6715-4bc8-9ba4-c06655198fc1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107681, 2182, 188, 3, 44, "Subsection",ExpressionUUID->"b9e00a75-94da-42f8-a671-0985f703217f"],
Cell[CellGroupData[{
Cell[107894, 2189, 1377, 43, 100, "Input",ExpressionUUID->"859755c1-e0be-45e6-9452-20091d208af6"],
Cell[109274, 2234, 836, 28, 71, "Output",ExpressionUUID->"876b8cb5-3706-46a9-a897-0acf37545312"]
}, Open  ]]
}, Open  ]]
}
]
*)

