""" read in result CSVs to process stats: avg and stdev
"""

import pandas as pd
import numpy as np
from scipy import stats
import sys
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.use('tkagg')



# str_time = ''





# # finite K-armed bandit
# dir = f'./cmab_model/run_imbalanced/results' #/{domain}'

# # finite K-armed bandit
# algo_names = ['ignorant', 'historical', 'artificial_replay']
# stat_names = ['runtime', 'unused_h', 'regret']
# dir = f'./k_armed_model/k_armed_historical/plots' #/{domain}'

# filenames = [
#
# # adaptive
# 'cmab_model/run_imbalanced/plots/frac0.1_regret_env-quadratic_n5_b3_eps0.05_H10000_effort3_26-09-2022_15:01:16.png'
# cmab_model/run_imbalanced/plots/frac0.5_regret_env-quadratic_n5_b3_eps0.05_H10000_effort3_26-09-2022_14:44:15.png
# cmab_model/run_imbalanced/plots/frac0.6_regret_env-quadratic_n5_b3_eps0.05_H10000_effort3_26-09-2022_14:57:21.png
# cmab_model/run_imbalanced/plots/frac0.7_regret_env-quadratic_n5_b3_eps0.05_H10000_effort3_26-09-2022_15:00:25.png
# cmab_model/run_imbalanced/plots/frac0.9_regret_env-quadratic_n5_b3_eps0.05_H10000_effort3_26-09-2022_14:50:56.png
#     # finite armed
#     'stats_regret_k_armed_k10_b3_H10000_25-09-2022_23:25:12',
#     'stats_regret_k_armed_k10_b3_H1000_25-09-2022_23:23:12',
#     'stats_regret_k_armed_k10_b3_H100_25-09-2022_23:25:50',
#     'stats_regret_k_armed_k10_b3_H10_25-09-2022_23:22:17'
# ]

# H = 100
# frac0.1_regret_env-quadratic_n5_b3_eps0.03125_H100_effort3_26-09-2022_16/13/21.png
# frac0.5_regret_env-quadratic_n5_b3_eps0.03125_H100_effort3_26-09-2022_16/13/24.png
# frac0.7_regret_env-quadratic_n5_b3_eps0.05_H100_effort3_26-09-2022_16/05/20.png
# frac0.7_regret_env-quadratic_n5_b3_eps0.03125_H100_effort3_26-09-2022_16/13/25.png


###########################
# # adaptive better
# # H = 300
# dir = f'./cmab_model/rand_sample/results' #/{domain}'
# filenames = [
# # 'stats_frac0.1_regret_env-quadratic_n5_b3_eps0.03125_H300_effort3_26-09-2022_16:22:29.csv'
# 'stats_frac0.1_regret_env-quadratic_n5_b3_eps0.03125_H300_effort3_26-09-2022_16:22:29.csv',
# 'stats_frac0.5_regret_env-quadratic_n5_b3_eps0.03125_H300_effort3_26-09-2022_16:22:33.csv',
# 'stats_frac0.7_regret_env-quadratic_n5_b3_eps0.03125_H300_effort3_26-09-2022_16:22:33.csv',
# 'stats_frac0.9_regret_env-quadratic_n5_b3_eps0.03125_H300_effort3_26-09-2022_16:22:36.csv',
# ]
#
# # fixed discretization
# dir = f'./cmab_model/run_imbalanced/results'
# filenames = [
# 'stats_frac0.1_regret_env-quadratic_n5_b3_eps0.03125_H10000_effort3.csv',
# 'stats_frac0.5_regret_env-quadratic_n5_b3_eps0.03125_H10000_effort3.csv',
# 'stats_frac0.7_regret_env-quadratic_n5_b3_eps0.03125_H10000_effort3.csv',
# 'stats_frac0.9_regret_env-quadratic_n5_b3_eps0.03125_H10000_effort3.csv',
# ]

def process_regret():
    T      = 1000
    K      = 10

    # n_historical = 100 # 10, 100, 1000, 10000
    # H = 10000


    ###########################
    # adaptive: imbalanced coverage
    ###########################
    # combinatorial bandit
    # algo_names = ['fixed_ignorant', 'fixed_historical', 'fixed_artificial_replay',
    #               'adaptive_ignorant', 'adaptive_historical', 'adaptive_artificial_replay',
    #               'regression']
    # algo_names = ['adaptive_ignorant', 'adaptive_historical', 'adaptive_artificial_replay', 'regression']
    # stat_names = ['runtime', 'unused_h', 'regret', 'n_regions']
    # frac_vals = [0.1, 0.5, 0.7, 0.9]


    ###########################
    # finite K-armed bandit: spurious data
    ###########################
    algo_names = ['ignorant', 'historical', 'artificial_replay', 'random', 'optimal']
    # stat_names = ['runtime', 'unused_h', 'regret']
    # columns: 'algo', 'iter', 't', 'reward', 'regret', 'unused_h'

    # dir = f'./k_armed_model/k_armed_historical/results' #/{domain}'


    dir = f'./k_armed_model/k_armed_b1/results' #/{domain}'
    budget = 1
    H = 1000
    filename = f'regret_regret_k_armed_k10_b{budget}_H{H}.csv' # K-armed with spurious data

    # H_vals    = [10, 100, 1000, 10000] # num historical

    # for stat_name in stat_names:

    # print('------------------')
    # print(stat_name)
    # print('------------------')

    # rewards['t']   = T_vals
    # regrets['t']   = T_vals
    # unused_hs['t'] = T_vals

    # ###########################
    # # combinatorial bandit
    # ###########################
    # # budget = 3
    # # algo_names = ['adaptive_ignorant', 'adaptive_historical', 'adaptive_artificial_replay', 'regression']
    # # algo_names = ['fixed_ignorant', 'fixed_historical', 'fixed_artificial_replay', 'regression', 'optimal']
    # # dir = './cmab_model/60_iters/results'
    # # filename = 'regret_env-pwl_n5_b2_eps0.2_H300_effort3.csv' # 60 iterations: PWL regret
    # algo_names = ['fixed_ignorant', 'fixed_historical', 'fixed_artificial_replay', 'optimal'] # 'regression',
    # dir = './cmab_model/3_iters/results'
    # filename = 'regret_env-quadratic-fixed_n5_b2_eps0.2_H300_effort3.csv'
    #
    # # algo_names = ['adaptive_ignorant', 'adaptive_historical', 'adaptive_artificial_replay', 'optimal'] #'regression', 'optimal']
    # dir = './cmab_model/1_iters/results'
    # # filename = 'regret_env-quadratic-adaptive_n5_b2_eps0.2_H300_effort3.csv'
    # # filename = 'regret_env-pwl-adaptive_n5_b2_eps0.03125_H300_effort3.csv'
    # # filename = 'regret_env-uganda-adaptive_real_h_n5_b3_eps0.2_H300_effort3.csv'
    # filename = 'regret_env-uganda-fixed_n5_b2_eps0.2_H1000_effort3.csv'

    ###########################
    # run
    ###########################

    T_vals = np.arange(T)
    rewards = {}
    regrets = {}
    unused_hs = {}

    in_path = f'{dir}/{filename}'
    df = pd.read_csv(in_path)

    print(f'read in file {in_path}')

    for algo_name in algo_names:
        # means = np.zeros(T)
        # sems  = np.zeros(T)
        ########### adaptive
        # for frac in frac_vals:
        # filename = f'stats_frac{frac}_regret_env-quadratic_n5_b3_eps0.03125_H10000_effort3.csv'  # adaptive, with imbalanced data coverage
        ########### finite K-armed
        # for H in H_vals: # K-armed bandit

        # get rows from algo
        algo_df = df.loc[df['algo'] == algo_name]

        rewards[f'{algo_name}']       = np.zeros(T)
        regrets[f'{algo_name}']       = np.zeros(T)
        unused_hs[f'{algo_name}']     = np.zeros(T)
        rewards[f'{algo_name}_sem']   = np.zeros(T)
        unused_hs[f'{algo_name}_sem'] = np.zeros(T)
        regrets[f'{algo_name}_sem']   = np.zeros(T)
        for t in range(T):
            t_df = algo_df.loc[algo_df['t'] == t]
            rewards[f'{algo_name}'][t]       = t_df['reward'].mean()
            regrets[f'{algo_name}'][t]       = t_df['regret'].mean()
            unused_hs[f'{algo_name}'][t]     = t_df['unused_h'].mean()
            rewards[f'{algo_name}_sem'][t]   = stats.sem(t_df['reward'])
            regrets[f'{algo_name}_sem'][t]   = stats.sem(t_df['regret'])
            unused_hs[f'{algo_name}_sem'][t] = stats.sem(t_df['unused_h'])

    reward_df = pd.DataFrame(rewards)
    regret_df = pd.DataFrame(regrets)
    unused_h_df = pd.DataFrame(unused_hs)

    reward_df.index.name = 't'
    regret_df.index.name = 't'
    unused_h_df.index.name = 't'

    reward_df.to_csv(f'{dir}/avg_reward_{filename}')
    regret_df.to_csv(f'{dir}/avg_regret_{filename}')
    unused_h_df.to_csv(f'{dir}/avg_unused_h_{filename}')

process_regret()

def process_total_stats():
    T      = 1000
    K      = 10
    budget = 1#3
    n_historical = 100 # 10, 100, 1000, 10000


    ###########################
    # adaptive: imbalanced coverage
    ###########################
    # combinatorial bandit
    # algo_names = ['fixed_ignorant', 'fixed_historical', 'fixed_artificial_replay',
    #               'adaptive_ignorant', 'adaptive_historical', 'adaptive_artificial_replay',
    #               'regression']
    # algo_names = ['adaptive_ignorant', 'adaptive_historical', 'adaptive_artificial_replay', 'regression']
    # stat_names = ['runtime', 'unused_h', 'regret', 'n_regions']
    # frac_vals = [0.1, 0.5, 0.7, 0.9]


    ###########################
    # finite K-armed bandit: spurious data
    ###########################
    algo_names = ['ignorant', 'historical', 'artificial_replay', 'random']
    stat_names = ['runtime', 'unused_h', 'regret']
    # dir = f'./k_armed_model/k_armed_historical/results' #/{domain}'
    dir = f'./k_armed_model/k_armed_b1/results' #/{domain}'
    H_vals    = [10, 100, 1000, 10000] # num historical

    for stat_name in stat_names:
        print('------------------')
        print(stat_name)
        print('------------------')

        total_stats = {}
        # total_stats['frac_vals'] = frac_vals
        total_stats['H'] = H_vals

        for algo_name in algo_names:
            means = []
            sems = []
            ########### adaptive
            # for frac in frac_vals:
            # filename = f'stats_frac{frac}_regret_env-quadratic_n5_b3_eps0.03125_H10000_effort3.csv'  # adaptive, with imbalanced data coverage
            ########### finite K-armed
            for H in H_vals: # K-armed bandit
                filename = f'stats_regret_k_armed_k10_b{budget}_H{H}.csv' # K-armed with spurious data
                in_path = f'{dir}/{filename}'
                df = pd.read_csv(in_path)

                values = df[f'{stat_name}-{algo_name}']
                means.append(values.mean())
                sems.append(stats.sem(values))

            total_stats[f'{algo_name}'] = means
            total_stats[f'{algo_name}_sem'] = sems


        stat_df = pd.DataFrame(total_stats)
        stat_df.to_csv(f'{dir}/{stat_name}.csv')

# process_total_stats()
