import sys
from transformers import AutoModelForCausalLM
from ellipse_attack.transformations import Model

if __name__ == "__main__":
    model_name = sys.argv[1]
    # Get and save model params
    model = AutoModelForCausalLM.from_pretrained(model_name)
    W = model.lm_head.weight.cpu().numpy().T
    gamma = model.transformer.ln_f.weight.cpu().numpy()
    beta = model.transformer.ln_f.bias.cpu().numpy()
    final_layer = Model(stretch=gamma, bias=beta, unembed=W)
    os.makedirs("data/model", exist_ok=True)
    np.savez(f"data/model/{os.path.basename(model_name)}.npz", **asdict(final_layer))
