import pandas as pd

df = (
    pd.read_pickle("data/error_data.pkl")
    .set_index(("fnames", None))
    .set_index(("Samples", None), append=True)
)

df1 = (
    df.stack(1, future_stack=True)
    .reorder_levels([2, 0, 1])
    .sort_index(level=0, sort_remaining=False)
    .reset_index(level=1)
    .rename(columns={("fnames", None): "fnames"})
    .loc[lambda df: ~df.fnames.str.contains("band")]
    .loc[lambda df: ~df.fnames.str.contains("ellipse_pred")]
    .drop(columns="fnames")
    .unstack(0)
    .drop(
        columns=[
            ("Angle", "bias"),
            ("Angle", "stretch"),
            ("RMS", "rot2"),
        ]
    )[["Angle", "RMS"]]
    .reset_index()
    .droplevel(0, axis="columns")
    .rename(columns={None: "Samples"})
    .assign(Samples=lambda df: df.Samples.astype(int))
    .sort_values("Samples")
    # .set_index("Samples")
    .loc[lambda df: df.Samples <= 60_000]
    [["Samples", "bias", "stretch", "rot2"]]
)

print(df1)
print()

df1.to_csv("overleaf/data/dist.dat", sep="\t", index=False)

table = (
    df1.style.relabel_index(
        ["Samples", "Bias (MSE)", "Stretch (MSE)", r"Rotation (geodesic distance)"],
        axis="columns",
    )
    .hide(axis=0)
    .format(precision=2)
    .format(precision=3, subset="bias")
    .to_latex(hrules=True, siunitx=True,
              column_format="S[table-format=6]S[table-format=1.2]S[table-format=1.2]S[table-format=1.2]")
)

print(table)

with open("overleaf/tab/errors.tex", "w") as file:
    print(table, file=file)
