# dynamics.py

import numpy as np


def best_response_lex(y, x):
    n = len(y)
    i = np.argmax(y)
    xnew = np.zeros(n); xnew[i] = 1
    return xnew


def best_response_rand(y, x):
    n = len(y)
    v = np.max(y)
    i_set = [i for i in np.arange(n) if y[i] == v]
    i = np.random.choice(i_set)
    xnew = np.zeros(n); xnew[i] = 1
    return xnew


def FTRL(A, n, x1, x2, T, alpha, Q, eta):

    # primal/dual variable tracking
    x1_t = {}; x2_t = {}
    y1_t = {}; y2_t = {}

    # initialization
    x1_t[0] = np.zeros(n)
    x2_t[0] = np.zeros(n)

    x1_t[1] = x1
    x2_t[1] = x2 

    y1_t[2] = eta*A@x2
    y2_t[2] = -eta*A.T@x1

    for t in np.arange(2, T):

        x1_new = Q(
            y1_t[t] + alpha*A@x2_t[t-1],    # payoff vector
            x1_t[t-1],  # prev x1
        )
        x1_t[t] = x1_new
        
        x2_new = Q(
            y2_t[t] - alpha*A.T@x1_t[t-1],    # payoff vector
            x2_t[t-1],  # prev x2
        )
        x2_t[t] = x2_new
        
        y1_t[t+1] = y1_t[t] + eta*A@x2_new
        y2_t[t+1] = y2_t[t] - eta*A.T@x1_new

    return x1_t, x2_t, y1_t, y2_t

    
def AFTRL(A, n, x1, T, alpha, Q, eta):

    # primal/dual variable tracking
    x1_t = {}; x2_t = {}
    y1_t = {}; y2_t = {}

    # initialization
    x1_t[1] = x1
    x1_t[-1] = np.zeros(n)
    x1_t[T+2] = np.zeros(n)
    x2_t[0] = np.ones(n)/n

    y1_t[2] = np.zeros(n)
    y2_t[2] = -eta*A.T@x1

    for k in np.arange(1, int(T/2)):

        # even update: t = 2k
        t=2*k
        x2_new = Q(
            y2_t[t] - alpha*A.T@x1_t[t-1], # payoff vector
            x2_t[t-2],                     # prev. x2
        )
        x2_t[t] = x2_new

        y1_t[t+1] = y1_t[t] + eta*A@x2_new
        y2_t[t+1] = y2_t[t] - eta*A.T@x1_t[t-1]

        if t >= T-2: break
        
        # odd update: t = 2k+1
        t1 = 2*k+1
        x1_new = Q(
            y1_t[t1] + alpha*A@x2_t[t], # payoff vector
            x1_t[t1-2],                 # prev. x1
        )
        x1_t[t1] = x1_new

        y1_t[t1+1] = y1_t[t1] + eta*A@x2_t[t]
        y2_t[t1+1] = y2_t[t1] - eta*A.T@x1_new
    
    return x1_t, x2_t, y1_t, y2_t



