# Copyright (c) 2018-present, Royal Bank of Canada and other authors.
# See the AUTHORS.txt file for a list of contributors.
# All rights reserved.
#
# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.
#

# flake8: noqa

from .base import Attack
from .base import LabelMixin

from .one_step_gradient import GradientAttack
from .one_step_gradient import GradientSignAttack
from .one_step_gradient import FGM
from .one_step_gradient import FGSM

from .iterative_projected_gradient import FastFeatureAttack
from .iterative_projected_gradient import L2BasicIterativeAttack
from .iterative_projected_gradient import LinfBasicIterativeAttack
from .iterative_projected_gradient import PGDAttack
from .iterative_projected_gradient import LinfPGDAttack
from .iterative_projected_gradient import L2PGDAttack
from .iterative_projected_gradient import L1PGDAttack
from .iterative_projected_gradient import SparseL1DescentAttack
from .iterative_projected_gradient import MomentumIterativeAttack
from .iterative_projected_gradient import L2MomentumIterativeAttack
from .iterative_projected_gradient import LinfMomentumIterativeAttack

from .carlini_wagner import CarliniWagnerL2Attack
from .ead import ElasticNetL1Attack

from .decoupled_direction_norm import DDNL2Attack
from .deepfool import DeepfoolLinfAttack

from .lbfgs import LBFGSAttack

from .localsearch import SinglePixelAttack
from .localsearch import LocalSearchAttack

from .spatial import SpatialTransformAttack

from .jsma import JacobianSaliencyMapAttack
from .jsma import JSMA

from .spsa import LinfSPSAAttack
from .fast_adaptive_boundary import FABAttack
from .fast_adaptive_boundary import LinfFABAttack
from .fast_adaptive_boundary import L2FABAttack
from .fast_adaptive_boundary import L1FABAttack

from .utils import ChooseBestAttack

from .blackbox.gen_attack import GenAttack
from .blackbox.gen_attack import LinfGenAttack
from .blackbox.gen_attack import L2GenAttack

from .blackbox.nattack import NAttack
from .blackbox.nattack import LinfNAttack
from .blackbox.nattack import L2NAttack

from .blackbox.estimators import FDWrapper, NESWrapper

from .blackbox.bandits import BanditAttack
from .blackbox.iterative_gradient_approximation import NESAttack