from argparse import ArgumentParser


def create_parser():
    parser = ArgumentParser(description='LongtailAT', allow_abbrev=False)
    parser.add_argument('--model', type=str, choices=['RES-18', 'RES-50',' WRN-34-10'],  default='RES-18', metavar='N',
                        help='model architecture')
    parser.add_argument('--aug', type=str, choices=['aua', 'ra', 'none'], default='aua', metavar='N',
                        help='data augmentation')
    parser.add_argument('--batch', type=int, default=128, metavar='N',
                        help='input batch size for training (default: 128)')
    parser.add_argument('--pre_epochs', type=int, default=100, metavar='N',
                        help='number of epochs to train')
    parser.add_argument('--epochs', type=int, default=100, metavar='N',
                        help='number of epochs to train')
    parser.add_argument('--weight-decay', '--wd', default=5e-4,
                        type=float, metavar='W')
    parser.add_argument('--lr', type=float, default=0.1, metavar='LR',
                        help='learning rate')
    parser.add_argument('--momentum', type=float, default=0.9, metavar='M',
                        help='SGD momentum')
    parser.add_argument('--no-cuda', action='store_true', default=False,
                        help='disables CUDA training')
    parser.add_argument('--log-interval', type=int, default=100, metavar='N',
                        help='how many batches to wait before logging training status')
    parser.add_argument('--model-dir', default='./model-cifar10',
                        help='directory of model for saving checkpoint')
    parser.add_argument('--save-freq', '-s', default=1, type=int, metavar='N',
                        help='save frequency')
    parser.add_argument('--alpha', type=float, default=0)
    parser.add_argument('--beta', type=float, default=0)
    parser.add_argument('--gamma', type=float, default=0)
    parser.add_argument('--delta', type=float, default=0)
    parser.add_argument('--pre_batch', type=int, default=16)
    parser.add_argument('--debug', type=int, default=0)
    parser.add_argument('--ensemble_number', type=int, default=-1)
    parser.add_argument('--IR', type=float, default=0.02)
    parser.add_argument('--teacher', type = str, default ='LTD')

    parser.add_argument('--pre_training', default=1, choices=[0, 1], type=int, help='Inhibit wandb logging')
    parser.add_argument('--threshold', default=1, choices=[0, 1], type=int, help='Inhibit wandb logging')
    parser.add_argument('--wandb_entity', type=str, default='wandb_entity', help='Wandb entity')
    parser.add_argument('--wandb_project', type=str, default='wandb_proj', help='Wandb project name')
    parser.add_argument('--wandb_name', type=str, default="test", help='Wandb running name')
    parser.add_argument('--wandb_tags', type=str, default="NoTag", help='Wandb running tags')
    parser.add_argument('--method', type=str, default='method', help='Wandb entity')
    parser.add_argument('--dataset', type=str, default='cifar100', help='Wandb entity')
    parser.add_argument('--ensemble_method', type=str, default='full_balance', help='Wandb entity')
    parser.add_argument('--training', type=str, default='AT', help='Wandb entity')
    

    return parser
