This folder is to generate poison data in ssba.py ("--attack_train_replace_imgs_path" and 
"--attack_test_replace_imgs_path" should receive two path for poisoned training data and poisoned testing data, respectively).

Step 1: 

Choose the dataset you want to poison, and run the following command to convert the dataset into seperate image files in the same folder:
    eg. 

```shell
python dataset_convert_into_images.py --dataset {dataset_name}
```

(If you do not want to use the dataset we provided, you can also use your own dataset. Then you should put the training images and testing images separately into two folders.)

Step 2:

Run the following command to train the autoencoder on given **training** dataest:

eg.

```shell
  python train.py \
  --data_dir /path/to/images/ \
  --output_dir /path/to/output/ \
  --EXP_NAME customized_experiment_name \
  --use_celeba_preprocessing \
  --random_seed 0 \
  --fingerprint_length 100 \
  --image_resolution 128 \
  --num_epochs 20 \
  --batch_size 64 \
  --use_residual 0 \
  --use_modulated 0 \
  --fc_layers 0 \
  --fused_conv 0
  ```
  where
  - `use_celeba_preprocessing` needs to be active if and only if using CelebA aligned and cropped images.
  
  - `image_resolution` indicates the image resolution for training. All the images in `data_dir` is center-cropped according to the shorter side and then resized to this resolution. When `use_celeba_preprocessing` is active, `image_resolution` has to be set as 128.
  
  - `output_dir` contains model snapshots, image snapshots, and log files. For model snapshots, `*_encoder.pth` and `*_decoder.pth` correspond to the fingerprint encoder and decoder respectively.
  
  - `use_residual` indicates the output mode of encoder. When it is set to 0, the output is exactly the encoded image. When it is set to 1, the output is the residual, and the encoded image is generated by residual + original image.
  
  - `use_modulated` indicates whether to use the modulated convolution layers in StyleGAN2. When it is 0, the model is just the normal StegaStamp.
  
  - `fc_layers` indicates whether to add 8 fc layers to disentangle the fingerprints before it is sent to the encoder, just as the way in StyleGAN2.
  
  - `fused_conv` indicates the mode of modulated convolution as is shown in the figure below. When it is set to 0, the 'Fuse' option in modulated convolution is set to be False.

Step 3:

Run the following command to generate the poisoned training and testing data:

eg.

```shell
# embedding training dataset
python embed_fingerprints.py \
    --encoder_path {path to encoder pth file} \
    --data_dir {train_dataset_folder} \
    --output_dir {folder path that you put poisoned trainig images} \
    --image_resolution 32 \
    --identical_fingerprints \
    --check \
    --decoder_path {path to decoder pth file} \
    --batch_size 32 \
    --seed 0 \
    --encode_method bch \
    --secret {secret you want to encode into poisoned data} \
    --use_residual 0 \
    --use_modulated 0 \
    --fused_conv 0 \
    --fc_layers 0 \
    --cuda 0
    
# pack images into npy file
python utils/pack_images.py \
  --path {folder path that you put poisoned trainig images} \
  --save_file_path {packed poisoned training data npy file path}
  
# embedding test dataset
python embed_fingerprints.py \
    --encoder_path {path to encoder pth file} \
    --data_dir {test_dataset_folder} \
    --output_dir {folder path that you put poisoned testing images} \
    --image_resolution 32 \
    --identical_fingerprints \
    --check \
    --decoder_path {path to decoder pth file} \
    --batch_size 32 \
    --seed 0 \
    --encode_method bch \
    --secret {secret you want to encode into poisoned data} \
    --use_residual 0 \
    --use_modulated 0 \
    --fused_conv 0 \
    --fc_layers 0 \
    --cuda 0

# pack images into npy file
python utils/pack_images.py \
  --path {folder path that you put poisoned testing images} \
  --save_file_path {packed poisoned testing data npy file path}

```
