# Numer-FLUX

A fine-tuning framework for FLUX.1-dev diffusion models with LoRA training, designed for numerical counting and object generation tasks.

## Quick Start

### Prerequisites

```bash
pip install torch torchvision diffusers transformers accelerate wandb peft
```

### Training

1. Configure your training parameters in `configs/` directory
2. Set up your dataset JSON and image folder
3. Run training:

```bash
bash train.sh
```

### Configuration

Edit configuration files in `configs/` to customize:
- Model paths and settings
- Training hyperparameters  
- Dataset paths and preprocessing
- LoRA rank and target modules
- Validation prompts

## Project Structure

```
├── configs/           # Training configurations
├── accelerate_cfg/    # Multi-GPU training configs
├── train_flux_lora.py # Main training script
├── custom_dataset.py  # Dataset implementation
├── custom_pipeline.py # Custom FLUX pipeline
├── eval.py           # Evaluation utilities
└── utils.py          # Helper functions
```

## License

Apache 2.0