
_base_ = "../base.py"

### path & device settings
output_path_base = '/workspace/output/v01_lora_r16_bs16_flux_count_'
cache_dir = '/workspace/cache'
total_gpu_num = 1

### wandb settings
wandb_job_name = "flux_" + '{{fileBasenameNoExtension}}'

### Dataset Settings
resolution=512
dataset_cfg = dict(
    resolution=512,
    center_crop=False,
    random_flip=False,
    data_json_path="/workspace/data/train_data.json",
    image_folder="/workspace/images/",
    train_with_one_sample=False,
    # debug=True,
)
dataloader_shuffle = True
dataloader_pin_memory = True
dataloader_drop_last = True
dataloader_num_workers = 8
# max_train_samples = 1_000_000
# dataloader_num_workers = 1
base_checkpoint = None


# custom noise settings
random_layout = True


### Model Settings
rank = 16
text_encoder_rank = 64
train_text_encoder = False

### Training Settings
weighting_scheme = "none"
logit_mean = 0.0
logit_std = 1.0
mode_scale = 1.29
guidance_scale = 1.0 ###IMPORTANT

# steps
train_batch_size = 16
num_train_epochs = 1000
max_train_steps = 10000
checkpointing_steps = 1000
resume_from_checkpoint = "latest"
gradient_accumulation_steps = 1

# lr
optimizer = "adamw"
learning_rate = 1e-5
scale_lr = False
lr_scheduler = "constant"
lr_warmup_steps = 0
lr_num_cycles = 1
lr_power = 1.0

# optim
adam_beta1 = 0.9
adam_beta2 = 0.999
adam_weight_decay = 1e-3
adam_epsilon = 1e-8
prodigy_beta3 = None
prodigy_decouple = True
prodigy_use_bias_correction = True
prodigy_safeguard_warmup = True
max_grad_norm = 1.0

# logging
tracker_task_name = '{{fileBasenameNoExtension}}'
output_dir = output_path_base + "{{fileBasenameNoExtension}}"

### Validation Settings
# num_validation_images = 4
# validation_steps = 500
# validation_prompts = [
#     "A minimalist black line drawing of thirteen rabbits, set against a soft gray background, each outlined with smooth, precise lines to create an elegant and harmonious composition.",
#     "A sleek and simple black line art depiction of seven elephants, all drawn with clean, straight lines against a soft gray background, highlighting their graceful yet minimalist form.",
#     "An artistic, minimalist rendering of twenty-one foxes in black line art, featuring sharp, clean outlines and a neutral gray backdrop, providing a balanced and sophisticated aesthetic.",
#     "A charming collection of thirty lions, each drawn with minimalist black lines, creating a graceful and balanced visual impression on a soft gray canvas.",
# ]
validation_prompts = None