import numpy as np
import scipy.sparse as sp

def _deg_vec(A):
    d = np.asarray(A.sum(axis=1)).ravel().astype(float)
    d[d <= 0.0] = 1e-12
    return d

def _dnorm(u, d):
    return np.sqrt(float((d * (u * u)).sum()) + 1e-24)

def HaarGOB_with_Sassign_degree_norm(treeG, S_assign_list):
    Ntr = len(treeG)

    clusterJ0 = treeG[Ntr-1]['clusters']; N0 = len(clusterJ0)
    chic = np.identity(N0)
    uc = [None] * N0
    uc[0] = (1.0 / np.sqrt(N0)) * np.ones(N0, dtype=float)
    for l in range(1, N0):
        uc[l] = np.sqrt((N0 - l) / (N0 - l + 1.0)) * (chic[l-1, :] - (1.0 / (N0 - l)) * np.sum(chic[l:, :], axis=0))

    A_top = treeG[Ntr-1]['adj'].tocsr()
    d_top = _deg_vec(A_top)
    for l in range(N0):
        nrm = _dnorm(uc[l], d_top); uc[l] = uc[l] / nrm

    for j_tr in np.arange(Ntr-2, -1, -1):
        N1 = len(treeG[j_tr]['clusters'])
        S_assign = np.asarray(S_assign_list[j_tr], dtype=float)
        A_lvl = treeG[j_tr]['adj'].tocsr()
        d_lvl = _deg_vec(A_lvl)

        u = [None] * N1
        i = N0
        for l in range(N0):
            cluster_l = np.asarray(treeG[j_tr+1]['clusters'][l], dtype=int)
            ul1 = np.zeros(N1, dtype=float)
            for j in range(N0):
                idxj = np.asarray(treeG[j_tr+1]['clusters'][j], dtype=int)
                if idxj.size == 0: continue
                w = S_assign[idxj, l]
                ul1[idxj] += uc[l][j] * w
            nrm = _dnorm(ul1, d_lvl)
            if nrm > 0: ul1 = ul1 / nrm
            u[l] = ul1

            kl = int(cluster_l.size)
            if kl > 1:
                chil = np.zeros((kl, N1), dtype=float)
                for k in range(kl):
                    chil[k, cluster_l[k]] = 1.0
                for k in range(1, kl):
                    i += 1
                    ulk = np.sqrt((kl - k) / (kl - k + 1.0)) * (chil[k-1, :] - (1.0 / (kl - k)) * np.sum(chil[k:, :], axis=0))
                    nrmk = _dnorm(ulk, d_lvl)
                    if nrmk > 0: ulk = ulk / nrmk
                    u[i-1] = ulk
        treeG[j_tr]['u'] = u
        uc = u; N0 = N1
    return treeG

def extract_haar_basis_and_graph_info(tree_real):
    Tree_length = len(tree_real)
    num_nodes_tree = np.zeros(Tree_length, dtype=int)
    num_edges_tree = np.zeros(Tree_length, dtype=int)
    edge_index_list = [None] * Tree_length
    U = []
    features_list = []
    from graph_utils import adj2edge
    for j in range(Tree_length):
        u = tree_real[j]['u']
        N = len(u)
        N1 = len(tree_real[j+1]['u']) if j < Tree_length - 1 else 1
        HaarBases = np.zeros((N, N1), dtype=np.float64)
        for k in range(N1):
            HaarBases[:, k] = u[k]
        U.append(HaarBases)
        num_nodes_tree[j] = N
        edge_index, _ = adj2edge(tree_real[j]['adj'])
        edge_index_list[j] = edge_index
        num_edges_tree[j] = edge_index.size(1)
        features_list.append(tree_real[j]['features'])
    num_nodes_tree[-1] = 1
    num_edges_tree[-1] = 1
    return U, num_nodes_tree, num_edges_tree, edge_index_list, features_list

