import matplotlib.pyplot as plt
import numpy as np
from matplotlib import cm, ticker

if __name__ == "__main__":
    N=26
    N2=21
    x=np.linspace(-2,3,  N)
    y=np.linspace(2,-2, N2)
    X,Y=np.meshgrid(x,y)
    Z=np.load(f'data/map_12.npy')
    loc=np.where(Z==np.max(Z))
    levels=np.arange(0,100,0.1)
    fig1=plt.figure(figsize=(6.5,5.2))
    cs=plt.contourf(X,Y,Z,levels, cmap=plt.get_cmap('coolwarm'))
    plt.xticks([-2,-1,-0,1,2,3],['-2','-1','0','1','2','3'],fontsize=16)
    plt.xlabel(r"$\lambda_1$", fontsize=16)
    plt.yticks([-2,-1,0,1,2], ['-2','-1','0','1','2'],fontsize=16)
    plt.ylabel(r"$\lambda_2$", fontsize=16)
    cl=fig1.colorbar(cs)
    cl.ax.tick_params(labelsize=16)
    cl.set_ticks([0,30,60,90])
    cl.set_ticklabels(['0','30','60','90'])
    plt.scatter(1,0, s=200, marker='o', color='black')
    plt.scatter((loc[1][0]-10)/5, (10-loc[0][0])/5, s=200, marker='+', color='green', linewidths=5)
    plt.show()

    diff = np.maximum(Z - Z[10, 15], 0)
    lev = np.arange(0, np.max(diff), 0.05)
    fig2=plt.figure(figsize=(6.5,5.2))
    cs=plt.contourf(X,Y,diff,lev, cmap=plt.get_cmap('coolwarm'))
    plt.xticks([-2,-1,-0,1,2,3],['-2','-1','0','1','2','3'],fontsize=16)
    plt.xlabel(r"$\lambda_1$", fontsize=16)
    plt.yticks([-2,-1,0,1,2], ['-2','-1','0','1','2'],fontsize=16)
    plt.ylabel(r"$\lambda_2$", fontsize=16)
    cl=fig2.colorbar(cs)
    cl.ax.tick_params(labelsize=16)
    ceil=int(np.max(diff))
    tick0=[]
    tick0_label=[]
    for i in range(ceil+1):
        tick0.append(i)
        tick0_label.append(str(i))
    cl.set_ticks(tick0)
    cl.set_ticklabels(tick0_label)
    plt.scatter(1,0, s=200, marker='o', color='black')
    plt.scatter((loc[1][0]-10)/5, (10-loc[0][0])/5, s=200, marker='+', color='red', linewidths=5)
    plt.show()

    x=np.linspace(-2,3,  100)
    y=np.linspace(-2,2, 100)
    X,Y=np.meshgrid(x,y)
    ineq1 = (0.79 * X - 0.64 * Y) >= 0.2
    ineq2 = (0.79 ** 2 * X + 0.64 ** 2 * Y) >= 0.2
    bounded_x = np.abs(X) <= 2
    bounded_y = np.abs(Y) <= 2

    # Combine the inequalities and the boundaries
    mask = ineq1 & ineq2 & bounded_x & bounded_y

    # Convert the mask (boolean) to 0 and 1 values
    mask_int = np.array(mask, dtype=np.float32)

    #levels=np.arange(0,100,0.1)
    fig1=plt.figure(figsize=(6,6))
    cs=plt.contourf(X,Y,mask, cmap=plt.get_cmap('coolwarm'))
    #cs.cmap.set_over('red')
    #cs.cmap.set_under('blue')
    #cs.changed()
    plt.xticks([-2,-1,-0,1,2,3],['-2','-1','0','1','2','3'],fontsize=18)
    plt.xlabel(r"$\lambda_1$", fontsize=18)
    plt.yticks([-2,-1,0,1,2], ['-2','-1','0','1','2'],fontsize=18)
    plt.ylabel(r"$\lambda_2$", fontsize=18)
    #cl=fig1.colorbar(cs)

    #cl.ax.tick_params(labelsize=16)
    #cl.set_ticks([0,30,60,90])
    #cl.set_ticklabels(['0','30','60','90'])
    #plt.scatter(1,0, s=200, marker='o', color='black')
    #plt.scatter((loc[1][0]-10)/5, (10-loc[0][0])/5, s=200, marker='+', color='green', linewidths=5)
    plt.show()


