import json
import argparse
from trainer import train


def main():
    args = setup_parser().parse_args()
    param = load_json(args.config)
    args = vars(args)  # Converting argparse Namespace to a dict.
    args.update(param)  # Add parameters from json
    train(args)


def load_json(settings_path):
    with open(settings_path) as data_file:
        param = json.load(data_file)

    return param


def setup_parser():
    parser = argparse.ArgumentParser(description='Reproduce of multiple continual learning algorithms.')
    parser.add_argument('--config', type=str, default='./exps/lwf/omni.json',
                        help='Json file of settings.')
    parser.add_argument('--log_name', type=str, default='./results/compared',
                        help='Json file of settings.')
    parser.add_argument('--data_root', type=str, default='../data/',
                        help='Json file of settings.')
    
    ## DNM parameters
    parser.add_argument('--num_branch', type=int, default=2,
                        help='Json file of settings.')
    parser.add_argument('--synapse_activation', type=str, default='sigmoid',
                        help='Json file of settings.')
    parser.add_argument('--dendritic_activation', type=str, default='none',
                        help='Json file of settings.')
    parser.add_argument('--soma', type=str, default='none',
                        help='Json file of settings.')
    parser.add_argument('--dnm', action='store_true', help='Whether to use DNM')
    parser.add_argument('--sn', action='store_true', help='A boolean flag of synaptic normalization in DNM')
    parser.add_argument('--dn', action='store_true', help='A boolean flag of dendritic normalization in DNM')
    parser.add_argument('--test', action='store_true', help='mode of run')
    parser.add_argument('--save_model', type=int,default=1, help='save model default: True')

    return parser


if __name__ == '__main__':
    main()
