import os

# name = ['derdnm','icarl','lwf','foster','tagfex','finetune']
method_name = ['lwf','icarl','lwf','der','replay','finetune']
data_name = ['vtab','ina','cifar100','cub','inr','omni']


script_path = './scripts/'
log_name = './results/compared'
data_root  = '../data/'


## dnm parametere
sn = True
dn = False
synapse_activation = ['sigmoid']
soma = ['none']
dendritic_activation = ['none']
num_branch = [2]



for method in method_name:
    f = open(os.path.join(script_path,f'run_{method}.sh'),'w')
    f1 = open(os.path.join(script_path,f'run_{method}_dnm.sh'),'w')
    for data in data_name:
        # original
        f.write(f'python main.py --config ./exps/{method}/{data}.json --log_name {log_name}  --data_root {data_root} \n')
        
        # Plus DNM
        f1.write(f'python main.py --config ./exps/{method}/{data}.json --log_name {log_name}  --data_root {data_root} ')
        for sa in synapse_activation:
            for da in dendritic_activation:
                for soma_t in soma:
                    for n in num_branch:
                        f1.write(f' --synapse_activation {sa} --dendritic_activation {da} '
                                 f' --soma {soma_t} --num_branch {n} ')
                        if sn:
                            f1.write(' --sn ')
                        if dn:
                            f1.write(' --dn ')
                        f1.write(' --dnm \n')
f.close()
f1.close()

