# F-PvE: Fairness-Aware Structured Neural Network Pruning via Evolution

## Project Overview

F-PvE is proposed as a general method to achieve fairness-aware structured neural network pruning via evolutionary optmization techniques. The project is organized according to the three fairness scenarios in the paper.

## Directory Structure

```
.
├── task1/                      # Task 1: Class-wise degradation in multi-class classification
│   ├── engine/                 # Core engine components
│   │   ├── models/            # Model architectures (ResNet)
│   │   └── utils/             # Utility functions
│   ├── FPVE_scripts/          # Execution scripts
│   ├── pretrain/              # Pre-training related files
│   └── prune_tp/              # Pruning implementation
│
├── task2/                      # Task 2: Group-wise degradation in classification with sensitive groups
│   ├── archs/                 # Neural architectures
│   ├── utils/                 # Utility functions including fairness calculations
│   ├── FPVE_scripts/          # Execution scripts
│   └── prune_tp/              # Pruning and fine-tuning implementations
│
└── task3/                      # Task 3: Social bias in generated contents of language models
    ├── FASP/                  # Modules of the prior work FASP
    │   ├── holistic/          # Holistic evaluation data
    │   ├── model/             # Model configurations and scores
    │   └── prompts/           # Test prompts and configurations
    └── run_FPVE.sh            # Main execution script
```

## Task Descriptions

Task 1: Class-wise degradation in multi-class classification

Task 2: Group-wise degradation in classification with sensitive groups

Task 3: Social bias in generated contents of language models

## Usage

### Task 1:

```bash
# Run the example script
cd task1
bash FPVE_scripts/run_FPVE_example.sh
```

### Task 2: Extended FPVE with Fairness

```bash
# Run the example script
cd task2
bash FPVE_scripts/run_FPVE_example.sh
```

### Task 3: FASP Integration

```bash
# Run the example script
cd task3
bash run_FPVE.sh
```

More details can be found in the README.md under the corresponding task
