#!/bin/bash
# This is a demo script for basic training experiments.

# Main training script
TRAIN_SCRIPT="python trainer.py"

# Common parameters shared across all runs
COMMON_PARAMS=" --dataset your_dataset \
                --data_root your_data_root_path \
                --ckpt_save_dir your_save_path \
                --arch your_arch \
                --opt_name your_optimizer \
                --lr your_lr \
                --lr_scheduler_name your_lr_scheduler \
                --batch_size your_batch_size \
                --ft_epochs your_epochs \
                ...
                "

# Seed and GPU mapping (parallel execution)
SEEDS=(YOUR_SEED_1 YOUR_SEED_2 YOUR_SEED_3)  # e.g. (2021 2022 2023 2024)
GPUS=(YOUR_GPU_1 YOUR_GPU_2 YOUR_GPU_3)      # e.g. (0 1 2 3)


for i in "${!SEEDS[@]}"; do
    SEED=${SEEDS[$i]}
    GPU=${GPUS[$i]}
    echo "Starting training: seed=$SEED, GPU=$GPU"
    $TRAIN_SCRIPT $COMMON_PARAMS --gpu $GPU --random_seed $SEED &
done

wait
echo "All training jobs completed!"