#!/bin/bash

# Main training script
TRAIN_SCRIPT="python trainer.py"

# Example parameters for a specific dataset and architecture:
COMMON_PARAMS=" --dataset cub200 \
                --data_root your_data_root_path \
                --ckpt_save_dir your_save_path \
                --arch resnet50 \
                --opt_name sgd \
                --lr 0.002 \
                --lr_scheduler_name cosineannealinglr \
                --batch_size 8 \
                --ft_epochs 88 \
                "
# Seed and GPU mapping (parallel execution)
SEEDS=(2021)
GPUS=(0)


for i in "${!SEEDS[@]}"; do
    SEED=${SEEDS[$i]}
    GPU=${GPUS[$i]}
    echo "Starting training: seed=$SEED, GPU=$GPU"
    $TRAIN_SCRIPT $COMMON_PARAMS --gpu $GPU --random_seed $SEED &
done

wait
echo "All training jobs completed!"