#!/bin/bash
# This is a demo script for basic training experiments on CelebA dataset

# Main training script
TRAIN_SCRIPT="python trainer.py"

# Common parameters shared across all runs
COMMON_PARAMS=" --arch resnet18_half \
                --mode train \
                --dataset celeba \
                --dataset_dir your_dataset_path \
                --target_attr Attractive \
                --save_dir your_save_path \
                --train_data_ratio your_train_data_ratio \
                --batch_size your_batch_size \
                --epochs your_epochs \
                "
# --use_schedular \ # optional, use if you want to use a scheduler

# Seed and GPU mapping (parallel execution)
SEEDS=(YOUR_SEED_1 YOUR_SEED_2 YOUR_SEED_3)
GPUS=(YOUR_GPU_1 YOUR_GPU_2 YOUR_GPU_3)

for i in "${!SEEDS[@]}"; do
    SEED=${SEEDS[$i]}
    GPU=${GPUS[$i]}
    echo "──────────────────────────────────────"
    echo "Starting training: seed=$SEED, GPU=$GPU"
    echo "──────────────────────────────────────"
    
    $TRAIN_SCRIPT $COMMON_PARAMS --gpu $GPU -rd $SEED &
done

wait
echo "──────────────────────────────────────"
echo "All training jobs completed!"
echo "──────────────────────────────────────"