#!/bin/bash

# Main training script
TRAIN_SCRIPT="python trainer.py"

# Common parameters shared across all runs
COMMON_PARAMS=" --arch resnet18_half \
                --mode train \
                --dataset celeba \
                --dataset_dir your_dataset_path \
                --target_attr Attractive \
                --save_dir your_save_path \
                --train_data_ratio 0.1 \
                --batch_size 256 \
                --epochs 50 \
                --use_schedular \
                "

# Seed and GPU mapping (parallel execution)
SEEDS=(2021 2022 2023 2024)
GPUS=(0 1 2 3)

for i in "${!SEEDS[@]}"; do
    SEED=${SEEDS[$i]}
    GPU=${GPUS[$i]}
    echo "──────────────────────────────────────"
    echo "Starting training: seed=$SEED, GPU=$GPU"
    echo "──────────────────────────────────────"
    
    $TRAIN_SCRIPT $COMMON_PARAMS --gpu $GPU -rd $SEED &
done

wait
echo "──────────────────────────────────────"
echo "All training jobs completed!"
echo "──────────────────────────────────────"