#!/bin/bash
# this is a demo script to run FPVE
# Make sure to set the correct paths for your output directories and modify the parameters as needed.

# Single-objective evolutionary pruning
python main_FPVE.py \
    --model gpt2 \
    --pruned_heads_ratio 0.1 \
    --pop_size 10 \
    --evo_epoch 20 \
    --seed 1 \
    --output_dir YOUR_OUTPUT_PATH_1 \
    --device "cuda:0" \
    --scalar 1 \
    --mutation_rate 0.1 \
    --fitness_mode 'BIAS_PPL' &
    # optional: --parent_selection "roulette_wheel" \  default is "random"

# Multi-objective evolutionary pruning (NSGA-II)
python main_FPVE.py \
    --model gpt2 \
    --pruned_heads_ratio 0.2 \
    --pop_size 32 \
    --evo_epoch 25 \
    --seed 1 \
    --output_dir YOUR_OUTPUT_PATH_2 \
    --device "cuda:1" \
    --scalar 1 \
    --mutation_rate 0.1 \
    --fitness_mode 'BIAS_PPL' \
    --nsgaii \
    --parent_selection "binary_tournament" &

wait
echo "Both experiments started in parallel"