import argparse


TRN_SPLIT = {
    'imagenet2012': 'train',
    'caltech101': 'train[:90%]',
    'caltech_birds2011': 'train[:90%]',
    'cifar100': 'train[:90%]',
    'cifar100_1880': 'train[:1880]',
    'cifar100_4500': 'train[:4500]',
    'dtd': 'train',
    'oxford_flowers102': 'train',
    'oxford_iiit_pet': 'train[:90%]',
    'sun397': 'train',
    'svhn_cropped': 'train[:90%]',
}
VAL_SPLIT = {
    'imagenet2012': 'validation',
    'caltech101': 'train[90%:]',
    'caltech_birds2011': 'train[90%:]',
    'cifar100': 'train[90%:]',
    'cifar100_1880': 'train[90%:]',
    'cifar100_4500': 'train[90%:]',
    'dtd': 'validation',
    'oxford_flowers102': 'validation',
    'oxford_iiit_pet': 'train[90%:]',
    'sun397': 'validation',
    'svhn_cropped': 'train[90%:]',
}
TST_SPLIT = {
    'imagenet2012': 'validation',
    'caltech101': 'test',
    'caltech_birds2011': 'test',
    'cifar100': 'test',
    'cifar100_1880': 'test',
    'cifar100_4500': 'test',
    'dtd': 'test',
    'oxford_flowers102': 'test',
    'oxford_iiit_pet': 'test',
    'sun397': 'test',
    'svhn_cropped': 'test',
}
NUM_CLASSES = {
    'imagenet2012': 1000,
    'caltech101': 101,
    'caltech_birds2011': 200,
    'cifar100': 100,
    'cifar100_1880': 100,
    'cifar100_4500': 100,
    'dtd': 47,
    'oxford_flowers102': 102,
    'oxford_iiit_pet': 37,
    'sun397': 397,
    'svhn_cropped': 10,
}


def str2bool(v):
    if isinstance(v, bool):
        return v
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')


def default_argument_parser():
    parser = argparse.ArgumentParser()

    parser.add_argument(
        '--data_name', default='caltech101', type=str,
        choices=[
            'caltech101', 'cifar100', 'dtd',
            'caltech_birds2011', 'oxford_flowers102', 'oxford_iiit_pet',
            'cifar100_1880', 'cifar100_4500'])

    parser.add_argument(
        '--resnet_depth', default=50, type=int,
        help='depth of the residual network (default: 50)')
    parser.add_argument(
        '--resnet_width', default=1, type=int,
        help='width of the residual network (default: 1)')

    parser.add_argument(
        '--batch_size', default=128, type=int,
        help='the number of examples for each mini-batch (default: 128)')
    parser.add_argument(
        '--num_workers', default=32, type=int,
        help='how many subprocesses to use for data loading (default: 32)')
    parser.add_argument(
        '--prefetch_factor', default=2, type=int,
        help='number of batches loaded in advance by each worker (default: 2)')

    return parser
