# Introduction

This is the implementation of our paper "Tackling Feature-Classifier Mismatch in Federated Learning via Prompt-Driven Feature Transformation."

# Dataset

Our experiments utilize three datasets: CIFAR-10, CIFAR-100, and Tiny ImageNet. CIFAR-10 and CIFAR-100 will automatically download when the code is run. Due to file size limitations for uploads, we do not provide the Tiny ImageNet dataset. One can download the dataset from http://cs231n.stanford.edu/tiny-imagenet-200.zip and extract it to the `./data/` directory. 

# System

- `main.py`: Entry point of the program.
- `./utils/options.py`: Configuration of experimental hyperparameters.
- `./src/client.py`: Client-side code.
- `./src/server.py`: Server-side code.
- `./models`: Directory for storing backbone model code.
- `./moco`: Directory for storing MoCo algorithm code utilized in FedPFT+Con.

# Simulation

## Environment

The required experimental environments can be found in `requirements.txt`.

## Training and Evaluation Demo

- Experiment in Pathological non-IID scenario with CIFAR-10 dataset.

  ```shell
  # FedPFT
  python main.py --num_users=40 --dataset=cifar --model=resnet8 --feature_dim=256 --noniid=pathological --alpha=2 --lr=0.1 --train_num=500 --test_num=100 --local_bs=100 --classification_lr=0.1 --epochs=1000 --local_ep=1 --contrastive_ep=4 --lamda1=0 --prompt_num_tokens_g=0 --prompt_num_tokens_p=10 --save_model=0 --seed=0
  
  # FedPFT+Con
  python main.py --num_users=40 --dataset=cifar --model=resnet8 --feature_dim=256 --noniid=pathological --alpha=2 --lr=0.1 --mlp_lr=0.1 --moco-dim=128 --moco-t=0.07 --train_num=500 --test_num=100 --local_bs=100 --classification_lr=0.1 --epochs=1000 --local_ep=1 --contrastive_ep=4 --prompt_num_tokens_g=20 --prompt_num_tokens_p=10 --save_model=0 --seed=0
  ```

- Experiment in Dirichlet  non-IID scenario with CIFAR-100 dataset.

  ```shell
  # FedPFT
  python main.py --num_users=40 --dataset=cifar-100 --model=resnet10 --feature_dim=512 --noniid=dirichlet --alpha=1.0 --lr=0.1 --train_num=500 --test_num=100 --local_bs=100 --classification_lr=0.1 --epochs=1000 --local_ep=1 --contrastive_ep=4 --lambda1=0 --prompt_num_tokens_g=0 --prompt_num_tokens_p=10 --save_model=0 --seed=0
  
  # FedPFT+Con
  python main.py --num_users=40 --dataset=cifar-100 --model=resnet10 --feature_dim=512 --noniid=dirichlet --alpha=1.0 --lr=0.1 --mlp_lr=0.1 --moco-dim=128 --moco-t=0.07 --train_num=500 --test_num=100 --local_bs=100 --classification_lr=0.1 --epochs=1000 --local_ep=1 --contrastive_ep=4 --prompt_num_tokens_g=20 --prompt_num_tokens_p=10 --save_model=0 --seed=0
  ```


Experimental results can be found in the `./log` directory.