import torch
import torch.nn as nn
import numpy as np


def divide_no_nan(a, b):
    result = a / b
    result[result != result] = .0
    result[result == np.inf] = .0
    return result

class smape_loss(nn.Module):
    def __init__(self):
        super(smape_loss, self).__init__()
    
    def forward(self, forecast: torch.Tensor, target: torch.Tensor):
        return 200 * torch.mean(divide_no_nan(torch.abs(forecast - target),
                                              torch.abs(forecast.data) + torch.abs(target.data)))