from evaluation_MIMIC4ED import compute_scores
import pandas as pd
import numpy as np

import ipdb

all_mean_f1 = []
all_std_f1 = []

for missing_ratio in [0.2]:#[0.2,0.5,0.8]:
    synthesized_data = pd.read_csv('./generated_MIMIC4ED/generated_samples_MIMIC4ED2_0.2.csv')
    # ipdb.set_trace()

    path = './data_MIMIC4ED_onehot/used.csv'
    train = pd.read_csv(path)
    train.drop(columns='Unnamed: 0', axis=1,inplace=True)
    train.replace(False, 0, inplace=True)
    train.replace(True, 0, inplace=True)

    path = './data_MIMIC4ED_onehot/test.csv'
    test = pd.read_csv(path)
    test = test.iloc[:, [7, 18, 26, 27, 28, 32, 33, 34, 35, 36, 37, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 78, 79, 80, 82, 83, 85, 89, 94, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 20, 115, 116]]
    test['ed_los'] = pd.to_timedelta(test['ed_los']).dt.seconds / 60
    # ipdb.set_trace()


    metadata = {'problem_type' : 'regression','columns':[
 {'type': 'categorical', 'i2s': ['M', 'F'], 'size': 2, 'name': 'gender'},
 {'type': 'continuous', 'name': 'age', 'max': 103, 'min': 18},
 {'type': 'continuous', 'name': 'n_ed_30d', 'max': 20, 'min': 0},
 {'type': 'continuous', 'name': 'n_ed_90d', 'max': 41, 'min': 0},
 {'type': 'continuous', 'name': 'n_ed_365d', 'max': 112, 'min': 0},
 {'type': 'continuous', 'name': 'n_hosp_30d', 'max': 15, 'min': 0},
 {'type': 'continuous', 'name': 'n_hosp_90d', 'max': 30, 'min': 0},
 {'type': 'continuous', 'name': 'n_hosp_365d', 'max': 69, 'min': 0},
 {'type': 'continuous', 'name': 'n_icu_30d', 'max': 4, 'min': 0},
 {'type': 'continuous', 'name': 'n_icu_90d', 'max': 6, 'min': 0},
 {'type': 'continuous', 'name': 'n_icu_365d', 'max': 14, 'min': 0},
 {'type': 'continuous',
  'name': 'triage_temperature',
  'max': 44.11111111111112,
  'min': 26.0},
 {'type': 'continuous', 'name': 'triage_heartrate', 'max': 256.0, 'min': 1.0},
 {'type': 'continuous', 'name': 'triage_resprate', 'max': 209.0, 'min': 0.0},
 {'type': 'continuous', 'name': 'triage_o2sat', 'max': 100.0, 'min': 0.0},
 {'type': 'continuous', 'name': 'triage_sbp', 'max': 299.0, 'min': 1.0},
 {'type': 'continuous', 'name': 'triage_dbp', 'max': 375.0, 'min': 0.0},
 {'type': 'continuous', 'name': 'triage_pain', 'max': 10.0, 'min': 0.0},
 {'type': 'continuous', 'name': 'triage_acuity', 'max': 5.0, 'min': 1.0},
 {'type': 'categorical', 'i2s': [0], 'size': 1, 'name': 'chiefcom_chest_pain'},
 {'type': 'categorical',
  'i2s': [0],
  'size': 1,
  'name': 'chiefcom_abdominal_pain'},
 {'type': 'categorical', 'i2s': [0], 'size': 1, 'name': 'chiefcom_headache'},
 {'type': 'categorical',
  'i2s': [0],
  'size': 1,
  'name': 'chiefcom_shortness_of_breath'},
 {'type': 'categorical', 'i2s': [0], 'size': 1, 'name': 'chiefcom_back_pain'},
 {'type': 'categorical', 'i2s': [0], 'size': 1, 'name': 'chiefcom_cough'},
 {'type': 'categorical',
  'i2s': [0],
  'size': 1,
  'name': 'chiefcom_nausea_vomiting'},
 {'type': 'categorical',
  'i2s': [0],
  'size': 1,
  'name': 'chiefcom_fever_chills'},
 {'type': 'categorical', 'i2s': [0], 'size': 1, 'name': 'chiefcom_syncope'},
 {'type': 'categorical', 'i2s': [0], 'size': 1, 'name': 'chiefcom_dizziness'},
 {'type': 'continuous', 'name': 'cci_MI', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_CHF', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_PVD', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Stroke', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Dementia', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Pulmonary', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Rheumatic', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_PUD', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Liver1', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_DM1', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_DM2', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Paralysis', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Renal', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Cancer1', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Liver2', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_Cancer2', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'cci_HIV', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Arrhythmia', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Valvular', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_PHTN', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_HTN1', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_HTN2', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_NeuroOther', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Hypothyroid', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Lymphoma', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Coagulopathy', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Obesity', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_WeightLoss', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_FluidsLytes', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_BloodLoss', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Anemia', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Alcohol', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Drugs', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Psychoses', 'max': 1, 'min': 0},
 {'type': 'continuous', 'name': 'eci_Depression', 'max': 1, 'min': 0},
 {'type': 'continuous',
  'name': 'ed_temperature_last',
  'max': 45.0,
  'min': 26.0},
 {'type': 'continuous', 'name': 'ed_heartrate_last', 'max': 229.0, 'min': 0.0},
 {'type': 'continuous', 'name': 'ed_resprate_last', 'max': 181.0, 'min': 0.0},
 {'type': 'continuous', 'name': 'ed_o2sat_last', 'max': 100.0, 'min': 0.0},
 {'type': 'continuous', 'name': 'ed_sbp_last', 'max': 268.0, 'min': 0.0},
 {'type': 'continuous', 'name': 'ed_dbp_last', 'max': 375.0, 'min': 0.0},
 {'type': 'continuous',
  'name': 'ed_los',
  'max': 1439.3833333333334,
  'min': 0.0},
 {'type': 'continuous', 'name': 'n_med', 'max': 38.0, 'min': 0.0},
 {'type': 'continuous', 'name': 'n_medrecon', 'max': 67.0, 'min': 0.0}]}

    mean_f1, std_f1 = compute_scores(train.to_numpy(), test.to_numpy(), synthesized_data.to_numpy(), metadata)
    all_mean_f1.append(mean_f1)
    all_std_f1.append(std_f1)

dict = dict = {"missing_ratio":0.2,"f1_mean":all_mean_f1, "f1_std":all_std_f1}#[0.2,0.5,0.8]
df = pd.DataFrame(dict) 
df.to_csv('miss_diff_MIMIC4ED_utility.csv')
print(all_mean_f1)
print(all_std_f1)