# Introspective Experience Replay: Look Back When Surprised


This repository serves to open-source the code used in the paper: Introspective Experience Replay: Look Back When Surprised

### Getting started

To avoid any conflict with your existing Python setup, it is suggested to work in a virtual environment with [`virtualenv`](https://docs.python-guide.org/dev/virtualenvs/). To install `virtualenv`:
```bash
pip install --upgrade virtualenv
```
Create a virtual environment, activate it and install the requirements in [`requirements.txt`](requirements.txt).
```bash
virtualenv env
source env/bin/activate
pip install -r requirements.txt
```

### Training & Testing

Our models can be trained as follows:
```bash
python -W ignore -m src.main --exp_name <name> --algo <algo> --replay_buffer_sampler <replay_buffer_choice> --env <env_name> --train --seed $1 --snapshot_dir $2
```
