#!/usr/bin/env python3

if __name__ == '__main__':
    import argparse
    import os
    from ml_logger import instr
    from model_free_analysis import RUN
    import jaynes
    from dmc_gen.collect_offline_data import main
    from dmc_gen.config import Args
    from invr_thru_inf.config import Adapt, CollectData
    from params_proto.neo_hyper import Sweep

    parser = argparse.ArgumentParser()
    parser.add_argument('sweep_file')
    parser.add_argument('-m', '--mode')
    parser.add_argument('--debug', action='store_true')
    parser.add_argument('-v', '--verbose', action='store_true')
    args = parser.parse_args()

    assert os.path.isfile(args.sweep_file)

    RUN.debug = args.debug
    sweep = Sweep(RUN, Args, Adapt, CollectData).load(args.sweep_file)

    jaynes.config(args.mode, verbose=args.verbose)
    for kwargs in sweep:
        thunk = instr(main, **kwargs)
        jaynes.run(thunk)

    jaynes.listen()
