#!/usr/bin/env python3

if __name__ == '__main__':
    import argparse
    import os
    from ml_logger import instr
    from model_free_analysis.baselines import RUN
    import jaynes
    from dmc_gen.adapt import main
    from dmc_gen.config import Args
    from invr_thru_inf.config import Adapt
    from params_proto.neo_hyper import Sweep

    parser = argparse.ArgumentParser()
    parser.add_argument('sweep_file')
    parser.add_argument('-m', '--mode')
    parser.add_argument('--debug', action='store_true')
    parser.add_argument('-v', '--verbose', action='store_true')
    args = parser.parse_args()

    assert os.path.isfile(args.sweep_file)

    RUN.debug = args.debug
    sweep = Sweep(RUN, Args, Adapt).load(args.sweep_file)

    jaynes.config(args.mode, verbose=args.verbose)
    for kwargs in sweep:
        thunk = instr(main, **kwargs)
        jaynes.run(thunk)
        import time
        time.sleep(6)

    jaynes.listen()
