# Xformer: Hybrid X-Shaped Transformer for Image Denoising
This repository is the PyTorch implementation of Xformer model. Our Xformer achieves state-of-the-art performance in
- Gaussian color image denoising
- Gaussian grayscale image denoising
- Real image denoising

## Installation

This repository is built in PyTorch 1.8.0. (Python3.8, CUDA11.6).

1. Make conda environment
```
conda create -n torch18 python=3.8
conda activate torch18
```

2. Install dependencies
```
pip install -r requirements.txt
```

3. Install basicsr
```
python setup.py develop --no_cuda_ext
```

## Contents

1. [Datasets](#Datasets)
1. [Testing](#Testing)
1. [Acknowledgements](#Acknowledgements)


## Datasets
Used training and training sets can be downloaded as follows:

| Task                                          |                                       Testing Set                          |    
| :-------------------------------------------- | :----------------------------------------------------------: |
| GaussionColor image denoising                                      | CBSD68+Kodak24+McMaster+Urban100 | 
|GaussionGrayscale image denoising                          | Set12+BSD68+Urban100 |
| real image denoising                          | SIDD + DND |



Download testing datasets and put them into the folder `datasets/test/`. Go to the folder to find details of directory structure.


## Testing
### Test on Gaussian Color Image Denoising
1. Please download the corresponding testing datasets and put them in the folder `datasets/test/ColorDN`. Download the corresponding models and put them in the folder `experiments/pretrained_models`. We provide anonymous download links here, for noise level [15](https://ufile.io/bkzecgiv), [25](https://ufile.io/pqhk1o0f), [50](https://ufile.io/in9xxv36), and [blind noise](https://ufile.io/joz6kpd6).
2. Follow the instructions below to begin testing our Xformer model.
```bash
#Xformer model for color image denoising. You can find corresponding results in Table 5 of the main paper.
##noise 15
python evaluate/test_gaussian_color_denoising.py --sigma 15
python evaluate/evaluate_gaussian_color_denoising.py --sigma 15
##noise 25
python evaluate/test_gaussian_color_denoising.py --sigma 25
python evaluate/evaluate_gaussian_color_denoising.py --sigma 25
##noise 50
python evaluate/test_gaussian_color_denoising.py --sigma 50
python evaluate/evaluate_gaussian_color_denoising.py --sigma 50
#Xformer for learning a single model to handle various noise levels. You can find corresponding results in Table 3 of the supplementary material.
##noise 15, 25, 50
python evaluate/test_gaussian_color_denoising.py --model_type blind --sigma 15
python evaluate/test_gaussian_color_denoising.py --model_type blind --sigma 25
python evaluate/test_gaussian_color_denoising.py --model_type blind --sigma 50
python evaluate/evaluate_gaussian_color_denoising.py
``` 

### Test on Gaussian Grayscale Image Denoising
1. Please download the corresponding testing datasets and put them in the folder `datasets/test/GrayDN`. Download the corresponding models and put them in the folder `experiments/pretrained_models`. We provide anonymous download links here, for noise level [15](https://ufile.io/s8eapew7), [25](https://ufile.io/84f73xpx), [50](https://ufile.io/s0y82xbh), and [blind noise](https://ufile.io/pmt8zo79).
2. Follow the instructions below to begin testing our Xformer model.
```bash
#Xformer model for gray image denoising. You can find corresponding results in Table 4 of the main paper.
##noise 15
python evaluate/test_gaussian_gray_denoising.py --sigma 15
python evaluate/evaluate_gaussian_gray_denoising.py --sigma 15
##noise 25
python evaluate/test_gaussian_gray_denoising.py --sigma 25
python evaluate/evaluate_gaussian_gray_denoising.py --sigma 25
##noise 50
python evaluate/test_gaussian_gray_denoising.py --sigma 50
python evaluate/evaluate_gaussian_gray_denoising.py --sigma 50
#Xformer for learning a single model to handle various noise levels. You can find corresponding results in Table 3 of the supplementary material.
##noise 15, 25, 50
python evaluate/test_gaussian_gray_denoising.py --model_type blind --sigma 15
python evaluate/test_gaussian_gray_denoising.py --model_type blind --sigma 25
python evaluate/test_gaussian_gray_denoising.py --model_type blind --sigma 50
python evaluate/evaluate_gaussian_gray_denoising.py
```


### Test on Real Image Denoising
1. Please download the corresponding testing datasets and put them in the folder `datasets/test/SIDD` and `datasets/test/SIDD`. Download the corresponding models and put them in the folder `experiments/pretrained_models`. We provide an anonymous download link [here](https://ufile.io/tw336v1a).
2. Follow the instructions below to begin testing our Xformer model.
```bash
#Xformer model for real image denoising. You can find corresponding results in Table 6 of the main paper.
##sidd
python evaluate/test_real_denoising_sidd.py
run evaluate_sidd.m
##dnd (You should upload the generated mat files to the online server to get PSNR and SSIM.)
python evaluate/test_real_denoising_dnd.py
```




## Acknowledgements
This work is released under the Apache 2.0 license.
The codes are based on [Restormer](https://github.com/swz30/Restormer) and [BasicSR](https://github.com/XPixelGroup/BasicSR). Please also follow their licenses. Thanks for their awesome works.
