import os
import numpy as np
from glob import glob
from natsort import natsorted
from skimage import io
import cv2
import argparse
from skimage.metrics import structural_similarity
from tqdm import tqdm
import concurrent.futures
import utils

def proc(filename):
    tar,prd = filename
    tar_img = utils.load_gray_img(tar)
    prd_img = utils.load_gray_img(prd)
        
    PSNR = utils.calculate_psnr(tar_img, prd_img)
    SSIM = utils.calculate_ssim(tar_img, prd_img)
    return PSNR, SSIM

parser = argparse.ArgumentParser(description='Gasussian Grayscale Denoising')

parser.add_argument('--sigmas', default='15,25,50', type=str, help='Sigma values')

args = parser.parse_args()

sigmas = np.int_(args.sigmas.split(','))

datasets = ['Set12', 'BSD68', 'Urban100']

for dataset in datasets:

    gt_path = os.path.join('datasets','test', 'GrayDN', dataset)
    gt_list = natsorted(glob(os.path.join(gt_path, '*.png')) + glob(os.path.join(gt_path, '*.tif')))
    assert len(gt_list) != 0, "Target files not found"

    for sigma_test in sigmas:
        file_path = os.path.join('results', 'xformer_gray_dn', dataset, str(sigma_test))
        path_list = natsorted(glob(os.path.join(file_path, '*.png')) + glob(os.path.join(file_path, '*.tif')))
        assert len(path_list) != 0, "Predicted files not found"

        psnr, ssim = [], []
        img_files =[(i, j) for i,j in zip(gt_list,path_list)]
        with concurrent.futures.ProcessPoolExecutor(max_workers=10) as executor:
            for filename, PSNR_SSIM in zip(img_files, executor.map(proc, img_files)):
                psnr.append(PSNR_SSIM[0])
                ssim.append(PSNR_SSIM[1])

        avg_psnr = sum(psnr)/len(psnr)
        avg_ssim = sum(ssim)/len(ssim)

        # print('For {:s} dataset Noise Level {:d} PSNR: {:f}\n'.format(dataset, sigma_test, avg_psnr))
        print('For {:s} dataset Noise Level {:d} PSNR: {:f} SSIM: {:f}\n'.format(dataset, sigma_test, avg_psnr, avg_ssim))
