import sys

import numpy as np

sys.path.append("../")

from fedlab.contrib.compressor.quantization import QSGDCompressor
from fedlab.contrib.compressor.topk import TopkCompressor
from fedlab.contrib.algorithm.basic_client import SGDClientTrainer, SGDSerialClientTrainer
from fedlab.contrib.algorithm.basic_server import SyncServerHandler
import torch
import argparse
import os
from opcode import cmp_op
from fedlab.models.mlp import MLP
from torchvision import transforms
from fedlab.contrib.dataset.partitioned_mnist import PartitionedMNIST
from fedlab.contrib.dataset.partitioned_cifar import PartitionCIFAR
from fedlab.contrib.dataset.partitioned_cifar10 import PartitionedCIFAR10
from fedlab.utils.functional import evaluate
from fedlab.core.standalone import StandalonePipeline
from torch import nn
from torch.utils.data import DataLoader
import torchvision
from fedlab.models.mlp import MLP
from fedlab.models.cnn import CNN_MNIST
from fedlab.models.cnn import CNN_CIFAR10, AlexNet_CIFAR10
from fedlab.models.convex import LinearModel, PiecewiseLinearModel, LinearModelEnsemble

# from Check_Sigma import CompressSerialClientTrainer, CompressServerHandler, EvalPipeline
use_cuda = True if torch.cuda.is_available() else False
# Check if CUDA is available
if torch.cuda.is_available():
    # Specify the CUDA device, 'cuda:0' for the first GPU
    device = torch.device('cuda:0')
else:
    # Fallback to CPU if CUDA is not available
    device = torch.device('cpu')


class CompressSerialClientTrainer(SGDSerialClientTrainer):
    def setup_compressor(self, compressor):
        self.compressor = compressor

    def update_model(self, server_model_state_dict):
        self.model.load_state_dict(server_model_state_dict)

    @property
    def uplink_package(self):
        package = super().uplink_package
        new_package = []
        for content in package:
            pack = [self.compressor.compress(content[0])]
            new_package.append(pack)
        return new_package


class CompressServerHandler(SyncServerHandler):
    def setup_compressor(self, compressor, type):
        self.compressor = compressor
        self.type = type

    def load(self, payload) -> bool:
        if self.type == 'topk':
            # values, indices = payload[0]
            values, indices = payload[0]
            values = values.to(self.model_parameters.device)
            indices = indices.to(self.model_parameters.device)
            decompressed_payload = self.compressor.decompress(values, indices, self.model_parameters.shape)

        if self.type == 'qsgd':
            n, s, l = payload[0]
            decompressed_payload = self.compressor.decompress((n, s, l))

        return  super().load([decompressed_payload])

    # def downlink_package(self):
    #     return self.model.state_dict()


class EvalPipeline(StandalonePipeline):
    def __init__(self, handler, trainer, test_loader):
        super().__init__(handler, trainer)
        self.test_loader = test_loader

    def main(self):
        res_loss, res_acc = [], []
        while self.handler.if_stop is False:
            # server size
            sampled_clients = self.handler.sample_clients()
            broadcast = self.handler.downlink_package

            # client size
            self.trainer.local_process(broadcast, sampled_clients)

            uploads = self.trainer.uplink_package

            # server side
            for pack in uploads:
                self.handler.load(pack)

            loss, acc = evaluate(self.handler.model, nn.CrossEntropyLoss(), self.test_loader)
            print(f"Centralized Evaluation round {self.handler.round}: loss {loss:.4f}, test accuracy {acc:.4f}")
            res_loss.append(loss)
            res_acc.append(acc)

        return res_loss, res_acc


def args_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('--compressor', type=str, default='topk', help='choose from topk and qsgd')
    parser.add_argument('--k_ratio', type=float, default='1', help='TopK k ratio')
    parser.add_argument('--n_bit', type=int, default=8, help='number of bits for quantization')
    parser.add_argument('--total_client', type=int, default=1)
    parser.add_argument('--alpha', type=float, default=0.7, help="Dirichlet alpha")
    parser.add_argument('--seed', type=int, default=42)
    parser.add_argument('--epochs', type=int, default=1)
    parser.add_argument('--lr', type=float, default=0.1)
    parser.add_argument('--batch_size', '-bs', type=int, default=1024)
    parser.add_argument('--com_round', type=int, default=1)
    parser.add_argument('--sample_ratio', default=0.1, type=float)
    parser.add_argument('--model', default='LinearModel', type=str, help="MLP?")
    parser.add_argument('--dataset', default='PartitionedMNIST', type=str,
                        help="PartitionedMNIST | PartitionedCIFAR10?")
    parser.add_argument('--verbose', default=True, type=bool, help='Whether print dataset splits?')
    args = parser.parse_args()
    return args


args = args_parser()
use_cuda = torch.cuda.is_available()
device = torch.device('cuda:0' if use_cuda else 'cpu')

tpk_compressor = TopkCompressor(compress_ratio=args.k_ratio)
compressor = tpk_compressor

total_clients = [1, 2, 4, 8, 16, 32, 64, 128, 256, 10, 100]
# alphas = [0.1, 0.3, 0.5, 0.7, 0.9, 1.0, 1000]
alphas = [0.3, 0.5, 0.7, 0.9, 1.0, 1000]
datasets = ["PartitionedMNIST", "PartitionedCIFAR10", "PartitionedCIFAR100"]
print(f"../datasets/{args.dataset}")
if not os.path.exists(f"../datasets/{args.dataset}"):
    os.mkdir(f"../datasets/{args.dataset}")

if args.dataset == "PartitionedMNIST":
    partition = "noniid-labeldir"
    data_path = f"../datasets/{args.dataset}/{partition}_{args.alpha}_{args.total_client}"
    model = CNN_MNIST().to(device)

elif args.dataset == "PartitionedCIFAR10":
    partition = "dirichlet"
    data_path = f"../datasets/{args.dataset}/{partition}_{args.alpha}_{args.total_client}"
    model = CNN_MNIST().to(device)

elif args.dataset == "PartitionedCIFAR100":
    partition = "dirichlet"
    data_path = f"../datasets/{args.dataset}/{partition}_{args.alpha}_{args.total_client}"
    model = CNN_MNIST().to(device)

preprocess = False if os.path.exists(data_path) else True
# if not os.path.exists(data_path):
#     os.mkdir(data_path)

if args.dataset == "PartitionedMNIST":
    dataset = PartitionedMNIST(root="../datasets",
                               path=data_path,
                               num_clients=args.total_client,
                               partition=partition,
                               dir_alpha=args.alpha,
                               seed=args.seed,
                               preprocess=preprocess,
                               download=True,
                               verbose=True,
                               transform=transforms.Compose([
                                   transforms.ToPILImage(),
                                   transforms.ToTensor()
                               ]))
    test_data = torchvision.datasets.MNIST(root=f"../datasets/{dataset}",
                                           train=False,
                                           download=True,
                                           transform=transforms.ToTensor())

elif args.dataset == "PartitionedCIFAR10":
    dataset = PartitionedCIFAR10(root="../datasets",
                                 path=data_path,
                                 num_clients=args.total_client,
                                 partition=partition,
                                 dir_alpha=args.alpha,
                                 seed=args.seed,
                                 dataname="cifar10",
                                 preprocess=preprocess,
                                 download=True,
                                 verbose=True,
                                 transform=transforms.Compose([
                                     # transforms.ToPILImage(),
                                     transforms.ToTensor()
                                 ]))
    test_data = torchvision.datasets.CIFAR10(root=f"../datasets/{dataset}",
                                             train=False,
                                             download=True,
                                             transform=transforms.ToTensor())


elif args.dataset == "PartitionedCIFAR100":
    dataset = PartitionCIFAR(root="../datasets",
                                 path=data_path,
                                 num_clients=args.total_client,
                                 partition=partition,
                                 dir_alpha=args.alpha,
                                 seed=args.seed,
                                 dataname="cifar100",
                                 preprocess=preprocess,
                                 download=True,
                                 verbose=True,
                                 transform=transforms.Compose([
                                     # transforms.ToPILImage(),
                                     transforms.ToTensor()
                                 ]))
    test_data = torchvision.datasets.CIFAR100(root=f"../datasets/{dataset}",
                                             train=False,
                                             download=True,
                                             transform=transforms.ToTensor())

trainer = CompressSerialClientTrainer(model, args.total_client, cuda=use_cuda)
trainer.setup_dataset(dataset)
trainer.setup_optim(args.epochs, args.batch_size, args.lr)
trainer.setup_compressor(compressor)

handler = CompressServerHandler(model=model,
                                global_round=args.com_round,
                                num_clients=args.total_client,
                                sample_ratio=args.sample_ratio,
                                cuda=use_cuda)
handler.setup_compressor(compressor, args.compressor)
# test_loader = DataLoader(test_data, batch_size=1024)
# standalone_eval = EvalPipeline(handler=handler,
#                                trainer=trainer,
#                                test_loader=test_loader)
