"""
This script generate the LMDB dataset file from <multiples> folder of images and associated csv
"""
from dataclasses import dataclass
from typing import List
from dataclasses import field

from data.BlenderDataset.BlenderDataset import BlenderLMDBDataset
from data.BlenderDataset.BlenderDatasetPNG import folder2lmdb, lmdb2lmdbpickle


def return_factory(param):
    return field(default_factory=lambda: param)


@dataclass
class Params:
    lmdb_dest_path   : str = r'path_dest\semantic_inversion'
    lmdb_dest_name   : str = 'testpickle.lmdb'

    write_frequency  : int = 100


params = Params()


db = BlenderLMDBDataset(
    db_path=r'path_dest\blender_inversion_rgb.lmdb',
    target_transform=None,
    return_params=True,
    return_domain=None,
    is_one=False,
    get_item_for_translation=True,
    use_pickle=False,
)

print(f'{len(db)=}')

# create lmdb dataset
lmdb2lmdbpickle(db, params.lmdb_dest_path, params.lmdb_dest_name, write_frequency=params.write_frequency)
