"""
This script generate the LMDB dataset file from <multiples> folder of images and associated csv
"""
from dataclasses import dataclass
from typing import List
from dataclasses import field

from data.BlenderDataset.BlenderDatasetPNG import BlenderPNGDataset, folder2lmdb


def return_factory(param):
    return field(default_factory=lambda: param)


@dataclass
class Params:
    list_images_paths: List[str] = return_factory(['imgs'])
    list_csv_paths   : List[str] = return_factory(['params.csv'])

    lmdb_dest_path   : str = 'no_random'
    lmdb_dest_name   : str = 'blender_dataset_no_random.lmdb'

    write_frequency  : int = 100


params = Params()


db = BlenderPNGDataset(
    path_list_imgs=params.list_images_paths,
    path_list_csv =params.list_csv_paths,
    return_params =True,
    process_params=False,
)

print(f'{len(db)=}')

# create lmdb dataset
folder2lmdb(db, params.lmdb_dest_path, params.lmdb_dest_name, write_frequency=params.write_frequency)
