from conf.dataset import DatasetParams
from conf.model import LoggingParams
from utils.Logging.LogBlender import LogBlender1, LogBlender3
from utils.Logging.LogBRATS2020 import LogBRATS2020
from utils.Logging.LogCelebA import LogCelebA1, LogCelebA3
from utils.Logging.LogStrategy import LogStrategy

def get_log_strategy(params: LoggingParams, params_data: DatasetParams) -> LogStrategy:
    name = params.name

    loggers = {
        'blender1': LogBlender1,
        'blender3': LogBlender3,
        'brats2020': LogBRATS2020,
        'celeba1': LogCelebA1,
        'celeba3': LogCelebA3,
    }

    if name not in loggers:
        raise NotImplementedError(f'Logging strategy {name} not implemented')

    return loggers[name](params, params_data)
