# Replication Code for "A Fast Kernel-based Conditional Independence test with Application to Causal Discovery"

## Replication of Simulation Study (Section 5)

To replicate simulations, first, create a python environment and do

```
pip install causal-learn joblib scikit-learn
```

The code for comparisons of the standard KCI and FastKCI is contained in `simulation_ci.py`.

- For Section 5.1 you may run with `--num_d` $= \{1,2,3,4,5\}$, `--num_k` $= \{1,3,10\}$ with `--num_obs` $=1200$ and `--num_reps` $=200$.
- For the first experiment in Section 5.2 you may run with `--num_d` $= 1 $, `--num_k` $= \{1,3,10\}$ with `--num_obs` $=1200$ and `--num_reps` $=200$. Set the paramter `is_type_2 = True` in the DGP. Vary the strength of violation in the DGP accordingly.
- For the second experiment in Section 5.2 you may run with `--num_k` $= \{3\}$ with `--num_obs` $=1200$ and `--num_reps` $=200$ and exchange the DGP in the file with `type2_x_cause_y(n=n, k=k)`.

The code for comparisons of the standard KCI and FastKCI for causal discovery with the PC is contained in `pc_sim.py`.
- For Section 5.3 you may run with `create_data()` for the process that replicates Zhang et al. (2012) with `--num_obs` $=\{400,800,1200,2000\}$ `--num_nodes` $=6$ `--sparsity` $=0.3$ and `--use_gp = True`.
- For Section 5.3 you may run with `create_data_2()` for the process that replicates Liu et al. (2024) with `--num_obs` $=\{400,800,1200,2000\}$ `--num_nodes` $=6$ `--sparsity` $=0.5$ and `--use_gp = True`.
- For Section 5.4 additionally run `simulation_ci.py` with `--num_k` $= \{3\}$ with `--num_obs` $=\{400,800,2000\}$ and `--num_reps` $=200$.
- For Section 5.5 you may run with `create_data()` and `create_data_2()` with `--num_obs` $=\{2000,10000,20000,50000,100000\}$ and the above settings and `--use_gp = False`.


## Replication of Application (Section 6)

To replicate the application part, additionally do

```
pip install causalAssembly
```

- For the full benchmark, run `causalass_sim_complete.py`
- For the stations benchmark, run `causalass_sim_stations.py`
