# EGRU

## Command for running sequential MNIST experiments

```bash
python bin/smnist.py --train-epochs 200 --units 590 --batch-size 500 --rnn-type egrud --use-output-trace --use-grad-clipping --grad-clip-norm 0.25  --cuda
```

## Command for running the continuous time EGRU model

```bash

python bin/cont-time.py --initial-delay 1 --delay 2 --input-length 1 --input-width 2 --train-iter 5000 --one-hot-encoding --output-repeat-factor 1 --bias-std 0.2 --num-units 2 --seed 123 --activity-reg-constant 1.

```

## Command for running the DVS Gesture experiments

```bash

python dvs_gesture/dvs128.py --data /tmp/dataset/ --cache /tmp/cache/ --logdir ./logs/ --batch-size 256 --units 1024 --unit-size 1 --num-layers 2 --frame-size 32 --train-epochs 1000 --frame-time 25   --rnn-type egrud --learning-rate 0.001 --event-agg-method mean --flatten-frame --use-all-timesteps --activity-regularization --activity-regularization-constant 0.01
```

##  Language modelling experiments

Scripts  and instructions can be found in the `lm` directory.
