export PYTHONPATH=$PYTHONPATH:"."

export ID=0
export model="lstm"
export target="T (degC)"
export data_folder="climate/data"
export output_folder="climate/output/lstm"
export save_predictions=true
export horizon=168
export width=64
export activation="tanh"
export reg_scale=5e-5
export seed=42
export timedelay=168

export args="-i $ID -m $model"
export args=$args" -f $data_folder -o $output_folder -p $save_predictions"
export args=$args" -w $width -a $activation -r $reg_scale -s $seed"
export args=$args" -d $timedelay -z $horizon"

# Couldn't make bash work with $target as it has spaces. So passing it separately.
python climate/src/run_experiment.py $args -t "$target" && echo $args
