export PYTHONPATH=$PYTHONPATH:"."

while [[ $# -gt 0 ]]; do
  case $1 in
    -m|--model)
      export model="$2"
      shift 
      shift
      ;;
    -*|--*)
      echo "Unknown option $1"
      exit 1
      ;;
  esac
done

echo "Starting grid search for $model"
export folder="climate/grid_search/$model"
nohup python climate/src/run_grid_search.py -f $folder -r 5 -s 42 2> $folder/nohup.out &